/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\t\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\u000b\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"doProcessReceiverType", "", "Lcom/intellij/psi/PsiType;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "processClassType", "Lcom/intellij/psi/PsiClassType;", "processReceiverType", "intellij.groovy.psi"})
public final class ReceiverKt {
    public static final boolean processReceiverType(@Nullable PsiType $receiver, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        if ($receiver == null) {
            return true;
        }
        if (!ReceiverKt.doProcessReceiverType($receiver, processor, state, place)) {
            return false;
        }
        return !ResolveUtilKt.processNonCodeMembers(state) || ResolveUtil.processNonCodeMembers($receiver, processor, place, state);
    }

    private static final boolean doProcessReceiverType(@NotNull PsiType $receiver, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        boolean bl;
        block21: {
            PsiType psiType = $receiver;
            if (psiType instanceof PsiPrimitiveType) {
                PsiClassType psiClassType = ((PsiPrimitiveType)$receiver).getBoxedType(place);
                bl = psiClassType != null ? ReceiverKt.processReceiverType((PsiType)psiClassType, processor, state, place) : true;
            } else if (psiType instanceof PsiDisjunctionType) {
                bl = ReceiverKt.processReceiverType(((PsiDisjunctionType)$receiver).getLeastUpperBound(), processor, state, place);
            } else if (psiType instanceof PsiIntersectionType) {
                for (Object element$iv : (Object[])((PsiIntersectionType)$receiver).getConjuncts()) {
                    PsiType it = (PsiType)element$iv;
                    if (ReceiverKt.processReceiverType(it, processor, state, place)) continue;
                    bl = false;
                    break block21;
                }
                bl = true;
            } else if (psiType instanceof PsiCapturedWildcardType) {
                bl = ReceiverKt.processReceiverType((PsiType)((PsiCapturedWildcardType)$receiver).getWildcard(), processor, state, place);
            } else if (psiType instanceof PsiWildcardType) {
                bl = !((PsiWildcardType)$receiver).isExtends() || ReceiverKt.processReceiverType(((PsiWildcardType)$receiver).getExtendsBound(), processor, state, place);
            } else if (psiType instanceof GrTraitType) {
                Iterable $receiver$iv = ArraysKt.reversed((Object[])((GrTraitType)$receiver).getConjuncts());
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        PsiType it = (PsiType)element$iv;
                        if (ReceiverKt.processReceiverType(it, processor, state, place)) continue;
                        bl = false;
                        break block21;
                    }
                    bl = true;
                }
            } else if (psiType instanceof PsiArrayType) {
                GrTypeDefinition grTypeDefinition = GroovyPsiManager.getInstance(place.getProject()).getArrayClass(((PsiArrayType)$receiver).getComponentType());
                if (grTypeDefinition == null) {
                    return true;
                }
                GrTypeDefinition arrayClass = grTypeDefinition;
                bl = ResolveUtil.processClassDeclarations(arrayClass, processor, state, null, place);
            } else if (psiType instanceof PsiClassType) {
                bl = ReceiverKt.processClassType((PsiClassType)$receiver, processor, state, place);
            } else {
                return true;
            }
        }
        return bl;
    }

    private static final boolean processClassType(@NotNull PsiClassType $receiver, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        PsiClassType.ClassResolveResult result = $receiver.resolveGenerics();
        PsiClass psiClass = result.getElement();
        if (psiClass == null) {
            return true;
        }
        PsiClass clazz = psiClass;
        PsiSubstitutor substitutor = ((PsiSubstitutor)state.get(PsiSubstitutor.KEY)).putAll(result.getSubstitutor());
        return ResolveUtil.processClassDeclarations(clazz, processor, state.put(PsiSubstitutor.KEY, (Object)substitutor), null, place);
    }
}

