/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.ide.IconProvider;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.mvc.projectView.AbstractMvcPsiNodeDescriptor;
import org.jetbrains.plugins.groovy.mvc.projectView.ClassNode;
import org.jetbrains.plugins.groovy.mvc.projectView.FileNode;

public class AbstractFolderNode
extends AbstractMvcPsiNodeDescriptor {
    private final String myPresentableText;

    protected AbstractFolderNode(@NotNull Module module, @NotNull PsiDirectory directory, @NotNull String presentableText, ViewSettings viewSettings, int weight) {
        if (module == null) {
            AbstractFolderNode.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            AbstractFolderNode.$$$reportNull$$$0(1);
        }
        if (presentableText == null) {
            AbstractFolderNode.$$$reportNull$$$0(2);
        }
        super(module, viewSettings, (PsiElement)directory, weight);
        this.myPresentableText = presentableText;
    }

    @Override
    protected String getTestPresentationImpl(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            AbstractFolderNode.$$$reportNull$$$0(3);
        }
        VirtualFile virtualFile = this.getVirtualFile();
        assert (virtualFile != null);
        return "Folder: " + virtualFile.getPresentableName();
    }

    @NotNull
    protected PsiDirectory getPsiDirectory() {
        PsiDirectory psiDirectory = (PsiDirectory)this.extractPsiFromValue();
        if (psiDirectory == null) {
            AbstractFolderNode.$$$reportNull$$$0(4);
        }
        return psiDirectory;
    }

    @Nullable
    protected Collection<AbstractTreeNode> getChildrenImpl() {
        PsiDirectory directory = this.getPsiDirectory();
        if (!directory.isValid()) {
            return Collections.emptyList();
        }
        List<AbstractTreeNode> children = Arrays.stream(directory.getSubdirectories()).map(this::createFolderNode).collect(Collectors.toList());
        for (PsiFile file : directory.getFiles()) {
            this.processNotDirectoryFile(children, file);
        }
        return children;
    }

    private AbstractFolderNode createFolderNode(PsiDirectory directory) {
        PsiDirectory realDirectory = directory;
        StringBuilder textBuilder = null;
        if (this.getSettings().isHideEmptyMiddlePackages()) {
            PsiDirectory[] subdirectories;
            while (realDirectory.getFiles().length <= 0 && (subdirectories = realDirectory.getSubdirectories()).length == 1) {
                if (textBuilder == null) {
                    textBuilder = new StringBuilder();
                    textBuilder.append(realDirectory.getName());
                }
                realDirectory = subdirectories[0];
                textBuilder.append('.').append(realDirectory.getName());
            }
        }
        String presentableText = textBuilder == null ? directory.getName() : textBuilder.toString();
        return new AbstractFolderNode(this.getModule(), realDirectory, presentableText, this.getSettings(), 100){

            @Override
            protected void processNotDirectoryFile(List<AbstractTreeNode> nodes, PsiFile file) {
                AbstractFolderNode.this.processNotDirectoryFile(nodes, file);
            }

            @Override
            protected AbstractTreeNode createClassNode(GrTypeDefinition typeDefinition) {
                return AbstractFolderNode.this.createClassNode(typeDefinition);
            }
        };
    }

    @Override
    protected void updateImpl(PresentationData data) {
        PsiDirectory psiDirectory = this.getPsiDirectory();
        data.setPresentableText(this.myPresentableText);
        for (IconProvider provider2 : (IconProvider[])Extensions.getExtensions((ExtensionPointName)IconProvider.EXTENSION_POINT_NAME)) {
            Icon icon = provider2.getIcon((PsiElement)psiDirectory, 0);
            if (icon == null) continue;
            data.setIcon(icon);
            return;
        }
    }

    @Override
    protected boolean containsImpl(@NotNull VirtualFile file) {
        PsiElement psiElement;
        if (file == null) {
            AbstractFolderNode.$$$reportNull$$$0(5);
        }
        if ((psiElement = this.extractPsiFromValue()) == null || !psiElement.isValid()) {
            return false;
        }
        VirtualFile valueFile = ((PsiDirectory)psiElement).getVirtualFile();
        if (!VfsUtil.isAncestor((VirtualFile)valueFile, (VirtualFile)file, (boolean)false)) {
            return false;
        }
        Project project = psiElement.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = fileIndex.getModuleForFile(valueFile);
        if (module == null) {
            return fileIndex.getModuleForFile(file) == null;
        }
        return ModuleRootManager.getInstance((Module)module).getFileIndex().isInContent(file);
    }

    protected void processNotDirectoryFile(List<AbstractTreeNode> nodes, PsiFile file) {
        GrTypeDefinition[] definitions;
        if (file instanceof GroovyFile && (definitions = ((GroovyFile)file).getTypeDefinitions()).length > 0) {
            for (GrTypeDefinition typeDefinition : definitions) {
                nodes.add(this.createClassNode(typeDefinition));
            }
            return;
        }
        nodes.add((AbstractTreeNode)new FileNode(this.getModule(), file, this.getSettings()));
    }

    protected AbstractTreeNode createClassNode(GrTypeDefinition typeDefinition) {
        assert (this.getValue() != null);
        return new ClassNode(this.getModule(), typeDefinition, this.getSettings());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/mvc/projectView/AbstractFolderNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/projectView/AbstractFolderNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTestPresentationImpl";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

