/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.DeleteColumnJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.DeleteRowJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DeleteGridSelectionJob
extends BatchSelectionJob {
    private FXOMObject targetGridPane;

    public DeleteGridSelectionJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        Selection selection = this.getEditorController().getSelection();
        assert (selection.getGroup() instanceof GridSelectionGroup);
        GridSelectionGroup gsg = (GridSelectionGroup)selection.getGroup();
        this.targetGridPane = gsg.getAncestor();
        switch (gsg.getType()) {
            case COLUMN: {
                result.add(new DeleteColumnJob(this.getEditorController()));
                break;
            }
            case ROW: {
                result.add(new DeleteRowJob(this.getEditorController()));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return this.getSubJobs().get(0).getDescription();
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        HashSet<FXOMObject> newObjects = new HashSet<FXOMObject>();
        newObjects.add(this.targetGridPane);
        return new ObjectSelectionGroup(newObjects, this.targetGridPane, null);
    }
}

