/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/AlarmDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "ensureAtLeast", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "parameter", "", "min", "", "getApplicableMethodNames", "", "", "getLongValue", "argument", "Lorg/jetbrains/uast/UExpression;", "visitMethod", "method", "Lcom/intellij/psi/PsiMethod;", "Issues", "android.sdktools.lint-checks"})
public final class AlarmDetector
extends Detector
implements Detector.UastScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    public static final Issue ISSUE;
    public static final Issues Issues;

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"setRepeating");
    }

    @Override
    public void visitMethod(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isMemberInClass((PsiMember)method, "android.app.AlarmManager") && evaluator.getParameterCount(method) == 4) {
            this.ensureAtLeast(context, node, 1, 5000L);
            this.ensureAtLeast(context, node, 2, 60000L);
        }
    }

    private final void ensureAtLeast(JavaContext context, UCallExpression node, int parameter, long min) {
        UExpression argument = (UExpression)node.getValueArguments().get(parameter);
        long value = this.getLongValue(context, argument);
        if (value < min) {
            String message = "Value will be forced up to " + min + " as of Android 5.1; " + "don't rely on this to be exact";
            Issue issue = ISSUE;
            Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"ISSUE");
            JavaContext.report$default(context, issue, (UElement)argument, context.getLocation((UElement)argument), message, null, 16, null);
        }
    }

    private final long getLongValue(JavaContext context, UExpression argument) {
        Object value = ConstantEvaluator.evaluate(context, (UElement)argument);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.MAX_VALUE;
    }

    static {
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(AlarmDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.create("ShortAlarm", "Short or Frequent Alarm", "\nFrequent alarms are bad for battery life. As of API 22, the `AlarmManager` will override \\\nnear-future and high-frequency alarm requests, delaying the alarm at least 5 seconds into the \\\nfuture and ensuring that the repeat interval is at least 60 seconds.\n\nIf you really need to do work sooner than 5 seconds, post a delayed message or runnable to a \\\nHandler.", Category.CORRECTNESS, 6, Severity.WARNING, AlarmDetector.Issues.getIMPLEMENTATION());
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/AlarmDetector$Issues;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "kotlin.jvm.PlatformType", "android.sdktools.lint-checks"})
    public static final class Issues {
        private final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

