/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/ByteOrderMarkDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "Lcom/android/tools/lint/detector/api/Detector$GradleScanner;", "()V", "beforeCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "Lcom/android/tools/lint/detector/api/JavaContext;", "run", "visitDocument", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "Issues", "android.sdktools.lint-checks"})
public final class ByteOrderMarkDetector
extends ResourceXmlDetector
implements Detector.UastScanner,
Detector.GradleScanner {
    @JvmField
    public static final Issue BOM;
    public static final Issues Issues;

    /*
     * Unable to fully structure code
     */
    @Override
    public void beforeCheckFile(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        v0 = context.getContents();
        if (v0 == null) {
            return;
        }
        source = v0;
        max = source.length();
        var4_4 = 1;
        var5_5 = max;
        while (var4_4 < var5_5) {
            block5: {
                block6: {
                    c = source.charAt((int)i);
                    if (c != '\ufeff') break block5;
                    location = Location.Companion.create(context.file, source, (int)i, (int)(i + true));
                    message = "Found byte-order-mark in the middle of a file";
                    if (!(context instanceof XmlContext)) break block6;
                    leaf = ((XmlContext)context).getParser().findNodeAt((XmlContext)context, (int)i);
                    if (leaf == null) ** GOTO lbl-1000
                    v1 = (XmlContext)context;
                    v2 = ByteOrderMarkDetector.BOM;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"BOM");
                    XmlContext.report$default(v1, v2, leaf, location, message, null, 16, null);
                    break block5;
                }
                if (!(context instanceof JavaContext) || (file = ((JavaContext)context).getUastFile()) == null) ** GOTO lbl-1000
                psi = file.getPsi();
                closest = psi.findElementAt((int)i);
                if (closest == null && !file.getClasses().isEmpty()) {
                    closest = (PsiElement)file.getClasses().get(0);
                }
                if (closest != null) {
                    v3 = (JavaContext)context;
                    v4 = ByteOrderMarkDetector.BOM;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"BOM");
                    JavaContext.report$default(v3, v4, closest, location, message, null, 16, null);
                } else lbl-1000:
                // 3 sources

                {
                    v5 = ByteOrderMarkDetector.BOM;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"BOM");
                    Context.report$default(context, v5, location, message, null, 8, null);
                }
            }
            ++i;
        }
    }

    @Override
    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
    }

    @Override
    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return null;
    }

    @Override
    public void run(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
    }

    static {
        Issues = new Issues(null);
        BOM = Issue.create("ByteOrderMark", "Byte order mark inside files", "\nLint will flag any byte-order-mark (BOM) characters it finds in the middle of a file. Since we \\\nexpect files to be encoded with UTF-8 (see the EnforceUTF8 issue), the BOM characters are not \\\nnecessary, and they are not handled correctly by all tools. For example, if you have a BOM as \\\npart of a resource name in one particular translation, that name will not be considered identical \\\nto the base resource's name and the translation will not be used.", Category.I18N, 8, Severity.FATAL, new Implementation(ByteOrderMarkDetector.class, EnumSet.of((Enum)Scope.MANIFEST, new Scope[]{Scope.RESOURCE_FILE, Scope.JAVA_FILE, Scope.GRADLE_FILE, Scope.PROPERTY_FILE, Scope.PROGUARD_FILE}), Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE, Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE, Scope.GRADLE_SCOPE, Scope.PROPERTY_SCOPE, Scope.PROGUARD_SCOPE)).addMoreInfo("http://en.wikipedia.org/wiki/Byte_order_mark");
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/ByteOrderMarkDetector$Issues;", "", "()V", "BOM", "Lcom/android/tools/lint/detector/api/Issue;", "kotlin.jvm.PlatformType", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

