/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.CompositeIssueRegistry;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.SdkUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\b\u0010\u0013\u001a\u00020\tH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/client/api/JarFileIssueRegistry;", "Lcom/android/tools/lint/client/api/IssueRegistry;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jarFile", "Ljava/io/File;", "registry", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Lcom/android/tools/lint/client/api/IssueRegistry;)V", "hasLombokLegacyDetectors", "", "hasPsiLegacyDetectors", "issues", "", "Lcom/android/tools/lint/detector/api/Issue;", "getJarFile", "()Ljava/io/File;", "timestamp", "", "getIssues", "isUpToDate", "Factory", "android.sdktools.lint-api"})
public final class JarFileIssueRegistry
extends IssueRegistry {
    private final List<Issue> issues;
    private long timestamp;
    private boolean hasLombokLegacyDetectors;
    private boolean hasPsiLegacyDetectors;
    @NotNull
    private final File jarFile;
    private static final String SERVICE_KEY = "META-INF/services/com.android.tools.lint.client.api.IssueRegistry";
    private static final String MF_LINT_REGISTRY = "Lint-Registry-v2";
    private static final String MF_LINT_REGISTRY_OLD = "Lint-Registry";
    private static Map<File, SoftReference<JarFileIssueRegistry>> cache;
    public static final Factory Factory;

    public final boolean hasLombokLegacyDetectors() {
        return this.hasLombokLegacyDetectors;
    }

    public final boolean hasPsiLegacyDetectors() {
        return this.hasPsiLegacyDetectors;
    }

    @Override
    public boolean isUpToDate() {
        return this.timestamp == this.jarFile.lastModified();
    }

    @Override
    @NotNull
    public List<Issue> getIssues() {
        return this.issues;
    }

    @NotNull
    public final File getJarFile() {
        return this.jarFile;
    }

    private JarFileIssueRegistry(LintClient client, File jarFile, IssueRegistry registry) {
        ClassLoader loader;
        this.jarFile = jarFile;
        this.issues = CollectionsKt.toList((Iterable)registry.getIssues());
        this.timestamp = this.jarFile.lastModified();
        for (Issue issue : this.issues) {
            EnumSet<Scope> scope = issue.getImplementation().getScope();
            if (!scope.contains((Object)Scope.JAVA_FILE) && !scope.contains((Object)Scope.JAVA_LIBRARIES) && !scope.contains((Object)Scope.ALL_JAVA_FILES)) continue;
            Class<? extends Detector> detectorClass = issue.getImplementation().getDetectorClass();
            if (Detector.JavaScanner.class.isAssignableFrom(detectorClass)) {
                this.hasLombokLegacyDetectors = true;
                break;
            }
            if (!Detector.JavaPsiScanner.class.isAssignableFrom(detectorClass)) break;
            this.hasPsiLegacyDetectors = true;
            break;
        }
        if ((loader = registry.getClass().getClassLoader()) instanceof URLClassLoader) {
            JarFileIssueRegistry.Factory.loadAndCloseURLClassLoader(client, this.jarFile, (URLClassLoader)loader);
        }
    }

    static {
        Factory = new Factory(null);
    }

    public /* synthetic */ JarFileIssueRegistry(@NotNull LintClient client, @NotNull File jarFile, @NotNull IssueRegistry registry, DefaultConstructorMarker $constructor_marker) {
        this(client, jarFile, registry);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015H\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\tH\u0002J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00192\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015J\u001f\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001d\"\u00020\u001b\u00a2\u0006\u0002\u0010\u001eJ \u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0002J\"\u0010$\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R.\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/client/api/JarFileIssueRegistry$Factory;", "", "()V", "MF_LINT_REGISTRY", "", "MF_LINT_REGISTRY_OLD", "SERVICE_KEY", "cache", "", "Ljava/io/File;", "Ljava/lang/ref/SoftReference;", "Lcom/android/tools/lint/client/api/JarFileIssueRegistry;", "getCache", "()Ljava/util/Map;", "setCache", "(Ljava/util/Map;)V", "findRegistries", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jarFiles", "", "get", "registryClassName", "jarFile", "", "join", "Lcom/android/tools/lint/client/api/IssueRegistry;", "registries", "", "([Lcom/android/tools/lint/client/api/IssueRegistry;)Lcom/android/tools/lint/client/api/IssueRegistry;", "loadAndCloseURLClassLoader", "", "file", "loader", "Ljava/net/URLClassLoader;", "loadIssueRegistry", "className", "android.sdktools.lint-api"})
    public static final class Factory {
        private final Map<File, SoftReference<JarFileIssueRegistry>> getCache() {
            return cache;
        }

        private final void setCache(Map<File, SoftReference<JarFileIssueRegistry>> map) {
            cache = map;
        }

        @NotNull
        public final List<JarFileIssueRegistry> get(@NotNull LintClient client, @NotNull Collection<? extends File> jarFiles) {
            Map<String, File> map;
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull(jarFiles, (String)"jarFiles");
            try {
                map = this.findRegistries(client, jarFiles);
            }
            catch (IOException e) {
                client.log(e, "Could not load custom lint check jar files: " + e.getMessage(), new Object[0]);
                return CollectionsKt.emptyList();
            }
            Map<String, File> registryMap = map;
            if (registryMap.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            int capacity = jarFiles.size() + 1;
            ArrayList<JarFileIssueRegistry> registries = new ArrayList<JarFileIssueRegistry>(capacity);
            Map<String, File> map2 = registryMap;
            Iterator<Map.Entry<String, File>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, File> entry;
                Map.Entry<String, File> entry2 = entry = iterator.next();
                String registryClass = entry2.getKey();
                entry2 = entry;
                File jarFile = entry2.getValue();
                try {
                    JarFileIssueRegistry registry;
                    if (this.get(client, registryClass, jarFile) == null) {
                        continue;
                    }
                    registries.add(registry);
                }
                catch (Throwable e) {
                    client.log(e, "Could not load custom lint check jar file %1$s", jarFile);
                }
            }
            return registries;
        }

        private final JarFileIssueRegistry get(LintClient client, String registryClassName, File jarFile) {
            JarFileIssueRegistry jarFileIssueRegistry;
            if (this.getCache() == null) {
                this.setCache(new HashMap());
            } else {
                JarFileIssueRegistry registry;
                SoftReference<JarFileIssueRegistry> reference;
                Map<File, SoftReference<JarFileIssueRegistry>> map = this.getCache();
                if (map == null) {
                    Intrinsics.throwNpe();
                }
                if ((reference = map.get(jarFile)) != null && (registry = reference.get()) != null && registry.isUpToDate()) {
                    return registry;
                }
            }
            IssueRegistry.reset();
            IssueRegistry userRegistry = this.loadIssueRegistry(client, jarFile, registryClassName);
            if (userRegistry != null) {
                JarFileIssueRegistry jarIssueRegistry = new JarFileIssueRegistry(client, jarFile, userRegistry, null);
                Map<File, SoftReference<JarFileIssueRegistry>> map = this.getCache();
                if (map == null) {
                    Intrinsics.throwNpe();
                }
                map.put(jarFile, new SoftReference<JarFileIssueRegistry>(jarIssueRegistry));
                jarFileIssueRegistry = jarIssueRegistry;
            } else {
                jarFileIssueRegistry = null;
            }
            return jarFileIssueRegistry;
        }

        @NotNull
        public final IssueRegistry join(IssueRegistry ... registries) {
            Intrinsics.checkParameterIsNotNull((Object)registries, (String)"registries");
            return ((Object[])registries).length == 1 ? registries[0] : (IssueRegistry)new CompositeIssueRegistry(ArraysKt.toList((Object[])registries));
        }

        private final IssueRegistry loadIssueRegistry(LintClient client, File jarFile, String className) {
            IssueRegistry issueRegistry;
            URL url = SdkUtils.fileToUrl((File)jarFile);
            try {
                URL[] uRLArray = new URL[1];
                URL uRL = url;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
                uRLArray[0] = uRL;
                ClassLoader classLoader = JarFileIssueRegistry.class.getClassLoader();
                Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"JarFileIssueRegistry::class.java.classLoader");
                ClassLoader loader = client.createUrlClassLoader(uRLArray, classLoader);
                Class<?> registryClass = Class.forName(className, true, loader);
                Object obj = registryClass.newInstance();
                if (obj == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.tools.lint.client.api.IssueRegistry");
                }
                issueRegistry = (IssueRegistry)obj;
            }
            catch (Throwable e) {
                client.log(e, "Could not load custom lint check jar file %1$s", jarFile);
                issueRegistry = null;
            }
            return issueRegistry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Map<String, File> findRegistries(LintClient client, Collection<? extends File> jarFiles) {
            HashMap registryClassToJarFile = new HashMap();
            for (File file : jarFiles) {
                Closeable closeable = new JarFile(file);
                Throwable throwable = null;
                try {
                    Serializable serializable;
                    Object object;
                    JarFile file2 = (JarFile)closeable;
                    Manifest manifest = file2.getManifest();
                    Attributes attrs = manifest.getMainAttributes();
                    Object attribute = attrs.get(new Attributes.Name(JarFileIssueRegistry.MF_LINT_REGISTRY));
                    boolean isLegacy = false;
                    if (attribute == null && (attribute = attrs.get(new Attributes.Name(JarFileIssueRegistry.MF_LINT_REGISTRY_OLD))) != null) {
                        isLegacy = true;
                    }
                    if (attribute instanceof String) {
                        Object className = attribute;
                        if (!isLegacy || registryClassToJarFile.get(className) == null) {
                            object = registryClassToJarFile;
                            serializable = file;
                            object.put(className, serializable);
                        }
                    } else {
                        JarEntry services = file2.getJarEntry(JarFileIssueRegistry.SERVICE_KEY);
                        if (services != null) {
                            object = file2.getInputStream(services);
                            serializable = null;
                            try {
                                Reader $receiver$iv;
                                InputStream it = (InputStream)object;
                                InputStreamReader reader = new InputStreamReader(it, Charsets.UTF_8);
                                Closeable closeable2 = $receiver$iv = (Reader)reader;
                                int n = 8192;
                                closeable2 = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n);
                                Throwable throwable2 = null;
                                try {
                                    BufferedReader it$iv = (BufferedReader)closeable2;
                                    Sequence it2 = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                                    for (String line : it2) {
                                        String className;
                                        String string;
                                        Object object2;
                                        int comment = StringsKt.indexOf$default((CharSequence)line, (String)"#", (int)0, (boolean)false, (int)6, null);
                                        if (comment >= 0) {
                                            object2 = line;
                                            int n2 = 0;
                                            String string2 = object2;
                                            if (string2 == null) {
                                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                            }
                                            String string3 = string2.substring(n2, comment);
                                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                            object2 = string3;
                                            CharSequence charSequence = object2;
                                            if (charSequence == null) {
                                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                            }
                                            string = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
                                        } else {
                                            object2 = line;
                                            String string4 = object2;
                                            if (string4 == null) {
                                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                            }
                                            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                                        }
                                        if ((object2 = (CharSequence)(className = string)).length() == 0 || registryClassToJarFile.get(className) != null) continue;
                                        object2 = registryClassToJarFile;
                                        File file22 = file;
                                        object2.put(className, file22);
                                    }
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable4) {
                                serializable = throwable4;
                                throw throwable4;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object, (Throwable)serializable);
                            }
                            Map map = registryClassToJarFile;
                            return map;
                        }
                        Object[] objectArray = new Object[2];
                        String string = file.getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jarFile.path");
                        objectArray[0] = string;
                        objectArray[1] = JarFileIssueRegistry.MF_LINT_REGISTRY;
                        client.log(Severity.ERROR, null, "Custom lint rule jar %1$s does not contain a valid registry manifest key (%2$s).\nEither the custom jar is invalid, or it uses an outdated API not supported this lint client", objectArray);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            return registryClassToJarFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void loadAndCloseURLClassLoader(LintClient client, File file, URLClassLoader loader) {
            try {
                Closeable closeable = new JarFile(file);
                Throwable throwable = null;
                try {
                    JarFile jar = (JarFile)closeable;
                    Enumeration<JarEntry> enumeration = jar.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry entry = enumeration.nextElement();
                        String name = entry.getName();
                        if (!StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null)) continue;
                        String string = name;
                        int n = 0;
                        int n2 = name.length() - ".class".length();
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n, n2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        name = string3;
                        name = StringsKt.replace$default((String)name, (char)'/', (char)'.', (boolean)false, (int)4, null);
                        try {
                            Class<?> aClass = Class.forName(name, true, loader);
                            aClass.newInstance();
                        }
                        catch (Throwable e) {
                            client.log(Severity.ERROR, e, "Failed to prefetch " + name + " from " + file, new Object[0]);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    loader.close();
                }
                catch (Throwable throwable) {}
            }
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

