/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseModuleManager;
import org.jetbrains.idea.eclipse.config.CachedXmlDocumentSet;

@State(name="EclipseModuleManager")
public class EclipseModuleManagerImpl
implements EclipseModuleManager,
PersistentStateComponent<Element>,
StateStorageChooserEx {
    @NonNls
    private static final String VALUE_ATTR = "value";
    @NonNls
    private static final String VARELEMENT = "varelement";
    @NonNls
    private static final String VAR_ATTRIBUTE = "var";
    @NonNls
    private static final String CONELEMENT = "conelement";
    @NonNls
    private static final String FORCED_JDK = "forced_jdk";
    @NonNls
    private static final String SRC_DESCRIPTION = "src_description";
    @NonNls
    private static final String EXPECTED_POSITION = "expected_position";
    @NonNls
    private static final String SRC_FOLDER = "src_folder";
    private CachedXmlDocumentSet myDocumentSet;
    private final Map<String, String> myEclipseVariablePaths = new LinkedHashMap<String, String>();
    private final Set<String> myEclipseUrls = new LinkedHashSet<String>();
    private final Set<String> myUnknownCons = new LinkedHashSet<String>();
    private boolean myForceConfigureJDK;
    @NonNls
    private static final String SRC_PREFIX = "src:";
    @NonNls
    private static final String SRC_LINK_PREFIX = "linksrc:";
    @NonNls
    private static final String LINK_PREFIX = "link:";
    @NonNls
    private static final String PREFIX_ATTR = "kind";
    private final Module myModule;
    @NonNls
    private static final String LIBELEMENT = "libelement";
    private int myExpectedModuleSourcePlace;
    private Map<String, Integer> mySrcPlace = new LinkedHashMap<String, Integer>();
    private String myInvalidJdk;
    private Set<String> myKnownCons = new LinkedHashSet<String>();

    public EclipseModuleManagerImpl(Module module) {
        this.myModule = module;
    }

    public static EclipseModuleManagerImpl getInstance(Module module) {
        return (EclipseModuleManagerImpl)ModuleServiceManager.getService((Module)module, EclipseModuleManagerImpl.class);
    }

    public static boolean isEclipseStorage(@NotNull Module module) {
        if (module == null) {
            EclipseModuleManagerImpl.$$$reportNull$$$0(0);
        }
        return "eclipse".equals(ClassPathStorageUtil.getStorageType((Module)module));
    }

    public void setInvalidJdk(String invalidJdk) {
        this.myInvalidJdk = invalidJdk;
    }

    public String getInvalidJdk() {
        return this.myInvalidJdk;
    }

    public void registerCon(String name) {
        this.myKnownCons.add(name);
    }

    public String[] getUsedCons() {
        return ArrayUtil.toStringArray(this.myKnownCons);
    }

    @Nullable
    public CachedXmlDocumentSet getDocumentSet() {
        return this.myDocumentSet;
    }

    public void setDocumentSet(@Nullable CachedXmlDocumentSet documentSet) {
        this.myDocumentSet = documentSet;
    }

    public void registerEclipseVariablePath(String path, String var) {
        this.myEclipseVariablePaths.put(path, var);
    }

    public void registerEclipseSrcVariablePath(String path, String var) {
        this.myEclipseVariablePaths.put(SRC_PREFIX + path, var);
    }

    public void registerEclipseLinkedSrcVarPath(String path, String var) {
        this.myEclipseVariablePaths.put(SRC_LINK_PREFIX + path, var);
    }

    public String getEclipseLinkedSrcVariablePath(String path) {
        return this.myEclipseVariablePaths.get(SRC_LINK_PREFIX + path);
    }

    public void registerEclipseLinkedVarPath(String path, String var) {
        this.myEclipseVariablePaths.put(LINK_PREFIX + path, var);
    }

    public String getEclipseLinkedVarPath(String path) {
        return this.myEclipseVariablePaths.get(LINK_PREFIX + path);
    }

    public String getEclipseVariablePath(String path) {
        return this.myEclipseVariablePaths.get(path);
    }

    public String getEclipseSrcVariablePath(String path) {
        return this.myEclipseVariablePaths.get(SRC_PREFIX + path);
    }

    public void registerUnknownCons(String con) {
        this.myUnknownCons.add(con);
    }

    @NotNull
    public Set<String> getUnknownCons() {
        Set<String> set = this.myUnknownCons;
        if (set == null) {
            EclipseModuleManagerImpl.$$$reportNull$$$0(1);
        }
        return set;
    }

    public boolean isForceConfigureJDK() {
        return this.myForceConfigureJDK;
    }

    public void setForceConfigureJDK() {
        this.myForceConfigureJDK = true;
        ++this.myExpectedModuleSourcePlace;
    }

    public void registerEclipseLibUrl(String url) {
        this.myEclipseUrls.add(url);
    }

    public boolean isEclipseLibUrl(String url) {
        return this.myEclipseUrls.contains(url);
    }

    @NotNull
    public StateStorageChooserEx.Resolution getResolution(@NotNull Storage storage, @NotNull StateStorageOperation operation) {
        if (storage == null) {
            EclipseModuleManagerImpl.$$$reportNull$$$0(2);
        }
        if (operation == null) {
            EclipseModuleManagerImpl.$$$reportNull$$$0(3);
        }
        if (operation == StateStorageOperation.READ) {
            StateStorageChooserEx.Resolution resolution = StateStorageChooserEx.Resolution.DO;
            if (resolution == null) {
                EclipseModuleManagerImpl.$$$reportNull$$$0(4);
            }
            return resolution;
        }
        if (EclipseModuleManagerImpl.isEclipseStorage(this.myModule) || this.myEclipseUrls.isEmpty() && this.myEclipseVariablePaths.isEmpty() && !this.myForceConfigureJDK && this.myUnknownCons.isEmpty()) {
            StateStorageChooserEx.Resolution resolution = StateStorageChooserEx.Resolution.CLEAR;
            if (resolution == null) {
                EclipseModuleManagerImpl.$$$reportNull$$$0(5);
            }
            return resolution;
        }
        StateStorageChooserEx.Resolution resolution = StateStorageChooserEx.Resolution.DO;
        if (resolution == null) {
            EclipseModuleManagerImpl.$$$reportNull$$$0(6);
        }
        return resolution;
    }

    public Element getState() {
        Element root = new Element("EclipseModuleSettings");
        for (String eclipseUrl : this.myEclipseUrls) {
            root.addContent(new Element(LIBELEMENT).setAttribute(VALUE_ATTR, eclipseUrl));
        }
        for (String var : this.myEclipseVariablePaths.keySet()) {
            Element varElement = new Element(VARELEMENT);
            if (var.startsWith(SRC_PREFIX)) {
                varElement.setAttribute(VAR_ATTRIBUTE, StringUtil.trimStart((String)var, (String)SRC_PREFIX));
                varElement.setAttribute(PREFIX_ATTR, SRC_PREFIX);
            } else if (var.startsWith(SRC_LINK_PREFIX)) {
                varElement.setAttribute(VAR_ATTRIBUTE, StringUtil.trimStart((String)var, (String)SRC_LINK_PREFIX));
                varElement.setAttribute(PREFIX_ATTR, SRC_LINK_PREFIX);
            } else if (var.startsWith(LINK_PREFIX)) {
                varElement.setAttribute(VAR_ATTRIBUTE, StringUtil.trimStart((String)var, (String)LINK_PREFIX));
                varElement.setAttribute(PREFIX_ATTR, LINK_PREFIX);
            } else {
                varElement.setAttribute(VAR_ATTRIBUTE, var);
            }
            varElement.setAttribute(VALUE_ATTR, this.myEclipseVariablePaths.get(var));
            root.addContent(varElement);
        }
        for (String unknownCon : this.myUnknownCons) {
            root.addContent(new Element(CONELEMENT).setAttribute(VALUE_ATTR, unknownCon));
        }
        if (this.myForceConfigureJDK) {
            root.setAttribute(FORCED_JDK, String.valueOf(true));
        }
        Element srcDescriptionElement = new Element(SRC_DESCRIPTION);
        srcDescriptionElement.setAttribute(EXPECTED_POSITION, String.valueOf(this.myExpectedModuleSourcePlace));
        for (String srcUrl : this.mySrcPlace.keySet()) {
            Element srcFolder = new Element(SRC_FOLDER);
            srcFolder.setAttribute(VALUE_ATTR, srcUrl);
            srcFolder.setAttribute(EXPECTED_POSITION, this.mySrcPlace.get(srcUrl).toString());
            srcDescriptionElement.addContent(srcFolder);
        }
        root.addContent(srcDescriptionElement);
        return root;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            EclipseModuleManagerImpl.$$$reportNull$$$0(7);
        }
        this.myEclipseUrls.clear();
        this.myEclipseVariablePaths.clear();
        this.myUnknownCons.clear();
        this.mySrcPlace.clear();
        this.myKnownCons.clear();
        for (Element o : state.getChildren(LIBELEMENT)) {
            this.myEclipseUrls.add(o.getAttributeValue(VALUE_ATTR));
        }
        for (Element o : state.getChildren(VARELEMENT)) {
            this.myEclipseVariablePaths.put(o.getAttributeValue(VAR_ATTRIBUTE), o.getAttributeValue(PREFIX_ATTR, "") + o.getAttributeValue(VALUE_ATTR));
        }
        for (Element o : state.getChildren(CONELEMENT)) {
            this.myUnknownCons.add(o.getAttributeValue(VALUE_ATTR));
        }
        this.myForceConfigureJDK = Boolean.parseBoolean(state.getAttributeValue(FORCED_JDK, "false"));
        Element srcDescriptionElement = state.getChild(SRC_DESCRIPTION);
        if (srcDescriptionElement != null) {
            this.myExpectedModuleSourcePlace = Integer.parseInt(srcDescriptionElement.getAttributeValue(EXPECTED_POSITION));
            for (Element o : srcDescriptionElement.getChildren(SRC_FOLDER)) {
                this.mySrcPlace.put(o.getAttributeValue(VALUE_ATTR), Integer.parseInt(o.getAttributeValue(EXPECTED_POSITION)));
            }
        }
    }

    public void setExpectedModuleSourcePlace(int expectedModuleSourcePlace) {
        this.myExpectedModuleSourcePlace = expectedModuleSourcePlace;
    }

    public boolean isExpectedModuleSourcePlace(int expectedPlace) {
        return this.myExpectedModuleSourcePlace == expectedPlace;
    }

    public void registerSrcPlace(String srcUrl, int placeIdx) {
        this.mySrcPlace.put(srcUrl, placeIdx);
    }

    public int getSrcPlace(String srcUtl) {
        Integer v = this.mySrcPlace.get(srcUtl);
        return v == null ? -1 : v;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/eclipse/config/EclipseModuleManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/eclipse/config/EclipseModuleManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknownCons";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEclipseStorage";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResolution";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

