/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHidDeviceAppConfiguration;
import android.bluetooth.BluetoothHidDeviceAppQosSettings;
import android.bluetooth.BluetoothHidDeviceAppSdpSettings;
import android.bluetooth.BluetoothHidDeviceCallback;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothHidDeviceCallback;
import android.bluetooth.IBluetoothInputHost;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BluetoothInputHost
implements BluetoothProfile {
    private static final String TAG = BluetoothInputHost.class.getSimpleName();
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.inputhost.profile.action.CONNECTION_STATE_CHANGED";
    public static final byte SUBCLASS1_NONE = 0;
    public static final byte SUBCLASS1_KEYBOARD = 64;
    public static final byte SUBCLASS1_MOUSE = -128;
    public static final byte SUBCLASS1_COMBO = -64;
    public static final byte SUBCLASS2_UNCATEGORIZED = 0;
    public static final byte SUBCLASS2_JOYSTICK = 1;
    public static final byte SUBCLASS2_GAMEPAD = 2;
    public static final byte SUBCLASS2_REMOTE_CONTROL = 3;
    public static final byte SUBCLASS2_SENSING_DEVICE = 4;
    public static final byte SUBCLASS2_DIGITIZER_TABLED = 5;
    public static final byte SUBCLASS2_CARD_READER = 6;
    public static final byte REPORT_TYPE_INPUT = 1;
    public static final byte REPORT_TYPE_OUTPUT = 2;
    public static final byte REPORT_TYPE_FEATURE = 3;
    public static final byte ERROR_RSP_SUCCESS = 0;
    public static final byte ERROR_RSP_NOT_READY = 1;
    public static final byte ERROR_RSP_INVALID_RPT_ID = 2;
    public static final byte ERROR_RSP_UNSUPPORTED_REQ = 3;
    public static final byte ERROR_RSP_INVALID_PARAM = 4;
    public static final byte ERROR_RSP_UNKNOWN = 14;
    public static final byte PROTOCOL_BOOT_MODE = 0;
    public static final byte PROTOCOL_REPORT_MODE = 1;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private volatile IBluetoothInputHost mService;
    private BluetoothAdapter mAdapter;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothStateChange(boolean up) {
            Log.d(TAG, "onBluetoothStateChange: up=" + up);
            ServiceConnection serviceConnection = BluetoothInputHost.this.mConnection;
            synchronized (serviceConnection) {
                if (!up) {
                    Log.d(TAG, "Unbinding service...");
                    if (BluetoothInputHost.this.mService != null) {
                        BluetoothInputHost.this.mService = null;
                        try {
                            BluetoothInputHost.this.mContext.unbindService(BluetoothInputHost.this.mConnection);
                        }
                        catch (IllegalArgumentException e) {
                            Log.e(TAG, "onBluetoothStateChange: could not unbind service:", e);
                        }
                    }
                } else {
                    try {
                        if (BluetoothInputHost.this.mService == null) {
                            Log.d(TAG, "Binding HID Device service...");
                            BluetoothInputHost.this.doBind();
                        }
                    }
                    catch (IllegalStateException e) {
                        Log.e(TAG, "onBluetoothStateChange: could not bind to HID Dev service: ", e);
                    }
                    catch (SecurityException e) {
                        Log.e(TAG, "onBluetoothStateChange: could not bind to HID Dev service: ", e);
                    }
                }
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            Log.d(TAG, "onServiceConnected()");
            BluetoothInputHost.this.mService = IBluetoothInputHost.Stub.asInterface(service);
            if (BluetoothInputHost.this.mServiceListener != null) {
                BluetoothInputHost.this.mServiceListener.onServiceConnected(19, BluetoothInputHost.this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName className) {
            Log.d(TAG, "onServiceDisconnected()");
            BluetoothInputHost.this.mService = null;
            if (BluetoothInputHost.this.mServiceListener != null) {
                BluetoothInputHost.this.mServiceListener.onServiceDisconnected(19);
            }
        }
    };

    BluetoothInputHost(Context context, BluetoothProfile.ServiceListener listener) {
        Log.v(TAG, "BluetoothInputHost");
        this.mContext = context;
        this.mServiceListener = listener;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        this.doBind();
    }

    boolean doBind() {
        Intent intent = new Intent(IBluetoothInputHost.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e(TAG, "Could not bind to Bluetooth HID Device Service with " + intent);
            return false;
        }
        Log.d(TAG, "Bound to HID Device Service");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Log.v(TAG, "close()");
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                this.mService = null;
                try {
                    this.mContext.unbindService(this.mConnection);
                }
                catch (IllegalArgumentException e) {
                    Log.e(TAG, "close: could not unbind HID Dev service: ", e);
                }
            }
        }
        this.mServiceListener = null;
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        Log.v(TAG, "getConnectedDevices()");
        IBluetoothInputHost service = this.mService;
        if (service != null) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        Log.v(TAG, "getDevicesMatchingConnectionStates(): states=" + Arrays.toString(states));
        IBluetoothInputHost service = this.mService;
        if (service != null) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    public int getConnectionState(BluetoothDevice device) {
        Log.v(TAG, "getConnectionState(): device=" + device);
        IBluetoothInputHost service = this.mService;
        if (service != null) {
            try {
                return service.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    public boolean registerApp(BluetoothHidDeviceAppSdpSettings sdp, BluetoothHidDeviceAppQosSettings inQos, BluetoothHidDeviceAppQosSettings outQos, BluetoothHidDeviceCallback callback) {
        Log.v(TAG, "registerApp(): sdp=" + sdp + " inQos=" + inQos + " outQos=" + outQos + " callback=" + callback);
        boolean result = false;
        if (sdp == null || callback == null) {
            return false;
        }
        IBluetoothInputHost service = this.mService;
        if (service != null) {
            try {
                BluetoothHidDeviceAppConfiguration config = new BluetoothHidDeviceAppConfiguration();
                BluetoothHidDeviceCallbackWrapper cbw = new BluetoothHidDeviceCallbackWrapper(callback);
                result = service.registerApp(config, sdp, inQos, outQos, cbw);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean unregisterApp(BluetoothHidDeviceAppConfiguration config) {
        Log.v(TAG, "unregisterApp()");
        boolean result = false;
        IBluetoothInputHost service = this.mService;
        if (service != null) {
            try {
                result = service.unregisterApp(config);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean sendReport(BluetoothDevice device, int id2, byte[] data) {
        boolean result = false;
        IBluetoothInputHost service = this.mService;
        if (service != null) {
            try {
                result = service.sendReport(device, id2, data);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean replyReport(BluetoothDevice device, byte type, byte id2, byte[] data) {
        Log.v(TAG, "replyReport(): device=" + device + " type=" + type + " id=" + id2);
        boolean result = false;
        IBluetoothInputHost service = this.mService;
        if (service != null) {
            try {
                result = service.replyReport(device, type, id2, data);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean reportError(BluetoothDevice device, byte error) {
        Log.v(TAG, "reportError(): device=" + device + " error=" + error);
        boolean result = false;
        IBluetoothInputHost service = this.mService;
        if (service != null) {
            try {
                result = service.reportError(device, error);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean unplug(BluetoothDevice device) {
        Log.v(TAG, "unplug(): device=" + device);
        boolean result = false;
        IBluetoothInputHost service = this.mService;
        if (service != null) {
            try {
                result = service.unplug(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean connect(BluetoothDevice device) {
        Log.v(TAG, "connect(): device=" + device);
        boolean result = false;
        IBluetoothInputHost service = this.mService;
        if (service != null) {
            try {
                result = service.connect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    public boolean disconnect(BluetoothDevice device) {
        Log.v(TAG, "disconnect(): device=" + device);
        boolean result = false;
        IBluetoothInputHost service = this.mService;
        if (service != null) {
            try {
                result = service.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
        }
        return result;
    }

    private static class BluetoothHidDeviceCallbackWrapper
    extends IBluetoothHidDeviceCallback.Stub {
        private BluetoothHidDeviceCallback mCallback;

        public BluetoothHidDeviceCallbackWrapper(BluetoothHidDeviceCallback callback) {
            this.mCallback = callback;
        }

        @Override
        public void onAppStatusChanged(BluetoothDevice pluggedDevice, BluetoothHidDeviceAppConfiguration config, boolean registered) {
            this.mCallback.onAppStatusChanged(pluggedDevice, config, registered);
        }

        @Override
        public void onConnectionStateChanged(BluetoothDevice device, int state) {
            this.mCallback.onConnectionStateChanged(device, state);
        }

        @Override
        public void onGetReport(BluetoothDevice device, byte type, byte id2, int bufferSize) {
            this.mCallback.onGetReport(device, type, id2, bufferSize);
        }

        @Override
        public void onSetReport(BluetoothDevice device, byte type, byte id2, byte[] data) {
            this.mCallback.onSetReport(device, type, id2, data);
        }

        @Override
        public void onSetProtocol(BluetoothDevice device, byte protocol) {
            this.mCallback.onSetProtocol(device, protocol);
        }

        @Override
        public void onIntrData(BluetoothDevice device, byte reportId, byte[] data) {
            this.mCallback.onIntrData(device, reportId, data);
        }

        @Override
        public void onVirtualCableUnplug(BluetoothDevice device) {
            this.mCallback.onVirtualCableUnplug(device);
        }
    }
}

