/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.BaseCanvas;
import android.graphics.Bitmap;
import android.graphics.Canvas_Delegate;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.microedition.khronos.opengles.GL;
import libcore.util.NativeAllocationRegistry;

public class Canvas
extends BaseCanvas {
    public static boolean sCompatibilityRestore = false;
    public static boolean sCompatibilitySetBitmap = false;
    private Bitmap mBitmap;
    private DrawFilter mDrawFilter;
    private static final int MAXMIMUM_BITMAP_SIZE = 32766;
    private static final long NATIVE_ALLOCATION_SIZE = 525L;
    private Runnable mFinalizer;
    public static final int MATRIX_SAVE_FLAG = 1;
    public static final int CLIP_SAVE_FLAG = 2;
    public static final int HAS_ALPHA_LAYER_SAVE_FLAG = 4;
    public static final int FULL_COLOR_LAYER_SAVE_FLAG = 8;
    public static final int CLIP_TO_LAYER_SAVE_FLAG = 16;
    public static final int ALL_SAVE_FLAG = 31;

    public long getNativeCanvasWrapper() {
        return this.mNativeCanvasWrapper;
    }

    public boolean isRecordingFor(Object o) {
        return false;
    }

    public Canvas() {
        if (!this.isHardwareAccelerated()) {
            this.mNativeCanvasWrapper = Canvas.nInitRaster(null);
            this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativeCanvasWrapper);
        } else {
            this.mFinalizer = null;
        }
    }

    public Canvas(Bitmap bitmap) {
        if (!bitmap.isMutable()) {
            throw new IllegalStateException("Immutable bitmap passed to Canvas constructor");
        }
        this.throwIfCannotDraw(bitmap);
        this.mNativeCanvasWrapper = Canvas.nInitRaster(bitmap);
        this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativeCanvasWrapper);
        this.mBitmap = bitmap;
        this.mDensity = bitmap.mDensity;
    }

    public Canvas(long nativeCanvas) {
        if (nativeCanvas == 0L) {
            throw new IllegalStateException();
        }
        this.mNativeCanvasWrapper = nativeCanvas;
        this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativeCanvasWrapper);
        this.mDensity = Bitmap.getDefaultDensity();
    }

    @Deprecated
    protected GL getGL() {
        return null;
    }

    @Override
    public boolean isHardwareAccelerated() {
        return false;
    }

    public void setBitmap(Bitmap bitmap) {
        if (this.isHardwareAccelerated()) {
            throw new RuntimeException("Can't set a bitmap device on a HW accelerated canvas");
        }
        Matrix preservedMatrix = null;
        if (bitmap != null && sCompatibilitySetBitmap) {
            preservedMatrix = this.getMatrix();
        }
        if (bitmap == null) {
            Canvas.nSetBitmap(this.mNativeCanvasWrapper, null);
            this.mDensity = 0;
        } else {
            if (!bitmap.isMutable()) {
                throw new IllegalStateException();
            }
            this.throwIfCannotDraw(bitmap);
            Canvas.nSetBitmap(this.mNativeCanvasWrapper, bitmap);
            this.mDensity = bitmap.mDensity;
        }
        if (preservedMatrix != null) {
            this.setMatrix(preservedMatrix);
        }
        this.mBitmap = bitmap;
    }

    public void insertReorderBarrier() {
    }

    public void insertInorderBarrier() {
    }

    public boolean isOpaque() {
        return Canvas.nIsOpaque(this.mNativeCanvasWrapper);
    }

    public int getWidth() {
        return Canvas.nGetWidth(this.mNativeCanvasWrapper);
    }

    public int getHeight() {
        return Canvas.nGetHeight(this.mNativeCanvasWrapper);
    }

    public int getDensity() {
        return this.mDensity;
    }

    public void setDensity(int density) {
        if (this.mBitmap != null) {
            this.mBitmap.setDensity(density);
        }
        this.mDensity = density;
    }

    public void setScreenDensity(int density) {
        this.mScreenDensity = density;
    }

    public int getMaximumBitmapWidth() {
        return 32766;
    }

    public int getMaximumBitmapHeight() {
        return 32766;
    }

    public int save() {
        return Canvas.nSave(this.mNativeCanvasWrapper, 3);
    }

    public int save(int saveFlags) {
        return Canvas.nSave(this.mNativeCanvasWrapper, saveFlags);
    }

    public int saveLayer(RectF bounds, Paint paint, int saveFlags) {
        if (bounds == null) {
            bounds = new RectF(this.getClipBounds());
        }
        return this.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, paint, saveFlags);
    }

    public int saveLayer(RectF bounds, Paint paint) {
        return this.saveLayer(bounds, paint, 31);
    }

    public int saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        return Canvas.nSaveLayer(this.mNativeCanvasWrapper, left, top, right, bottom, paint != null ? paint.getNativeInstance() : 0L, saveFlags);
    }

    public int saveLayer(float left, float top, float right, float bottom, Paint paint) {
        return this.saveLayer(left, top, right, bottom, paint, 31);
    }

    public int saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        if (bounds == null) {
            bounds = new RectF(this.getClipBounds());
        }
        return this.saveLayerAlpha(bounds.left, bounds.top, bounds.right, bounds.bottom, alpha, saveFlags);
    }

    public int saveLayerAlpha(RectF bounds, int alpha) {
        return this.saveLayerAlpha(bounds, alpha, 31);
    }

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        alpha = Math.min(255, Math.max(0, alpha));
        return Canvas.nSaveLayerAlpha(this.mNativeCanvasWrapper, left, top, right, bottom, alpha, saveFlags);
    }

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha) {
        return this.saveLayerAlpha(left, top, right, bottom, alpha, 31);
    }

    public void restore() {
        if (!(Canvas.nRestore(this.mNativeCanvasWrapper) || sCompatibilityRestore && this.isHardwareAccelerated())) {
            throw new IllegalStateException("Underflow in restore - more restores than saves");
        }
    }

    public int getSaveCount() {
        return Canvas.nGetSaveCount(this.mNativeCanvasWrapper);
    }

    public void restoreToCount(int saveCount) {
        if (saveCount < 1) {
            if (!sCompatibilityRestore || !this.isHardwareAccelerated()) {
                throw new IllegalArgumentException("Underflow in restoreToCount - more restores than saves");
            }
            saveCount = 1;
        }
        Canvas.nRestoreToCount(this.mNativeCanvasWrapper, saveCount);
    }

    public void translate(float dx, float dy) {
        if (dx == 0.0f && dy == 0.0f) {
            return;
        }
        Canvas.nTranslate(this.mNativeCanvasWrapper, dx, dy);
    }

    public void scale(float sx, float sy) {
        if (sx == 1.0f && sy == 1.0f) {
            return;
        }
        Canvas.nScale(this.mNativeCanvasWrapper, sx, sy);
    }

    public void scale(float sx, float sy, float px, float py) {
        if (sx == 1.0f && sy == 1.0f) {
            return;
        }
        this.translate(px, py);
        this.scale(sx, sy);
        this.translate(-px, -py);
    }

    public void rotate(float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        Canvas.nRotate(this.mNativeCanvasWrapper, degrees);
    }

    public void rotate(float degrees, float px, float py) {
        if (degrees == 0.0f) {
            return;
        }
        this.translate(px, py);
        this.rotate(degrees);
        this.translate(-px, -py);
    }

    public void skew(float sx, float sy) {
        if (sx == 0.0f && sy == 0.0f) {
            return;
        }
        Canvas.nSkew(this.mNativeCanvasWrapper, sx, sy);
    }

    public void concat(Matrix matrix) {
        if (matrix != null) {
            Canvas.nConcat(this.mNativeCanvasWrapper, matrix.native_instance);
        }
    }

    public void setMatrix(Matrix matrix) {
        Canvas.nSetMatrix(this.mNativeCanvasWrapper, matrix == null ? 0L : matrix.native_instance);
    }

    @Deprecated
    public void getMatrix(Matrix ctm) {
        Canvas.nGetMatrix(this.mNativeCanvasWrapper, ctm.native_instance);
    }

    @Deprecated
    public Matrix getMatrix() {
        Matrix m = new Matrix();
        this.getMatrix(m);
        return m;
    }

    @Deprecated
    public boolean clipRect(RectF rect, Region.Op op) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    @Deprecated
    public boolean clipRect(Rect rect, Region.Op op) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRect(RectF rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipOutRect(RectF rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.DIFFERENCE.nativeInt);
    }

    public boolean clipRect(Rect rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipOutRect(Rect rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.DIFFERENCE.nativeInt);
    }

    @Deprecated
    public boolean clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, op.nativeInt);
    }

    public boolean clipRect(float left, float top, float right, float bottom) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipOutRect(float left, float top, float right, float bottom) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.DIFFERENCE.nativeInt);
    }

    public boolean clipRect(int left, int top, int right, int bottom) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipOutRect(int left, int top, int right, int bottom) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.DIFFERENCE.nativeInt);
    }

    @Deprecated
    public boolean clipPath(Path path, Region.Op op) {
        return Canvas.nClipPath(this.mNativeCanvasWrapper, path.readOnlyNI(), op.nativeInt);
    }

    public boolean clipPath(Path path) {
        return this.clipPath(path, Region.Op.INTERSECT);
    }

    public boolean clipOutPath(Path path) {
        return this.clipPath(path, Region.Op.DIFFERENCE);
    }

    @Deprecated
    public boolean clipRegion(Region region, Region.Op op) {
        return false;
    }

    @Deprecated
    public boolean clipRegion(Region region) {
        return false;
    }

    public DrawFilter getDrawFilter() {
        return this.mDrawFilter;
    }

    public void setDrawFilter(DrawFilter filter) {
        long nativeFilter = 0L;
        if (filter != null) {
            nativeFilter = filter.mNativeInt;
        }
        this.mDrawFilter = filter;
        Canvas.nSetDrawFilter(this.mNativeCanvasWrapper, nativeFilter);
    }

    public boolean quickReject(RectF rect, EdgeType type) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom);
    }

    public boolean quickReject(Path path, EdgeType type) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, path.readOnlyNI());
    }

    public boolean quickReject(float left, float top, float right, float bottom, EdgeType type) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, left, top, right, bottom);
    }

    public boolean getClipBounds(Rect bounds) {
        return Canvas.nGetClipBounds(this.mNativeCanvasWrapper, bounds);
    }

    public Rect getClipBounds() {
        Rect r = new Rect();
        this.getClipBounds(r);
        return r;
    }

    public void drawPicture(Picture picture) {
        picture.endRecording();
        int restoreCount = this.save();
        picture.draw(this);
        this.restoreToCount(restoreCount);
    }

    public void drawPicture(Picture picture, RectF dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPicture(Picture picture, Rect dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale((float)dst.width() / (float)picture.getWidth(), (float)dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void release() {
        this.mNativeCanvasWrapper = 0L;
        if (this.mFinalizer != null) {
            this.mFinalizer.run();
            this.mFinalizer = null;
        }
    }

    public static void freeCaches() {
        Canvas.nFreeCaches();
    }

    public static void freeTextLayoutCaches() {
        Canvas.nFreeTextLayoutCaches();
    }

    @LayoutlibDelegate
    private static void nFreeCaches() {
        Canvas_Delegate.nFreeCaches();
    }

    @LayoutlibDelegate
    private static void nFreeTextLayoutCaches() {
        Canvas_Delegate.nFreeTextLayoutCaches();
    }

    @LayoutlibDelegate
    private static long nInitRaster(Bitmap bitmap) {
        return Canvas_Delegate.nInitRaster(bitmap);
    }

    @LayoutlibDelegate
    private static long nGetNativeFinalizer() {
        return Canvas_Delegate.nGetNativeFinalizer();
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetBitmap(long l, Bitmap bitmap) {
        Canvas_Delegate.nSetBitmap(l, bitmap);
    }

    @LayoutlibDelegate
    @FastNative
    private static boolean nGetClipBounds(long l, Rect rect) {
        return Canvas_Delegate.nGetClipBounds(l, rect);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nIsOpaque(long l) {
        return Canvas_Delegate.nIsOpaque(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nGetWidth(long l) {
        return Canvas_Delegate.nGetWidth(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nGetHeight(long l) {
        return Canvas_Delegate.nGetHeight(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nSave(long l, int n) {
        return Canvas_Delegate.nSave(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nSaveLayer(long l, float f, float f2, float f3, float f4, long l2, int n) {
        return Canvas_Delegate.nSaveLayer(l, f, f2, f3, f4, l2, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nSaveLayerAlpha(long l, float f, float f2, float f3, float f4, int n, int n2) {
        return Canvas_Delegate.nSaveLayerAlpha(l, f, f2, f3, f4, n, n2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nRestore(long l) {
        return Canvas_Delegate.nRestore(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nRestoreToCount(long l, int n) {
        Canvas_Delegate.nRestoreToCount(l, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static int nGetSaveCount(long l) {
        return Canvas_Delegate.nGetSaveCount(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nTranslate(long l, float f, float f2) {
        Canvas_Delegate.nTranslate(l, f, f2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nScale(long l, float f, float f2) {
        Canvas_Delegate.nScale(l, f, f2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nRotate(long l, float f) {
        Canvas_Delegate.nRotate(l, f);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSkew(long l, float f, float f2) {
        Canvas_Delegate.nSkew(l, f, f2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nConcat(long l, long l2) {
        Canvas_Delegate.nConcat(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetMatrix(long l, long l2) {
        Canvas_Delegate.nSetMatrix(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nClipRect(long l, float f, float f2, float f3, float f4, int n) {
        return Canvas_Delegate.nClipRect(l, f, f2, f3, f4, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nClipPath(long l, long l2, int n) {
        return Canvas_Delegate.nClipPath(l, l2, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nSetDrawFilter(long l, long l2) {
        Canvas_Delegate.nSetDrawFilter(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nGetMatrix(long l, long l2) {
        Canvas_Delegate.nGetMatrix(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nQuickReject(long l, long l2) {
        return Canvas_Delegate.nQuickReject(l, l2);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static boolean nQuickReject(long l, float f, float f2, float f3, float f4) {
        return Canvas_Delegate.nQuickReject(l, f, f2, f3, f4);
    }

    @Override
    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        super.drawArc(oval, startAngle, sweepAngle, useCenter, paint);
    }

    @Override
    public void drawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        super.drawArc(left, top, right, bottom, startAngle, sweepAngle, useCenter, paint);
    }

    @Override
    public void drawARGB(int a, int r, int g, int b) {
        super.drawARGB(a, r, g, b);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        super.drawBitmap(bitmap, left, top, paint);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        super.drawBitmap(bitmap, src, dst, paint);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        super.drawBitmap(bitmap, src, dst, paint);
    }

    @Override
    @Deprecated
    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        super.drawBitmap(colors, offset, stride, x, y, width, height, hasAlpha, paint);
    }

    @Override
    @Deprecated
    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        super.drawBitmap(colors, offset, stride, x, y, width, height, hasAlpha, paint);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        super.drawBitmap(bitmap, matrix, paint);
    }

    @Override
    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        super.drawBitmapMesh(bitmap, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint);
    }

    @Override
    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        super.drawCircle(cx, cy, radius, paint);
    }

    @Override
    public void drawColor(int color2) {
        super.drawColor(color2);
    }

    @Override
    public void drawColor(int color2, PorterDuff.Mode mode) {
        super.drawColor(color2, mode);
    }

    @Override
    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        super.drawLine(startX, startY, stopX, stopY, paint);
    }

    @Override
    public void drawLines(float[] pts, int offset, int count, Paint paint) {
        super.drawLines(pts, offset, count, paint);
    }

    @Override
    public void drawLines(float[] pts, Paint paint) {
        super.drawLines(pts, paint);
    }

    @Override
    public void drawOval(RectF oval, Paint paint) {
        super.drawOval(oval, paint);
    }

    @Override
    public void drawOval(float left, float top, float right, float bottom, Paint paint) {
        super.drawOval(left, top, right, bottom, paint);
    }

    @Override
    public void drawPaint(Paint paint) {
        super.drawPaint(paint);
    }

    @Override
    public void drawPatch(NinePatch patch, Rect dst, Paint paint) {
        super.drawPatch(patch, dst, paint);
    }

    @Override
    public void drawPatch(NinePatch patch, RectF dst, Paint paint) {
        super.drawPatch(patch, dst, paint);
    }

    @Override
    public void drawPath(Path path, Paint paint) {
        super.drawPath(path, paint);
    }

    @Override
    public void drawPoint(float x, float y, Paint paint) {
        super.drawPoint(x, y, paint);
    }

    @Override
    public void drawPoints(float[] pts, int offset, int count, Paint paint) {
        super.drawPoints(pts, offset, count, paint);
    }

    @Override
    public void drawPoints(float[] pts, Paint paint) {
        super.drawPoints(pts, paint);
    }

    @Override
    @Deprecated
    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        super.drawPosText(text, index, count, pos, paint);
    }

    @Override
    @Deprecated
    public void drawPosText(String text, float[] pos, Paint paint) {
        super.drawPosText(text, pos, paint);
    }

    @Override
    public void drawRect(RectF rect, Paint paint) {
        super.drawRect(rect, paint);
    }

    @Override
    public void drawRect(Rect r, Paint paint) {
        super.drawRect(r, paint);
    }

    @Override
    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        super.drawRect(left, top, right, bottom, paint);
    }

    @Override
    public void drawRGB(int r, int g, int b) {
        super.drawRGB(r, g, b);
    }

    @Override
    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        super.drawRoundRect(rect, rx, ry, paint);
    }

    @Override
    public void drawRoundRect(float left, float top, float right, float bottom, float rx, float ry, Paint paint) {
        super.drawRoundRect(left, top, right, bottom, rx, ry, paint);
    }

    @Override
    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        super.drawText(text, index, count, x, y, paint);
    }

    @Override
    public void drawText(String text, float x, float y, Paint paint) {
        super.drawText(text, x, y, paint);
    }

    @Override
    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        super.drawText(text, start, end, x, y, paint);
    }

    @Override
    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        super.drawText(text, start, end, x, y, paint);
    }

    @Override
    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        super.drawTextOnPath(text, index, count, path, hOffset, vOffset, paint);
    }

    @Override
    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        super.drawTextOnPath(text, path, hOffset, vOffset, paint);
    }

    @Override
    public void drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, boolean isRtl, Paint paint) {
        super.drawTextRun(text, index, count, contextIndex, contextCount, x, y, isRtl, paint);
    }

    @Override
    public void drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint paint) {
        super.drawTextRun(text, start, end, contextStart, contextEnd, x, y, isRtl, paint);
    }

    @Override
    public void drawVertices(VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
        super.drawVertices(mode, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint);
    }

    static /* synthetic */ long access$000() {
        return Canvas.nGetNativeFinalizer();
    }

    public static enum VertexMode {
        TRIANGLES(0),
        TRIANGLE_STRIP(1),
        TRIANGLE_FAN(2);

        public final int nativeInt;

        private VertexMode(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static enum EdgeType {
        BW(0),
        AA(1);

        public final int nativeInt;

        private EdgeType(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Saveflags {
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = new NativeAllocationRegistry(Canvas.class.getClassLoader(), Canvas.access$000(), 525L);

        private NoImagePreloadHolder() {
        }
    }
}

