/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.content.Context;
import android.hardware.radio.IRadioService;
import android.hardware.radio.ITuner;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioMetadata;
import android.hardware.radio.RadioTuner;
import android.hardware.radio.TunerAdapter;
import android.hardware.radio.TunerCallbackAdapter;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RadioManager {
    private static final String TAG = "BroadcastRadio.manager";
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR = Integer.MIN_VALUE;
    public static final int STATUS_PERMISSION_DENIED = -1;
    public static final int STATUS_NO_INIT = -19;
    public static final int STATUS_BAD_VALUE = -22;
    public static final int STATUS_DEAD_OBJECT = -32;
    public static final int STATUS_INVALID_OPERATION = -38;
    public static final int STATUS_TIMED_OUT = -110;
    public static final int CLASS_AM_FM = 0;
    public static final int CLASS_SAT = 1;
    public static final int CLASS_DT = 2;
    public static final int BAND_INVALID = -1;
    public static final int BAND_AM = 0;
    public static final int BAND_FM = 1;
    public static final int BAND_FM_HD = 2;
    public static final int BAND_AM_HD = 3;
    public static final int REGION_ITU_1 = 0;
    public static final int REGION_ITU_2 = 1;
    public static final int REGION_OIRT = 2;
    public static final int REGION_JAPAN = 3;
    public static final int REGION_KOREA = 4;
    private final Context mContext;
    private final IRadioService mService;

    private static void writeStringMap(Parcel dest, Map<String, String> map) {
        dest.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
    }

    private static Map<String, String> readStringMap(Parcel in) {
        int size = in.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        while (size-- > 0) {
            String key = in.readString();
            String value = in.readString();
            map.put(key, value);
        }
        return map;
    }

    public int listModules(List<ModuleProperties> modules) {
        List<ModuleProperties> returnedList;
        if (modules == null) {
            Log.e(TAG, "the output list must not be empty");
            return -22;
        }
        Log.d(TAG, "Listing available tuners...");
        try {
            returnedList = this.mService.listModules();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed listing available tuners", e);
            return -32;
        }
        if (returnedList == null) {
            Log.e(TAG, "Returned list was a null");
            return Integer.MIN_VALUE;
        }
        modules.addAll(returnedList);
        return 0;
    }

    private int nativeListModules(List<ModuleProperties> list) {
        return OverrideMethod.invokeI("android.hardware.radio.RadioManager#nativeListModules(Ljava/util/List;)I", true, this);
    }

    public RadioTuner openTuner(int moduleId, BandConfig config, boolean withAudio, RadioTuner.Callback callback, Handler handler) {
        ITuner tuner;
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be empty");
        }
        Log.d(TAG, "Opening tuner " + moduleId + "...");
        TunerCallbackAdapter halCallback = new TunerCallbackAdapter(callback, handler);
        try {
            tuner = this.mService.openTuner(moduleId, config, withAudio, halCallback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to open tuner", e);
            return null;
        }
        if (tuner == null) {
            Log.e(TAG, "Failed to open tuner");
            return null;
        }
        return new TunerAdapter(tuner, config != null ? config.getType() : -1);
    }

    public RadioManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mService = IRadioService.Stub.asInterface(ServiceManager.getServiceOrThrow("broadcastradio"));
    }

    public static class ProgramInfo
    implements Parcelable {
        private static final int FLAG_LIVE = 1;
        private static final int FLAG_MUTED = 2;
        private static final int FLAG_TRAFFIC_PROGRAM = 4;
        private static final int FLAG_TRAFFIC_ANNOUNCEMENT = 8;
        private final ProgramSelector mSelector;
        private final boolean mTuned;
        private final boolean mStereo;
        private final boolean mDigital;
        private final int mFlags;
        private final int mSignalStrength;
        private final RadioMetadata mMetadata;
        private final Map<String, String> mVendorInfo;
        public static final Parcelable.Creator<ProgramInfo> CREATOR = new Parcelable.Creator<ProgramInfo>(){

            @Override
            public ProgramInfo createFromParcel(Parcel in) {
                return new ProgramInfo(in);
            }

            public ProgramInfo[] newArray(int size) {
                return new ProgramInfo[size];
            }
        };

        ProgramInfo(ProgramSelector selector, boolean tuned, boolean stereo, boolean digital, int signalStrength, RadioMetadata metadata, int flags, Map<String, String> vendorInfo) {
            this.mSelector = selector;
            this.mTuned = tuned;
            this.mStereo = stereo;
            this.mDigital = digital;
            this.mFlags = flags;
            this.mSignalStrength = signalStrength;
            this.mMetadata = metadata;
            this.mVendorInfo = vendorInfo == null ? new HashMap() : vendorInfo;
        }

        public ProgramSelector getSelector() {
            return this.mSelector;
        }

        @Deprecated
        public int getChannel() {
            try {
                return (int)this.mSelector.getFirstId(1);
            }
            catch (IllegalArgumentException ex) {
                Log.w(RadioManager.TAG, "Not an AM/FM program");
                return 0;
            }
        }

        @Deprecated
        public int getSubChannel() {
            try {
                return (int)this.mSelector.getFirstId(4) + 1;
            }
            catch (IllegalArgumentException ex) {
                return 0;
            }
        }

        public boolean isTuned() {
            return this.mTuned;
        }

        public boolean isStereo() {
            return this.mStereo;
        }

        public boolean isDigital() {
            return this.mDigital;
        }

        public boolean isLive() {
            return (this.mFlags & 1) != 0;
        }

        public boolean isMuted() {
            return (this.mFlags & 2) != 0;
        }

        public boolean isTrafficProgram() {
            return (this.mFlags & 4) != 0;
        }

        public boolean isTrafficAnnouncementActive() {
            return (this.mFlags & 8) != 0;
        }

        public int getSignalStrength() {
            return this.mSignalStrength;
        }

        public RadioMetadata getMetadata() {
            return this.mMetadata;
        }

        public Map<String, String> getVendorInfo() {
            return this.mVendorInfo;
        }

        private ProgramInfo(Parcel in) {
            this.mSelector = (ProgramSelector)in.readParcelable(null);
            this.mTuned = in.readByte() == 1;
            this.mStereo = in.readByte() == 1;
            this.mDigital = in.readByte() == 1;
            this.mSignalStrength = in.readInt();
            this.mMetadata = in.readByte() == 1 ? RadioMetadata.CREATOR.createFromParcel(in) : null;
            this.mFlags = in.readInt();
            this.mVendorInfo = RadioManager.readStringMap(in);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable(this.mSelector, 0);
            dest.writeByte((byte)(this.mTuned ? 1 : 0));
            dest.writeByte((byte)(this.mStereo ? 1 : 0));
            dest.writeByte((byte)(this.mDigital ? 1 : 0));
            dest.writeInt(this.mSignalStrength);
            if (this.mMetadata == null) {
                dest.writeByte((byte)0);
            } else {
                dest.writeByte((byte)1);
                this.mMetadata.writeToParcel(dest, flags);
            }
            dest.writeInt(this.mFlags);
            RadioManager.writeStringMap(dest, this.mVendorInfo);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "ProgramInfo [mSelector=" + this.mSelector + ", mTuned=" + this.mTuned + ", mStereo=" + this.mStereo + ", mDigital=" + this.mDigital + ", mFlags=" + this.mFlags + ", mSignalStrength=" + this.mSignalStrength + (this.mMetadata == null ? "" : ", mMetadata=" + this.mMetadata.toString()) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mSelector.hashCode();
            result = 31 * result + (this.mTuned ? 1 : 0);
            result = 31 * result + (this.mStereo ? 1 : 0);
            result = 31 * result + (this.mDigital ? 1 : 0);
            result = 31 * result + this.mFlags;
            result = 31 * result + this.mSignalStrength;
            result = 31 * result + (this.mMetadata == null ? 0 : this.mMetadata.hashCode());
            result = 31 * result + this.mVendorInfo.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ProgramInfo)) {
                return false;
            }
            ProgramInfo other = (ProgramInfo)obj;
            if (!this.mSelector.equals(other.getSelector())) {
                return false;
            }
            if (this.mTuned != other.isTuned()) {
                return false;
            }
            if (this.mStereo != other.isStereo()) {
                return false;
            }
            if (this.mDigital != other.isDigital()) {
                return false;
            }
            if (this.mFlags != other.mFlags) {
                return false;
            }
            if (this.mSignalStrength != other.getSignalStrength()) {
                return false;
            }
            if (this.mMetadata == null ? other.getMetadata() != null : !this.mMetadata.equals(other.getMetadata())) {
                return false;
            }
            return this.mVendorInfo.equals(other.mVendorInfo);
        }
    }

    public static class AmBandConfig
    extends BandConfig {
        private final boolean mStereo;
        public static final Parcelable.Creator<AmBandConfig> CREATOR = new Parcelable.Creator<AmBandConfig>(){

            @Override
            public AmBandConfig createFromParcel(Parcel in) {
                return new AmBandConfig(in);
            }

            public AmBandConfig[] newArray(int size) {
                return new AmBandConfig[size];
            }
        };

        AmBandConfig(AmBandDescriptor descriptor) {
            super(descriptor);
            this.mStereo = descriptor.isStereoSupported();
        }

        AmBandConfig(int region, int type, int lowerLimit, int upperLimit, int spacing, boolean stereo) {
            super(region, type, lowerLimit, upperLimit, spacing);
            this.mStereo = stereo;
        }

        public boolean getStereo() {
            return this.mStereo;
        }

        private AmBandConfig(Parcel in) {
            super(in);
            this.mStereo = in.readByte() == 1;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte((byte)(this.mStereo ? 1 : 0));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public String toString() {
            return "AmBandConfig [" + super.toString() + ", mStereo=" + this.mStereo + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.mStereo ? 1 : 0);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof AmBandConfig)) {
                return false;
            }
            AmBandConfig other = (AmBandConfig)obj;
            return this.mStereo == other.getStereo();
        }

        public static class Builder {
            private final BandDescriptor mDescriptor;
            private boolean mStereo;

            public Builder(AmBandDescriptor descriptor) {
                this.mDescriptor = new BandDescriptor(descriptor.getRegion(), descriptor.getType(), descriptor.getLowerLimit(), descriptor.getUpperLimit(), descriptor.getSpacing());
                this.mStereo = descriptor.isStereoSupported();
            }

            public Builder(AmBandConfig config) {
                this.mDescriptor = new BandDescriptor(config.getRegion(), config.getType(), config.getLowerLimit(), config.getUpperLimit(), config.getSpacing());
                this.mStereo = config.getStereo();
            }

            public AmBandConfig build() {
                AmBandConfig config = new AmBandConfig(this.mDescriptor.getRegion(), this.mDescriptor.getType(), this.mDescriptor.getLowerLimit(), this.mDescriptor.getUpperLimit(), this.mDescriptor.getSpacing(), this.mStereo);
                return config;
            }

            public Builder setStereo(boolean state) {
                this.mStereo = state;
                return this;
            }
        }
    }

    public static class FmBandConfig
    extends BandConfig {
        private final boolean mStereo;
        private final boolean mRds;
        private final boolean mTa;
        private final boolean mAf;
        private final boolean mEa;
        public static final Parcelable.Creator<FmBandConfig> CREATOR = new Parcelable.Creator<FmBandConfig>(){

            @Override
            public FmBandConfig createFromParcel(Parcel in) {
                return new FmBandConfig(in);
            }

            public FmBandConfig[] newArray(int size) {
                return new FmBandConfig[size];
            }
        };

        FmBandConfig(FmBandDescriptor descriptor) {
            super(descriptor);
            this.mStereo = descriptor.isStereoSupported();
            this.mRds = descriptor.isRdsSupported();
            this.mTa = descriptor.isTaSupported();
            this.mAf = descriptor.isAfSupported();
            this.mEa = descriptor.isEaSupported();
        }

        FmBandConfig(int region, int type, int lowerLimit, int upperLimit, int spacing, boolean stereo, boolean rds, boolean ta, boolean af, boolean ea) {
            super(region, type, lowerLimit, upperLimit, spacing);
            this.mStereo = stereo;
            this.mRds = rds;
            this.mTa = ta;
            this.mAf = af;
            this.mEa = ea;
        }

        public boolean getStereo() {
            return this.mStereo;
        }

        public boolean getRds() {
            return this.mRds;
        }

        public boolean getTa() {
            return this.mTa;
        }

        public boolean getAf() {
            return this.mAf;
        }

        public boolean getEa() {
            return this.mEa;
        }

        private FmBandConfig(Parcel in) {
            super(in);
            this.mStereo = in.readByte() == 1;
            this.mRds = in.readByte() == 1;
            this.mTa = in.readByte() == 1;
            this.mAf = in.readByte() == 1;
            this.mEa = in.readByte() == 1;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte((byte)(this.mStereo ? 1 : 0));
            dest.writeByte((byte)(this.mRds ? 1 : 0));
            dest.writeByte((byte)(this.mTa ? 1 : 0));
            dest.writeByte((byte)(this.mAf ? 1 : 0));
            dest.writeByte((byte)(this.mEa ? 1 : 0));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public String toString() {
            return "FmBandConfig [" + super.toString() + ", mStereo=" + this.mStereo + ", mRds=" + this.mRds + ", mTa=" + this.mTa + ", mAf=" + this.mAf + ", mEa =" + this.mEa + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.mStereo ? 1 : 0);
            result = 31 * result + (this.mRds ? 1 : 0);
            result = 31 * result + (this.mTa ? 1 : 0);
            result = 31 * result + (this.mAf ? 1 : 0);
            result = 31 * result + (this.mEa ? 1 : 0);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof FmBandConfig)) {
                return false;
            }
            FmBandConfig other = (FmBandConfig)obj;
            if (this.mStereo != other.mStereo) {
                return false;
            }
            if (this.mRds != other.mRds) {
                return false;
            }
            if (this.mTa != other.mTa) {
                return false;
            }
            if (this.mAf != other.mAf) {
                return false;
            }
            return this.mEa == other.mEa;
        }

        public static class Builder {
            private final BandDescriptor mDescriptor;
            private boolean mStereo;
            private boolean mRds;
            private boolean mTa;
            private boolean mAf;
            private boolean mEa;

            public Builder(FmBandDescriptor descriptor) {
                this.mDescriptor = new BandDescriptor(descriptor.getRegion(), descriptor.getType(), descriptor.getLowerLimit(), descriptor.getUpperLimit(), descriptor.getSpacing());
                this.mStereo = descriptor.isStereoSupported();
                this.mRds = descriptor.isRdsSupported();
                this.mTa = descriptor.isTaSupported();
                this.mAf = descriptor.isAfSupported();
                this.mEa = descriptor.isEaSupported();
            }

            public Builder(FmBandConfig config) {
                this.mDescriptor = new BandDescriptor(config.getRegion(), config.getType(), config.getLowerLimit(), config.getUpperLimit(), config.getSpacing());
                this.mStereo = config.getStereo();
                this.mRds = config.getRds();
                this.mTa = config.getTa();
                this.mAf = config.getAf();
                this.mEa = config.getEa();
            }

            public FmBandConfig build() {
                FmBandConfig config = new FmBandConfig(this.mDescriptor.getRegion(), this.mDescriptor.getType(), this.mDescriptor.getLowerLimit(), this.mDescriptor.getUpperLimit(), this.mDescriptor.getSpacing(), this.mStereo, this.mRds, this.mTa, this.mAf, this.mEa);
                return config;
            }

            public Builder setStereo(boolean state) {
                this.mStereo = state;
                return this;
            }

            public Builder setRds(boolean state) {
                this.mRds = state;
                return this;
            }

            public Builder setTa(boolean state) {
                this.mTa = state;
                return this;
            }

            public Builder setAf(boolean state) {
                this.mAf = state;
                return this;
            }

            public Builder setEa(boolean state) {
                this.mEa = state;
                return this;
            }
        }
    }

    public static class BandConfig
    implements Parcelable {
        final BandDescriptor mDescriptor;
        public static final Parcelable.Creator<BandConfig> CREATOR = new Parcelable.Creator<BandConfig>(){

            @Override
            public BandConfig createFromParcel(Parcel in) {
                int type = BandDescriptor.lookupTypeFromParcel(in);
                switch (type) {
                    case 1: 
                    case 2: {
                        return new FmBandConfig(in);
                    }
                    case 0: 
                    case 3: {
                        return new AmBandConfig(in);
                    }
                }
                throw new IllegalArgumentException("Unsupported band: " + type);
            }

            public BandConfig[] newArray(int size) {
                return new BandConfig[size];
            }
        };

        BandConfig(BandDescriptor descriptor) {
            this.mDescriptor = descriptor;
        }

        BandConfig(int region, int type, int lowerLimit, int upperLimit, int spacing) {
            this.mDescriptor = new BandDescriptor(region, type, lowerLimit, upperLimit, spacing);
        }

        private BandConfig(Parcel in) {
            this.mDescriptor = new BandDescriptor(in);
        }

        BandDescriptor getDescriptor() {
            return this.mDescriptor;
        }

        public int getRegion() {
            return this.mDescriptor.getRegion();
        }

        public int getType() {
            return this.mDescriptor.getType();
        }

        public int getLowerLimit() {
            return this.mDescriptor.getLowerLimit();
        }

        public int getUpperLimit() {
            return this.mDescriptor.getUpperLimit();
        }

        public int getSpacing() {
            return this.mDescriptor.getSpacing();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.mDescriptor.writeToParcel(dest, flags);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "BandConfig [ " + this.mDescriptor.toString() + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mDescriptor.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            BandConfig other;
            BandDescriptor otherDesc;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BandConfig)) {
                return false;
            }
            if (this.mDescriptor == null != ((otherDesc = (other = (BandConfig)obj).getDescriptor()) == null)) {
                return false;
            }
            return this.mDescriptor == null || this.mDescriptor.equals(otherDesc);
        }
    }

    public static class AmBandDescriptor
    extends BandDescriptor {
        private final boolean mStereo;
        public static final Parcelable.Creator<AmBandDescriptor> CREATOR = new Parcelable.Creator<AmBandDescriptor>(){

            @Override
            public AmBandDescriptor createFromParcel(Parcel in) {
                return new AmBandDescriptor(in);
            }

            public AmBandDescriptor[] newArray(int size) {
                return new AmBandDescriptor[size];
            }
        };

        AmBandDescriptor(int region, int type, int lowerLimit, int upperLimit, int spacing, boolean stereo) {
            super(region, type, lowerLimit, upperLimit, spacing);
            this.mStereo = stereo;
        }

        public boolean isStereoSupported() {
            return this.mStereo;
        }

        private AmBandDescriptor(Parcel in) {
            super(in);
            this.mStereo = in.readByte() == 1;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte((byte)(this.mStereo ? 1 : 0));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public String toString() {
            return "AmBandDescriptor [ " + super.toString() + " mStereo=" + this.mStereo + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.mStereo ? 1 : 0);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof AmBandDescriptor)) {
                return false;
            }
            AmBandDescriptor other = (AmBandDescriptor)obj;
            return this.mStereo == other.isStereoSupported();
        }
    }

    public static class FmBandDescriptor
    extends BandDescriptor {
        private final boolean mStereo;
        private final boolean mRds;
        private final boolean mTa;
        private final boolean mAf;
        private final boolean mEa;
        public static final Parcelable.Creator<FmBandDescriptor> CREATOR = new Parcelable.Creator<FmBandDescriptor>(){

            @Override
            public FmBandDescriptor createFromParcel(Parcel in) {
                return new FmBandDescriptor(in);
            }

            public FmBandDescriptor[] newArray(int size) {
                return new FmBandDescriptor[size];
            }
        };

        FmBandDescriptor(int region, int type, int lowerLimit, int upperLimit, int spacing, boolean stereo, boolean rds, boolean ta, boolean af, boolean ea) {
            super(region, type, lowerLimit, upperLimit, spacing);
            this.mStereo = stereo;
            this.mRds = rds;
            this.mTa = ta;
            this.mAf = af;
            this.mEa = ea;
        }

        public boolean isStereoSupported() {
            return this.mStereo;
        }

        public boolean isRdsSupported() {
            return this.mRds;
        }

        public boolean isTaSupported() {
            return this.mTa;
        }

        public boolean isAfSupported() {
            return this.mAf;
        }

        public boolean isEaSupported() {
            return this.mEa;
        }

        private FmBandDescriptor(Parcel in) {
            super(in);
            this.mStereo = in.readByte() == 1;
            this.mRds = in.readByte() == 1;
            this.mTa = in.readByte() == 1;
            this.mAf = in.readByte() == 1;
            this.mEa = in.readByte() == 1;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte((byte)(this.mStereo ? 1 : 0));
            dest.writeByte((byte)(this.mRds ? 1 : 0));
            dest.writeByte((byte)(this.mTa ? 1 : 0));
            dest.writeByte((byte)(this.mAf ? 1 : 0));
            dest.writeByte((byte)(this.mEa ? 1 : 0));
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public String toString() {
            return "FmBandDescriptor [ " + super.toString() + " mStereo=" + this.mStereo + ", mRds=" + this.mRds + ", mTa=" + this.mTa + ", mAf=" + this.mAf + ", mEa =" + this.mEa + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.mStereo ? 1 : 0);
            result = 31 * result + (this.mRds ? 1 : 0);
            result = 31 * result + (this.mTa ? 1 : 0);
            result = 31 * result + (this.mAf ? 1 : 0);
            result = 31 * result + (this.mEa ? 1 : 0);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof FmBandDescriptor)) {
                return false;
            }
            FmBandDescriptor other = (FmBandDescriptor)obj;
            if (this.mStereo != other.isStereoSupported()) {
                return false;
            }
            if (this.mRds != other.isRdsSupported()) {
                return false;
            }
            if (this.mTa != other.isTaSupported()) {
                return false;
            }
            if (this.mAf != other.isAfSupported()) {
                return false;
            }
            return this.mEa == other.isEaSupported();
        }
    }

    public static class BandDescriptor
    implements Parcelable {
        private final int mRegion;
        private final int mType;
        private final int mLowerLimit;
        private final int mUpperLimit;
        private final int mSpacing;
        public static final Parcelable.Creator<BandDescriptor> CREATOR = new Parcelable.Creator<BandDescriptor>(){

            @Override
            public BandDescriptor createFromParcel(Parcel in) {
                int type = BandDescriptor.lookupTypeFromParcel(in);
                switch (type) {
                    case 1: 
                    case 2: {
                        return new FmBandDescriptor(in);
                    }
                    case 0: 
                    case 3: {
                        return new AmBandDescriptor(in);
                    }
                }
                throw new IllegalArgumentException("Unsupported band: " + type);
            }

            public BandDescriptor[] newArray(int size) {
                return new BandDescriptor[size];
            }
        };

        BandDescriptor(int region, int type, int lowerLimit, int upperLimit, int spacing) {
            if (type != 0 && type != 1 && type != 2 && type != 3) {
                throw new IllegalArgumentException("Unsupported band: " + type);
            }
            this.mRegion = region;
            this.mType = type;
            this.mLowerLimit = lowerLimit;
            this.mUpperLimit = upperLimit;
            this.mSpacing = spacing;
        }

        public int getRegion() {
            return this.mRegion;
        }

        public int getType() {
            return this.mType;
        }

        public boolean isAmBand() {
            return this.mType == 0 || this.mType == 3;
        }

        public boolean isFmBand() {
            return this.mType == 1 || this.mType == 2;
        }

        public int getLowerLimit() {
            return this.mLowerLimit;
        }

        public int getUpperLimit() {
            return this.mUpperLimit;
        }

        public int getSpacing() {
            return this.mSpacing;
        }

        private BandDescriptor(Parcel in) {
            this.mRegion = in.readInt();
            this.mType = in.readInt();
            this.mLowerLimit = in.readInt();
            this.mUpperLimit = in.readInt();
            this.mSpacing = in.readInt();
        }

        private static int lookupTypeFromParcel(Parcel in) {
            int pos = in.dataPosition();
            in.readInt();
            int type = in.readInt();
            in.setDataPosition(pos);
            return type;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mRegion);
            dest.writeInt(this.mType);
            dest.writeInt(this.mLowerLimit);
            dest.writeInt(this.mUpperLimit);
            dest.writeInt(this.mSpacing);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "BandDescriptor [mRegion=" + this.mRegion + ", mType=" + this.mType + ", mLowerLimit=" + this.mLowerLimit + ", mUpperLimit=" + this.mUpperLimit + ", mSpacing=" + this.mSpacing + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mRegion;
            result = 31 * result + this.mType;
            result = 31 * result + this.mLowerLimit;
            result = 31 * result + this.mUpperLimit;
            result = 31 * result + this.mSpacing;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BandDescriptor)) {
                return false;
            }
            BandDescriptor other = (BandDescriptor)obj;
            if (this.mRegion != other.getRegion()) {
                return false;
            }
            if (this.mType != other.getType()) {
                return false;
            }
            if (this.mLowerLimit != other.getLowerLimit()) {
                return false;
            }
            if (this.mUpperLimit != other.getUpperLimit()) {
                return false;
            }
            return this.mSpacing == other.getSpacing();
        }
    }

    public static class ModuleProperties
    implements Parcelable {
        private final int mId;
        private final String mServiceName;
        private final int mClassId;
        private final String mImplementor;
        private final String mProduct;
        private final String mVersion;
        private final String mSerial;
        private final int mNumTuners;
        private final int mNumAudioSources;
        private final boolean mIsCaptureSupported;
        private final BandDescriptor[] mBands;
        private final boolean mIsBgScanSupported;
        private final Set<Integer> mSupportedProgramTypes;
        private final Set<Integer> mSupportedIdentifierTypes;
        private final Map<String, String> mVendorInfo;
        public static final Parcelable.Creator<ModuleProperties> CREATOR = new Parcelable.Creator<ModuleProperties>(){

            @Override
            public ModuleProperties createFromParcel(Parcel in) {
                return new ModuleProperties(in);
            }

            public ModuleProperties[] newArray(int size) {
                return new ModuleProperties[size];
            }
        };

        ModuleProperties(int id2, String serviceName, int classId, String implementor, String product, String version, String serial, int numTuners, int numAudioSources, boolean isCaptureSupported, BandDescriptor[] bands, boolean isBgScanSupported, int[] supportedProgramTypes, int[] supportedIdentifierTypes, Map<String, String> vendorInfo) {
            this.mId = id2;
            this.mServiceName = TextUtils.isEmpty(serviceName) ? "default" : serviceName;
            this.mClassId = classId;
            this.mImplementor = implementor;
            this.mProduct = product;
            this.mVersion = version;
            this.mSerial = serial;
            this.mNumTuners = numTuners;
            this.mNumAudioSources = numAudioSources;
            this.mIsCaptureSupported = isCaptureSupported;
            this.mBands = bands;
            this.mIsBgScanSupported = isBgScanSupported;
            this.mSupportedProgramTypes = ModuleProperties.arrayToSet(supportedProgramTypes);
            this.mSupportedIdentifierTypes = ModuleProperties.arrayToSet(supportedIdentifierTypes);
            this.mVendorInfo = vendorInfo == null ? new HashMap() : vendorInfo;
        }

        private static Set<Integer> arrayToSet(int[] arr) {
            return Arrays.stream(arr).boxed().collect(Collectors.toSet());
        }

        private static int[] setToArray(Set<Integer> set) {
            return set.stream().mapToInt(Integer::intValue).toArray();
        }

        public int getId() {
            return this.mId;
        }

        public String getServiceName() {
            return this.mServiceName;
        }

        public int getClassId() {
            return this.mClassId;
        }

        public String getImplementor() {
            return this.mImplementor;
        }

        public String getProduct() {
            return this.mProduct;
        }

        public String getVersion() {
            return this.mVersion;
        }

        public String getSerial() {
            return this.mSerial;
        }

        public int getNumTuners() {
            return this.mNumTuners;
        }

        public int getNumAudioSources() {
            return this.mNumAudioSources;
        }

        public boolean isCaptureSupported() {
            return this.mIsCaptureSupported;
        }

        public boolean isBackgroundScanningSupported() {
            return this.mIsBgScanSupported;
        }

        public boolean isProgramTypeSupported(int type) {
            return this.mSupportedProgramTypes.contains(type);
        }

        public boolean isProgramIdentifierSupported(int type) {
            return this.mSupportedIdentifierTypes.contains(type);
        }

        public Map<String, String> getVendorInfo() {
            return this.mVendorInfo;
        }

        public BandDescriptor[] getBands() {
            return this.mBands;
        }

        private ModuleProperties(Parcel in) {
            this.mId = in.readInt();
            String serviceName = in.readString();
            this.mServiceName = TextUtils.isEmpty(serviceName) ? "default" : serviceName;
            this.mClassId = in.readInt();
            this.mImplementor = in.readString();
            this.mProduct = in.readString();
            this.mVersion = in.readString();
            this.mSerial = in.readString();
            this.mNumTuners = in.readInt();
            this.mNumAudioSources = in.readInt();
            this.mIsCaptureSupported = in.readInt() == 1;
            Parcelable[] tmp = in.readParcelableArray(BandDescriptor.class.getClassLoader());
            this.mBands = new BandDescriptor[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                this.mBands[i] = (BandDescriptor)tmp[i];
            }
            this.mIsBgScanSupported = in.readInt() == 1;
            this.mSupportedProgramTypes = ModuleProperties.arrayToSet(in.createIntArray());
            this.mSupportedIdentifierTypes = ModuleProperties.arrayToSet(in.createIntArray());
            this.mVendorInfo = RadioManager.readStringMap(in);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mId);
            dest.writeString(this.mServiceName);
            dest.writeInt(this.mClassId);
            dest.writeString(this.mImplementor);
            dest.writeString(this.mProduct);
            dest.writeString(this.mVersion);
            dest.writeString(this.mSerial);
            dest.writeInt(this.mNumTuners);
            dest.writeInt(this.mNumAudioSources);
            dest.writeInt(this.mIsCaptureSupported ? 1 : 0);
            dest.writeParcelableArray(this.mBands, flags);
            dest.writeInt(this.mIsBgScanSupported ? 1 : 0);
            dest.writeIntArray(ModuleProperties.setToArray(this.mSupportedProgramTypes));
            dest.writeIntArray(ModuleProperties.setToArray(this.mSupportedIdentifierTypes));
            RadioManager.writeStringMap(dest, this.mVendorInfo);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "ModuleProperties [mId=" + this.mId + ", mServiceName=" + this.mServiceName + ", mClassId=" + this.mClassId + ", mImplementor=" + this.mImplementor + ", mProduct=" + this.mProduct + ", mVersion=" + this.mVersion + ", mSerial=" + this.mSerial + ", mNumTuners=" + this.mNumTuners + ", mNumAudioSources=" + this.mNumAudioSources + ", mIsCaptureSupported=" + this.mIsCaptureSupported + ", mIsBgScanSupported=" + this.mIsBgScanSupported + ", mBands=" + Arrays.toString(this.mBands) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mId;
            result = 31 * result + this.mServiceName.hashCode();
            result = 31 * result + this.mClassId;
            result = 31 * result + (this.mImplementor == null ? 0 : this.mImplementor.hashCode());
            result = 31 * result + (this.mProduct == null ? 0 : this.mProduct.hashCode());
            result = 31 * result + (this.mVersion == null ? 0 : this.mVersion.hashCode());
            result = 31 * result + (this.mSerial == null ? 0 : this.mSerial.hashCode());
            result = 31 * result + this.mNumTuners;
            result = 31 * result + this.mNumAudioSources;
            result = 31 * result + (this.mIsCaptureSupported ? 1 : 0);
            result = 31 * result + Arrays.hashCode(this.mBands);
            result = 31 * result + (this.mIsBgScanSupported ? 1 : 0);
            result = 31 * result + this.mVendorInfo.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ModuleProperties)) {
                return false;
            }
            ModuleProperties other = (ModuleProperties)obj;
            if (this.mId != other.getId()) {
                return false;
            }
            if (!TextUtils.equals(this.mServiceName, other.mServiceName)) {
                return false;
            }
            if (this.mClassId != other.getClassId()) {
                return false;
            }
            if (this.mImplementor == null ? other.getImplementor() != null : !this.mImplementor.equals(other.getImplementor())) {
                return false;
            }
            if (this.mProduct == null ? other.getProduct() != null : !this.mProduct.equals(other.getProduct())) {
                return false;
            }
            if (this.mVersion == null ? other.getVersion() != null : !this.mVersion.equals(other.getVersion())) {
                return false;
            }
            if (this.mSerial == null ? other.getSerial() != null : !this.mSerial.equals(other.getSerial())) {
                return false;
            }
            if (this.mNumTuners != other.getNumTuners()) {
                return false;
            }
            if (this.mNumAudioSources != other.getNumAudioSources()) {
                return false;
            }
            if (this.mIsCaptureSupported != other.isCaptureSupported()) {
                return false;
            }
            if (!Arrays.equals(this.mBands, other.getBands())) {
                return false;
            }
            if (this.mIsBgScanSupported != other.isBackgroundScanningSupported()) {
                return false;
            }
            return this.mVendorInfo.equals(other.mVendorInfo);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Band {
    }
}

