/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.number.Format;
import android.icu.impl.number.FormatQuantity;
import android.icu.impl.number.ModifierHolder;
import android.icu.impl.number.NumberStringBuilder;
import android.icu.impl.number.PatternString;
import android.icu.impl.number.Properties;
import android.icu.impl.number.formatters.BigDecimalMultiplier;
import android.icu.impl.number.formatters.CompactDecimalFormat;
import android.icu.impl.number.formatters.CurrencyFormat;
import android.icu.impl.number.formatters.MagnitudeMultiplier;
import android.icu.impl.number.formatters.MeasureFormat;
import android.icu.impl.number.formatters.PaddingFormat;
import android.icu.impl.number.formatters.PositiveDecimalFormat;
import android.icu.impl.number.formatters.PositiveNegativeAffixFormat;
import android.icu.impl.number.formatters.RoundingFormat;
import android.icu.impl.number.formatters.ScientificFormat;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.PluralRules;
import android.icu.util.ULocale;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Endpoint {
    private static final ThreadLocal<Map<ULocale, DecimalFormatSymbols>> threadLocalSymbolsCache = new ThreadLocal<Map<ULocale, DecimalFormatSymbols>>(){

        @Override
        protected Map<ULocale, DecimalFormatSymbols> initialValue() {
            return new HashMap<ULocale, DecimalFormatSymbols>();
        }
    };
    private static final ThreadLocal<Map<String, Properties>> threadLocalPropertiesCache = new ThreadLocal<Map<String, Properties>>(){

        @Override
        protected Map<String, Properties> initialValue() {
            return new HashMap<String, Properties>();
        }
    };
    private static final ThreadLocal<Map<ULocale, PluralRules>> threadLocalRulesCache = new ThreadLocal<Map<ULocale, PluralRules>>(){

        @Override
        protected Map<ULocale, PluralRules> initialValue() {
            return new HashMap<ULocale, PluralRules>();
        }
    };

    public static Format fromBTA(Properties properties) {
        return Endpoint.fromBTA(properties, Endpoint.getSymbols());
    }

    public static Format.SingularFormat fromBTA(Properties properties, Locale locale) {
        return Endpoint.fromBTA(properties, Endpoint.getSymbols(locale));
    }

    public static Format.SingularFormat fromBTA(Properties properties, ULocale uLocale) {
        return Endpoint.fromBTA(properties, Endpoint.getSymbols(uLocale));
    }

    public static Format.SingularFormat fromBTA(String pattern) {
        return Endpoint.fromBTA(Endpoint.getProperties(pattern), Endpoint.getSymbols());
    }

    public static Format.SingularFormat fromBTA(String pattern, Locale locale) {
        return Endpoint.fromBTA(Endpoint.getProperties(pattern), Endpoint.getSymbols(locale));
    }

    public static Format.SingularFormat fromBTA(String pattern, ULocale uLocale) {
        return Endpoint.fromBTA(Endpoint.getProperties(pattern), Endpoint.getSymbols(uLocale));
    }

    public static Format.SingularFormat fromBTA(String pattern, DecimalFormatSymbols symbols) {
        return Endpoint.fromBTA(Endpoint.getProperties(pattern), symbols);
    }

    public static Format.SingularFormat fromBTA(Properties properties, DecimalFormatSymbols symbols) {
        if (symbols == null) {
            throw new IllegalArgumentException("symbols must not be null");
        }
        boolean canUseFastTrack = true;
        PluralRules rules = Endpoint.getPluralRules(symbols.getULocale(), properties);
        Format.BeforeTargetAfterFormat format = new Format.BeforeTargetAfterFormat(rules);
        PositiveDecimalFormat target = new PositiveDecimalFormat(symbols, properties);
        format.setTargetFormat(target);
        if (MagnitudeMultiplier.useMagnitudeMultiplier(properties)) {
            canUseFastTrack = false;
            format.addBeforeFormat(MagnitudeMultiplier.getInstance(properties));
        }
        if (BigDecimalMultiplier.useMultiplier(properties)) {
            canUseFastTrack = false;
            format.addBeforeFormat(BigDecimalMultiplier.getInstance(properties));
        }
        if (MeasureFormat.useMeasureFormat(properties)) {
            canUseFastTrack = false;
            format.addBeforeFormat(MeasureFormat.getInstance(symbols, properties));
        }
        if (CurrencyFormat.useCurrency(properties)) {
            canUseFastTrack = false;
            if (CompactDecimalFormat.useCompactDecimalFormat(properties)) {
                format.addBeforeFormat(CompactDecimalFormat.getInstance(symbols, properties));
            } else if (ScientificFormat.useScientificNotation(properties)) {
                format.addBeforeFormat(PositiveNegativeAffixFormat.getInstance(symbols, properties));
                format.addBeforeFormat(ScientificFormat.getInstance(symbols, properties));
            } else {
                format.addBeforeFormat(CurrencyFormat.getCurrencyRounder(symbols, properties));
                format.addBeforeFormat(CurrencyFormat.getCurrencyModifier(symbols, properties));
            }
        } else if (CompactDecimalFormat.useCompactDecimalFormat(properties)) {
            canUseFastTrack = false;
            format.addBeforeFormat(CompactDecimalFormat.getInstance(symbols, properties));
        } else if (ScientificFormat.useScientificNotation(properties)) {
            canUseFastTrack = false;
            format.addBeforeFormat(PositiveNegativeAffixFormat.getInstance(symbols, properties));
            format.addBeforeFormat(ScientificFormat.getInstance(symbols, properties));
        } else {
            format.addBeforeFormat(PositiveNegativeAffixFormat.getInstance(symbols, properties));
            format.addBeforeFormat(RoundingFormat.getDefaultOrNoRounder(properties));
        }
        if (PaddingFormat.usePadding(properties)) {
            canUseFastTrack = false;
            format.addAfterFormat(PaddingFormat.getInstance(properties));
        }
        if (canUseFastTrack) {
            return new Format.PositiveNegativeRounderTargetFormat(PositiveNegativeAffixFormat.getInstance(symbols, properties), RoundingFormat.getDefaultOrNoRounder(properties), target);
        }
        return format;
    }

    public static String staticFormat(FormatQuantity input, Properties properties) {
        return Endpoint.staticFormat(input, properties, Endpoint.getSymbols());
    }

    public static String staticFormat(FormatQuantity input, Properties properties, Locale locale) {
        return Endpoint.staticFormat(input, properties, Endpoint.getSymbols(locale));
    }

    public static String staticFormat(FormatQuantity input, Properties properties, ULocale uLocale) {
        return Endpoint.staticFormat(input, properties, Endpoint.getSymbols(uLocale));
    }

    public static String staticFormat(FormatQuantity input, String pattern) {
        return Endpoint.staticFormat(input, Endpoint.getProperties(pattern), Endpoint.getSymbols());
    }

    public static String staticFormat(FormatQuantity input, String pattern, Locale locale) {
        return Endpoint.staticFormat(input, Endpoint.getProperties(pattern), Endpoint.getSymbols(locale));
    }

    public static String staticFormat(FormatQuantity input, String pattern, ULocale uLocale) {
        return Endpoint.staticFormat(input, Endpoint.getProperties(pattern), Endpoint.getSymbols(uLocale));
    }

    public static String staticFormat(FormatQuantity input, String pattern, DecimalFormatSymbols symbols) {
        return Endpoint.staticFormat(input, Endpoint.getProperties(pattern), symbols);
    }

    public static String staticFormat(FormatQuantity input, Properties properties, DecimalFormatSymbols symbols) {
        PluralRules rules = null;
        ModifierHolder mods = Format.threadLocalModifierHolder.get().clear();
        NumberStringBuilder sb = Format.threadLocalStringBuilder.get().clear();
        int length = 0;
        if (!input.isNaN()) {
            if (MagnitudeMultiplier.useMagnitudeMultiplier(properties)) {
                MagnitudeMultiplier.getInstance(properties).before(input, mods, rules);
            }
            if (BigDecimalMultiplier.useMultiplier(properties)) {
                BigDecimalMultiplier.getInstance(properties).before(input, mods, rules);
            }
            if (MeasureFormat.useMeasureFormat(properties)) {
                rules = rules != null ? rules : Endpoint.getPluralRules(symbols.getULocale(), properties);
                MeasureFormat.getInstance(symbols, properties).before(input, mods, rules);
            }
            if (CompactDecimalFormat.useCompactDecimalFormat(properties)) {
                rules = rules != null ? rules : Endpoint.getPluralRules(symbols.getULocale(), properties);
                CompactDecimalFormat.apply(input, mods, rules, symbols, properties);
            } else if (CurrencyFormat.useCurrency(properties)) {
                rules = rules != null ? rules : Endpoint.getPluralRules(symbols.getULocale(), properties);
                CurrencyFormat.getCurrencyRounder(symbols, properties).before(input, mods, rules);
                CurrencyFormat.getCurrencyModifier(symbols, properties).before(input, mods, rules);
            } else if (ScientificFormat.useScientificNotation(properties)) {
                PositiveNegativeAffixFormat.getInstance(symbols, properties).before(input, mods, rules);
                ScientificFormat.getInstance(symbols, properties).before(input, mods, rules);
            } else {
                PositiveNegativeAffixFormat.apply(input, mods, symbols, properties);
                RoundingFormat.getDefaultOrNoRounder(properties).before(input, mods, rules);
            }
        }
        length += new PositiveDecimalFormat(symbols, properties).target(input, sb, 0);
        length += mods.applyStrong(sb, 0, length);
        if (PaddingFormat.usePadding(properties)) {
            length += PaddingFormat.getInstance(properties).after(mods, sb, 0, length);
        }
        length += mods.applyAll(sb, 0, length);
        return sb.toString();
    }

    private static DecimalFormatSymbols getSymbols() {
        ULocale uLocale = ULocale.getDefault();
        return Endpoint.getSymbols(uLocale);
    }

    private static DecimalFormatSymbols getSymbols(Locale locale) {
        ULocale uLocale = ULocale.forLocale(locale);
        return Endpoint.getSymbols(uLocale);
    }

    private static DecimalFormatSymbols getSymbols(ULocale uLocale) {
        DecimalFormatSymbols symbols;
        if (uLocale == null) {
            uLocale = ULocale.getDefault();
        }
        if ((symbols = threadLocalSymbolsCache.get().get(uLocale)) == null) {
            symbols = DecimalFormatSymbols.getInstance(uLocale);
            threadLocalSymbolsCache.get().put(uLocale, symbols);
        }
        return symbols;
    }

    private static Properties getProperties(String pattern) {
        Properties properties;
        if (pattern == null) {
            pattern = "#";
        }
        if ((properties = threadLocalPropertiesCache.get().get(pattern)) == null) {
            properties = PatternString.parseToProperties(pattern);
            threadLocalPropertiesCache.get().put(pattern.intern(), properties);
        }
        return properties;
    }

    private static PluralRules getPluralRules(ULocale uLocale, Properties properties) {
        PluralRules rules;
        if (properties.getPluralRules() != null) {
            return properties.getPluralRules();
        }
        if (properties.getCurrencyPluralInfo() != null) {
            return properties.getCurrencyPluralInfo().getPluralRules();
        }
        if (uLocale == null) {
            uLocale = ULocale.getDefault();
        }
        if ((rules = threadLocalRulesCache.get().get(uLocale)) == null) {
            rules = PluralRules.forLocale(uLocale);
            threadLocalRulesCache.get().put(uLocale, rules);
        }
        return rules;
    }

    public static interface IProperties {
        public static final PluralRules DEFAULT_PLURAL_RULES = null;

        public PluralRules getPluralRules();

        public IProperties setPluralRules(PluralRules var1);
    }
}

