/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.IBinder;
import android.os.RemoteException;
import android.transition.Transition;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.autofill.Helper;
import android.view.autofill.IAutofillWindowPresenter;
import android.widget.PopupWindow;

public class AutofillPopupWindow
extends PopupWindow {
    private static final String TAG = "AutofillPopupWindow";
    private final WindowPresenter mWindowPresenter;
    private WindowManager.LayoutParams mWindowLayoutParams;

    public AutofillPopupWindow(IAutofillWindowPresenter presenter) {
        this.mWindowPresenter = new WindowPresenter(presenter);
        this.setOutsideTouchable(true);
        this.setInputMethodMode(1);
    }

    @Override
    protected boolean hasContentView() {
        return true;
    }

    @Override
    protected boolean hasDecorView() {
        return true;
    }

    @Override
    protected WindowManager.LayoutParams getDecorViewLayoutParams() {
        return this.mWindowLayoutParams;
    }

    public void update(final View anchor, int offsetX, int offsetY, int width, int height, final Rect virtualBounds) {
        View actualAnchor;
        if (virtualBounds != null) {
            actualAnchor = new View(anchor.getContext()){

                @Override
                public void getLocationOnScreen(int[] location) {
                    location[0] = virtualBounds.left;
                    location[1] = virtualBounds.top;
                }

                @Override
                public int getAccessibilityViewId() {
                    return anchor.getAccessibilityViewId();
                }

                @Override
                public ViewTreeObserver getViewTreeObserver() {
                    return anchor.getViewTreeObserver();
                }

                @Override
                public IBinder getApplicationWindowToken() {
                    return anchor.getApplicationWindowToken();
                }

                @Override
                public View getRootView() {
                    return anchor.getRootView();
                }

                @Override
                public int getLayoutDirection() {
                    return anchor.getLayoutDirection();
                }

                @Override
                public void getWindowDisplayFrame(Rect outRect) {
                    anchor.getWindowDisplayFrame(outRect);
                }

                @Override
                public void addOnAttachStateChangeListener(View.OnAttachStateChangeListener listener) {
                    anchor.addOnAttachStateChangeListener(listener);
                }

                @Override
                public void removeOnAttachStateChangeListener(View.OnAttachStateChangeListener listener) {
                    anchor.removeOnAttachStateChangeListener(listener);
                }

                @Override
                public boolean isAttachedToWindow() {
                    return anchor.isAttachedToWindow();
                }

                @Override
                public boolean requestRectangleOnScreen(Rect rectangle, boolean immediate) {
                    return anchor.requestRectangleOnScreen(rectangle, immediate);
                }

                @Override
                public IBinder getWindowToken() {
                    return anchor.getWindowToken();
                }
            };
            actualAnchor.setLeftTopRightBottom(virtualBounds.left, virtualBounds.top, virtualBounds.right, virtualBounds.bottom);
            actualAnchor.setScrollX(anchor.getScrollX());
            actualAnchor.setScrollY(anchor.getScrollY());
        } else {
            actualAnchor = anchor;
        }
        if (!this.isShowing()) {
            this.setWidth(width);
            this.setHeight(height);
            this.showAsDropDown(actualAnchor, offsetX, offsetY);
        } else {
            this.update(actualAnchor, offsetX, offsetY, width, height);
        }
    }

    @Override
    protected void update(View anchor, WindowManager.LayoutParams params) {
        int layoutDirection = anchor != null ? anchor.getLayoutDirection() : 3;
        this.mWindowPresenter.show(params, this.getTransitionEpicenter(), this.isLayoutInsetDecor(), layoutDirection);
    }

    @Override
    public void showAsDropDown(View anchor, int xoff, int yoff, int gravity) {
        if (Helper.sVerbose) {
            Log.v(TAG, "showAsDropDown(): anchor=" + anchor + ", xoff=" + xoff + ", yoff=" + yoff + ", isShowing(): " + this.isShowing());
        }
        if (this.isShowing()) {
            return;
        }
        this.setShowing(true);
        this.setDropDown(true);
        this.attachToAnchor(anchor, xoff, yoff, gravity);
        WindowManager.LayoutParams p = this.mWindowLayoutParams = this.createPopupLayoutParams(anchor.getWindowToken());
        boolean aboveAnchor = this.findDropDownPosition(anchor, p, xoff, yoff, p.width, p.height, gravity, this.getAllowScrollingAnchorParent());
        this.updateAboveAnchor(aboveAnchor);
        p.accessibilityIdOfAnchor = anchor.getAccessibilityViewId();
        p.packageName = anchor.getContext().getPackageName();
        this.mWindowPresenter.show(p, this.getTransitionEpicenter(), this.isLayoutInsetDecor(), anchor.getLayoutDirection());
    }

    @Override
    public void dismiss() {
        if (!this.isShowing() || this.isTransitioningToDismiss()) {
            return;
        }
        this.setShowing(false);
        this.setTransitioningToDismiss(true);
        this.mWindowPresenter.hide(this.getTransitionEpicenter());
        this.detachFromAnchor();
        if (this.getOnDismissListener() != null) {
            this.getOnDismissListener().onDismiss();
        }
    }

    @Override
    public int getAnimationStyle() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public Drawable getBackground() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public View getContentView() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public float getElevation() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public Transition getEnterTransition() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public Transition getExitTransition() {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setAnimationStyle(int animationStyle) {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setBackgroundDrawable(Drawable background) {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setContentView(View contentView) {
        if (contentView != null) {
            throw new IllegalStateException("You can't call this!");
        }
    }

    @Override
    public void setElevation(float elevation) {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setEnterTransition(Transition enterTransition) {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setExitTransition(Transition exitTransition) {
        throw new IllegalStateException("You can't call this!");
    }

    @Override
    public void setTouchInterceptor(View.OnTouchListener l) {
        throw new IllegalStateException("You can't call this!");
    }

    private class WindowPresenter {
        final IAutofillWindowPresenter mPresenter;

        WindowPresenter(IAutofillWindowPresenter presenter) {
            this.mPresenter = presenter;
        }

        void show(WindowManager.LayoutParams p, Rect transitionEpicenter, boolean fitsSystemWindows, int layoutDirection) {
            try {
                this.mPresenter.show(p, transitionEpicenter, fitsSystemWindows, layoutDirection);
            }
            catch (RemoteException e) {
                Log.w(AutofillPopupWindow.TAG, "Error showing fill window", e);
                e.rethrowFromSystemServer();
            }
        }

        void hide(Rect transitionEpicenter) {
            try {
                this.mPresenter.hide(transitionEpicenter);
            }
            catch (RemoteException e) {
                Log.w(AutofillPopupWindow.TAG, "Error hiding fill window", e);
                e.rethrowFromSystemServer();
            }
        }
    }
}

