/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.res.Resources;
import android.os.LocaleList;
import android.os.RemoteException;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Pair;
import android.util.Printer;
import android.util.Slog;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.TextServicesManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.inputmethod.LocaleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class InputMethodUtils {
    public static final boolean DEBUG = false;
    public static final int NOT_A_SUBTYPE_ID = -1;
    public static final String SUBTYPE_MODE_ANY = null;
    public static final String SUBTYPE_MODE_KEYBOARD = "keyboard";
    public static final String SUBTYPE_MODE_VOICE = "voice";
    private static final String TAG = "InputMethodUtils";
    private static final Locale ENGLISH_LOCALE = new Locale("en");
    private static final String NOT_A_SUBTYPE_ID_STR = String.valueOf(-1);
    private static final String TAG_ENABLED_WHEN_DEFAULT_IS_NOT_ASCII_CAPABLE = "EnabledWhenDefaultIsNotAsciiCapable";
    private static final String TAG_ASCII_CAPABLE = "AsciiCapable";
    private static final char INPUT_METHOD_SEPARATOR = ':';
    private static final char INPUT_METHOD_SUBTYPE_SEPARATOR = ';';
    private static final Locale[] SEARCH_ORDER_OF_FALLBACK_LOCALES = new Locale[]{Locale.ENGLISH, Locale.US, Locale.UK};
    private static final Object sCacheLock = new Object();
    @GuardedBy(value="sCacheLock")
    private static LocaleList sCachedSystemLocales;
    @GuardedBy(value="sCacheLock")
    private static InputMethodInfo sCachedInputMethodInfo;
    @GuardedBy(value="sCacheLock")
    private static ArrayList<InputMethodSubtype> sCachedResult;
    private static final LocaleUtils.LocaleExtractor<InputMethodSubtype> sSubtypeToLocale;
    private static final Locale LOCALE_EN_US;
    private static final Locale LOCALE_EN_GB;

    private InputMethodUtils() {
    }

    public static String getApiCallStack() {
        String apiCallStack = "";
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException e) {
            StackTraceElement[] frames = e.getStackTrace();
            for (int j = 1; j < frames.length; ++j) {
                String tempCallStack = frames[j].toString();
                if (TextUtils.isEmpty(apiCallStack)) {
                    apiCallStack = tempCallStack;
                    continue;
                }
                if (tempCallStack.indexOf("Transact(") >= 0) break;
                apiCallStack = tempCallStack;
            }
            return apiCallStack;
        }
    }

    public static boolean isSystemIme(InputMethodInfo inputMethod) {
        return (inputMethod.getServiceInfo().applicationInfo.flags & 1) != 0;
    }

    public static boolean isSystemImeThatHasSubtypeOf(InputMethodInfo imi, Context context, boolean checkDefaultAttribute, Locale requiredLocale, boolean checkCountry, String requiredSubtypeMode) {
        if (!InputMethodUtils.isSystemIme(imi)) {
            return false;
        }
        if (checkDefaultAttribute && !imi.isDefault(context)) {
            return false;
        }
        return InputMethodUtils.containsSubtypeOf(imi, requiredLocale, checkCountry, requiredSubtypeMode);
    }

    public static Locale getFallbackLocaleForDefaultIme(ArrayList<InputMethodInfo> imis, Context context) {
        int i;
        for (Locale fallbackLocale : SEARCH_ORDER_OF_FALLBACK_LOCALES) {
            for (i = 0; i < imis.size(); ++i) {
                if (!InputMethodUtils.isSystemImeThatHasSubtypeOf(imis.get(i), context, true, fallbackLocale, true, SUBTYPE_MODE_KEYBOARD)) continue;
                return fallbackLocale;
            }
        }
        for (Locale fallbackLocale : SEARCH_ORDER_OF_FALLBACK_LOCALES) {
            for (i = 0; i < imis.size(); ++i) {
                if (!InputMethodUtils.isSystemImeThatHasSubtypeOf(imis.get(i), context, false, fallbackLocale, true, SUBTYPE_MODE_KEYBOARD)) continue;
                return fallbackLocale;
            }
        }
        Slog.w(TAG, "Found no fallback locale. imis=" + Arrays.toString(imis.toArray()));
        return null;
    }

    private static boolean isSystemAuxilialyImeThatHasAutomaticSubtype(InputMethodInfo imi, Context context, boolean checkDefaultAttribute) {
        if (!InputMethodUtils.isSystemIme(imi)) {
            return false;
        }
        if (checkDefaultAttribute && !imi.isDefault(context)) {
            return false;
        }
        if (!imi.isAuxiliaryIme()) {
            return false;
        }
        int subtypeCount = imi.getSubtypeCount();
        for (int i = 0; i < subtypeCount; ++i) {
            InputMethodSubtype s = imi.getSubtypeAt(i);
            if (!s.overridesImplicitlyEnabledSubtype()) continue;
            return true;
        }
        return false;
    }

    public static Locale getSystemLocaleFromContext(Context context) {
        try {
            return context.getResources().getConfiguration().locale;
        }
        catch (Resources.NotFoundException ex) {
            return null;
        }
    }

    private static InputMethodListBuilder getMinimumKeyboardSetWithSystemLocale(ArrayList<InputMethodInfo> imis, Context context, Locale systemLocale, Locale fallbackLocale) {
        InputMethodListBuilder builder = new InputMethodListBuilder();
        builder.fillImes(imis, context, true, systemLocale, true, SUBTYPE_MODE_KEYBOARD);
        if (!builder.isEmpty()) {
            return builder;
        }
        builder.fillImes(imis, context, true, systemLocale, false, SUBTYPE_MODE_KEYBOARD);
        if (!builder.isEmpty()) {
            return builder;
        }
        builder.fillImes(imis, context, true, fallbackLocale, true, SUBTYPE_MODE_KEYBOARD);
        if (!builder.isEmpty()) {
            return builder;
        }
        builder.fillImes(imis, context, true, fallbackLocale, false, SUBTYPE_MODE_KEYBOARD);
        if (!builder.isEmpty()) {
            return builder;
        }
        builder.fillImes(imis, context, false, fallbackLocale, true, SUBTYPE_MODE_KEYBOARD);
        if (!builder.isEmpty()) {
            return builder;
        }
        builder.fillImes(imis, context, false, fallbackLocale, false, SUBTYPE_MODE_KEYBOARD);
        if (!builder.isEmpty()) {
            return builder;
        }
        Slog.w(TAG, "No software keyboard is found. imis=" + Arrays.toString(imis.toArray()) + " systemLocale=" + systemLocale + " fallbackLocale=" + fallbackLocale);
        return builder;
    }

    public static ArrayList<InputMethodInfo> getDefaultEnabledImes(Context context, ArrayList<InputMethodInfo> imis) {
        Locale fallbackLocale = InputMethodUtils.getFallbackLocaleForDefaultIme(imis, context);
        Locale systemLocale = InputMethodUtils.getSystemLocaleFromContext(context);
        return InputMethodUtils.getMinimumKeyboardSetWithSystemLocale(imis, context, systemLocale, fallbackLocale).fillImes(imis, context, true, systemLocale, true, SUBTYPE_MODE_ANY).fillAuxiliaryImes(imis, context).build();
    }

    public static Locale constructLocaleFromString(String localeStr) {
        if (TextUtils.isEmpty(localeStr)) {
            return null;
        }
        String[] localeParams = localeStr.split("_", 3);
        if (localeParams.length >= 1 && "tl".equals(localeParams[0])) {
            localeParams[0] = "fil";
        }
        if (localeParams.length == 1) {
            return new Locale(localeParams[0]);
        }
        if (localeParams.length == 2) {
            return new Locale(localeParams[0], localeParams[1]);
        }
        if (localeParams.length == 3) {
            return new Locale(localeParams[0], localeParams[1], localeParams[2]);
        }
        return null;
    }

    public static boolean containsSubtypeOf(InputMethodInfo imi, Locale locale, boolean checkCountry, String mode) {
        if (locale == null) {
            return false;
        }
        int N = imi.getSubtypeCount();
        for (int i = 0; i < N; ++i) {
            Locale subtypeLocale;
            InputMethodSubtype subtype = imi.getSubtypeAt(i);
            if (!checkCountry ? !TextUtils.equals((subtypeLocale = new Locale(InputMethodUtils.getLanguageFromLocaleString(subtype.getLocale()))).getLanguage(), locale.getLanguage()) : (subtypeLocale = subtype.getLocaleObject()) == null || !TextUtils.equals(subtypeLocale.getLanguage(), locale.getLanguage()) || !TextUtils.equals(subtypeLocale.getCountry(), locale.getCountry())) continue;
            if (mode != SUBTYPE_MODE_ANY && !TextUtils.isEmpty(mode) && !mode.equalsIgnoreCase(subtype.getMode())) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<InputMethodSubtype> getSubtypes(InputMethodInfo imi) {
        ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
        int subtypeCount = imi.getSubtypeCount();
        for (int i = 0; i < subtypeCount; ++i) {
            subtypes.add(imi.getSubtypeAt(i));
        }
        return subtypes;
    }

    public static ArrayList<InputMethodSubtype> getOverridingImplicitlyEnabledSubtypes(InputMethodInfo imi, String mode) {
        ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
        int subtypeCount = imi.getSubtypeCount();
        for (int i = 0; i < subtypeCount; ++i) {
            InputMethodSubtype subtype = imi.getSubtypeAt(i);
            if (!subtype.overridesImplicitlyEnabledSubtype() || !subtype.getMode().equals(mode)) continue;
            subtypes.add(subtype);
        }
        return subtypes;
    }

    public static InputMethodInfo getMostApplicableDefaultIME(List<InputMethodInfo> enabledImes) {
        if (enabledImes == null || enabledImes.isEmpty()) {
            return null;
        }
        int i = enabledImes.size();
        int firstFoundSystemIme = -1;
        while (i > 0) {
            InputMethodInfo imi;
            if ((imi = enabledImes.get(--i)).isAuxiliaryIme()) continue;
            if (InputMethodUtils.isSystemIme(imi) && InputMethodUtils.containsSubtypeOf(imi, ENGLISH_LOCALE, false, SUBTYPE_MODE_KEYBOARD)) {
                return imi;
            }
            if (firstFoundSystemIme >= 0 || !InputMethodUtils.isSystemIme(imi)) continue;
            firstFoundSystemIme = i;
        }
        return enabledImes.get(Math.max(firstFoundSystemIme, 0));
    }

    public static boolean isValidSubtypeId(InputMethodInfo imi, int subtypeHashCode) {
        return InputMethodUtils.getSubtypeIdFromHashCode(imi, subtypeHashCode) != -1;
    }

    public static int getSubtypeIdFromHashCode(InputMethodInfo imi, int subtypeHashCode) {
        if (imi != null) {
            int subtypeCount = imi.getSubtypeCount();
            for (int i = 0; i < subtypeCount; ++i) {
                InputMethodSubtype ims = imi.getSubtypeAt(i);
                if (subtypeHashCode != ims.hashCode()) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static ArrayList<InputMethodSubtype> getImplicitlyApplicableSubtypesLocked(Resources res, InputMethodInfo imi) {
        LocaleList systemLocales = res.getConfiguration().getLocales();
        Object object = sCacheLock;
        synchronized (object) {
            if (systemLocales.equals(sCachedSystemLocales) && sCachedInputMethodInfo == imi) {
                return new ArrayList<InputMethodSubtype>(sCachedResult);
            }
        }
        ArrayList<InputMethodSubtype> result = InputMethodUtils.getImplicitlyApplicableSubtypesLockedImpl(res, imi);
        Object object2 = sCacheLock;
        synchronized (object2) {
            sCachedSystemLocales = systemLocales;
            sCachedInputMethodInfo = imi;
            sCachedResult = new ArrayList<InputMethodSubtype>(result);
        }
        return result;
    }

    private static ArrayList<InputMethodSubtype> getImplicitlyApplicableSubtypesLockedImpl(Resources res, InputMethodInfo imi) {
        InputMethodSubtype lastResortKeyboardSubtype;
        ArrayList<InputMethodSubtype> subtypes = InputMethodUtils.getSubtypes(imi);
        LocaleList systemLocales = res.getConfiguration().getLocales();
        String systemLocale = systemLocales.get(0).toString();
        if (TextUtils.isEmpty(systemLocale)) {
            return new ArrayList<InputMethodSubtype>();
        }
        int numSubtypes = subtypes.size();
        HashMap<String, InputMethodSubtype> applicableModeAndSubtypesMap = new HashMap<String, InputMethodSubtype>();
        for (int i = 0; i < numSubtypes; ++i) {
            String mode;
            InputMethodSubtype subtype = (InputMethodSubtype)subtypes.get(i);
            if (!subtype.overridesImplicitlyEnabledSubtype() || applicableModeAndSubtypesMap.containsKey(mode = subtype.getMode())) continue;
            applicableModeAndSubtypesMap.put(mode, subtype);
        }
        if (applicableModeAndSubtypesMap.size() > 0) {
            return new ArrayList<InputMethodSubtype>(applicableModeAndSubtypesMap.values());
        }
        HashMap nonKeyboardSubtypesMap = new HashMap();
        ArrayList<InputMethodSubtype> keyboardSubtypes = new ArrayList<InputMethodSubtype>();
        for (int i = 0; i < numSubtypes; ++i) {
            InputMethodSubtype subtype = (InputMethodSubtype)subtypes.get(i);
            String mode = subtype.getMode();
            if (SUBTYPE_MODE_KEYBOARD.equals(mode)) {
                keyboardSubtypes.add(subtype);
                continue;
            }
            if (!nonKeyboardSubtypesMap.containsKey(mode)) {
                nonKeyboardSubtypesMap.put(mode, new ArrayList());
            }
            ((ArrayList)nonKeyboardSubtypesMap.get(mode)).add(subtype);
        }
        ArrayList<InputMethodSubtype> applicableSubtypes = new ArrayList<InputMethodSubtype>();
        LocaleUtils.filterByLanguage(keyboardSubtypes, sSubtypeToLocale, systemLocales, applicableSubtypes);
        if (!applicableSubtypes.isEmpty()) {
            boolean hasAsciiCapableKeyboard = false;
            int numApplicationSubtypes = applicableSubtypes.size();
            for (int i = 0; i < numApplicationSubtypes; ++i) {
                InputMethodSubtype subtype = applicableSubtypes.get(i);
                if (!subtype.containsExtraValueKey(TAG_ASCII_CAPABLE)) continue;
                hasAsciiCapableKeyboard = true;
                break;
            }
            if (!hasAsciiCapableKeyboard) {
                int numKeyboardSubtypes = keyboardSubtypes.size();
                for (int i = 0; i < numKeyboardSubtypes; ++i) {
                    InputMethodSubtype subtype = (InputMethodSubtype)keyboardSubtypes.get(i);
                    String mode = subtype.getMode();
                    if (!SUBTYPE_MODE_KEYBOARD.equals(mode) || !subtype.containsExtraValueKey(TAG_ENABLED_WHEN_DEFAULT_IS_NOT_ASCII_CAPABLE)) continue;
                    applicableSubtypes.add(subtype);
                }
            }
        }
        if (applicableSubtypes.isEmpty() && (lastResortKeyboardSubtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(res, subtypes, SUBTYPE_MODE_KEYBOARD, systemLocale, true)) != null) {
            applicableSubtypes.add(lastResortKeyboardSubtype);
        }
        for (ArrayList subtypeList : nonKeyboardSubtypesMap.values()) {
            LocaleUtils.filterByLanguage(subtypeList, sSubtypeToLocale, systemLocales, applicableSubtypes);
        }
        return applicableSubtypes;
    }

    public static String getLanguageFromLocaleString(String locale) {
        int idx = locale.indexOf(95);
        if (idx < 0) {
            return locale;
        }
        return locale.substring(0, idx);
    }

    public static InputMethodSubtype findLastResortApplicableSubtypeLocked(Resources res, List<InputMethodSubtype> subtypes, String mode, String locale, boolean canIgnoreLocaleAsLastResort) {
        if (subtypes == null || subtypes.size() == 0) {
            return null;
        }
        if (TextUtils.isEmpty(locale)) {
            locale = res.getConfiguration().locale.toString();
        }
        String language = InputMethodUtils.getLanguageFromLocaleString(locale);
        boolean partialMatchFound = false;
        InputMethodSubtype applicableSubtype = null;
        InputMethodSubtype firstMatchedModeSubtype = null;
        int N = subtypes.size();
        for (int i = 0; i < N; ++i) {
            InputMethodSubtype subtype = subtypes.get(i);
            String subtypeLocale = subtype.getLocale();
            String subtypeLanguage = InputMethodUtils.getLanguageFromLocaleString(subtypeLocale);
            if (mode != null && !subtypes.get(i).getMode().equalsIgnoreCase(mode)) continue;
            if (firstMatchedModeSubtype == null) {
                firstMatchedModeSubtype = subtype;
            }
            if (locale.equals(subtypeLocale)) {
                applicableSubtype = subtype;
                break;
            }
            if (partialMatchFound || !language.equals(subtypeLanguage)) continue;
            applicableSubtype = subtype;
            partialMatchFound = true;
        }
        if (applicableSubtype == null && canIgnoreLocaleAsLastResort) {
            return firstMatchedModeSubtype;
        }
        return applicableSubtype;
    }

    public static boolean canAddToLastInputMethod(InputMethodSubtype subtype) {
        if (subtype == null) {
            return true;
        }
        return !subtype.isAuxiliary();
    }

    public static void setNonSelectedSystemImesDisabledUntilUsed(IPackageManager packageManager, List<InputMethodInfo> enabledImis, int userId, String callingPackage) {
        String[] systemImesDisabledUntilUsed = Resources.getSystem().getStringArray(17236000);
        if (systemImesDisabledUntilUsed == null || systemImesDisabledUntilUsed.length == 0) {
            return;
        }
        SpellCheckerInfo currentSpellChecker = TextServicesManager.getInstance().getCurrentSpellChecker();
        for (String packageName : systemImesDisabledUntilUsed) {
            boolean isSystemPackage;
            boolean enabledIme = false;
            for (int j = 0; j < enabledImis.size(); ++j) {
                InputMethodInfo imi = enabledImis.get(j);
                if (!packageName.equals(imi.getPackageName())) continue;
                enabledIme = true;
                break;
            }
            if (enabledIme || currentSpellChecker != null && packageName.equals(currentSpellChecker.getPackageName())) continue;
            ApplicationInfo ai = null;
            try {
                ai = packageManager.getApplicationInfo(packageName, 32768, userId);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "getApplicationInfo failed. packageName=" + packageName + " userId=" + userId, e);
                continue;
            }
            if (ai == null) continue;
            boolean bl = isSystemPackage = (ai.flags & 1) != 0;
            if (!isSystemPackage) continue;
            InputMethodUtils.setDisabledUntilUsed(packageManager, packageName, userId, callingPackage);
        }
    }

    private static void setDisabledUntilUsed(IPackageManager packageManager, String packageName, int userId, String callingPackage) {
        int state;
        try {
            state = packageManager.getApplicationEnabledSetting(packageName, userId);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "getApplicationEnabledSetting failed. packageName=" + packageName + " userId=" + userId, e);
            return;
        }
        if (state == 0 || state == 1) {
            try {
                packageManager.setApplicationEnabledSetting(packageName, 4, 0, userId, callingPackage);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "setApplicationEnabledSetting failed. packageName=" + packageName + " userId=" + userId + " callingPackage=" + callingPackage, e);
                return;
            }
        }
    }

    public static CharSequence getImeAndSubtypeDisplayName(Context context, InputMethodInfo imi, InputMethodSubtype subtype) {
        CharSequence imiLabel = imi.loadLabel(context.getPackageManager());
        return subtype != null ? TextUtils.concat(subtype.getDisplayName(context, imi.getPackageName(), imi.getServiceInfo().applicationInfo), TextUtils.isEmpty(imiLabel) ? "" : " - " + imiLabel) : imiLabel;
    }

    public static boolean checkIfPackageBelongsToUid(AppOpsManager appOpsManager, int uid, String packageName) {
        try {
            appOpsManager.checkPackage(uid, packageName);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    @VisibleForTesting
    public static ArrayMap<String, ArraySet<String>> parseInputMethodsAndSubtypesString(String inputMethodsAndSubtypesString) {
        ArrayMap<String, ArraySet<String>> imeMap = new ArrayMap<String, ArraySet<String>>();
        if (TextUtils.isEmpty(inputMethodsAndSubtypesString)) {
            return imeMap;
        }
        TextUtils.SimpleStringSplitter typeSplitter = new TextUtils.SimpleStringSplitter(':');
        TextUtils.SimpleStringSplitter subtypeSplitter = new TextUtils.SimpleStringSplitter(';');
        List<Pair<String, ArrayList<String>>> allImeSettings = InputMethodSettings.buildInputMethodsAndSubtypeList(inputMethodsAndSubtypesString, typeSplitter, subtypeSplitter);
        for (Pair<String, ArrayList<String>> ime : allImeSettings) {
            ArraySet subtypes = new ArraySet();
            if (ime.second != null) {
                subtypes.addAll((Collection)ime.second);
            }
            imeMap.put((String)ime.first, subtypes);
        }
        return imeMap;
    }

    public static String buildInputMethodsAndSubtypesString(ArrayMap<String, ArraySet<String>> map) {
        ArrayList<Pair<String, ArrayList<String>>> imeMap = new ArrayList<Pair<String, ArrayList<String>>>(4);
        for (Map.Entry<String, ArraySet<String>> entry : map.entrySet()) {
            String imeName = entry.getKey();
            ArraySet<String> subtypeSet = entry.getValue();
            ArrayList<String> subtypes = new ArrayList<String>(2);
            if (subtypeSet != null) {
                subtypes.addAll(subtypeSet);
            }
            imeMap.add(new Pair(imeName, subtypes));
        }
        return InputMethodSettings.buildInputMethodsSettingString(imeMap);
    }

    @VisibleForTesting
    public static ArrayList<Locale> getSuitableLocalesForSpellChecker(Locale systemLocale) {
        Locale systemLocaleLanguage;
        Locale systemLocaleLanguageCountry;
        Locale systemLocaleLanguageCountryVariant;
        if (systemLocale != null) {
            String language = systemLocale.getLanguage();
            boolean hasLanguage = !TextUtils.isEmpty(language);
            String country = systemLocale.getCountry();
            boolean hasCountry = !TextUtils.isEmpty(country);
            String variant = systemLocale.getVariant();
            boolean hasVariant = !TextUtils.isEmpty(variant);
            systemLocaleLanguageCountryVariant = hasLanguage && hasCountry && hasVariant ? new Locale(language, country, variant) : null;
            systemLocaleLanguageCountry = hasLanguage && hasCountry ? new Locale(language, country) : null;
            systemLocaleLanguage = hasLanguage ? new Locale(language) : null;
        } else {
            systemLocaleLanguageCountryVariant = null;
            systemLocaleLanguageCountry = null;
            systemLocaleLanguage = null;
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (systemLocaleLanguageCountryVariant != null) {
            locales.add(systemLocaleLanguageCountryVariant);
        }
        if (Locale.ENGLISH.equals(systemLocaleLanguage)) {
            if (systemLocaleLanguageCountry != null) {
                if (systemLocaleLanguageCountry != null) {
                    locales.add(systemLocaleLanguageCountry);
                }
                if (!LOCALE_EN_US.equals(systemLocaleLanguageCountry)) {
                    locales.add(LOCALE_EN_US);
                }
                if (!LOCALE_EN_GB.equals(systemLocaleLanguageCountry)) {
                    locales.add(LOCALE_EN_GB);
                }
                locales.add(Locale.ENGLISH);
            } else {
                locales.add(Locale.ENGLISH);
                locales.add(LOCALE_EN_US);
                locales.add(LOCALE_EN_GB);
            }
        } else {
            if (systemLocaleLanguageCountry != null) {
                locales.add(systemLocaleLanguageCountry);
            }
            if (systemLocaleLanguage != null) {
                locales.add(systemLocaleLanguage);
            }
            locales.add(LOCALE_EN_US);
            locales.add(LOCALE_EN_GB);
            locales.add(Locale.ENGLISH);
        }
        return locales;
    }

    static {
        sSubtypeToLocale = new LocaleUtils.LocaleExtractor<InputMethodSubtype>(){

            @Override
            public Locale get(InputMethodSubtype source) {
                return source != null ? source.getLocaleObject() : null;
            }
        };
        LOCALE_EN_US = new Locale("en", "US");
        LOCALE_EN_GB = new Locale("en", "GB");
    }

    public static class InputMethodSettings {
        private final TextUtils.SimpleStringSplitter mInputMethodSplitter = new TextUtils.SimpleStringSplitter(':');
        private final TextUtils.SimpleStringSplitter mSubtypeSplitter = new TextUtils.SimpleStringSplitter(';');
        private final Resources mRes;
        private final ContentResolver mResolver;
        private final HashMap<String, InputMethodInfo> mMethodMap;
        private final ArrayList<InputMethodInfo> mMethodList;
        private final HashMap<String, String> mCopyOnWriteDataStore = new HashMap();
        private boolean mCopyOnWrite = false;
        private String mEnabledInputMethodsStrCache = "";
        private int mCurrentUserId;
        private int[] mCurrentProfileIds = new int[0];

        private static void buildEnabledInputMethodsSettingString(StringBuilder builder, Pair<String, ArrayList<String>> ime) {
            builder.append((String)ime.first);
            for (String subtypeId : (ArrayList)ime.second) {
                builder.append(';').append(subtypeId);
            }
        }

        public static String buildInputMethodsSettingString(List<Pair<String, ArrayList<String>>> allImeSettingsMap) {
            StringBuilder b = new StringBuilder();
            boolean needsSeparator = false;
            for (Pair<String, ArrayList<String>> ime : allImeSettingsMap) {
                if (needsSeparator) {
                    b.append(':');
                }
                InputMethodSettings.buildEnabledInputMethodsSettingString(b, ime);
                needsSeparator = true;
            }
            return b.toString();
        }

        public static List<Pair<String, ArrayList<String>>> buildInputMethodsAndSubtypeList(String enabledInputMethodsStr, TextUtils.SimpleStringSplitter inputMethodSplitter, TextUtils.SimpleStringSplitter subtypeSplitter) {
            ArrayList<Pair<String, ArrayList<String>>> imsList = new ArrayList<Pair<String, ArrayList<String>>>();
            if (TextUtils.isEmpty(enabledInputMethodsStr)) {
                return imsList;
            }
            inputMethodSplitter.setString(enabledInputMethodsStr);
            while (inputMethodSplitter.hasNext()) {
                String nextImsStr = inputMethodSplitter.next();
                subtypeSplitter.setString(nextImsStr);
                if (!subtypeSplitter.hasNext()) continue;
                ArrayList<String> subtypeHashes = new ArrayList<String>();
                String imeId = subtypeSplitter.next();
                while (subtypeSplitter.hasNext()) {
                    subtypeHashes.add(subtypeSplitter.next());
                }
                imsList.add(new Pair(imeId, subtypeHashes));
            }
            return imsList;
        }

        public InputMethodSettings(Resources res, ContentResolver resolver, HashMap<String, InputMethodInfo> methodMap, ArrayList<InputMethodInfo> methodList, int userId, boolean copyOnWrite) {
            this.mRes = res;
            this.mResolver = resolver;
            this.mMethodMap = methodMap;
            this.mMethodList = methodList;
            this.switchCurrentUser(userId, copyOnWrite);
        }

        public void switchCurrentUser(int userId, boolean copyOnWrite) {
            if (this.mCurrentUserId != userId || this.mCopyOnWrite != copyOnWrite) {
                this.mCopyOnWriteDataStore.clear();
                this.mEnabledInputMethodsStrCache = "";
            }
            this.mCurrentUserId = userId;
            this.mCopyOnWrite = copyOnWrite;
        }

        private void putString(String key, String str) {
            if (this.mCopyOnWrite) {
                this.mCopyOnWriteDataStore.put(key, str);
            } else {
                Settings.Secure.putStringForUser(this.mResolver, key, str, this.mCurrentUserId);
            }
        }

        private String getString(String key, String defaultValue) {
            String result = this.mCopyOnWrite && this.mCopyOnWriteDataStore.containsKey(key) ? this.mCopyOnWriteDataStore.get(key) : Settings.Secure.getStringForUser(this.mResolver, key, this.mCurrentUserId);
            return result != null ? result : defaultValue;
        }

        private void putInt(String key, int value) {
            if (this.mCopyOnWrite) {
                this.mCopyOnWriteDataStore.put(key, String.valueOf(value));
            } else {
                Settings.Secure.putIntForUser(this.mResolver, key, value, this.mCurrentUserId);
            }
        }

        private int getInt(String key, int defaultValue) {
            if (this.mCopyOnWrite && this.mCopyOnWriteDataStore.containsKey(key)) {
                String result = this.mCopyOnWriteDataStore.get(key);
                return result != null ? Integer.parseInt(result) : 0;
            }
            return Settings.Secure.getIntForUser(this.mResolver, key, defaultValue, this.mCurrentUserId);
        }

        private void putBoolean(String key, boolean value) {
            this.putInt(key, value ? 1 : 0);
        }

        private boolean getBoolean(String key, boolean defaultValue) {
            return this.getInt(key, defaultValue ? 1 : 0) == 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCurrentProfileIds(int[] currentProfileIds) {
            InputMethodSettings inputMethodSettings = this;
            synchronized (inputMethodSettings) {
                this.mCurrentProfileIds = currentProfileIds;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCurrentProfile(int userId) {
            InputMethodSettings inputMethodSettings = this;
            synchronized (inputMethodSettings) {
                if (userId == this.mCurrentUserId) {
                    return true;
                }
                for (int i = 0; i < this.mCurrentProfileIds.length; ++i) {
                    if (userId != this.mCurrentProfileIds[i]) continue;
                    return true;
                }
                return false;
            }
        }

        public ArrayList<InputMethodInfo> getEnabledInputMethodListLocked() {
            return this.createEnabledInputMethodListLocked(this.getEnabledInputMethodsAndSubtypeListLocked());
        }

        public List<InputMethodSubtype> getEnabledInputMethodSubtypeListLocked(Context context, InputMethodInfo imi, boolean allowsImplicitlySelectedSubtypes) {
            List<InputMethodSubtype> enabledSubtypes = this.getEnabledInputMethodSubtypeListLocked(imi);
            if (allowsImplicitlySelectedSubtypes && enabledSubtypes.isEmpty()) {
                enabledSubtypes = InputMethodUtils.getImplicitlyApplicableSubtypesLocked(context.getResources(), imi);
            }
            return InputMethodSubtype.sort(context, 0, imi, enabledSubtypes);
        }

        public List<InputMethodSubtype> getEnabledInputMethodSubtypeListLocked(InputMethodInfo imi) {
            List<Pair<String, ArrayList<String>>> imsList = this.getEnabledInputMethodsAndSubtypeListLocked();
            ArrayList<InputMethodSubtype> enabledSubtypes = new ArrayList<InputMethodSubtype>();
            if (imi != null) {
                for (Pair<String, ArrayList<String>> imsPair : imsList) {
                    InputMethodInfo info = this.mMethodMap.get(imsPair.first);
                    if (info == null || !info.getId().equals(imi.getId())) continue;
                    int subtypeCount = info.getSubtypeCount();
                    for (int i = 0; i < subtypeCount; ++i) {
                        InputMethodSubtype ims = info.getSubtypeAt(i);
                        for (String s : (ArrayList)imsPair.second) {
                            if (!String.valueOf(ims.hashCode()).equals(s)) continue;
                            enabledSubtypes.add(ims);
                        }
                    }
                }
            }
            return enabledSubtypes;
        }

        public List<Pair<String, ArrayList<String>>> getEnabledInputMethodsAndSubtypeListLocked() {
            return InputMethodSettings.buildInputMethodsAndSubtypeList(this.getEnabledInputMethodsStr(), this.mInputMethodSplitter, this.mSubtypeSplitter);
        }

        public void appendAndPutEnabledInputMethodLocked(String id2, boolean reloadInputMethodStr) {
            if (reloadInputMethodStr) {
                this.getEnabledInputMethodsStr();
            }
            if (TextUtils.isEmpty(this.mEnabledInputMethodsStrCache)) {
                this.putEnabledInputMethodsStr(id2);
            } else {
                this.putEnabledInputMethodsStr(this.mEnabledInputMethodsStrCache + ':' + id2);
            }
        }

        public boolean buildAndPutEnabledInputMethodsStrRemovingIdLocked(StringBuilder builder, List<Pair<String, ArrayList<String>>> imsList, String id2) {
            boolean isRemoved = false;
            boolean needsAppendSeparator = false;
            for (Pair<String, ArrayList<String>> ims : imsList) {
                String curId = (String)ims.first;
                if (curId.equals(id2)) {
                    isRemoved = true;
                    continue;
                }
                if (needsAppendSeparator) {
                    builder.append(':');
                } else {
                    needsAppendSeparator = true;
                }
                InputMethodSettings.buildEnabledInputMethodsSettingString(builder, ims);
            }
            if (isRemoved) {
                this.putEnabledInputMethodsStr(builder.toString());
            }
            return isRemoved;
        }

        private ArrayList<InputMethodInfo> createEnabledInputMethodListLocked(List<Pair<String, ArrayList<String>>> imsList) {
            ArrayList<InputMethodInfo> res = new ArrayList<InputMethodInfo>();
            for (Pair<String, ArrayList<String>> ims : imsList) {
                InputMethodInfo info = this.mMethodMap.get(ims.first);
                if (info == null) continue;
                res.add(info);
            }
            return res;
        }

        private void putEnabledInputMethodsStr(String str) {
            if (TextUtils.isEmpty(str)) {
                this.putString("enabled_input_methods", null);
            } else {
                this.putString("enabled_input_methods", str);
            }
            this.mEnabledInputMethodsStrCache = str != null ? str : "";
        }

        public String getEnabledInputMethodsStr() {
            this.mEnabledInputMethodsStrCache = this.getString("enabled_input_methods", "");
            return this.mEnabledInputMethodsStrCache;
        }

        private void saveSubtypeHistory(List<Pair<String, String>> savedImes, String newImeId, String newSubtypeId) {
            StringBuilder builder = new StringBuilder();
            boolean isImeAdded = false;
            if (!TextUtils.isEmpty(newImeId) && !TextUtils.isEmpty(newSubtypeId)) {
                builder.append(newImeId).append(';').append(newSubtypeId);
                isImeAdded = true;
            }
            for (Pair<String, String> ime : savedImes) {
                String imeId = (String)ime.first;
                String subtypeId = (String)ime.second;
                if (TextUtils.isEmpty(subtypeId)) {
                    subtypeId = NOT_A_SUBTYPE_ID_STR;
                }
                if (isImeAdded) {
                    builder.append(':');
                } else {
                    isImeAdded = true;
                }
                builder.append(imeId).append(';').append(subtypeId);
            }
            this.putSubtypeHistoryStr(builder.toString());
        }

        private void addSubtypeToHistory(String imeId, String subtypeId) {
            List<Pair<String, String>> subtypeHistory = this.loadInputMethodAndSubtypeHistoryLocked();
            for (Pair<String, String> ime : subtypeHistory) {
                if (!((String)ime.first).equals(imeId)) continue;
                subtypeHistory.remove(ime);
                break;
            }
            this.saveSubtypeHistory(subtypeHistory, imeId, subtypeId);
        }

        private void putSubtypeHistoryStr(String str) {
            if (TextUtils.isEmpty(str)) {
                this.putString("input_methods_subtype_history", null);
            } else {
                this.putString("input_methods_subtype_history", str);
            }
        }

        public Pair<String, String> getLastInputMethodAndSubtypeLocked() {
            return this.getLastSubtypeForInputMethodLockedInternal(null);
        }

        public String getLastSubtypeForInputMethodLocked(String imeId) {
            Pair<String, String> ime = this.getLastSubtypeForInputMethodLockedInternal(imeId);
            if (ime != null) {
                return (String)ime.second;
            }
            return null;
        }

        private Pair<String, String> getLastSubtypeForInputMethodLockedInternal(String imeId) {
            List<Pair<String, ArrayList<String>>> enabledImes = this.getEnabledInputMethodsAndSubtypeListLocked();
            List<Pair<String, String>> subtypeHistory = this.loadInputMethodAndSubtypeHistoryLocked();
            for (Pair<String, String> imeAndSubtype : subtypeHistory) {
                String subtypeInTheHistory;
                String subtypeHashCode;
                String imeInTheHistory = (String)imeAndSubtype.first;
                if (!TextUtils.isEmpty(imeId) && !imeInTheHistory.equals(imeId) || TextUtils.isEmpty(subtypeHashCode = this.getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(enabledImes, imeInTheHistory, subtypeInTheHistory = (String)imeAndSubtype.second))) continue;
                return new Pair<String, String>(imeInTheHistory, subtypeHashCode);
            }
            return null;
        }

        private String getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(List<Pair<String, ArrayList<String>>> enabledImes, String imeId, String subtypeHashCode) {
            for (Pair<String, ArrayList<String>> enabledIme : enabledImes) {
                if (!((String)enabledIme.first).equals(imeId)) continue;
                ArrayList explicitlyEnabledSubtypes = (ArrayList)enabledIme.second;
                InputMethodInfo imi = this.mMethodMap.get(imeId);
                if (explicitlyEnabledSubtypes.size() == 0) {
                    ArrayList<InputMethodSubtype> implicitlySelectedSubtypes;
                    if (imi != null && imi.getSubtypeCount() > 0 && (implicitlySelectedSubtypes = InputMethodUtils.getImplicitlyApplicableSubtypesLocked(this.mRes, imi)) != null) {
                        int N = implicitlySelectedSubtypes.size();
                        for (int i = 0; i < N; ++i) {
                            InputMethodSubtype st = (InputMethodSubtype)implicitlySelectedSubtypes.get(i);
                            if (!String.valueOf(st.hashCode()).equals(subtypeHashCode)) continue;
                            return subtypeHashCode;
                        }
                    }
                } else {
                    for (String s : explicitlyEnabledSubtypes) {
                        if (!s.equals(subtypeHashCode)) continue;
                        try {
                            int hashCode = Integer.parseInt(subtypeHashCode);
                            if (InputMethodUtils.isValidSubtypeId(imi, hashCode)) {
                                return s;
                            }
                            return NOT_A_SUBTYPE_ID_STR;
                        }
                        catch (NumberFormatException e) {
                            return NOT_A_SUBTYPE_ID_STR;
                        }
                    }
                }
                return NOT_A_SUBTYPE_ID_STR;
            }
            return null;
        }

        private List<Pair<String, String>> loadInputMethodAndSubtypeHistoryLocked() {
            ArrayList<Pair<String, String>> imsList = new ArrayList<Pair<String, String>>();
            String subtypeHistoryStr = this.getSubtypeHistoryStr();
            if (TextUtils.isEmpty(subtypeHistoryStr)) {
                return imsList;
            }
            this.mInputMethodSplitter.setString(subtypeHistoryStr);
            while (this.mInputMethodSplitter.hasNext()) {
                String nextImsStr = this.mInputMethodSplitter.next();
                this.mSubtypeSplitter.setString(nextImsStr);
                if (!this.mSubtypeSplitter.hasNext()) continue;
                String subtypeId = NOT_A_SUBTYPE_ID_STR;
                String imeId = this.mSubtypeSplitter.next();
                if (this.mSubtypeSplitter.hasNext()) {
                    subtypeId = this.mSubtypeSplitter.next();
                }
                imsList.add(new Pair<String, String>(imeId, subtypeId));
            }
            return imsList;
        }

        private String getSubtypeHistoryStr() {
            String history = this.getString("input_methods_subtype_history", "");
            return history;
        }

        public void putSelectedInputMethod(String imeId) {
            this.putString("default_input_method", imeId);
        }

        public void putSelectedSubtype(int subtypeId) {
            this.putInt("selected_input_method_subtype", subtypeId);
        }

        public String getSelectedInputMethod() {
            String imi = this.getString("default_input_method", null);
            return imi;
        }

        public boolean isSubtypeSelected() {
            return this.getSelectedInputMethodSubtypeHashCode() != -1;
        }

        private int getSelectedInputMethodSubtypeHashCode() {
            return this.getInt("selected_input_method_subtype", -1);
        }

        public boolean isShowImeWithHardKeyboardEnabled() {
            return this.getBoolean("show_ime_with_hard_keyboard", false);
        }

        public void setShowImeWithHardKeyboard(boolean show) {
            this.putBoolean("show_ime_with_hard_keyboard", show);
        }

        public int getCurrentUserId() {
            return this.mCurrentUserId;
        }

        public int getSelectedInputMethodSubtypeId(String selectedImiId) {
            InputMethodInfo imi = this.mMethodMap.get(selectedImiId);
            if (imi == null) {
                return -1;
            }
            int subtypeHashCode = this.getSelectedInputMethodSubtypeHashCode();
            return InputMethodUtils.getSubtypeIdFromHashCode(imi, subtypeHashCode);
        }

        public void saveCurrentInputMethodAndSubtypeToHistory(String curMethodId, InputMethodSubtype currentSubtype) {
            String subtypeId = NOT_A_SUBTYPE_ID_STR;
            if (currentSubtype != null) {
                subtypeId = String.valueOf(currentSubtype.hashCode());
            }
            if (InputMethodUtils.canAddToLastInputMethod(currentSubtype)) {
                this.addSubtypeToHistory(curMethodId, subtypeId);
            }
        }

        public HashMap<InputMethodInfo, List<InputMethodSubtype>> getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked(Context context) {
            HashMap<InputMethodInfo, List<InputMethodSubtype>> enabledInputMethodAndSubtypes = new HashMap<InputMethodInfo, List<InputMethodSubtype>>();
            for (InputMethodInfo imi : this.getEnabledInputMethodListLocked()) {
                enabledInputMethodAndSubtypes.put(imi, this.getEnabledInputMethodSubtypeListLocked(context, imi, true));
            }
            return enabledInputMethodAndSubtypes;
        }

        public void dumpLocked(Printer pw, String prefix) {
            pw.println(prefix + "mCurrentUserId=" + this.mCurrentUserId);
            pw.println(prefix + "mCurrentProfileIds=" + Arrays.toString(this.mCurrentProfileIds));
            pw.println(prefix + "mCopyOnWrite=" + this.mCopyOnWrite);
            pw.println(prefix + "mEnabledInputMethodsStrCache=" + this.mEnabledInputMethodsStrCache);
        }
    }

    private static class InputMethodListBuilder {
        private final LinkedHashSet<InputMethodInfo> mInputMethodSet = new LinkedHashSet();

        private InputMethodListBuilder() {
        }

        public InputMethodListBuilder fillImes(ArrayList<InputMethodInfo> imis, Context context, boolean checkDefaultAttribute, Locale locale, boolean checkCountry, String requiredSubtypeMode) {
            for (int i = 0; i < imis.size(); ++i) {
                InputMethodInfo imi = imis.get(i);
                if (!InputMethodUtils.isSystemImeThatHasSubtypeOf(imi, context, checkDefaultAttribute, locale, checkCountry, requiredSubtypeMode)) continue;
                this.mInputMethodSet.add(imi);
            }
            return this;
        }

        public InputMethodListBuilder fillAuxiliaryImes(ArrayList<InputMethodInfo> imis, Context context) {
            InputMethodInfo imi;
            int i;
            for (InputMethodInfo imi2 : this.mInputMethodSet) {
                if (!imi2.isAuxiliaryIme()) continue;
                return this;
            }
            boolean added = false;
            for (i = 0; i < imis.size(); ++i) {
                imi = imis.get(i);
                if (!InputMethodUtils.isSystemAuxilialyImeThatHasAutomaticSubtype(imi, context, true)) continue;
                this.mInputMethodSet.add(imi);
                added = true;
            }
            if (added) {
                return this;
            }
            for (i = 0; i < imis.size(); ++i) {
                imi = imis.get(i);
                if (!InputMethodUtils.isSystemAuxilialyImeThatHasAutomaticSubtype(imi, context, false)) continue;
                this.mInputMethodSet.add(imi);
            }
            return this;
        }

        public boolean isEmpty() {
            return this.mInputMethodSet.isEmpty();
        }

        public ArrayList<InputMethodInfo> build() {
            return new ArrayList<InputMethodInfo>(this.mInputMethodSet);
        }
    }
}

