/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;

public class CaptureStorage {
    private static final ReferenceQueue KEY_REFERENCE_QUEUE;
    private static final ConcurrentMap<WeakReference, CapturedStack> STORAGE;
    private static final ThreadLocal<Deque<InsertMatch>> CURRENT_STACKS;
    private static boolean DEBUG;
    private static boolean ENABLED;
    private static final JavaLangAccess ourJavaLangAccess;

    public static void capture(Object key) {
        if (!ENABLED) {
            return;
        }
        try {
            Throwable exception = new Throwable();
            if (DEBUG) {
                System.out.println("capture " + CaptureStorage.getCallerDescriptor(exception) + " - " + key);
            }
            CapturedStack stack = CaptureStorage.createCapturedStack(exception, CURRENT_STACKS.get().peekLast());
            CaptureStorage.processQueue();
            WeakKey keyRef = new WeakKey(key, stack, KEY_REFERENCE_QUEUE);
            STORAGE.put(keyRef, stack);
        }
        catch (Exception e) {
            CaptureStorage.handleException(e);
        }
    }

    public static void insertEnter(Object key) {
        if (!ENABLED) {
            return;
        }
        try {
            CapturedStack stack = (CapturedStack)STORAGE.get(new HardKey(key));
            Deque<InsertMatch> currentStacks = CURRENT_STACKS.get();
            if (stack != null) {
                Throwable exception = new Throwable();
                currentStacks.add(new InsertMatch(stack, exception));
                if (DEBUG) {
                    System.out.println("insert " + CaptureStorage.getCallerDescriptor(exception) + " -> " + key + ", stack saved (" + currentStacks.size() + ")");
                }
            } else {
                currentStacks.add(InsertMatch.EMPTY);
                if (DEBUG) {
                    System.out.println("insert " + CaptureStorage.getCallerDescriptor(new Throwable()) + " -> " + key + ", no stack found (" + currentStacks.size() + ")");
                }
            }
        }
        catch (Exception e) {
            CaptureStorage.handleException(e);
        }
    }

    public static void insertExit(Object key) {
        if (!ENABLED) {
            return;
        }
        try {
            Deque<InsertMatch> currentStacks = CURRENT_STACKS.get();
            currentStacks.removeLast();
            if (DEBUG) {
                System.out.println("insert " + CaptureStorage.getCallerDescriptor(new Throwable()) + " <- " + key + ", stack removed (" + currentStacks.size() + ")");
            }
        }
        catch (Exception e) {
            CaptureStorage.handleException(e);
        }
    }

    private static void processQueue() {
        WeakKey key;
        while ((key = (WeakKey)KEY_REFERENCE_QUEUE.poll()) != null) {
            STORAGE.remove(key, key.myValue);
        }
    }

    private static CapturedStack createCapturedStack(Throwable exception, InsertMatch insertMatch) {
        if (insertMatch != null && insertMatch != InsertMatch.EMPTY) {
            CapturedStack stack = new DeepCapturedStack(exception, insertMatch);
            if (stack.getRecursionDepth() > 100) {
                ArrayList<StackTraceElement> trace = CaptureStorage.getStackTrace(stack, 500);
                trace.trimToSize();
                stack = new UnwindCapturedStack(trace);
            }
            return stack;
        }
        return new ExceptionCapturedStack(exception);
    }

    public static Object[][] getRelatedStack(Object key, int limit) {
        CapturedStack stack = (CapturedStack)STORAGE.get(new HardKey(key));
        if (stack == null) {
            return null;
        }
        ArrayList<StackTraceElement> stackTrace = CaptureStorage.getStackTrace(stack, limit);
        Object[][] res = new Object[stackTrace.size()][];
        for (int i = 0; i < stackTrace.size(); ++i) {
            StackTraceElement elem = (StackTraceElement)stackTrace.get(i);
            res[i] = elem == null ? null : new Object[]{elem.getClassName(), elem.getFileName(), elem.getMethodName(), String.valueOf(elem.getLineNumber())};
        }
        return res;
    }

    private static ArrayList<StackTraceElement> getStackTrace(CapturedStack stack, int limit) {
        ArrayList<StackTraceElement> res = new ArrayList<StackTraceElement>();
        while (stack != null && res.size() <= limit) {
            List<StackTraceElement> stackTrace = stack.getStackTrace();
            if (stack instanceof DeepCapturedStack) {
                InsertMatch match = ((DeepCapturedStack)stack).myInsertMatch;
                if (match != null && match != InsertMatch.EMPTY) {
                    stackTrace = stackTrace.subList(0, stackTrace.size() - match.getDepth() + 2);
                    stack = match.myStack;
                }
            } else {
                stack = null;
            }
            res.addAll(stackTrace);
            if (stack == null) continue;
            res.add(null);
        }
        return res;
    }

    public static void setDebug(boolean debug) {
        DEBUG = debug;
    }

    public static void setEnabled(boolean enabled) {
        ENABLED = enabled;
    }

    private static int getStackTraceDepth(Throwable exception) {
        return ourJavaLangAccess != null ? ourJavaLangAccess.getStackTraceDepth(exception) : exception.getStackTrace().length;
    }

    private static void handleException(Throwable e) {
        ENABLED = false;
        System.err.println("Critical error in IDEA Async Stacktraces instrumenting agent. Agent is now disabled. Please report to IDEA support:");
        e.printStackTrace();
    }

    private static String getCallerDescriptor(Throwable e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement caller = stackTrace[stackTrace.length - 2];
        return caller.getClassName() + "." + caller.getMethodName();
    }

    static {
        JavaLangAccess access;
        KEY_REFERENCE_QUEUE = new ReferenceQueue();
        STORAGE = new ConcurrentHashMap<WeakReference, CapturedStack>();
        CURRENT_STACKS = new ThreadLocal<Deque<InsertMatch>>(){

            @Override
            protected Deque<InsertMatch> initialValue() {
                return new LinkedList<InsertMatch>();
            }
        };
        DEBUG = false;
        ENABLED = true;
        try {
            access = SharedSecrets.getJavaLangAccess();
            if (access != null) {
                access.getStackTraceDepth(new Throwable());
            }
        }
        catch (Throwable e) {
            access = null;
        }
        ourJavaLangAccess = access;
    }

    private static class InsertMatch {
        private final CapturedStack myStack;
        private final Throwable myException;
        static final InsertMatch EMPTY = new InsertMatch(null, null){

            @Override
            int getDepth() {
                return 0;
            }
        };

        private InsertMatch(CapturedStack stack, Throwable exception) {
            this.myStack = stack;
            this.myException = exception;
        }

        int getDepth() {
            return CaptureStorage.getStackTraceDepth(this.myException);
        }
    }

    private static class DeepCapturedStack
    extends ExceptionCapturedStack {
        final InsertMatch myInsertMatch;
        final int myRecursionDepth;

        public DeepCapturedStack(Throwable exception, InsertMatch insertMatch) {
            super(exception);
            this.myInsertMatch = insertMatch;
            this.myRecursionDepth = insertMatch.myStack.getRecursionDepth() + 1;
        }

        @Override
        public int getRecursionDepth() {
            return this.myRecursionDepth;
        }
    }

    private static class ExceptionCapturedStack
    implements CapturedStack {
        final Throwable myException;

        private ExceptionCapturedStack(Throwable exception) {
            this.myException = exception;
        }

        @Override
        public List<StackTraceElement> getStackTrace() {
            StackTraceElement[] stackTrace = this.myException.getStackTrace();
            return Arrays.asList(stackTrace).subList(1, stackTrace.length);
        }

        @Override
        public int getRecursionDepth() {
            return 0;
        }
    }

    private static class UnwindCapturedStack
    implements CapturedStack {
        final List<StackTraceElement> myStackTraceElements;

        public UnwindCapturedStack(List<StackTraceElement> elements) {
            this.myStackTraceElements = elements;
        }

        @Override
        public List<StackTraceElement> getStackTrace() {
            return this.myStackTraceElements;
        }

        @Override
        public int getRecursionDepth() {
            return 0;
        }
    }

    private static interface CapturedStack {
        public List<StackTraceElement> getStackTrace();

        public int getRecursionDepth();
    }

    private static class WeakKey
    extends WeakReference {
        private final int myHash;
        private final CapturedStack myValue;

        public WeakKey(Object key, CapturedStack value, ReferenceQueue q) {
            super(key, q);
            this.myHash = System.identityHashCode(key);
            this.myValue = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WeakKey)) {
                return false;
            }
            Object t = this.get();
            Object u = ((WeakKey)o).get();
            if (t == null || u == null) {
                return false;
            }
            return t == u;
        }

        public int hashCode() {
            return this.myHash;
        }
    }

    private static class HardKey {
        private final Object myKey;
        private final int myHash;

        public HardKey(Object key) {
            this.myKey = key;
            this.myHash = System.identityHashCode(key);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof WeakKey && ((WeakKey)o).get() == this.myKey;
        }

        public int hashCode() {
            return this.myHash;
        }
    }
}

