/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.ColorAndFontPanelFactoryEx;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.ConsoleFontOptions;
import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.colors.FontOptions;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.RainbowAttributeDescriptor;
import com.intellij.application.options.colors.RainbowColorsInSchemeState;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.application.options.colors.ScopeAttributesUtil;
import com.intellij.application.options.colors.ScopeColorsPageFactory;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.application.options.colors.TextAttributesDescription;
import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.ide.actions.QuickChangeColorSchemeAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorSchemesComparator;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.colors.AbstractKeyDescriptor;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyValidationManagerImpl;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.ColorUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorAndFontOptions
extends SearchableConfigurable.Parent.Abstract
implements EditorOptionsProvider,
SchemesModel<EditorColorsScheme> {
    private static final Logger LOG = Logger.getInstance(ColorAndFontOptions.class);
    public static final String ID = "reference.settingsdialog.IDE.editor.colors";
    public static final String FONT_CONFIGURABLE_NAME = "Color Scheme Font";
    private Map<String, MyColorScheme> mySchemes;
    private MyColorScheme mySelectedScheme;
    public static final String SCOPES_GROUP = ApplicationBundle.message((String)"title.scope.based", (Object[])new Object[0]);
    private boolean mySomeSchemesDeleted = false;
    private Map<ColorAndFontPanelFactory, InnerSearchableConfigurable> mySubPanelFactories;
    private SchemesPanel myRootSchemesPanel;
    private boolean myInitResetCompleted = false;
    private boolean myInitResetInvoked = false;
    private boolean myRevertChangesCompleted = false;
    private boolean myApplyCompleted = false;
    private boolean myDisposeCompleted = false;
    private final Disposable myDisposable = Disposer.newDisposable();
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private boolean myIsReset = false;

    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(0);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void stateChanged() {
        ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).settingsChanged();
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.colors.and.fonts", (Object[])new Object[0]);
    }

    public boolean isModified() {
        boolean listModified = this.isSchemeListModified();
        boolean schemeModified = this.isSomeSchemeModified();
        if (listModified || schemeModified) {
            this.myApplyCompleted = false;
        }
        return listModified;
    }

    private boolean isSchemeListModified() {
        if (this.mySomeSchemesDeleted) {
            return true;
        }
        if (!this.mySelectedScheme.getName().equals(EditorColorsManager.getInstance().getGlobalScheme().getName())) {
            return true;
        }
        for (MyColorScheme scheme2 : this.mySchemes.values()) {
            if (!scheme2.isNew()) continue;
            return true;
        }
        return false;
    }

    private boolean isSomeSchemeModified() {
        for (MyColorScheme scheme2 : this.mySchemes.values()) {
            if (!scheme2.isModified()) continue;
            return true;
        }
        return false;
    }

    public EditorColorsScheme selectScheme(@NotNull String name) {
        if (name == null) {
            ColorAndFontOptions.$$$reportNull$$$0(1);
        }
        this.mySelectedScheme = this.getScheme(name);
        return this.mySelectedScheme;
    }

    MyColorScheme getScheme(String name) {
        return this.mySchemes.get(name);
    }

    public EditorColorsScheme getSelectedScheme() {
        return this.mySelectedScheme;
    }

    public EditorSchemeAttributeDescriptor[] getCurrentDescriptions() {
        return this.mySelectedScheme.getDescriptors();
    }

    @Override
    public boolean canDuplicateScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(2);
        }
        return true;
    }

    @Override
    public boolean canResetScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(3);
        }
        AbstractColorsScheme originalScheme = scheme2 instanceof AbstractColorsScheme ? ((AbstractColorsScheme)scheme2).getOriginal() : null;
        return !ColorAndFontOptions.isReadOnly(scheme2) && scheme2.getName().startsWith("_@user_") && originalScheme instanceof ReadOnlyColorsScheme;
    }

    @Override
    public boolean canDeleteScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(4);
        }
        return !ColorAndFontOptions.isReadOnly(scheme2) && ColorAndFontOptions.canBeDeleted(scheme2);
    }

    @Override
    public boolean isProjectScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(5);
        }
        return false;
    }

    @Override
    public boolean canRenameScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(6);
        }
        return this.canDeleteScheme(scheme2);
    }

    @Override
    public boolean containsScheme(@NotNull String name, boolean projectScheme) {
        if (name == null) {
            ColorAndFontOptions.$$$reportNull$$$0(7);
        }
        assert (!projectScheme);
        return this.mySchemes.get(name) != null || this.mySchemes.get("_@user_" + name) != null;
    }

    @Override
    public boolean differsFromDefault(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(8);
        }
        if (scheme2.getName().startsWith("_@user_")) {
            String displayName = SchemeManager.getDisplayName((Scheme)scheme2);
            EditorColorsScheme defaultScheme = DefaultColorSchemesManager.getInstance().getScheme(displayName);
            if (defaultScheme == null) {
                defaultScheme = EditorColorsManager.getInstance().getScheme(displayName);
            }
            if (defaultScheme != null && scheme2 instanceof AbstractColorsScheme) {
                return !((AbstractColorsScheme)scheme2).settingsEqual(defaultScheme, colorKey -> !colorKey.getExternalName().startsWith("FILESTATUS_"));
            }
        }
        return false;
    }

    public static boolean isReadOnly(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(9);
        }
        return ((MyColorScheme)scheme2).isReadOnly();
    }

    public static boolean canBeDeleted(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(10);
        }
        return scheme2 instanceof MyColorScheme && ((MyColorScheme)scheme2).canBeDeleted();
    }

    @NotNull
    public Collection<EditorColorsScheme> getOrderedSchemes() {
        ArrayList<EditorColorsScheme> schemes = new ArrayList<EditorColorsScheme>(this.mySchemes.values());
        Collections.sort(schemes, EditorColorSchemesComparator.INSTANCE);
        ArrayList<EditorColorsScheme> arrayList = schemes;
        if (arrayList == null) {
            ColorAndFontOptions.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public Collection<EditorColorsScheme> getSchemes() {
        ArrayList<EditorColorsScheme> arrayList = new ArrayList<EditorColorsScheme>(this.mySchemes.values());
        if (arrayList == null) {
            ColorAndFontOptions.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public boolean saveSchemeAs(@NotNull EditorColorsScheme editorScheme, @NotNull String name) {
        if (editorScheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(13);
        }
        if (name == null) {
            ColorAndFontOptions.$$$reportNull$$$0(14);
        }
        if (editorScheme instanceof MyColorScheme) {
            MyColorScheme scheme2 = (MyColorScheme)editorScheme;
            EditorColorsScheme clone = (EditorColorsScheme)scheme2.getParentScheme().clone();
            scheme2.apply(clone);
            if (clone instanceof AbstractColorsScheme) {
                ((AbstractColorsScheme)clone).setSaveNeeded(true);
            }
            clone.setName(name);
            MyColorScheme newScheme = new MyColorScheme(clone);
            ColorAndFontOptions.initScheme(newScheme);
            newScheme.setIsNew();
            this.mySchemes.put(name, newScheme);
            this.selectScheme(newScheme.getName());
            this.resetSchemesCombo(null);
            return true;
        }
        return false;
    }

    public void addImportedScheme(@NotNull EditorColorsScheme imported) {
        if (imported == null) {
            ColorAndFontOptions.$$$reportNull$$$0(15);
        }
        if (imported instanceof AbstractColorsScheme) {
            ((AbstractColorsScheme)imported).setSaveNeeded(true);
        }
        MyColorScheme newScheme = new MyColorScheme(imported);
        ColorAndFontOptions.initScheme(newScheme);
        this.mySchemes.put(imported.getName(), newScheme);
        this.selectScheme(newScheme.getName());
        this.resetSchemesCombo(null);
    }

    @Override
    public void removeScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(16);
        }
        String schemeName = scheme2.getName();
        if (this.mySelectedScheme.getName().equals(schemeName)) {
            this.selectDefaultScheme();
        }
        boolean deletedNewlyCreated = false;
        MyColorScheme toDelete = this.mySchemes.get(schemeName);
        if (toDelete != null) {
            deletedNewlyCreated = toDelete.isNew();
        }
        this.mySchemes.remove(schemeName);
        this.resetSchemesCombo(null);
        this.mySomeSchemesDeleted = this.mySomeSchemesDeleted || !deletedNewlyCreated;
    }

    private void selectDefaultScheme() {
        DefaultColorsScheme defaultScheme = (DefaultColorsScheme)EditorColorsManager.getInstance().getScheme("Default");
        this.selectScheme(defaultScheme.getEditableCopyName());
    }

    void resetSchemeToOriginal(@NotNull String name) {
        if (name == null) {
            ColorAndFontOptions.$$$reportNull$$$0(17);
        }
        MyColorScheme schemeToReset = this.mySchemes.get(name);
        schemeToReset.resetToOriginal();
        this.resetImpl();
        this.selectScheme(name);
        this.resetSchemesCombo(null);
        ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        if (this.myApplyCompleted) {
            return;
        }
        try {
            EditorColorsManager myColorsManager = EditorColorsManager.getInstance();
            SchemeManager<EditorColorsScheme> schemeManager2 = ((EditorColorsManagerImpl)myColorsManager).getSchemeManager();
            ArrayList<EditorColorsScheme> result2 = new ArrayList<EditorColorsScheme>(this.mySchemes.values().size());
            boolean activeSchemeModified = false;
            EditorColorsScheme activeOriginalScheme = this.mySelectedScheme.getParentScheme();
            for (MyColorScheme scheme2 : this.mySchemes.values()) {
                boolean isModified = scheme2.apply();
                if (isModified && !activeSchemeModified && activeOriginalScheme == scheme2.getParentScheme()) {
                    activeSchemeModified = true;
                }
                result2.add(scheme2.getParentScheme());
            }
            boolean refreshEditors = activeSchemeModified && schemeManager2.getCurrentScheme() == activeOriginalScheme;
            schemeManager2.setSchemes(ColorAndFontOptions.includingInvisible(result2, schemeManager2), activeOriginalScheme);
            if (refreshEditors) {
                ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
            }
            boolean isEditorThemeDark = ColorUtil.isDark((Color)activeOriginalScheme.getDefaultBackground());
            QuickChangeColorSchemeAction.changeLafIfNecessary(isEditorThemeDark);
            this.reset();
        }
        finally {
            this.myApplyCompleted = true;
        }
    }

    private static List<EditorColorsScheme> includingInvisible(@NotNull List<EditorColorsScheme> schemeList, @NotNull SchemeManager<EditorColorsScheme> schemeManager2) {
        if (schemeList == null) {
            ColorAndFontOptions.$$$reportNull$$$0(18);
        }
        if (schemeManager2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(19);
        }
        for (EditorColorsScheme scheme2 : schemeManager2.getAllSchemes()) {
            if (AbstractColorsScheme.isVisible(scheme2)) continue;
            schemeList.add(scheme2);
        }
        return schemeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSchemesCombo(Object source) {
        this.myIsReset = true;
        try {
            this.myRootSchemesPanel.resetSchemesCombo(source);
            if (this.mySubPanelFactories != null) {
                for (NewColorAndFontPanel subPartialConfigurable : this.getPanels()) {
                    subPartialConfigurable.reset(source);
                }
            }
        }
        finally {
            this.myIsReset = false;
        }
    }

    public JComponent createComponent() {
        if (this.myRootSchemesPanel == null) {
            this.ensureSchemesPanel();
        }
        return this.myRootSchemesPanel;
    }

    public boolean hasOwnContent() {
        return true;
    }

    @NotNull
    public Configurable[] buildConfigurables() {
        this.myDisposeCompleted = false;
        this.initAll();
        List<ColorAndFontPanelFactory> panelFactories = this.createPanelFactories();
        this.mySubPanelFactories = new LinkedHashMap<ColorAndFontPanelFactory, InnerSearchableConfigurable>(panelFactories.size());
        for (ColorAndFontPanelFactory panelFactory : panelFactories) {
            this.mySubPanelFactories.put(panelFactory, new InnerSearchableConfigurable(panelFactory));
        }
        Configurable[] configurableArray = this.mySubPanelFactories.values().toArray(new Configurable[0]);
        if (configurableArray == null) {
            ColorAndFontOptions.$$$reportNull$$$0(20);
        }
        return configurableArray;
    }

    @NotNull
    private Set<NewColorAndFontPanel> getPanels() {
        HashSet<NewColorAndFontPanel> result2 = new HashSet<NewColorAndFontPanel>();
        for (InnerSearchableConfigurable configurable : this.mySubPanelFactories.values()) {
            NewColorAndFontPanel panel2 = configurable.getSubPanelIfInitialized();
            if (panel2 == null) continue;
            result2.add(panel2);
        }
        HashSet<NewColorAndFontPanel> hashSet = result2;
        if (hashSet == null) {
            ColorAndFontOptions.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    protected List<ColorAndFontPanelFactory> createPanelFactories() {
        ColorSettingsPage[] pages;
        ArrayList<ColorAndFontPanelFactoryEx> extensions = new ArrayList<ColorAndFontPanelFactoryEx>();
        extensions.add(new FontConfigurableFactory());
        extensions.add(new ConsoleFontConfigurableFactory());
        for (final ColorSettingsPage page : pages = ColorSettingsPages.getInstance().getRegisteredPages()) {
            extensions.add(new ColorAndFontPanelFactoryEx(){

                @Override
                @NotNull
                public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
                    if (options == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    SimpleEditorPreview preview = new SimpleEditorPreview(options, page);
                    NewColorAndFontPanel newColorAndFontPanel = NewColorAndFontPanel.create(preview, page.getDisplayName(), options, null, page);
                    if (newColorAndFontPanel == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return newColorAndFontPanel;
                }

                @Override
                @NotNull
                public String getPanelDisplayName() {
                    String string = page.getDisplayName();
                    if (string == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                public DisplayPriority getPriority() {
                    if (page instanceof DisplayPrioritySortable) {
                        return ((DisplayPrioritySortable)page).getPriority();
                    }
                    return DisplayPriority.LANGUAGE_SETTINGS;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "options";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createPanel";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPanelDisplayName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createPanel";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
        Collections.addAll(extensions, Extensions.getExtensions(ColorAndFontPanelFactory.EP_NAME));
        Collections.sort(extensions, (f1, f2) -> {
            if (f1 instanceof DisplayPrioritySortable) {
                if (!(f2 instanceof DisplayPrioritySortable)) return 1;
                int result1 = ((DisplayPrioritySortable)f1).getPriority().compareTo((Enum)((DisplayPrioritySortable)f2).getPriority());
                if (result1 == 0) return f1.getPanelDisplayName().compareToIgnoreCase(f2.getPanelDisplayName());
                return result1;
            }
            if (!(f2 instanceof DisplayPrioritySortable)) return f1.getPanelDisplayName().compareToIgnoreCase(f2.getPanelDisplayName());
            return -1;
        });
        ArrayList<ColorAndFontPanelFactory> result2 = new ArrayList<ColorAndFontPanelFactory>(extensions);
        result2.add(new ScopeColorsPageFactory());
        return result2;
    }

    private void initAll() {
        this.mySchemes = new THashMap();
        for (EditorColorsScheme allScheme : EditorColorsManager.getInstance().getAllSchemes()) {
            MyColorScheme schemeDelegate = new MyColorScheme(allScheme);
            ColorAndFontOptions.initScheme(schemeDelegate);
            this.mySchemes.put(schemeDelegate.getName(), schemeDelegate);
        }
        this.mySelectedScheme = this.mySchemes.get(EditorColorsManager.getInstance().getGlobalScheme().getName());
        assert (this.mySelectedScheme != null) : EditorColorsManager.getInstance().getGlobalScheme().getName() + "; myschemes=" + this.mySchemes;
    }

    private static void initScheme(@NotNull MyColorScheme scheme2) {
        if (scheme2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(22);
        }
        ArrayList<EditorSchemeAttributeDescriptor> descriptions = new ArrayList<EditorSchemeAttributeDescriptor>();
        ColorAndFontOptions.initPluggedDescriptions(descriptions, scheme2);
        ColorAndFontOptions.initScopesDescriptors(descriptions, scheme2);
        scheme2.setDescriptors(descriptions.toArray(new EditorSchemeAttributeDescriptor[0]));
    }

    private static void initPluggedDescriptions(@NotNull List<EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme2) {
        ColorSettingsPage[] pages;
        if (descriptions == null) {
            ColorAndFontOptions.$$$reportNull$$$0(23);
        }
        if (scheme2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(24);
        }
        for (ColorSettingsPage colorSettingsPage : pages = ColorSettingsPages.getInstance().getRegisteredPages()) {
            ColorAndFontOptions.initDescriptions((ColorAndFontDescriptorsProvider)colorSettingsPage, descriptions, scheme2);
        }
        for (ColorSettingsPage colorSettingsPage : (ColorAndFontDescriptorsProvider[])Extensions.getExtensions((ExtensionPointName)ColorAndFontDescriptorsProvider.EP_NAME)) {
            ColorAndFontOptions.initDescriptions((ColorAndFontDescriptorsProvider)colorSettingsPage, descriptions, scheme2);
        }
    }

    private static void initDescriptions(@NotNull ColorAndFontDescriptorsProvider provider, @NotNull List<EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme2) {
        if (provider == null) {
            ColorAndFontOptions.$$$reportNull$$$0(25);
        }
        if (descriptions == null) {
            ColorAndFontOptions.$$$reportNull$$$0(26);
        }
        if (scheme2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(27);
        }
        String className = provider.getClass().getName();
        String group = provider.getDisplayName();
        List<AttributesDescriptor> attributeDescriptors = ColorSettingsUtil.getAllAttributeDescriptors(provider);
        if (provider instanceof RainbowColorSettingsPage) {
            RainbowAttributeDescriptor d = new RainbowAttributeDescriptor(((RainbowColorSettingsPage)provider).getLanguage(), group, ApplicationBundle.message((String)"rainbow.option.panel.display.name", (Object[])new Object[0]), scheme2, scheme2.myRainbowState);
            descriptions.add((EditorSchemeAttributeDescriptor)d);
        }
        for (AttributesDescriptor descriptor : attributeDescriptors) {
            if (descriptor == null) {
                LOG.warn("Null attribute descriptor in " + className);
                continue;
            }
            SchemeTextAttributesDescription d = new SchemeTextAttributesDescription(descriptor.getDisplayName(), group, descriptor.getKey(), scheme2, null, null);
            descriptions.add((EditorSchemeAttributeDescriptor)d);
        }
        for (ColorDescriptor descriptor : provider.getColorDescriptors()) {
            if (descriptor == null) {
                LOG.warn("Null color descriptor in " + className);
                continue;
            }
            EditorSettingColorDescription d = new EditorSettingColorDescription(descriptor.getDisplayName(), group, descriptor.getKey(), descriptor.getKind(), scheme2);
            descriptions.add((EditorSchemeAttributeDescriptor)d);
        }
    }

    private static void initScopesDescriptors(@NotNull List<EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme2) {
        Project[] projects;
        if (descriptions == null) {
            ColorAndFontOptions.$$$reportNull$$$0(28);
        }
        if (scheme2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(29);
        }
        THashSet namedScopes = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<Pair<NamedScope, NamedScopesHolder>>(){

            public int computeHashCode(@NotNull Pair<NamedScope, NamedScopesHolder> object) {
                if (object == null) {
                    2.$$$reportNull$$$0(0);
                }
                return ((NamedScope)object.getFirst()).getName().hashCode();
            }

            public boolean equals(@NotNull Pair<NamedScope, NamedScopesHolder> o1, @NotNull Pair<NamedScope, NamedScopesHolder> o2) {
                if (o1 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (o2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return ((NamedScope)o1.getFirst()).getName().equals(((NamedScope)o2.getFirst()).getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o2";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computeHashCode";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "equals";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            DependencyValidationManagerImpl validationManager = (DependencyValidationManagerImpl)DependencyValidationManager.getInstance((Project)project);
            List<Pair<NamedScope, NamedScopesHolder>> cachedScopes = validationManager.getScopeBasedHighlightingCachedScopes();
            namedScopes.addAll(cachedScopes);
        }
        ArrayList list2 = new ArrayList(namedScopes);
        Collections.sort(list2, (o1, o2) -> ((NamedScope)o1.getFirst()).getName().compareToIgnoreCase(((NamedScope)o2.getFirst()).getName()));
        for (Pair pair : list2) {
            NamedScope namedScope = (NamedScope)pair.getFirst();
            String name = namedScope.getName();
            TextAttributesKey textAttributesKey = ScopeAttributesUtil.getScopeTextAttributeKey(name);
            if (scheme2.getAttributes(textAttributesKey) == null) {
                scheme2.setAttributes(textAttributesKey, new TextAttributes());
            }
            NamedScopesHolder holder = (NamedScopesHolder)pair.getSecond();
            PackageSet value = namedScope.getValue();
            String toolTip = holder.getDisplayName() + (value == null ? "" : ": " + value.getText());
            descriptions.add((EditorSchemeAttributeDescriptor)new SchemeTextAttributesDescription(name, SCOPES_GROUP, textAttributesKey, scheme2, holder.getIcon(), toolTip));
        }
    }

    private void revertChanges() {
        if (this.isSchemeListModified() || this.isSomeSchemeModified()) {
            this.myRevertChangesCompleted = false;
        }
        if (!this.myRevertChangesCompleted) {
            this.ensureSchemesPanel();
            try {
                this.resetImpl();
            }
            finally {
                this.myRevertChangesCompleted = true;
            }
        }
    }

    private void resetImpl() {
        this.mySomeSchemesDeleted = false;
        this.initAll();
        this.resetSchemesCombo(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void reset() {
        if (!this.myInitResetInvoked) {
            try {
                if (this.myInitResetCompleted) return;
                this.ensureSchemesPanel();
                try {
                    this.resetImpl();
                    return;
                }
                finally {
                    this.myInitResetCompleted = true;
                }
            }
            finally {
                this.myInitResetInvoked = true;
            }
        } else {
            this.revertChanges();
        }
    }

    public synchronized void resetFromChild() {
        if (!this.myInitResetCompleted) {
            this.ensureSchemesPanel();
            try {
                this.resetImpl();
            }
            finally {
                this.myInitResetCompleted = true;
            }
        }
    }

    private void ensureSchemesPanel() {
        if (this.myRootSchemesPanel == null) {
            this.myRootSchemesPanel = new SchemesPanel(this);
            this.myRootSchemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

                @Override
                public void schemeChanged(Object source) {
                    if (!ColorAndFontOptions.this.myIsReset) {
                        ColorAndFontOptions.this.resetSchemesCombo(source);
                    }
                }
            });
        }
    }

    public void disposeUIResources() {
        block6: {
            try {
                if (this.myDisposeCompleted) break block6;
                try {
                    super.disposeUIResources();
                    Disposer.dispose((Disposable)this.myDisposable);
                }
                finally {
                    this.myDisposeCompleted = true;
                }
            }
            finally {
                this.mySubPanelFactories = null;
                this.myInitResetCompleted = false;
                this.myInitResetInvoked = false;
                this.myRevertChangesCompleted = false;
                this.myApplyCompleted = false;
                this.myRootSchemesPanel = null;
            }
        }
    }

    @NotNull
    public String getHelpTopic() {
        if (ID == null) {
            ColorAndFontOptions.$$$reportNull$$$0(30);
        }
        return ID;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            ColorAndFontOptions.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Nullable
    public SearchableConfigurable findSubConfigurable(@NotNull Class pageClass) {
        if (pageClass == null) {
            ColorAndFontOptions.$$$reportNull$$$0(32);
        }
        if (this.mySubPanelFactories == null) {
            this.getConfigurables();
        }
        for (Map.Entry<ColorAndFontPanelFactory, InnerSearchableConfigurable> entry : this.mySubPanelFactories.entrySet()) {
            if (!pageClass.isInstance(entry.getValue().createPanel().getSettingsPage())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public SearchableConfigurable findSubConfigurable(String pageName) {
        if (this.mySubPanelFactories == null) {
            this.getConfigurables();
        }
        for (InnerSearchableConfigurable configurable : this.mySubPanelFactories.values()) {
            if (!configurable.getDisplayName().equals(pageName)) continue;
            return configurable;
        }
        return null;
    }

    @Nullable
    public NewColorAndFontPanel findPage(String pageName) {
        InnerSearchableConfigurable child = (InnerSearchableConfigurable)this.findSubConfigurable(pageName);
        return child == null ? null : child.createPanel();
    }

    public static boolean selectOrEditColor(@NotNull DataContext context, @Nullable String search2, @NotNull String name) {
        if (context == null) {
            ColorAndFontOptions.$$$reportNull$$$0(33);
        }
        if (name == null) {
            ColorAndFontOptions.$$$reportNull$$$0(34);
        }
        return ColorAndFontOptions.selectOrEdit(context, search2, options -> {
            if (name == null) {
                ColorAndFontOptions.$$$reportNull$$$0(38);
            }
            return options.findSubConfigurable(name);
        });
    }

    public static boolean selectOrEditColor(@NotNull DataContext context, @Nullable String search2, @NotNull Class<?> type) {
        if (context == null) {
            ColorAndFontOptions.$$$reportNull$$$0(35);
        }
        if (type == null) {
            ColorAndFontOptions.$$$reportNull$$$0(36);
        }
        return ColorAndFontOptions.selectOrEdit(context, search2, options -> {
            if (type == null) {
                ColorAndFontOptions.$$$reportNull$$$0(37);
            }
            return options.findSubConfigurable(type);
        });
    }

    private static boolean selectOrEdit(DataContext context, String search2, Function<ColorAndFontOptions, SearchableConfigurable> function) {
        return ColorAndFontOptions.select(context, search2, function) || ColorAndFontOptions.edit(context, search2, function);
    }

    private static boolean select(DataContext context, String search2, Function<ColorAndFontOptions, SearchableConfigurable> function) {
        Settings settings = (Settings)Settings.KEY.getData(context);
        if (settings == null) {
            return false;
        }
        ColorAndFontOptions options = settings.find(ColorAndFontOptions.class);
        if (options == null) {
            return false;
        }
        SearchableConfigurable page = function.apply(options);
        if (page == null) {
            return false;
        }
        settings.select((Configurable)page, search2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean edit(DataContext context, String search2, Function<ColorAndFontOptions, SearchableConfigurable> function) {
        ColorAndFontOptions options = new ColorAndFontOptions();
        SearchableConfigurable page = function.apply(options);
        Configurable[] configurables = options.getConfigurables();
        try {
            if (page != null) {
                Runnable runnable2 = search2 == null ? null : page.enableSearch(search2);
                Window window = UIUtil.getWindow((Component)((Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context)));
                if (window != null) {
                    ShowSettingsUtil.getInstance().editConfigurable((Component)window, (Configurable)page, runnable2);
                } else {
                    ShowSettingsUtil.getInstance().editConfigurable((Project)CommonDataKeys.PROJECT.getData(context), (Configurable)page, runnable2);
                }
            }
        }
        finally {
            for (Configurable configurable : configurables) {
                configurable.disposeUIResources();
            }
            options.disposeUIResources();
        }
        return page != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: 
            case 7: 
            case 14: 
            case 17: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 22: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorScheme";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imported";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeList";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeManager";
                break;
            }
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageClass";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderedSchemes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "buildConfigurables";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanels";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectScheme";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canDuplicateScheme";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canResetScheme";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteScheme";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isProjectScheme";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canRenameScheme";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsScheme";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "differsFromDefault";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReadOnly";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canBeDeleted";
                break;
            }
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 30: 
            case 31: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveSchemeAs";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addImportedScheme";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeScheme";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resetSchemeToOriginal";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "includingInvisible";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "initScheme";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "initPluggedDescriptions";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "initDescriptions";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "initScopesDescriptors";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findSubConfigurable";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "selectOrEditColor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$selectOrEditColor$4";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$selectOrEditColor$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class InnerSearchableConfigurable
    implements SearchableConfigurable,
    OptionsContainingConfigurable,
    Configurable.NoScroll {
        private NewColorAndFontPanel mySubPanel;
        private boolean mySubInitInvoked;
        @NotNull
        private final ColorAndFontPanelFactory myFactory;

        private InnerSearchableConfigurable(ColorAndFontPanelFactory factory) {
            if (factory == null) {
                InnerSearchableConfigurable.$$$reportNull$$$0(0);
            }
            this.mySubInitInvoked = false;
            this.myFactory = factory;
        }

        @NotNull
        @Nls
        public String getDisplayName() {
            String string = this.myFactory.getPanelDisplayName();
            if (string == null) {
                InnerSearchableConfigurable.$$$reportNull$$$0(1);
            }
            return string;
        }

        public NewColorAndFontPanel getSubPanelIfInitialized() {
            return this.mySubPanel;
        }

        private NewColorAndFontPanel createPanel() {
            if (this.mySubPanel == null) {
                this.mySubPanel = this.myFactory.createPanel(ColorAndFontOptions.this);
                this.mySubPanel.reset(this);
                this.mySubPanel.addSchemesListener(new ColorAndFontSettingsListener.Abstract(){

                    @Override
                    public void schemeChanged(Object source) {
                        if (!ColorAndFontOptions.this.myIsReset) {
                            ColorAndFontOptions.this.resetSchemesCombo(source);
                        }
                    }
                });
                this.mySubPanel.addDescriptionListener(new ColorAndFontSettingsListener.Abstract(){

                    @Override
                    public void fontChanged() {
                        for (NewColorAndFontPanel panel2 : ColorAndFontOptions.this.getPanels()) {
                            panel2.updatePreview();
                            panel2.updateSchemesPanel();
                        }
                    }
                });
            }
            return this.mySubPanel;
        }

        public String getHelpTopic() {
            return null;
        }

        public JComponent createComponent() {
            return this.createPanel().getPanel();
        }

        public boolean isModified() {
            this.createPanel();
            for (MyColorScheme scheme2 : ColorAndFontOptions.this.mySchemes.values()) {
                if (this.mySubPanel.containsFontOptions()) {
                    if (!scheme2.isFontModified() && !scheme2.isConsoleFontModified()) continue;
                    ColorAndFontOptions.this.myRevertChangesCompleted = false;
                    return true;
                }
                for (EditorSchemeAttributeDescriptor descriptor : scheme2.getDescriptors()) {
                    if (!this.mySubPanel.contains(descriptor) || !descriptor.isModified()) continue;
                    ColorAndFontOptions.this.myRevertChangesCompleted = false;
                    return true;
                }
            }
            return false;
        }

        public void apply() throws ConfigurationException {
            ColorAndFontOptions.this.apply();
        }

        public void reset() {
            if (!this.mySubInitInvoked) {
                if (!ColorAndFontOptions.this.myInitResetCompleted) {
                    ColorAndFontOptions.this.resetFromChild();
                }
                this.mySubInitInvoked = true;
            } else {
                ColorAndFontOptions.this.revertChanges();
            }
        }

        public void disposeUIResources() {
            if (this.mySubPanel != null) {
                this.mySubPanel.disposeUIResources();
                this.mySubPanel = null;
            }
        }

        @NotNull
        public String getId() {
            String string = ColorAndFontOptions.this.getId() + "." + this.getDisplayName();
            if (string == null) {
                InnerSearchableConfigurable.$$$reportNull$$$0(2);
            }
            return string;
        }

        public Runnable enableSearch(String option) {
            return this.createPanel().showOption(option);
        }

        @Override
        @NotNull
        public Set<String> processListOptions() {
            Set<String> set2 = this.createPanel().processListOptions();
            if (set2 == null) {
                InnerSearchableConfigurable.$$$reportNull$$$0(3);
            }
            return set2;
        }

        @NotNull
        @NonNls
        public String toString() {
            String string = "Color And Fonts for " + this.getDisplayName();
            if (string == null) {
                InnerSearchableConfigurable.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processListOptions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyColorScheme
    extends EditorColorsSchemeImpl {
        private EditorSchemeAttributeDescriptor[] myDescriptors;
        private String myName;
        private boolean myIsNew;
        private RainbowColorsInSchemeState myRainbowState;
        private static final Predicate<ColorKey> FILE_STATUS_COLORS = input -> input != null && input.getExternalName().startsWith("FILESTATUS_");

        private MyColorScheme(@NotNull EditorColorsScheme parentScheme) {
            if (parentScheme == null) {
                MyColorScheme.$$$reportNull$$$0(0);
            }
            super(parentScheme);
            this.myIsNew = false;
            if (parentScheme.isUseEditorFontPreferencesInConsole()) {
                this.setUseEditorFontPreferencesInConsole();
            } else {
                this.setConsoleFontPreferences(parentScheme.getConsoleFontPreferences());
            }
            if (parentScheme.isUseAppFontPreferencesInEditor()) {
                this.setUseAppFontPreferencesInEditor();
            } else {
                this.setFontPreferences(parentScheme.getFontPreferences());
            }
            this.setQuickDocFontSize(parentScheme.getQuickDocFontSize());
            this.myName = parentScheme.getName();
            RainbowHighlighter.transferRainbowState((SchemeMetaInfo)this, (SchemeMetaInfo)parentScheme);
            this.myRainbowState = new RainbowColorsInSchemeState(this, parentScheme);
            this.initFonts();
        }

        @Override
        @Nullable
        public AbstractColorsScheme getOriginal() {
            return this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getOriginal() : null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                MyColorScheme.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                MyColorScheme.$$$reportNull$$$0(2);
            }
            this.myName = name;
        }

        public void setDescriptors(EditorSchemeAttributeDescriptor[] descriptors) {
            this.myDescriptors = descriptors;
        }

        public EditorSchemeAttributeDescriptor[] getDescriptors() {
            return this.myDescriptors;
        }

        @Override
        public boolean isReadOnly() {
            return this.myParentScheme instanceof ReadOnlyColorsScheme;
        }

        public boolean isModified() {
            if (this.isFontModified() || this.isConsoleFontModified()) {
                return true;
            }
            for (EditorSchemeAttributeDescriptor descriptor : this.myDescriptors) {
                if (!descriptor.isModified()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean canBeDeleted() {
            return this.myParentScheme instanceof AbstractColorsScheme && ((AbstractColorsScheme)this.myParentScheme).canBeDeleted();
        }

        private boolean isFontModified() {
            return !MyColorScheme.areDelegatingOrEqual(this.getFontPreferences(), this.myParentScheme.getFontPreferences());
        }

        private boolean isConsoleFontModified() {
            return !MyColorScheme.areDelegatingOrEqual(this.getConsoleFontPreferences(), this.myParentScheme.getConsoleFontPreferences());
        }

        private boolean apply() {
            if (!(this.myParentScheme instanceof ReadOnlyColorsScheme)) {
                return this.apply(this.myParentScheme);
            }
            return false;
        }

        private boolean apply(@NotNull EditorColorsScheme scheme2) {
            boolean isModified;
            if (scheme2 == null) {
                MyColorScheme.$$$reportNull$$$0(3);
            }
            boolean bl = isModified = this.isFontModified() || this.isConsoleFontModified();
            if (this.isUseAppFontPreferencesInEditor()) {
                scheme2.setUseAppFontPreferencesInEditor();
            } else {
                scheme2.setFontPreferences(this.getFontPreferences());
            }
            if (this.isUseEditorFontPreferencesInConsole()) {
                scheme2.setUseEditorFontPreferencesInConsole();
            } else {
                scheme2.setConsoleFontPreferences(this.getConsoleFontPreferences());
            }
            for (EditorSchemeAttributeDescriptor descriptor : this.myDescriptors) {
                if (!descriptor.isModified()) continue;
                isModified = true;
                descriptor.apply(scheme2);
            }
            if (isModified && scheme2 instanceof AbstractColorsScheme) {
                ((AbstractColorsScheme)scheme2).setSaveNeeded(true);
            }
            return isModified;
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }

        public void setIsNew() {
            this.myIsNew = true;
        }

        public boolean isNew() {
            return this.myIsNew;
        }

        @Override
        @NotNull
        public String toString() {
            String string = "temporary scheme for " + this.myName;
            if (string == null) {
                MyColorScheme.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean isInherited(@NotNull TextAttributesKey key) {
            TextAttributesKey fallbackKey;
            if (key == null) {
                MyColorScheme.$$$reportNull$$$0(5);
            }
            if ((fallbackKey = key.getFallbackAttributeKey()) != null) {
                TextAttributes ownAttrs;
                if (this.myParentScheme instanceof AbstractColorsScheme && (ownAttrs = ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key)) != null) {
                    return ownAttrs == AbstractColorsScheme.INHERITED_ATTRS_MARKER;
                }
                TextAttributes attributes = this.getAttributes(key);
                if (attributes != null) {
                    TextAttributes fallbackAttributes = this.getAttributes(fallbackKey);
                    return attributes == fallbackAttributes;
                }
            }
            return false;
        }

        public boolean isInherited(ColorKey key) {
            ColorKey fallbackKey = key.getFallbackColorKey();
            if (fallbackKey != null) {
                Color ownAttrs;
                if (this.myParentScheme instanceof AbstractColorsScheme && (ownAttrs = ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedColor(key)) != null) {
                    return ownAttrs == AbstractColorsScheme.INHERITED_COLOR_MARKER;
                }
                Color attributes = this.getColor(key);
                if (attributes != null) {
                    Color fallback = this.getColor(fallbackKey);
                    return attributes == fallback;
                }
            }
            return false;
        }

        public void resetToOriginal() {
            AbstractColorsScheme originalScheme;
            if (this.myParentScheme instanceof AbstractColorsScheme && (originalScheme = ((AbstractColorsScheme)this.myParentScheme).getOriginal()) != null) {
                MyColorScheme.copyPreservingFileStatusColors(originalScheme, (AbstractColorsScheme)this.myParentScheme);
            }
        }

        private static void copyPreservingFileStatusColors(@NotNull AbstractColorsScheme source, @NotNull AbstractColorsScheme target2) {
            if (source == null) {
                MyColorScheme.$$$reportNull$$$0(6);
            }
            if (target2 == null) {
                MyColorScheme.$$$reportNull$$$0(7);
            }
            Map fileStatusColors = target2.getColorKeys().stream().filter(FILE_STATUS_COLORS).collect(Collectors.toMap(Function.identity(), target2::getDirectlyDefinedColor));
            source.copyTo(target2);
            for (ColorKey key : fileStatusColors.keySet()) {
                target2.setColor(key, fileStatusColors.get(key));
            }
            target2.setSaveNeeded(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentScheme";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$MyColorScheme";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$MyColorScheme";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isInherited";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "copyPreservingFileStatusColors";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EditorSettingColorDescription
    extends ColorAndFontDescription {
        private final ColorKey myColorKey;
        private final ColorDescriptor.Kind myKind;
        private final Color myInitialColor;
        private Color myColor;
        private TextAttributes myFallbackAttributes;
        private Pair<ColorAndFontDescriptorsProvider, ColorDescriptor> myBaseAttributeDescriptor;
        private boolean myIsInheritedInitial;

        EditorSettingColorDescription(String name, String group, @NotNull ColorKey colorKey, @NotNull ColorDescriptor.Kind kind, @NotNull MyColorScheme scheme2) {
            if (colorKey == null) {
                EditorSettingColorDescription.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                EditorSettingColorDescription.$$$reportNull$$$0(1);
            }
            if (scheme2 == null) {
                EditorSettingColorDescription.$$$reportNull$$$0(2);
            }
            super(name, group, colorKey.getExternalName(), scheme2, null, null);
            this.myColorKey = colorKey;
            this.myKind = kind;
            ColorKey fallbackKey = this.myColorKey.getFallbackColorKey();
            Color fallbackColor = null;
            if (fallbackKey != null) {
                fallbackColor = scheme2.getColor(fallbackKey);
                this.myBaseAttributeDescriptor = ColorSettingsPages.getInstance().getColorDescriptor(fallbackKey);
                if (this.myBaseAttributeDescriptor == null) {
                    this.myBaseAttributeDescriptor = Pair.create(null, (Object)new ColorDescriptor(fallbackKey.getExternalName(), fallbackKey, this.myKind));
                }
                this.myFallbackAttributes = new TextAttributes(this.myKind == ColorDescriptor.Kind.FOREGROUND ? fallbackColor : null, this.myKind == ColorDescriptor.Kind.BACKGROUND ? fallbackColor : null, null, null, 0);
            }
            this.myColor = scheme2.getColor(this.myColorKey);
            this.myInitialColor = (Color)ObjectUtils.chooseNotNull((Object)fallbackColor, (Object)this.myColor);
            this.myIsInheritedInitial = scheme2.isInherited(this.myColorKey);
            this.setInherited(this.myIsInheritedInitial);
            if (this.myIsInheritedInitial) {
                // empty if block
            }
            this.initCheckedStatus();
        }

        @Override
        public int getFontType() {
            return 0;
        }

        @Override
        public void setFontType(int type) {
        }

        @Override
        public Color getExternalEffectColor() {
            return null;
        }

        @Override
        public void setExternalEffectColor(Color color) {
        }

        @Override
        public void setExternalEffectType(EffectType type) {
        }

        @Override
        @NotNull
        public EffectType getExternalEffectType() {
            EffectType effectType = EffectType.LINE_UNDERSCORE;
            if (effectType == null) {
                EditorSettingColorDescription.$$$reportNull$$$0(3);
            }
            return effectType;
        }

        @Override
        public Color getExternalForeground() {
            return this.myKind == ColorDescriptor.Kind.FOREGROUND ? this.myColor : null;
        }

        @Override
        public void setExternalForeground(Color col) {
            if (this.myKind != ColorDescriptor.Kind.FOREGROUND) {
                return;
            }
            if (this.myColor != null && this.myColor.equals(col)) {
                return;
            }
            this.myColor = col;
        }

        @Override
        public Color getExternalBackground() {
            return this.myKind == ColorDescriptor.Kind.BACKGROUND ? this.myColor : null;
        }

        @Override
        public void setExternalBackground(Color col) {
            if (this.myKind != ColorDescriptor.Kind.BACKGROUND) {
                return;
            }
            if (this.myColor != null && this.myColor.equals(col)) {
                return;
            }
            this.myColor = col;
        }

        @Override
        public Color getExternalErrorStripe() {
            return null;
        }

        @Override
        public void setExternalErrorStripe(Color col) {
        }

        @Override
        public boolean isFontEnabled() {
            return false;
        }

        @Override
        public boolean isForegroundEnabled() {
            return this.myKind == ColorDescriptor.Kind.FOREGROUND;
        }

        @Override
        public boolean isBackgroundEnabled() {
            return this.myKind == ColorDescriptor.Kind.BACKGROUND;
        }

        @Override
        public boolean isEffectsColorEnabled() {
            return false;
        }

        @Override
        public boolean isModified() {
            if (this.isInherited()) {
                return !this.myIsInheritedInitial;
            }
            return !Comparing.equal((Object)this.myInitialColor, (Object)this.myColor) || this.myIsInheritedInitial;
        }

        @Override
        @Nullable
        public TextAttributes getBaseAttributes() {
            return this.myFallbackAttributes;
        }

        public void apply(EditorColorsScheme scheme2) {
            boolean skip;
            if (scheme2 == null) {
                scheme2 = this.getScheme();
            }
            boolean bl = skip = scheme2 instanceof EditorColorsSchemeImpl && this.isInherited() && this.myIsInheritedInitial;
            if (!skip) {
                scheme2.setColor(this.myColorKey, this.isInherited() ? AbstractColorsScheme.INHERITED_COLOR_MARKER : this.myColor);
            }
        }

        @Override
        @Nullable
        public Pair<ColorAndFontDescriptorsProvider, ? extends AbstractKeyDescriptor> getFallbackKeyDescriptor() {
            return this.myBaseAttributeDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$EditorSettingColorDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$EditorSettingColorDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExternalEffectType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SchemeTextAttributesDescription
    extends TextAttributesDescription {
        @NotNull
        private final TextAttributes myInitialAttributes;
        @NotNull
        private final TextAttributesKey key;
        private TextAttributes myFallbackAttributes;
        private Pair<ColorAndFontDescriptorsProvider, AttributesDescriptor> myBaseAttributeDescriptor;
        private boolean myIsInheritedInitial;

        private SchemeTextAttributesDescription(String name, String group, @NotNull TextAttributesKey key, @NotNull MyColorScheme scheme2, Icon icon, String toolTip) {
            if (key == null) {
                SchemeTextAttributesDescription.$$$reportNull$$$0(0);
            }
            if (scheme2 == null) {
                SchemeTextAttributesDescription.$$$reportNull$$$0(1);
            }
            super(name, group, SchemeTextAttributesDescription.getInitialAttributes(scheme2, key).clone(), key, scheme2, icon, toolTip);
            this.key = key;
            this.myInitialAttributes = SchemeTextAttributesDescription.getInitialAttributes(scheme2, key);
            TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
            if (fallbackKey != null) {
                this.myFallbackAttributes = scheme2.getAttributes(fallbackKey);
                this.myBaseAttributeDescriptor = ColorSettingsPages.getInstance().getAttributeDescriptor(fallbackKey);
                if (this.myBaseAttributeDescriptor == null) {
                    this.myBaseAttributeDescriptor = new Pair(null, (Object)new AttributesDescriptor(fallbackKey.getExternalName(), fallbackKey));
                }
            }
            this.myIsInheritedInitial = scheme2.isInherited(key);
            this.setInherited(this.myIsInheritedInitial);
            if (this.myIsInheritedInitial && this.myFallbackAttributes != null) {
                this.getTextAttributes().copyFrom(this.myFallbackAttributes);
            }
            this.initCheckedStatus();
        }

        @NotNull
        private static TextAttributes getInitialAttributes(@NotNull MyColorScheme scheme2, @NotNull TextAttributesKey key) {
            TextAttributes attributes;
            if (scheme2 == null) {
                SchemeTextAttributesDescription.$$$reportNull$$$0(2);
            }
            if (key == null) {
                SchemeTextAttributesDescription.$$$reportNull$$$0(3);
            }
            TextAttributes textAttributes = (attributes = scheme2.getAttributes(key)) != null ? attributes : new TextAttributes();
            if (textAttributes == null) {
                SchemeTextAttributesDescription.$$$reportNull$$$0(4);
            }
            return textAttributes;
        }

        public void apply(EditorColorsScheme scheme2) {
            boolean skip;
            if (scheme2 == null) {
                scheme2 = this.getScheme();
            }
            boolean bl = skip = scheme2 instanceof EditorColorsSchemeImpl && this.isInherited() && this.myIsInheritedInitial;
            if (!skip) {
                scheme2.setAttributes(this.key, this.isInherited() ? AbstractColorsScheme.INHERITED_ATTRS_MARKER : this.getTextAttributes());
            }
        }

        @Override
        public boolean isModified() {
            if (this.isInherited()) {
                return !this.myIsInheritedInitial;
            }
            return !Comparing.equal((Object)this.myInitialAttributes, (Object)this.getTextAttributes()) || this.myIsInheritedInitial;
        }

        @Override
        public boolean isErrorStripeEnabled() {
            return true;
        }

        @Override
        @Nullable
        public TextAttributes getBaseAttributes() {
            return this.myFallbackAttributes;
        }

        @Override
        @Nullable
        public Pair<ColorAndFontDescriptorsProvider, ? extends AbstractKeyDescriptor> getFallbackKeyDescriptor() {
            return this.myBaseAttributeDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getInitialAttributes";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ConsoleFontConfigurableFactory
    implements ColorAndFontPanelFactoryEx {
        private ConsoleFontConfigurableFactory() {
        }

        @Override
        @NotNull
        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
            if (options == null) {
                ConsoleFontConfigurableFactory.$$$reportNull$$$0(0);
            }
            FontEditorPreview previewPanel = new FontEditorPreview(() -> {
                if (options == null) {
                    ConsoleFontConfigurableFactory.$$$reportNull$$$0(4);
                }
                return options.getSelectedScheme();
            }, false){

                @Override
                protected EditorColorsScheme updateOptionsScheme(EditorColorsScheme selectedScheme) {
                    return ConsoleViewUtil.updateConsoleColorScheme(selectedScheme);
                }
            };
            NewColorAndFontPanel newColorAndFontPanel = new NewColorAndFontPanel(new SchemesPanel(options, 0), new ConsoleFontOptions(options), previewPanel, "Font", null, null){

                @Override
                public boolean containsFontOptions() {
                    return true;
                }
            };
            if (newColorAndFontPanel == null) {
                ConsoleFontConfigurableFactory.$$$reportNull$$$0(1);
            }
            return newColorAndFontPanel;
        }

        @Override
        @NotNull
        public String getPanelDisplayName() {
            if ("Console Font" == null) {
                ConsoleFontConfigurableFactory.$$$reportNull$$$0(2);
            }
            return "Console Font";
        }

        @NotNull
        public DisplayPriority getPriority() {
            DisplayPriority displayPriority = DisplayPriority.FONT_SETTINGS;
            if (displayPriority == null) {
                ConsoleFontConfigurableFactory.$$$reportNull$$$0(3);
            }
            return displayPriority;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$ConsoleFontConfigurableFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$ConsoleFontConfigurableFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPanelDisplayName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createPanel";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$createPanel$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FontConfigurableFactory
    implements ColorAndFontPanelFactoryEx {
        private FontConfigurableFactory() {
        }

        @Override
        @NotNull
        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
            if (options == null) {
                FontConfigurableFactory.$$$reportNull$$$0(0);
            }
            FontEditorPreview previewPanel = new FontEditorPreview(() -> {
                if (options == null) {
                    FontConfigurableFactory.$$$reportNull$$$0(3);
                }
                return options.getSelectedScheme();
            }, true);
            NewColorAndFontPanel newColorAndFontPanel = new NewColorAndFontPanel(new SchemesPanel(options, 0), new FontOptions(options), previewPanel, ColorAndFontOptions.FONT_CONFIGURABLE_NAME, null, null){

                @Override
                public boolean containsFontOptions() {
                    return true;
                }
            };
            if (newColorAndFontPanel == null) {
                FontConfigurableFactory.$$$reportNull$$$0(1);
            }
            return newColorAndFontPanel;
        }

        @Override
        @NotNull
        public String getPanelDisplayName() {
            if (ColorAndFontOptions.FONT_CONFIGURABLE_NAME == null) {
                FontConfigurableFactory.$$$reportNull$$$0(2);
            }
            return ColorAndFontOptions.FONT_CONFIGURABLE_NAME;
        }

        public DisplayPriority getPriority() {
            return DisplayPriority.FONT_SETTINGS;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$FontConfigurableFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$FontConfigurableFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPanelDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createPanel";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$createPanel$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

