/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineCommentCopyPastePreProcessor
implements CopyPastePreProcessor {
    @Override
    @Nullable
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @Override
    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file2, Editor editor, String text, RawText rawText) {
        Language language = file2.getLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter == null) {
            String string = text;
            if (string == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        String lineCommentPrefix = commenter.getLineCommentPrefix();
        if (lineCommentPrefix == null) {
            String string = text;
            if (string == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        Document document = editor.getDocument();
        int offset = editor.getSelectionModel().getSelectionStart();
        int lineStartOffset = DocumentUtil.getLineStartOffset(offset, document);
        CharSequence chars = document.getImmutableCharSequence();
        int firstNonWsLineOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStartOffset, (String)" \t");
        if (offset < firstNonWsLineOffset + lineCommentPrefix.length() || !CharArrayUtil.regionMatches((CharSequence)chars, (int)firstNonWsLineOffset, (CharSequence)lineCommentPrefix)) {
            String string = text;
            if (string == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((PsiFile)file2);
        String lineStartReplacement = "\n" + chars.subSequence(lineStartOffset, firstNonWsLineOffset + lineCommentPrefix.length()) + (codeStyleSettings.getCommonSettings((Language)language).LINE_COMMENT_ADD_SPACE ? " " : "");
        String string = StringUtil.trimTrailing((String)text, (char)'\n').replace("\n", lineStartReplacement);
        if (string == null) {
            LineCommentCopyPastePreProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/LineCommentCopyPastePreProcessor", "preprocessOnPaste"));
    }
}

