/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.google.common.collect.ImmutableMap;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUIContextEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.util.Function;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterInfoComponent
extends JPanel {
    private final Object[] myObjects;
    private int myCurrentParameterIndex;
    private PsiElement myParameterOwner;
    private Object myHighlighted;
    @NotNull
    private final ParameterInfoHandler myHandler;
    private final OneElementComponent[] myPanels;
    private final JLabel myShortcutLabel;
    private final Font NORMAL_FONT;
    private final Font BOLD_FONT;
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder();
    private static final Border BOTTOM_BORDER = new SideBorder((Color)new JBColor((Color)JBColor.LIGHT_GRAY, (Color)Gray._90), 8);
    protected int myWidthLimit;
    private static final Map<ParameterInfoUIContextEx.Flag, String> FLAG_TO_TAG = ImmutableMap.of((Object)ParameterInfoUIContextEx.Flag.HIGHLIGHT, (Object)"b", (Object)ParameterInfoUIContextEx.Flag.DISABLE, (Object)"font color=gray", (Object)ParameterInfoUIContextEx.Flag.STRIKEOUT, (Object)"strike");
    private static final Comparator<TextRange> TEXT_RANGE_COMPARATOR = (o1, o2) -> {
        if (o1.getStartOffset() == o2.getStartOffset()) {
            return o1.getEndOffset() > o2.getEndOffset() ? 1 : -1;
        }
        if (o1.getStartOffset() > o2.getStartOffset()) {
            return 1;
        }
        if (o1.getEndOffset() > o2.getEndOffset()) {
            return 1;
        }
        return -1;
    };
    private boolean myRequestFocus;

    public static ParameterInfoUIContextEx createContext(Object[] objects, Editor editor, @NotNull ParameterInfoHandler handler2, int currentParameterIndex) {
        if (handler2 == null) {
            ParameterInfoComponent.$$$reportNull$$$0(0);
        }
        return ParameterInfoComponent.createContext(objects, editor, handler2, currentParameterIndex, null);
    }

    public static ParameterInfoUIContextEx createContext(Object[] objects, Editor editor, @NotNull ParameterInfoHandler handler2, int currentParameterIndex, @Nullable PsiElement parameterOwner) {
        if (handler2 == null) {
            ParameterInfoComponent.$$$reportNull$$$0(1);
        }
        ParameterInfoComponent infoComponent = new ParameterInfoComponent(objects, editor, handler2);
        infoComponent.setCurrentParameterIndex(currentParameterIndex);
        infoComponent.setParameterOwner(parameterOwner);
        ParameterInfoComponent parameterInfoComponent = infoComponent;
        parameterInfoComponent.getClass();
        return parameterInfoComponent.new MyParameterContext(false);
    }

    ParameterInfoComponent(Object[] objects, Editor editor, @NotNull ParameterInfoHandler handler2) {
        if (handler2 == null) {
            ParameterInfoComponent.$$$reportNull$$$0(2);
        }
        this(objects, editor, handler2, false, false);
    }

    ParameterInfoComponent(Object[] objects, Editor editor, @NotNull ParameterInfoHandler handler2, boolean requestFocus, boolean allowSwitchLabel) {
        if (handler2 == null) {
            ParameterInfoComponent.$$$reportNull$$$0(3);
        }
        super(new BorderLayout());
        this.myWidthLimit = 500;
        this.myRequestFocus = requestFocus;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JComponent editorComponent = editor.getComponent();
            JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
            this.myWidthLimit = layeredPane.getWidth();
        }
        this.NORMAL_FONT = UIUtil.getLabelFont();
        this.BOLD_FONT = this.NORMAL_FONT.deriveFont(1);
        this.myObjects = objects;
        this.setBackground(HintUtil.getInformationColor());
        this.myHandler = handler2;
        this.myPanels = new OneElementComponent[this.myObjects.length];
        JPanel panel2 = new JPanel(new GridBagLayout());
        for (int i = 0; i < this.myObjects.length; ++i) {
            this.myPanels[i] = new OneElementComponent();
            panel2.add((Component)this.myPanels[i], new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (this.myRequestFocus) {
            AccessibleContextUtil.setName((Component)this, (String)"Parameter Info. Press TAB to navigate through each element. Press ESC to close.");
        }
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)panel2);
        pane.setBorder(null);
        pane.setHorizontalScrollBarPolicy(30);
        this.add((Component)pane, "Center");
        String upShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"MethodOverloadSwitchUp");
        String downShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"MethodOverloadSwitchDown");
        if (!allowSwitchLabel || editor instanceof EditorWindow || this.myObjects.length <= 1 || !this.myHandler.supportsOverloadSwitching() || upShortcut.isEmpty() && downShortcut.isEmpty()) {
            this.myShortcutLabel = null;
        } else {
            this.myShortcutLabel = new JLabel(upShortcut.isEmpty() || downShortcut.isEmpty() ? CodeInsightBundle.message((String)"parameter.info.switch.overload.shortcuts.single", (Object[])new Object[]{upShortcut.isEmpty() ? downShortcut : upShortcut}) : CodeInsightBundle.message((String)"parameter.info.switch.overload.shortcuts", (Object[])new Object[]{upShortcut, downShortcut}));
            this.myShortcutLabel.setForeground((Color)new JBColor(0x787878, 0x787878));
            Font labelFont = UIUtil.getLabelFont();
            this.myShortcutLabel.setFont(labelFont.deriveFont(labelFont.getSize2D() - (float)(SystemInfo.isWindows ? 1 : 2)));
            this.myShortcutLabel.setBorder((Border)new JBEmptyBorder(3, 0, 0, 0));
            this.add((Component)this.myShortcutLabel, "South");
        }
        this.myCurrentParameterIndex = -1;
    }

    @Override
    public Dimension getPreferredSize() {
        long visibleRows = Stream.of(this.myPanels).filter(Component::isVisible).count();
        Dimension preferredSize = super.getPreferredSize();
        if (visibleRows <= 20L) {
            return preferredSize;
        }
        return new Dimension(preferredSize.width + 20, 200);
    }

    @Override
    public String toString() {
        return Stream.of(this.myPanels).filter(Component::isVisible).map(c -> c.toString() + (c.getBorder() == BOTTOM_BORDER ? "\n-" : "")).collect(Collectors.joining("\n"));
    }

    public Object getHighlighted() {
        return this.myHighlighted;
    }

    public boolean isRequestFocus() {
        return this.myRequestFocus;
    }

    public void update(boolean singleParameterInfo) {
        MyParameterContext context = new MyParameterContext(singleParameterInfo);
        for (int i = 0; i < this.myObjects.length; ++i) {
            context.i = i;
            Object o = this.myObjects[i];
            if (singleParameterInfo && this.myObjects.length > 1 && !context.isHighlighted()) {
                this.setVisible(i, false);
                continue;
            }
            this.setVisible(i, true);
            this.myHandler.updateUI(o, (ParameterInfoUIContext)context);
        }
        if (this.myShortcutLabel != null) {
            this.myShortcutLabel.setVisible(!singleParameterInfo);
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public Object[] getObjects() {
        return this.myObjects;
    }

    void setEnabled(int index, boolean enabled) {
        this.myPanels[index].setEnabled(enabled);
    }

    void setVisible(int index, boolean visible) {
        this.myPanels[index].setVisible(visible);
    }

    boolean isEnabled(int index) {
        return this.myPanels[index].isEnabled();
    }

    public void setCurrentParameterIndex(int currentParameterIndex) {
        this.myCurrentParameterIndex = currentParameterIndex;
    }

    public int getCurrentParameterIndex() {
        return this.myCurrentParameterIndex;
    }

    public void setParameterOwner(PsiElement element) {
        this.myParameterOwner = element;
    }

    public PsiElement getParameterOwner() {
        return this.myParameterOwner;
    }

    public void setHighlightedParameter(Object element) {
        this.myHighlighted = element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "handler";
        objectArray2[1] = "com/intellij/codeInsight/hint/ParameterInfoComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class OneLineComponent
    extends JPanel {
        JLabel myLabel;
        private boolean isDisabledBeforeHighlight;

        private OneLineComponent() {
            super(new GridBagLayout());
            this.myLabel = new JLabel("", 2);
            this.isDisabledBeforeHighlight = false;
            this.myLabel.setOpaque(true);
            this.myLabel.setFont(ParameterInfoComponent.this.NORMAL_FONT);
            if (ParameterInfoComponent.this.myRequestFocus) {
                this.myLabel.setFocusable(true);
            }
            this.add((Component)this.myLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public String toString() {
            return this.myLabel.getText();
        }

        private String setup(String text, boolean isDisabled, boolean isStrikeout, Color background, @Nullable TextRange range2) {
            TreeMap<TextRange, ParameterInfoUIContextEx.Flag> flagsMap = new TreeMap<TextRange, ParameterInfoUIContextEx.Flag>(TEXT_RANGE_COMPARATOR);
            if (range2 != null) {
                flagsMap.put(range2, ParameterInfoUIContextEx.Flag.HIGHLIGHT);
            }
            if (isDisabled) {
                flagsMap.put(TextRange.create((int)0, (int)text.length()), ParameterInfoUIContextEx.Flag.DISABLE);
            }
            if (isStrikeout) {
                flagsMap.put(TextRange.create((int)0, (int)text.length()), ParameterInfoUIContextEx.Flag.STRIKEOUT);
            }
            return this.setup(text, flagsMap, background);
        }

        private String setup(@NotNull String text, @NotNull Map<TextRange, ParameterInfoUIContextEx.Flag> flagsMap, @NotNull Color background) {
            if (text == null) {
                OneLineComponent.$$$reportNull$$$0(0);
            }
            if (flagsMap == null) {
                OneLineComponent.$$$reportNull$$$0(1);
            }
            if (background == null) {
                OneLineComponent.$$$reportNull$$$0(2);
            }
            if (flagsMap.isEmpty()) {
                return this.doSetup(text, background);
            }
            String labelText = this.buildLabelText(text, flagsMap);
            return this.doSetup(labelText, background);
        }

        private String doSetup(@NotNull String text, @NotNull Color background) {
            if (text == null) {
                OneLineComponent.$$$reportNull$$$0(3);
            }
            if (background == null) {
                OneLineComponent.$$$reportNull$$$0(4);
            }
            this.myLabel.setBackground(background);
            this.setBackground(background);
            this.myLabel.setForeground(JBColor.foreground());
            this.myLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)text));
            if (UIUtil.isUnderDarcula()) {
                this.myLabel.setText(this.myLabel.getText().replace("<b>", "<b color=ffC800>"));
            }
            return this.myLabel.getText();
        }

        private String buildLabelText(@NotNull String text, @NotNull Map<TextRange, ParameterInfoUIContextEx.Flag> flagsMap) {
            if (text == null) {
                OneLineComponent.$$$reportNull$$$0(5);
            }
            if (flagsMap == null) {
                OneLineComponent.$$$reportNull$$$0(6);
            }
            StringBuilder labelText = new StringBuilder(text);
            String disabledTag = (String)FLAG_TO_TAG.get(ParameterInfoUIContextEx.Flag.DISABLE);
            HashMap<Integer, Integer> faultMap = new HashMap<Integer, Integer>();
            if (this.isDisabledBeforeHighlight) {
                String tag = this.getTag(disabledTag);
                labelText.insert(0, tag);
                faultMap.put(0, tag.length());
            }
            for (Map.Entry<TextRange, ParameterInfoUIContextEx.Flag> entry : flagsMap.entrySet()) {
                TextRange highlightRange = entry.getKey();
                ParameterInfoUIContextEx.Flag flag = entry.getValue();
                String tagValue = (String)FLAG_TO_TAG.get(flag);
                String tag = this.getTag(tagValue);
                int startOffset = highlightRange.getStartOffset();
                int endOffset = highlightRange.getEndOffset() + tag.length();
                for (Map.Entry entry1 : faultMap.entrySet()) {
                    if ((Integer)entry1.getKey() < highlightRange.getStartOffset()) {
                        startOffset += ((Integer)entry1.getValue()).intValue();
                    }
                    if ((Integer)entry1.getKey() >= highlightRange.getEndOffset()) continue;
                    endOffset += ((Integer)entry1.getValue()).intValue();
                }
                if (flag == ParameterInfoUIContextEx.Flag.HIGHLIGHT && this.isDisabledBeforeHighlight) {
                    String disableCloseTag = this.getClosingTag(disabledTag);
                    labelText.insert(startOffset, disableCloseTag);
                    faultMap.put(highlightRange.getStartOffset(), disableCloseTag.length());
                }
                labelText.insert(startOffset, tag);
                faultMap.put(highlightRange.getStartOffset(), tag.length());
                String endTag = this.getClosingTag(tagValue);
                labelText.insert(endOffset, endTag);
                faultMap.put(highlightRange.getEndOffset(), endTag.length());
            }
            return labelText.toString();
        }

        private String getTag(@NotNull String tagValue) {
            if (tagValue == null) {
                OneLineComponent.$$$reportNull$$$0(7);
            }
            return "<" + tagValue + ">";
        }

        private String getClosingTag(@NotNull String tagValue) {
            if (tagValue == null) {
                OneLineComponent.$$$reportNull$$$0(8);
            }
            return "</" + tagValue + ">";
        }

        public void setDisabledBeforeHighlight() {
            this.isDisabledBeforeHighlight = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flagsMap";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "background";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagValue";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/hint/ParameterInfoComponent$OneLineComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setup";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doSetup";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildLabelText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTag";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getClosingTag";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class OneElementComponent
    extends JPanel {
        private OneLineComponent[] myOneLineComponents;

        public OneElementComponent() {
            super(new GridBagLayout());
            this.myOneLineComponents = new OneLineComponent[0];
        }

        @Override
        public String toString() {
            boolean highlighted = this.myOneLineComponents.length > 0 && !HintUtil.getInformationColor().equals(this.myOneLineComponents[0].getBackground());
            String text = Stream.of(this.myOneLineComponents).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining());
            return highlighted ? '[' + text + ']' : text;
        }

        private void setup(String htmlText, Color background) {
            this.removeAll();
            this.myOneLineComponents = new OneLineComponent[1];
            this.myOneLineComponents[0] = new OneLineComponent();
            this.myOneLineComponents[0].doSetup(htmlText, background);
            this.add((Component)this.myOneLineComponents[0], new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        private String setup(String text, Function<String, String> escapeFunction, int highlightStartOffset, int highlightEndOffset, boolean isDisabled, boolean strikeout, boolean isDisabledBeforeHighlight, Color background) {
            StringBuilder buf = new StringBuilder();
            this.removeAll();
            String[] lines2 = UIUtil.splitText((String)text, (FontMetrics)this.getFontMetrics(ParameterInfoComponent.this.BOLD_FONT), (int)ParameterInfoComponent.this.myWidthLimit, (char)',');
            this.myOneLineComponents = new OneLineComponent[lines2.length];
            int lineOffset = 0;
            boolean hasHighlighting = highlightStartOffset >= 0 && highlightEndOffset > highlightStartOffset;
            TextRange highlightingRange = hasHighlighting ? new TextRange(highlightStartOffset, highlightEndOffset) : null;
            for (int i = 0; i < lines2.length; ++i) {
                String line = lines2[i];
                this.myOneLineComponents[i] = new OneLineComponent();
                TextRange lRange = new TextRange(lineOffset, lineOffset + line.length());
                TextRange hr = highlightingRange == null ? null : lRange.intersection(highlightingRange);
                hr = hr == null ? null : hr.shiftRight(-lineOffset);
                String before = this.escapeString(hr == null ? line : line.substring(0, hr.getStartOffset()), escapeFunction);
                String in = hr == null ? "" : this.escapeString(hr.substring(line), escapeFunction);
                String after = hr == null ? "" : this.escapeString(line.substring(hr.getEndOffset(), line.length()), escapeFunction);
                TextRange escapedHighlightingRange = in.isEmpty() ? null : TextRange.create((int)before.length(), (int)(before.length() + in.length()));
                buf.append(this.myOneLineComponents[i].setup(before + in + after, isDisabled, strikeout, background, escapedHighlightingRange));
                if (isDisabledBeforeHighlight && (highlightStartOffset < 0 || highlightEndOffset > lineOffset)) {
                    this.myOneLineComponents[i].setDisabledBeforeHighlight();
                }
                this.add((Component)this.myOneLineComponents[i], new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                lineOffset += line.length();
            }
            return buf.toString();
        }

        private String escapeString(String line, Function<String, String> escapeFunction) {
            line = XmlStringUtil.escapeString((String)line);
            return escapeFunction == null ? line : (String)escapeFunction.fun((Object)line);
        }

        public String setup(String[] texts, Function<String, String> escapeFunction, EnumSet<ParameterInfoUIContextEx.Flag>[] flags, Color background) {
            String paramText;
            StringBuilder buf = new StringBuilder();
            this.removeAll();
            this.setBackground(background);
            int index = 0;
            int curOffset = 0;
            ArrayList<OneLineComponent> components = new ArrayList<OneLineComponent>();
            TreeMap<TextRange, ParameterInfoUIContextEx.Flag> flagsMap = new TreeMap<TextRange, ParameterInfoUIContextEx.Flag>(TEXT_RANGE_COMPARATOR);
            String line = "";
            for (int i = 0; i < texts.length && (paramText = this.escapeString(texts[i], escapeFunction)) != null; ++i) {
                line = line + texts[i];
                EnumSet<ParameterInfoUIContextEx.Flag> flag = flags[i];
                if (flag.contains(ParameterInfoUIContextEx.Flag.HIGHLIGHT)) {
                    flagsMap.put(TextRange.create((int)curOffset, (int)(curOffset + paramText.trim().length())), ParameterInfoUIContextEx.Flag.HIGHLIGHT);
                }
                if (flag.contains(ParameterInfoUIContextEx.Flag.DISABLE)) {
                    flagsMap.put(TextRange.create((int)curOffset, (int)(curOffset + paramText.trim().length())), ParameterInfoUIContextEx.Flag.DISABLE);
                }
                if (flag.contains(ParameterInfoUIContextEx.Flag.STRIKEOUT)) {
                    flagsMap.put(TextRange.create((int)curOffset, (int)(curOffset + paramText.trim().length())), ParameterInfoUIContextEx.Flag.STRIKEOUT);
                }
                curOffset += paramText.length();
                if (line.length() < 50) continue;
                OneLineComponent component = new OneLineComponent();
                buf.append(component.setup(this.escapeString(line, escapeFunction), flagsMap, background));
                this.add((Component)component, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                ++index;
                flagsMap.clear();
                curOffset = 0;
                line = "";
                components.add(component);
            }
            OneLineComponent component = new OneLineComponent();
            buf.append(component.setup(this.escapeString(line, escapeFunction), flagsMap, background));
            this.add((Component)component, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            components.add(component);
            this.myOneLineComponents = components.toArray(new OneLineComponent[0]);
            return buf.toString();
        }
    }

    class MyParameterContext
    implements ParameterInfoUIContextEx {
        private final boolean mySingleParameterInfo;
        private int i;
        private Function<String, String> myEscapeFunction;

        public MyParameterContext(boolean singleParameterInfo) {
            this.mySingleParameterInfo = singleParameterInfo;
        }

        public String setupUIComponentPresentation(String text, int highlightStartOffset, int highlightEndOffset, boolean isDisabled, boolean strikeout, boolean isDisabledBeforeHighlight, Color background) {
            String resultedText = ParameterInfoComponent.this.myPanels[this.i].setup(text, (Function<String, String>)this.myEscapeFunction, highlightStartOffset, highlightEndOffset, isDisabled, strikeout, isDisabledBeforeHighlight, background);
            ParameterInfoComponent.this.myPanels[this.i].setBorder(this.isLastParameterOwner() || this.isSingleParameterInfo() ? EMPTY_BORDER : BOTTOM_BORDER);
            return resultedText;
        }

        public void setupRawUIComponentPresentation(String htmlText) {
            ParameterInfoComponent.this.myPanels[this.i].setup(htmlText, this.getDefaultParameterColor());
            ParameterInfoComponent.this.myPanels[this.i].setBorder(this.isLastParameterOwner() || this.isSingleParameterInfo() ? EMPTY_BORDER : BOTTOM_BORDER);
        }

        public String setupUIComponentPresentation(String[] texts, EnumSet<ParameterInfoUIContextEx.Flag>[] flags, Color background) {
            String resultedText = ParameterInfoComponent.this.myPanels[this.i].setup(texts, this.myEscapeFunction, flags, background);
            ParameterInfoComponent.this.myPanels[this.i].setBorder(this.isLastParameterOwner() || this.isSingleParameterInfo() ? EMPTY_BORDER : BOTTOM_BORDER);
            return resultedText;
        }

        public void setEscapeFunction(@Nullable Function<String, String> escapeFunction) {
            this.myEscapeFunction = escapeFunction;
        }

        public boolean isUIComponentEnabled() {
            return ParameterInfoComponent.this.isEnabled(this.i);
        }

        public void setUIComponentEnabled(boolean enabled) {
            ParameterInfoComponent.this.setEnabled(this.i, enabled);
        }

        public boolean isLastParameterOwner() {
            return this.i == ParameterInfoComponent.this.myPanels.length - 1;
        }

        public int getCurrentParameterIndex() {
            return ParameterInfoComponent.this.myCurrentParameterIndex;
        }

        public PsiElement getParameterOwner() {
            return ParameterInfoComponent.this.myParameterOwner;
        }

        public boolean isSingleOverload() {
            return ParameterInfoComponent.this.myPanels.length == 1;
        }

        public boolean isSingleParameterInfo() {
            return this.mySingleParameterInfo;
        }

        private boolean isHighlighted() {
            return ParameterInfoComponent.this.myObjects[this.i].equals(ParameterInfoComponent.this.myHighlighted);
        }

        public Color getDefaultParameterColor() {
            Color color = HintUtil.getInformationColor();
            return this.mySingleParameterInfo || !this.isHighlighted() ? color : (ColorUtil.isDark((Color)color) ? ColorUtil.brighter((Color)color, (int)2) : ColorUtil.darker((Color)color, (int)2));
        }
    }
}

