/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalAnnotatorInspectionVisitor
extends PsiElementVisitor {
    private static final Logger LOG = Logger.getInstance(ExternalAnnotatorInspectionVisitor.class);
    private final ProblemsHolder myHolder;
    private final ExternalAnnotator myAnnotator;
    private final boolean myIsOnTheFly;

    public ExternalAnnotatorInspectionVisitor(ProblemsHolder holder, ExternalAnnotator annotator, boolean isOnTheFly) {
        this.myHolder = holder;
        this.myAnnotator = annotator;
        this.myIsOnTheFly = isOnTheFly;
    }

    public void visitFile(PsiFile file2) {
        ProblemDescriptor[] descriptors = ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator(file2, this.myHolder.getManager(), this.myIsOnTheFly, this.myAnnotator);
        this.addDescriptors(descriptors);
    }

    @NotNull
    public static <Init, Result> ProblemDescriptor[] checkFileWithExternalAnnotator(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull ExternalAnnotator<Init, Result> annotator) {
        if (file2 == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(1);
        }
        if (annotator == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(2);
        }
        if (isOnTheFly) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(3);
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Object info = ReadAction.compute(() -> {
            if (annotator == null) {
                ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(19);
            }
            if (file2 == null) {
                ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(20);
            }
            return annotator.collectInformation(file2);
        });
        if (info != null) {
            Object annotationResult = annotator.doAnnotate(info);
            if (annotationResult == null) {
                if (ProblemDescriptor.EMPTY_ARRAY == null) {
                    ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(4);
                }
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            ProblemDescriptor[] problemDescriptorArray = (ProblemDescriptor[])ReadAction.compute(() -> {
                if (file2 == null) {
                    ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(16);
                }
                if (annotator == null) {
                    ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(17);
                }
                if (manager == null) {
                    ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(18);
                }
                AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2), true);
                annotator.apply(file2, annotationResult, (AnnotationHolder)annotationHolder);
                return ExternalAnnotatorInspectionVisitor.convertToProblemDescriptors((List<Annotation>)((Object)annotationHolder), manager, file2);
            });
            if (problemDescriptorArray == null) {
                ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(5);
            }
            return problemDescriptorArray;
        }
        if (ProblemDescriptor.EMPTY_ARRAY == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(6);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    private static ProblemDescriptor[] convertToProblemDescriptors(@NotNull List<Annotation> annotations, @NotNull InspectionManager manager, @NotNull PsiFile file2) {
        if (annotations == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(9);
        }
        if (annotations.isEmpty()) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(10);
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList problems = ContainerUtil.newArrayListWithCapacity((int)annotations.size());
        IdentityHashMap quickFixMappingCache = ContainerUtil.newIdentityHashMap();
        for (Annotation annotation : annotations) {
            PsiElement startElement;
            PsiElement endElement;
            if (annotation.getSeverity() == HighlightSeverity.INFORMATION || annotation.getStartOffset() == annotation.getEndOffset() && !annotation.isAfterEndOfLine()) continue;
            if (annotation.getStartOffset() == annotation.getEndOffset() && annotation.isAfterEndOfLine()) {
                startElement = endElement = file2.findElementAt(annotation.getEndOffset() - 1);
            } else {
                startElement = file2.findElementAt(annotation.getStartOffset());
                endElement = file2.findElementAt(annotation.getEndOffset() - 1);
            }
            if (startElement == null || endElement == null) continue;
            LocalQuickFix[] quickFixes = ExternalAnnotatorInspectionVisitor.toLocalQuickFixes(annotation.getQuickFixes(), quickFixMappingCache);
            ProblemDescriptorBase descriptor = new ProblemDescriptorBase(startElement, endElement, annotation.getMessage(), quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, annotation.isAfterEndOfLine(), null, true, false);
            problems.add(descriptor);
        }
        ProblemDescriptor[] problemDescriptorArray = problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
        if (problemDescriptorArray == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(11);
        }
        return problemDescriptorArray;
    }

    @NotNull
    private static LocalQuickFix[] toLocalQuickFixes(@Nullable List<Annotation.QuickFixInfo> fixInfos, @NotNull IdentityHashMap<IntentionAction, LocalQuickFix> quickFixMappingCache) {
        if (quickFixMappingCache == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(12);
        }
        if (fixInfos == null || fixInfos.isEmpty()) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(13);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] result2 = new LocalQuickFix[fixInfos.size()];
        int i = 0;
        for (Annotation.QuickFixInfo fixInfo : fixInfos) {
            LocalQuickFix fix;
            IntentionAction intentionAction = fixInfo.quickFix;
            if (intentionAction instanceof LocalQuickFix) {
                fix = (LocalQuickFix)intentionAction;
            } else {
                LocalQuickFix lqf = quickFixMappingCache.get(intentionAction);
                if (lqf == null) {
                    lqf = new LocalQuickFixBackedByIntentionAction(intentionAction);
                    quickFixMappingCache.put(intentionAction, lqf);
                }
                fix = lqf;
            }
            result2[i++] = fix;
        }
        if (result2 == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(14);
        }
        return result2;
    }

    private void addDescriptors(@NotNull ProblemDescriptor[] descriptors) {
        if (descriptors == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(15);
        }
        for (ProblemDescriptor descriptor : descriptors) {
            LOG.assertTrue(descriptor != null, (Object)((Object)((Object)this)).getClass().getName());
            this.myHolder.registerProblem(descriptor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixMappingCache";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "checkFileWithExternalAnnotator";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToProblemDescriptors";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocalQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFileWithExternalAnnotator";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblemDescriptors";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toLocalQuickFixes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptors";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkFileWithExternalAnnotator$1";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkFileWithExternalAnnotator$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LocalQuickFixBackedByIntentionAction
    implements LocalQuickFix,
    Iconable {
        private final IntentionAction myAction;

        public LocalQuickFixBackedByIntentionAction(@NotNull IntentionAction action) {
            if (action == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(0);
            }
            this.myAction = action;
        }

        @NotNull
        public String getName() {
            String string = this.myAction.getText();
            if (string == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myAction.getFamilyName();
            if (string == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(4);
            }
            this.myAction.invoke(project, null, LocalQuickFixBackedByIntentionAction.getPsiFile(descriptor));
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
            if (file2 == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(5);
            }
            return this.myAction.getElementToMakeWritable(file2);
        }

        @Nullable
        private static PsiFile getPsiFile(@NotNull ProblemDescriptor descriptor) {
            PsiElement startElement;
            if (descriptor == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(6);
            }
            if ((startElement = descriptor.getStartElement()) != null) {
                return startElement.getContainingFile();
            }
            PsiElement endElement = descriptor.getEndElement();
            if (endElement != null) {
                return endElement.getContainingFile();
            }
            return null;
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            if (this.myAction instanceof Iconable) {
                return ((Iconable)this.myAction).getIcon(flags);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalQuickFixBackedByIntentionAction action = (LocalQuickFixBackedByIntentionAction)o;
            return this.myAction.equals(action.myAction);
        }

        public int hashCode() {
            return this.myAction.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor$LocalQuickFixBackedByIntentionAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor$LocalQuickFixBackedByIntentionAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getPsiFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

