/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.MasterKeyStorage;
import com.intellij.credentialStore.WindowsEncryptionSupport;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.util.EncryptionSupport;
import com.intellij.util.io.PathKt;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.security.Key;
import java.util.Base64;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/credentialStore/MasterKeyFileStorage;", "Lcom/intellij/credentialStore/MasterKeyStorage;", "baseDirectory", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "encryptionSupport", "Lcom/intellij/util/EncryptionSupport;", "passwordFile", "kotlin.jvm.PlatformType", "get", "", "set", "", "key", "intellij.platform.credentialStore"})
public final class MasterKeyFileStorage
implements MasterKeyStorage {
    private final EncryptionSupport encryptionSupport;
    private final Path passwordFile;

    @Override
    @Nullable
    public byte[] get() {
        byte[] data;
        try {
            data = PathKt.readBytes((Path)this.passwordFile);
        }
        catch (NoSuchFileException e) {
            return null;
        }
        try {
            return this.encryptionSupport.decrypt(data);
        }
        catch (Exception e) {
            CredentialStoreKt.getLOG().warn("Cannot decrypt master key, file content: " + Base64.getEncoder().encodeToString(data), (Throwable)e);
            return null;
        }
    }

    @Override
    public void set(@Nullable byte[] key) {
        if (key == null) {
            PathKt.delete((Path)this.passwordFile);
            return;
        }
        PathKt.writeSafe$default((Path)this.passwordFile, (byte[])EncryptionSupport.encrypt$default((EncryptionSupport)this.encryptionSupport, (byte[])key, (int)0, (int)2, null), (int)0, (int)0, (int)6, null);
        FileUtilKt.setOwnerPermissions(this.passwordFile);
    }

    public MasterKeyFileStorage(@NotNull Path baseDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)baseDirectory, (String)"baseDirectory");
        this.passwordFile = baseDirectory.resolve("pdb.pwd");
        SecretKeySpec key = new SecretKeySpec(new byte[]{80, 114, (byte)111, (byte)120, (byte)121, (byte)32, (byte)67, (byte)111, (byte)110, (byte)102, (byte)105, (byte)103, (byte)32, (byte)83, (byte)101, (byte)99}, "AES");
        this.encryptionSupport = SystemInfo.isWindows ? (EncryptionSupport)new WindowsEncryptionSupport(key) : new EncryptionSupport((Key)key);
    }
}

