/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.jetbrains.annotations.NotNull;

public class LogMessage
extends AbstractMessage {
    private final Throwable myThrowable;
    private final String myHeader;
    private List<Attachment> myAttachments;

    LogMessage(@NotNull LoggingEvent event) {
        if (event == null) {
            LogMessage.$$$reportNull$$$0(0);
        }
        Throwable throwable = event.getThrowableInformation() == null ? null : event.getThrowableInformation().getThrowable();
        this.myThrowable = throwable == null ? null : ThrowableInterner.intern((Throwable)throwable);
        this.myHeader = event.getMessage() == null || event.getMessage().toString().isEmpty() ? this.getThrowable().toString() : event.getMessage().toString();
    }

    LogMessage(@NotNull IdeaLoggingEvent event) {
        String message;
        if (event == null) {
            LogMessage.$$$reportNull$$$0(1);
        }
        Throwable throwable = event.getThrowable();
        this.myThrowable = throwable == null ? null : ThrowableInterner.intern((Throwable)throwable);
        String header = null;
        if (!StringUtil.isEmptyOrSpaces((String)event.getMessage())) {
            header = event.getMessage();
        }
        if (this.myThrowable != null && StringUtil.isNotEmpty((String)(message = this.myThrowable.getMessage())) && (header == null || !header.startsWith(message))) {
            if (header != null) {
                if (header.endsWith(":")) {
                    header = header + " ";
                } else if (!header.endsWith(": ")) {
                    header = header + ": ";
                }
                header = header + message;
            } else {
                header = message;
            }
        }
        if (header == null) {
            header = "No message";
        }
        this.myHeader = header;
    }

    @Override
    public Throwable getThrowable() {
        return this.myThrowable;
    }

    @Override
    public String getMessage() {
        return this.myHeader;
    }

    @Override
    public String getThrowableText() {
        return StringUtil.join((String[])IdeaLogger.getThrowableRenderer().doRender(this.getThrowable()), (String)Layout.LINE_SEP);
    }

    void addAttachment(@NotNull Attachment attachment) {
        if (attachment == null) {
            LogMessage.$$$reportNull$$$0(2);
        }
        if (this.myAttachments == null) {
            this.myAttachments = ContainerUtil.createLockFreeCopyOnWriteList();
        }
        this.myAttachments.add(attachment);
    }

    @Override
    @NotNull
    public List<Attachment> getAllAttachments() {
        List<Object> list2 = this.myAttachments != null ? this.myAttachments : Collections.emptyList();
        if (list2 == null) {
            LogMessage.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/LogMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/LogMessage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAttachments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAttachment";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

