/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleHistoryBaseModel;
import com.intellij.execution.console.ConsoleHistoryModel;
import com.intellij.execution.console.MasterModel;
import com.intellij.execution.console.PrefixHistoryModelKt;
import gnu.trove.TIntStack;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\b\u0010\u001b\u001a\u00020\nH\u0016J+\u0010\u001c\u001a$\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u00070\u0007 \u001e*\u0010\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u00070\u00070\f0\u001dH\u0097\u0001J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0018H\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u0018H\u0016J\t\u0010!\u001a\u00020\nH\u0096\u0001J\t\u0010\"\u001a\u00020\nH\u0096\u0001J\t\u0010#\u001a\u00020$H\u0096\u0001J\b\u0010%\u001a\u00020&H\u0016J\t\u0010'\u001a\u00020&H\u0096\u0001J\b\u0010(\u001a\u00020&H\u0016J\u0012\u0010)\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u0016J\u0016\u0010*\u001a\u00020\u00152\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0016J\b\u0010,\u001a\u00020\u0015H\u0002J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0007H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006."}, d2={"Lcom/intellij/execution/console/PrefixHistoryModel;", "Lcom/intellij/execution/console/ConsoleHistoryBaseModel;", "Lcom/intellij/execution/console/ConsoleHistoryModel;", "masterModel", "Lcom/intellij/execution/console/MasterModel;", "getPrefixFn", "Lkotlin/Function0;", "", "(Lcom/intellij/execution/console/MasterModel;Lkotlin/jvm/functions/Function0;)V", "myCurrentIndex", "", "myEntries", "", "myPrevEntries", "Lgnu/trove/TIntStack;", "userContent", "getUserContent", "()Ljava/lang/String;", "setUserContent", "(Ljava/lang/String;)V", "addToHistory", "", "statement", "createPrevEntry", "Lcom/intellij/execution/console/ConsoleHistoryModel$Entry;", "prevEntry", "currentPrefix", "getCurrentIndex", "getEntries", "", "kotlin.jvm.PlatformType", "getHistoryNext", "getHistoryPrev", "getHistorySize", "getMaxHistorySize", "getModificationCount", "", "hasHistory", "", "isEmpty", "prevOnLastLine", "removeFromHistory", "resetEntries", "entries", "resetIndex", "setContent", "intellij.platform.lang.impl"})
final class PrefixHistoryModel
implements ConsoleHistoryBaseModel,
ConsoleHistoryModel {
    @NotNull
    private String userContent;
    private List<String> myEntries;
    private int myCurrentIndex;
    private TIntStack myPrevEntries;
    private final MasterModel masterModel;
    private final Function0<String> getPrefixFn;

    @NotNull
    public final String getUserContent() {
        return this.userContent;
    }

    public final void setUserContent(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.userContent = string;
    }

    @Override
    public void setContent(@NotNull String userContent) {
        Intrinsics.checkParameterIsNotNull((Object)userContent, (String)"userContent");
        this.userContent = userContent;
    }

    @Override
    public void resetEntries(@NotNull List<String> entries) {
        Intrinsics.checkParameterIsNotNull(entries, (String)"entries");
        this.masterModel.resetEntries(entries);
        this.resetIndex();
    }

    @Override
    public void addToHistory(@Nullable String statement) {
        PrefixHistoryModelKt.access$assertDispatchThread();
        CharSequence charSequence = statement;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        this.masterModel.addToHistory(statement);
        this.resetIndex();
    }

    @Override
    public void removeFromHistory(@Nullable String statement) {
        PrefixHistoryModelKt.access$assertDispatchThread();
        CharSequence charSequence = statement;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        this.masterModel.removeFromHistory(statement);
        this.resetIndex();
    }

    private final void resetIndex() {
        this.myEntries = null;
        this.myCurrentIndex = -1;
        this.myPrevEntries.clear();
    }

    @Override
    @Nullable
    public ConsoleHistoryModel.Entry getHistoryNext() {
        Iterable iterable;
        int offset;
        List<String> list2 = this.myEntries;
        if (list2 == null) {
            list2 = this.masterModel.getEntries();
        }
        List<String> entries = list2;
        int n = offset = this.myCurrentIndex == -1 ? entries.size() : this.myCurrentIndex;
        if (offset <= 0) {
            return null;
        }
        String searchPrefix = (String)this.getPrefixFn.invoke();
        Iterable iterable2 = iterable = CollectionsKt.withIndex((Iterable)entries);
        Object var7_6 = null;
        for (Object t : iterable2) {
            IndexedValue it = (IndexedValue)t;
            if (!(it.getIndex() < offset && StringsKt.startsWith$default((String)((String)it.getValue()), (String)searchPrefix, (boolean)false, (int)2, null))) continue;
            var7_6 = t;
        }
        IndexedValue indexedValue = var7_6;
        if (indexedValue == null) {
            return null;
        }
        IndexedValue res = indexedValue;
        if (this.myEntries == null) {
            this.myEntries = entries;
        }
        if (this.myCurrentIndex != -1) {
            this.myPrevEntries.push(this.myCurrentIndex);
        }
        this.myCurrentIndex = res.getIndex();
        return new ConsoleHistoryModel.Entry((String)res.getValue(), searchPrefix.length());
    }

    @Override
    @Nullable
    public ConsoleHistoryModel.Entry getHistoryPrev() {
        List<String> list2 = this.myEntries;
        if (list2 == null) {
            return null;
        }
        List<String> entries = list2;
        String currentPrefix = (String)this.getPrefixFn.invoke();
        if (this.myPrevEntries.size() > 0) {
            this.myCurrentIndex = this.myPrevEntries.pop();
            return this.createPrevEntry(entries.get(this.myCurrentIndex), currentPrefix);
        }
        this.resetIndex();
        return this.createPrevEntry(this.userContent, currentPrefix);
    }

    private final ConsoleHistoryModel.Entry createPrevEntry(String prevEntry, String currentPrefix) {
        return StringsKt.startsWith$default((String)prevEntry, (String)currentPrefix, (boolean)false, (int)2, null) ? new ConsoleHistoryModel.Entry(prevEntry, currentPrefix.length()) : new ConsoleHistoryModel.Entry(prevEntry, 0);
    }

    @Override
    public int getCurrentIndex() {
        return this.myCurrentIndex != -1 ? this.myCurrentIndex : this.getEntries().size() - 1;
    }

    @Override
    public boolean prevOnLastLine() {
        return true;
    }

    @Override
    public boolean hasHistory() {
        return this.myEntries != null;
    }

    public PrefixHistoryModel(@NotNull MasterModel masterModel, @NotNull Function0<String> getPrefixFn) {
        Intrinsics.checkParameterIsNotNull((Object)masterModel, (String)"masterModel");
        Intrinsics.checkParameterIsNotNull(getPrefixFn, (String)"getPrefixFn");
        this.masterModel = masterModel;
        this.getPrefixFn = getPrefixFn;
        this.userContent = "";
        this.myCurrentIndex = -1;
        this.myPrevEntries = new TIntStack();
        this.resetIndex();
    }

    @Override
    @NotNull
    public List<String> getEntries() {
        return this.masterModel.getEntries();
    }

    @Override
    public int getHistorySize() {
        return this.masterModel.getHistorySize();
    }

    @Override
    public int getMaxHistorySize() {
        return this.masterModel.getMaxHistorySize();
    }

    public long getModificationCount() {
        return this.masterModel.getModificationCount();
    }

    @Override
    public boolean isEmpty() {
        return this.masterModel.isEmpty();
    }
}

