/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GeneralTestEventsProcessor
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)GeneralTestEventsProcessor.class.getName());
    protected final SMTRunnerEventsListener myEventPublisher;
    protected final SMTestProxy.SMRootTestProxy myTestsRootProxy;
    protected SMTestLocator myLocator;
    private final String myTestFrameworkName;
    private final Project myProject;
    private TransferToEDTQueue<Runnable> myTransferToEDTQueue;
    protected List<SMTRunnerEventsListener> myListenerAdapters;
    protected boolean myTreeBuildBeforeStart;
    protected final List<Runnable> myBuildTreeRunnables;

    public GeneralTestEventsProcessor(Project project, @NotNull String testFrameworkName, @NotNull SMTestProxy.SMRootTestProxy testsRootProxy) {
        if (testFrameworkName == null) {
            GeneralTestEventsProcessor.$$$reportNull$$$0(0);
        }
        if (testsRootProxy == null) {
            GeneralTestEventsProcessor.$$$reportNull$$$0(1);
        }
        this.myLocator = null;
        this.myListenerAdapters = new ArrayList<SMTRunnerEventsListener>();
        this.myTreeBuildBeforeStart = false;
        this.myBuildTreeRunnables = new ArrayList<Runnable>();
        this.myProject = project;
        this.myEventPublisher = (SMTRunnerEventsListener)project.getMessageBus().syncPublisher(SMTRunnerEventsListener.TEST_STATUS);
        this.myTestFrameworkName = testFrameworkName;
        this.myTransferToEDTQueue = new TransferToEDTQueue("SM queue", runnable2 -> {
            runnable2.run();
            return true;
        }, project.getDisposed());
        this.myTestsRootProxy = testsRootProxy;
    }

    public void onRootPresentationAdded(String rootName, String comment, String rootLocation) {
        this.addToInvokeLater(() -> {
            this.myTestsRootProxy.setPresentation(rootName);
            this.myTestsRootProxy.setComment(comment);
            this.myTestsRootProxy.setRootLocationUrl(rootLocation);
            if (this.myLocator != null) {
                this.myTestsRootProxy.setLocator(this.myLocator);
            }
        });
    }

    protected SMTestProxy createProxy(String testName, String locationHint, String metaInfo, String id, String parentNodeId) {
        return new SMTestProxy(testName, false, locationHint, metaInfo, false);
    }

    protected SMTestProxy createSuite(String suiteName, String locationHint, String metaInfo, String id, String parentNodeId) {
        return new SMTestProxy(suiteName, true, locationHint, metaInfo, false);
    }

    public void onSuiteTreeNodeAdded(String testName, String locationHint, String metaInfo, String id, String parentNodeId) {
        this.myTreeBuildBeforeStart = true;
        this.myBuildTreeRunnables.add(() -> {
            SMTestProxy testProxy = this.createProxy(testName, locationHint, metaInfo, id, parentNodeId);
            testProxy.setTreeBuildBeforeStart();
            if (this.myLocator != null) {
                testProxy.setLocator(this.myLocator);
            }
            this.myEventPublisher.onSuiteTreeNodeAdded(testProxy);
            for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
                adapter.onSuiteTreeNodeAdded(testProxy);
            }
            testProxy.getParent().setTreeBuildBeforeStart();
        });
    }

    public void onSuiteTreeStarted(String suiteName, String locationHint, String metaInfo, String id, String parentNodeId) {
        this.myTreeBuildBeforeStart = true;
        this.myBuildTreeRunnables.add(() -> {
            SMTestProxy newSuite = this.createSuite(suiteName, locationHint, metaInfo, id, parentNodeId);
            if (this.myLocator != null) {
                newSuite.setLocator(this.myLocator);
            }
            newSuite.setTreeBuildBeforeStart();
            this.myEventPublisher.onSuiteTreeStarted(newSuite);
            for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
                adapter.onSuiteTreeStarted(newSuite);
            }
        });
    }

    public void onSuiteTreeEnded(String suiteName) {
        if (this.myBuildTreeRunnables.size() > 100) {
            ArrayList<Runnable> runnables = new ArrayList<Runnable>(this.myBuildTreeRunnables);
            this.myBuildTreeRunnables.clear();
            this.processTreeBuildEvents(runnables);
        }
    }

    public void onBuildTreeEnded() {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>(this.myBuildTreeRunnables);
        this.myBuildTreeRunnables.clear();
        this.processTreeBuildEvents(runnables);
    }

    private void processTreeBuildEvents(List<Runnable> runnables) {
        this.addToInvokeLater(() -> {
            for (Runnable runnable2 : runnables) {
                runnable2.run();
            }
            runnables.clear();
        });
    }

    public abstract void onStartTesting();

    protected void fireOnTestingStarted(SMTestProxy.SMRootTestProxy node) {
        this.myEventPublisher.onTestingStarted(node);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onTestingStarted(node);
        }
    }

    public abstract void onTestsCountInSuite(int var1);

    protected void fireOnTestsCountInSuite(int count) {
        this.myEventPublisher.onTestsCountInSuite(count);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onTestsCountInSuite(count);
        }
    }

    public abstract void onTestStarted(@NotNull TestStartedEvent var1);

    protected void fireOnTestStarted(SMTestProxy testProxy) {
        this.myEventPublisher.onTestStarted(testProxy);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onTestStarted(testProxy);
        }
    }

    public abstract void onTestFinished(@NotNull TestFinishedEvent var1);

    protected void fireOnTestFinished(SMTestProxy testProxy) {
        this.myEventPublisher.onTestFinished(testProxy);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onTestFinished(testProxy);
        }
    }

    public abstract void onTestFailure(@NotNull TestFailedEvent var1);

    protected void fireOnTestFailed(SMTestProxy testProxy) {
        this.myEventPublisher.onTestFailed(testProxy);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onTestFailed(testProxy);
        }
    }

    public abstract void onTestIgnored(@NotNull TestIgnoredEvent var1);

    protected void fireOnTestIgnored(SMTestProxy testProxy) {
        this.myEventPublisher.onTestIgnored(testProxy);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onTestIgnored(testProxy);
        }
    }

    public abstract void onTestOutput(@NotNull TestOutputEvent var1);

    public abstract void onSuiteStarted(@NotNull TestSuiteStartedEvent var1);

    protected void fireOnSuiteStarted(SMTestProxy newSuite) {
        this.myEventPublisher.onSuiteStarted(newSuite);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onSuiteStarted(newSuite);
        }
    }

    public abstract void onSuiteFinished(@NotNull TestSuiteFinishedEvent var1);

    protected void fireOnSuiteFinished(SMTestProxy mySuite) {
        this.myEventPublisher.onSuiteFinished(mySuite);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onSuiteFinished(mySuite);
        }
    }

    public abstract void onUncapturedOutput(@NotNull String var1, Key var2);

    public abstract void onError(@NotNull String var1, @Nullable String var2, boolean var3);

    protected static void fireOnTestsReporterAttached(SMTestProxy.SMRootTestProxy rootNode) {
        rootNode.setTestsReporterAttached();
    }

    public void onFinishTesting() {
        this.stopEventProcessing();
    }

    protected void fireOnTestingFinished(SMTestProxy.SMRootTestProxy root) {
        this.myEventPublisher.onTestingFinished(root);
        for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
            adapter.onTestingFinished(root);
        }
    }

    public void onCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        this.addToInvokeLater(() -> {
            this.myEventPublisher.onCustomProgressTestsCategory(categoryName, testCount);
            for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
                adapter.onCustomProgressTestsCategory(categoryName, testCount);
            }
        });
    }

    public void onCustomProgressTestStarted() {
        this.addToInvokeLater(() -> {
            this.myEventPublisher.onCustomProgressTestStarted();
            for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
                adapter.onCustomProgressTestStarted();
            }
        });
    }

    public void onCustomProgressTestFinished() {
        this.addToInvokeLater(() -> {
            this.myEventPublisher.onCustomProgressTestFinished();
            for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
                adapter.onCustomProgressTestFinished();
            }
        });
    }

    public void onCustomProgressTestFailed() {
        this.addToInvokeLater(() -> {
            this.myEventPublisher.onCustomProgressTestFailed();
            for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
                adapter.onCustomProgressTestFailed();
            }
        });
    }

    public abstract void onTestsReporterAttached();

    public void setLocator(@NotNull SMTestLocator locator) {
        if (locator == null) {
            GeneralTestEventsProcessor.$$$reportNull$$$0(2);
        }
        this.myLocator = locator;
    }

    public void addEventsListener(@NotNull SMTRunnerEventsListener listener2) {
        if (listener2 == null) {
            GeneralTestEventsProcessor.$$$reportNull$$$0(3);
        }
        this.myListenerAdapters.add(listener2);
    }

    public abstract void setPrinterProvider(@NotNull TestProxyPrinterProvider var1);

    public void dispose() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                this.myTransferToEDTQueue.drain();
            });
        }
    }

    protected void disconnectListeners() {
        this.myListenerAdapters.clear();
    }

    public Condition getDisposedCondition() {
        return Condition.FALSE;
    }

    public void addToInvokeLater(Runnable runnable2) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!this.myProject.isDisposed()) {
                    runnable2.run();
                }
            });
        } else if (application.isHeadlessEnvironment() || SwingUtilities.isEventDispatchThread()) {
            runnable2.run();
        } else {
            this.myTransferToEDTQueue.offer((Object)runnable2);
        }
    }

    public void stopEventProcessing() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.myTransferToEDTQueue.drain();
        });
    }

    protected static <T> boolean isTreeComplete(Collection<T> runningTests, SMTestProxy.SMRootTestProxy rootNode) {
        if (!runningTests.isEmpty()) {
            return false;
        }
        List<? extends SMTestProxy> children2 = rootNode.getChildren();
        for (SMTestProxy sMTestProxy : children2) {
            if (sMTestProxy.isFinal() && !sMTestProxy.wasTerminated()) continue;
            return false;
        }
        return true;
    }

    protected void logProblem(String msg) {
        GeneralTestEventsProcessor.logProblem(LOG, msg, this.myTestFrameworkName);
    }

    protected void logProblem(String msg, boolean throwError) {
        GeneralTestEventsProcessor.logProblem(LOG, msg, throwError, this.myTestFrameworkName);
    }

    public static String getTFrameworkPrefix(String testFrameworkName) {
        return "[" + testFrameworkName + "]: ";
    }

    public static void logProblem(Logger log, String msg, String testFrameworkName) {
        GeneralTestEventsProcessor.logProblem(log, msg, SMTestRunnerConnectionUtil.isInDebugMode(), testFrameworkName);
    }

    public static void logProblem(Logger log, String msg, boolean throwError, String testFrameworkName) {
        String text = GeneralTestEventsProcessor.getTFrameworkPrefix(testFrameworkName) + msg;
        if (throwError) {
            log.error(text);
        } else {
            log.warn(text);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsRootProxy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/sm/runner/GeneralTestEventsProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setLocator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addEventsListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

