/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.AppTopics;
import com.intellij.ProjectTopics;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GeneratedSourceFileChangeTrackerImpl
extends GeneratedSourceFileChangeTracker {
    private final FileDocumentManager myDocumentManager;
    private final EditorNotifications myEditorNotifications;
    private final MergingUpdateQueue myCheckingQueue;
    private final Set<VirtualFile> myFilesToCheck = Collections.synchronizedSet(new HashSet());
    private final Set<VirtualFile> myEditedGeneratedFiles = Collections.synchronizedSet(new HashSet());

    public GeneratedSourceFileChangeTrackerImpl(Project project, FileDocumentManager documentManager, EditorNotifications editorNotifications) {
        super(project);
        this.myDocumentManager = documentManager;
        this.myEditorNotifications = editorNotifications;
        this.myCheckingQueue = new MergingUpdateQueue("Checking for changes in generated sources", 500, false, null, (Disposable)project, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    @Override
    public boolean isEditedGeneratedFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            GeneratedSourceFileChangeTrackerImpl.$$$reportNull$$$0(0);
        }
        return this.myEditedGeneratedFiles.contains(file2);
    }

    public void projectOpened() {
        final Update check = new Update("check for changes in generated files"){

            public void run() {
                GeneratedSourceFileChangeTrackerImpl.this.checkFiles();
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (GeneratedSourceFileChangeTrackerImpl.this.myProject.isDisposed()) {
                    return;
                }
                VirtualFile file2 = GeneratedSourceFileChangeTrackerImpl.this.myDocumentManager.getFile(e.getDocument());
                ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)GeneratedSourceFileChangeTrackerImpl.this.myProject);
                if (file2 != null && (fileIndex.isInContent(file2) || fileIndex.isInLibrary(file2))) {
                    GeneratedSourceFileChangeTrackerImpl.this.myFilesToCheck.add(file2);
                    GeneratedSourceFileChangeTrackerImpl.this.myCheckingQueue.queue(check);
                }
            }
        }, (Disposable)this.myProject);
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    3.$$$reportNull$$$0(1);
                }
                GeneratedSourceFileChangeTrackerImpl.this.myFilesToCheck.remove(file2);
                if (GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles.remove(file2)) {
                    GeneratedSourceFileChangeTrackerImpl.this.myEditorNotifications.updateNotifications(file2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl$3";
                objectArray[2] = "fileContentReloaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles.remove(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl$4";
                objectArray[2] = "fileClosed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                GeneratedSourceFileChangeTrackerImpl.this.myFilesToCheck.addAll(GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles);
                GeneratedSourceFileChangeTrackerImpl.this.myEditedGeneratedFiles.clear();
                GeneratedSourceFileChangeTrackerImpl.this.myCheckingQueue.queue(check);
            }
        });
        this.myCheckingQueue.activate();
    }

    public void projectClosed() {
        this.myCheckingQueue.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFiles() {
        VirtualFile[] files;
        Set<VirtualFile> set2 = this.myFilesToCheck;
        synchronized (set2) {
            files = this.myFilesToCheck.toArray(VirtualFile.EMPTY_ARRAY);
            this.myFilesToCheck.clear();
        }
        final ArrayList newEditedGeneratedFiles = new ArrayList();
        new ReadAction(){

            protected void run(@NotNull Result result2) {
                if (result2 == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (GeneratedSourceFileChangeTrackerImpl.this.myProject.isDisposed()) {
                    return;
                }
                for (VirtualFile file2 : files) {
                    if (!GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)GeneratedSourceFileChangeTrackerImpl.this.myProject)) continue;
                    newEditedGeneratedFiles.add(file2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl$6", "run"));
            }
        }.execute();
        if (!newEditedGeneratedFiles.isEmpty()) {
            this.myEditedGeneratedFiles.addAll(newEditedGeneratedFiles);
            this.myEditorNotifications.updateAllNotifications();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/GeneratedSourceFileChangeTrackerImpl", "isEditedGeneratedFile"));
    }
}

