/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateDirectoryOrPackageHandler
implements InputValidatorEx {
    @Nullable
    private final Project myProject;
    @NotNull
    private final PsiDirectory myDirectory;
    private final boolean myIsDirectory;
    @Nullable
    private PsiFileSystemItem myCreatedElement;
    @NotNull
    private final String myDelimiters;
    @Nullable
    private final Component myDialogParent;
    private String myErrorText;

    public CreateDirectoryOrPackageHandler(@Nullable Project project, @NotNull PsiDirectory directory, boolean isDirectory, @NotNull String delimiters) {
        if (directory == null) {
            CreateDirectoryOrPackageHandler.$$$reportNull$$$0(0);
        }
        if (delimiters == null) {
            CreateDirectoryOrPackageHandler.$$$reportNull$$$0(1);
        }
        this(project, directory, isDirectory, delimiters, null);
    }

    public CreateDirectoryOrPackageHandler(@Nullable Project project, @NotNull PsiDirectory directory, boolean isDirectory, @NotNull String delimiters, @Nullable Component dialogParent) {
        if (directory == null) {
            CreateDirectoryOrPackageHandler.$$$reportNull$$$0(2);
        }
        if (delimiters == null) {
            CreateDirectoryOrPackageHandler.$$$reportNull$$$0(3);
        }
        this.myCreatedElement = null;
        this.myProject = project;
        this.myDirectory = directory;
        this.myIsDirectory = isDirectory;
        this.myDelimiters = delimiters;
        this.myDialogParent = dialogParent;
    }

    public boolean checkInput(String inputString) {
        StringTokenizer tokenizer = new StringTokenizer(inputString, this.myDelimiters);
        VirtualFile vFile = this.myDirectory.getVirtualFile();
        boolean firstToken = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens() && (token.equals(".") || token.equals(".."))) {
                this.myErrorText = "Can't create a directory with name '" + token + "'";
                return false;
            }
            if (vFile != null) {
                if (firstToken && "~".equals(token)) {
                    VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
                    if (userHomeDir == null) {
                        this.myErrorText = "User home directory not found";
                        return false;
                    }
                    vFile = userHomeDir;
                } else if ("..".equals(token)) {
                    if ((vFile = vFile.getParent()) == null) {
                        this.myErrorText = "Not a valid directory";
                        return false;
                    }
                } else if (!".".equals(token)) {
                    VirtualFile child = vFile.findChild(token);
                    if (child != null) {
                        if (!child.isDirectory()) {
                            this.myErrorText = "A file with name '" + token + "' already exists";
                            return false;
                        }
                        if (!tokenizer.hasMoreTokens()) {
                            this.myErrorText = "A directory with name '" + token + "' already exists";
                            return false;
                        }
                    }
                    vFile = child;
                }
            }
            if (FileTypeManager.getInstance().isFileIgnored(token)) {
                this.myErrorText = "Trying to create a " + (this.myIsDirectory ? "directory" : "package") + " with an ignored name, the result will not be visible";
                return true;
            }
            if (!this.myIsDirectory && token.length() > 0 && !PsiDirectoryFactory.getInstance(this.myProject).isValidPackageName(token)) {
                this.myErrorText = "Not a valid package name, it will not be possible to create a Java class inside";
                return true;
            }
            firstToken = false;
        }
        this.myErrorText = null;
        return true;
    }

    public String getErrorText(String inputString) {
        return this.myErrorText;
    }

    public boolean canClose(String subDirName) {
        Boolean createFile;
        if (subDirName.length() == 0) {
            this.showErrorDialog(IdeBundle.message((String)"error.name.should.be.specified", (Object[])new Object[0]));
            return false;
        }
        boolean multiCreation = StringUtil.containsAnyChar((String)subDirName, (String)this.myDelimiters);
        if (!multiCreation) {
            try {
                this.myDirectory.checkCreateSubdirectory(subDirName);
            }
            catch (IncorrectOperationException ex) {
                this.showErrorDialog(CreateElementActionBase.filterMessage((String)ex.getMessage()));
                return false;
            }
        }
        if ((createFile = this.suggestCreatingFileInstead(subDirName)) == null) {
            return false;
        }
        this.doCreateElement(subDirName, createFile);
        return this.myCreatedElement != null;
    }

    @Nullable
    private Boolean suggestCreatingFileInstead(String subDirName) {
        FileType fileType;
        Boolean createFile = false;
        if (StringUtil.countChars((CharSequence)subDirName, (char)'.') == 1 && Registry.is((String)"ide.suggest.file.when.creating.filename.like.directory") && (fileType = CreateDirectoryOrPackageHandler.findFileTypeBoundToName(subDirName)) != null) {
            String message = "The name you entered looks like a file name. Do you want to create a file named " + subDirName + " instead?";
            int ec = Messages.showYesNoCancelDialog((Project)this.myProject, (String)message, (String)"File Name Detected", (String)"&Yes, create file", (String)("&No, create " + (this.myIsDirectory ? "directory" : "packages")), (String)CommonBundle.getCancelButtonText(), (Icon)fileType.getIcon());
            if (ec == 2) {
                createFile = null;
            }
            if (ec == 0) {
                createFile = true;
            }
        }
        return createFile;
    }

    @Nullable
    public static FileType findFileTypeBoundToName(String name) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(name);
        return fileType instanceof UnknownFileType ? null : fileType;
    }

    private void doCreateElement(String subDirName, boolean createFile) {
        Runnable command = () -> {
            Runnable run2 = () -> {
                String dirPath = this.myDirectory.getVirtualFile().getPresentableUrl();
                String actionName = IdeBundle.message((String)"progress.creating.directory", (Object[])new Object[]{dirPath, File.separator, subDirName});
                LocalHistoryAction action = LocalHistory.getInstance().startAction(actionName);
                try {
                    if (createFile) {
                        CreateFileAction.MkDirs mkdirs = new CreateFileAction.MkDirs(subDirName, this.myDirectory);
                        this.myCreatedElement = mkdirs.directory.createFile(mkdirs.newName);
                    } else {
                        this.createDirectories(subDirName);
                    }
                }
                catch (IncorrectOperationException ex) {
                    ApplicationManager.getApplication().invokeLater(() -> this.showErrorDialog(CreateElementActionBase.filterMessage((String)ex.getMessage())));
                }
                finally {
                    action.finish();
                }
            };
            ApplicationManager.getApplication().runWriteAction(run2);
        };
        CommandProcessor.getInstance().executeCommand(this.myProject, command, createFile ? IdeBundle.message((String)"command.create.file", (Object[])new Object[0]) : (this.myIsDirectory ? IdeBundle.message((String)"command.create.directory", (Object[])new Object[0]) : IdeBundle.message((String)"command.create.package", (Object[])new Object[0])), null);
    }

    private void showErrorDialog(String message) {
        String title = CommonBundle.getErrorTitle();
        Icon icon = Messages.getErrorIcon();
        if (this.myDialogParent != null) {
            Messages.showMessageDialog((Component)this.myDialogParent, (String)message, (String)title, (Icon)icon);
        } else {
            Messages.showMessageDialog((Project)this.myProject, (String)message, (String)title, (Icon)icon);
        }
    }

    protected void createDirectories(String subDirName) {
        this.myCreatedElement = DirectoryUtil.createSubdirectories(subDirName, this.myDirectory, this.myDelimiters);
    }

    @Nullable
    public PsiFileSystemItem getCreatedElement() {
        return this.myCreatedElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "directory";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "delimiters";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/actions/CreateDirectoryOrPackageHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

