/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarListWrapper;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.ui.NavBarUIManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarPopup
extends LightweightHint
implements Disposable {
    private static final String JBLIST_KEY = "OriginalList";
    private static final String DISPOSED_OBJECTS = "DISPOSED_OBJECTS";
    private final NavBarPanel myPanel;
    private final int myIndex;

    public NavBarPopup(NavBarPanel panel2, Object[] siblings, final int selectedIndex) {
        super(NavBarPopup.createPopupContent(panel2, siblings));
        this.myPanel = panel2;
        this.myIndex = selectedIndex;
        this.setFocusRequestor(this.getComponent());
        this.setForceShowAsPopup(true);
        panel2.installPopupHandler((JComponent)this.getList(), selectedIndex);
        this.getList().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            private void click(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                NavBarPopup.this.myPanel.getModel().setSelectedIndex(selectedIndex);
                if (e.isPopupTrigger()) {
                    return;
                }
                Object value = NavBarPopup.this.getList().getSelectedValue();
                if (value != null) {
                    NavBarPopup.this.myPanel.navigateInsideBar(value);
                }
            }
        });
    }

    @Override
    protected void onPopupCancel() {
        Object o;
        JComponent component = this.getComponent();
        if (component != null && (o = component.getClientProperty(JBLIST_KEY)) instanceof JComponent) {
            HintUpdateSupply.hideHint((JComponent)((JComponent)o));
        }
        for (Disposable disposable : (List)this.getList().getClientProperty((Object)DISPOSED_OBJECTS)) {
            Disposer.dispose((Disposable)disposable);
        }
        Disposer.dispose((Disposable)this);
    }

    public void show(NavBarItem item) {
        this.show(item, true);
    }

    private void show(NavBarItem item, boolean checkRepaint) {
        RelativePoint point = new RelativePoint((Component)((Object)item), new Point(0, item.getHeight()));
        Point p = point.getPoint((Component)this.myPanel);
        if (p.x == 0 && p.y == 0 && checkRepaint) {
            SwingUtilities.invokeLater(() -> {
                this.myPanel.getUpdateQueue().rebuildUi();
                SwingUtilities.invokeLater(() -> this.show(item, false));
            });
        } else {
            int offset = NavBarUIManager.getUI().getPopupOffset(item);
            this.show(this.myPanel, p.x - offset, p.y, this.myPanel, new HintHint(this.myPanel, p));
            JBList<?> list2 = this.getList();
            AccessibleContextUtil.setName(list2, (String)item.getText());
            if (0 <= this.myIndex && this.myIndex < list2.getItemsCount()) {
                ScrollingUtil.selectItem(list2, (int)this.myIndex);
            }
        }
        if (this.myPanel.isInFloatingMode()) {
            Window window = SwingUtilities.windowForComponent(this.getList());
            window.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    Window w = e.getOppositeWindow();
                    if (w != null && DialogWrapper.findInstance((Component)w.getComponent(0)) != null) {
                        NavBarPopup.this.myPanel.hideHint();
                    }
                }
            });
        }
    }

    public void dispose() {
    }

    private static JComponent createPopupContent(NavBarPanel panel2, Object[] siblings) {
        class MyList<E>
        extends JBList<E>
        implements DataProvider,
        Queryable {
            final /* synthetic */ NavBarPanel val$panel;

            MyList(NavBarPanel navBarPanel) {
                this.val$panel = navBarPanel;
            }

            public void putInfo(@NotNull Map<String, String> info) {
                if (info == null) {
                    MyList.$$$reportNull$$$0(0);
                }
                this.val$panel.putInfo(info);
            }

            @Nullable
            public Object getData(String dataId) {
                return this.val$panel.getDataImpl(dataId, () -> JBIterable.of((Object)this.getSelectedValuesList()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/ide/navigationToolbar/NavBarPopup$1MyList", "putInfo"));
            }
        }
        MyList list2 = new MyList(panel2);
        list2.setModel((ListModel)new CollectionListModel(siblings));
        HintUpdateSupply.installSimpleHintUpdateSupply(list2);
        ArrayList disposables = new ArrayList();
        list2.putClientProperty(DISPOSED_OBJECTS, disposables);
        list2.installCellRenderer(obj -> {
            NavBarItem navBarItem = new NavBarItem(panel2, obj, null);
            disposables.add(navBarItem);
            return navBarItem;
        });
        list2.setBorder(JBUI.Borders.empty((int)5));
        NavBarPopup.installMoveAction(list2, panel2, -1, 37);
        NavBarPopup.installMoveAction(list2, panel2, 1, 39);
        NavBarPopup.installEnterAction(list2, panel2, 10);
        NavBarPopup.installEscapeAction(list2, panel2, 27);
        JComponent component = ListWithFilter.wrap(list2, (JScrollPane)((Object)new NavBarListWrapper((JList)((Object)list2))), o -> panel2.getPresentation().getPresentableText(o));
        component.putClientProperty(JBLIST_KEY, (Object)list2);
        return component;
    }

    private static void installEnterAction(final JBList list2, final NavBarPanel panel2, int keyCode) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel2.navigateInsideBar(list2.getSelectedValue());
            }
        };
        list2.registerKeyboardAction((ActionListener)action, KeyStroke.getKeyStroke(keyCode, 0), 0);
    }

    private static void installEscapeAction(JBList list2, final NavBarPanel panel2, int keyCode) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel2.cancelPopup();
            }
        };
        list2.registerKeyboardAction((ActionListener)action, KeyStroke.getKeyStroke(keyCode, 0), 0);
    }

    @NotNull
    public JBList<?> getList() {
        JBList jBList = (JBList)this.getComponent().getClientProperty(JBLIST_KEY);
        if (jBList == null) {
            NavBarPopup.$$$reportNull$$$0(0);
        }
        return jBList;
    }

    private static void installMoveAction(JBList list2, final NavBarPanel panel2, final int direction, int keyCode) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel2.cancelPopup();
                panel2.shiftFocus(direction);
                panel2.restorePopup();
            }
        };
        list2.registerKeyboardAction((ActionListener)action, KeyStroke.getKeyStroke(keyCode, 0), 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/navigationToolbar/NavBarPopup", "getList"));
    }
}

