/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class DarculaButtonPainter
implements Border,
UIResource {
    private static final int myOffset = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            Rectangle r = new Rectangle(x, y, width, height);
            JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
            g2.translate(r.x, r.y);
            int diam = JBUI.scale((int)DarculaButtonUI.HELP_BUTTON_DIAMETER);
            float arc = JBUI.scale((float)2.0f);
            float lw = DarculaUIUtil.lw(g2);
            float bw = DarculaUIUtil.bw();
            g2.setPaint(this.getBorderColor(c));
            if (UIUtil.isHelpButton((Component)c)) {
                g2.draw(new Ellipse2D.Float((r.width - diam) / 2, (r.height - diam) / 2, diam, diam));
            } else {
                Path2D.Float border = new Path2D.Float(0);
                border.append(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc), false);
                border.append(new RoundRectangle2D.Float(bw + lw, bw + lw, (float)r.width - (bw + lw) * 2.0f, (float)r.height - (bw + lw) * 2.0f, arc - lw, arc - lw), false);
                g2.fill(border);
            }
            if (c.hasFocus()) {
                if (UIUtil.isHelpButton((Component)c)) {
                    DarculaUIUtil.paintFocusOval(g2, (float)((r.width - diam) / 2) + lw, (float)((r.height - diam) / 2) + lw, (float)diam - lw, (float)diam - lw);
                } else {
                    DarculaUIUtil.paintFocusBorder(g2, r.width, r.height, arc, true);
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    public Color getBorderColor(Component button) {
        return button.isEnabled() && DarculaButtonUI.isDefaultButton(button) ? new ColorUIResource(3891338) : new ColorUIResource(6185056);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (c.getParent() instanceof ActionToolbar) {
            return JBUI.insets((int)5, (int)14);
        }
        if (DarculaButtonUI.isSquare(c)) {
            return JBUI.insets((int)4).asUIResource();
        }
        if (UIUtil.isHelpButton((Component)c)) {
            return JBUI.insets((int)3).asUIResource();
        }
        if (DarculaButtonUI.isComboButton((JComponent)c)) {
            return JBUI.insets((int)5, (int)10, (int)5, (int)5).asUIResource();
        }
        return JBUI.insets((int)5, (int)14).asUIResource();
    }

    protected int getOffset() {
        return 4;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

