/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import sun.swing.SwingUtilities2;

public class DarculaProgressBarUI
extends BasicProgressBarUI {
    private static final Color REMAINDER_COLOR = new JBColor(() -> UIUtil.isUnderWin10LookAndFeel() ? Gray.xCC : new JBColor((Color)Gray.xC4, (Color)Gray.x55));
    private static final Color FINISHED_COLOR = new JBColor(() -> UIUtil.isUnderWin10LookAndFeel() ? new Color(30170) : new JBColor((Color)Gray.x80, (Color)Gray.xA0));
    private static final Color START_COLOR = new JBColor(() -> UIUtil.isUnderWin10LookAndFeel() ? new Color(7780600) : new JBColor((Color)Gray.xC4, (Color)Gray.x69));
    private static final Color END_COLOR = new JBColor(() -> UIUtil.isUnderWin10LookAndFeel() ? new Color(30170) : new JBColor((Color)Gray.x80, (Color)Gray.x83));
    private static final Color RED = new JBColor(14045007, 15157320);
    private static final Color RED_LIGHT = new JBColor(16486281, 16032416);
    private static final Color GREEN = new JBColor(3453297, 36688);
    private static final Color GREEN_LIGHT = new JBColor(8317093, 6145167);
    private static final int CYCLE_TIME_DEFAULT = 800;
    private static final int REPAINT_INTERVAL_DEFAULT = 50;
    private static final int CYCLE_TIME_SIMPLIFIED = 1000;
    private static final int REPAINT_INTERVAL_SIMPLIFIED = 500;
    private static final int DEFAULT_WIDTH = 4;

    public static ComponentUI createUI(JComponent c) {
        return new DarculaProgressBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        UIManager.put("ProgressBar.repaintInterval", DarculaProgressBarUI.isSimplified() ? 500 : 50);
        UIManager.put("ProgressBar.cycleTime", DarculaProgressBarUI.isSimplified() ? 1000 : 800);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Color endColor;
            Color startColor;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Rectangle r = new Rectangle(this.progressBar.getSize());
            if (c.isOpaque()) {
                g2.setColor(c.getParent().getBackground());
                g2.fill(r);
            }
            Insets i = this.progressBar.getInsets();
            JBInsets.removeFrom((Rectangle)r, (Insets)i);
            int orientation = this.progressBar.getOrientation();
            Color foreground = this.progressBar.getForeground();
            if (foreground == ColorProgressBar.RED) {
                startColor = RED;
                endColor = RED_LIGHT;
            } else if (foreground == ColorProgressBar.GREEN) {
                startColor = GREEN;
                endColor = GREEN_LIGHT;
            } else {
                startColor = this.getStartColor();
                endColor = this.getEndColor();
            }
            int pHeight = this.progressBar.getPreferredSize().height;
            int pWidth = this.progressBar.getPreferredSize().width;
            int yOffset = r.y + (r.height - pHeight) / 2;
            int xOffset = r.x + (r.width - pWidth) / 2;
            if (DarculaProgressBarUI.isSimplified()) {
                Color[] ca = new Color[]{startColor, endColor};
                int idx = 0;
                int delta = JBUI.scale((int)10);
                if (orientation == 0) {
                    float offset = r.x;
                    while (offset - (float)r.x < (float)r.width) {
                        g2.setPaint(ca[(this.getAnimationIndex() + idx++) % 2]);
                        g2.fill(new Rectangle2D.Float(offset, yOffset, delta, pHeight));
                        offset += (float)delta;
                    }
                } else {
                    float offset = r.y;
                    while (offset - (float)r.y < (float)r.height) {
                        g2.setPaint(ca[(this.getAnimationIndex() + idx++) % 2]);
                        g2.fill(new Rectangle2D.Float(xOffset, offset, delta, pWidth));
                        offset += (float)delta;
                    }
                }
            } else {
                Shape shape;
                int step = JBUI.scale((int)6);
                if (orientation == 0) {
                    shape = this.getShapedRect(r.x, yOffset, r.width, pHeight, pHeight);
                    yOffset = r.y + pHeight / 2;
                    g2.setPaint(new GradientPaint(r.x + this.getAnimationIndex() * step * 2, yOffset, startColor, r.x + this.getFrameCount() * step + this.getAnimationIndex() * step * 2, yOffset, endColor, true));
                } else {
                    shape = this.getShapedRect(xOffset, r.y, pWidth, r.height, pWidth);
                    xOffset = r.x + pWidth / 2;
                    g2.setPaint(new GradientPaint(xOffset, r.y + this.getAnimationIndex() * step * 2, startColor, xOffset, r.y + this.getFrameCount() * step + this.getAnimationIndex() * step * 2, endColor, true));
                }
                g2.fill(shape);
            }
            if (this.progressBar.isStringPainted()) {
                if (this.progressBar.getOrientation() == 0) {
                    this.paintString((Graphics2D)g, i.left, i.top, r.width, r.height, this.boxRect.x, this.boxRect.width);
                } else {
                    this.paintString((Graphics2D)g, i.left, i.top, r.width, r.height, this.boxRect.y, this.boxRect.height);
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected Color getStartColor() {
        return START_COLOR;
    }

    protected Color getEndColor() {
        return END_COLOR;
    }

    private void paintString(Graphics2D g, int x, int y, int w, int h, int fillStart, int amountFull) {
        String progressString = this.progressBar.getString();
        g.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g, progressString, x, y, w, h);
        Rectangle oldClip = g.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            g.setColor(this.getSelectionBackground());
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g, progressString, renderLocation.x, renderLocation.y);
            g.setColor(this.getSelectionForeground());
            g.clipRect(fillStart, y, amountFull, h);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g, progressString, renderLocation.x, renderLocation.y);
        } else {
            g.setColor(this.getSelectionBackground());
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g, progressString, x, y, w, h);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g, progressString, renderLocation.x, renderLocation.y);
            g.setColor(this.getSelectionForeground());
            g.clipRect(x, fillStart, w, amountFull);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g, progressString, renderLocation.x, renderLocation.y);
        }
        g.setClip(oldClip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Shape coloredShape;
            Shape fullShape;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Rectangle r = new Rectangle(this.progressBar.getSize());
            if (c.isOpaque()) {
                g2.setColor(c.getParent().getBackground());
                g2.fill(r);
            }
            Insets i = this.progressBar.getInsets();
            JBInsets.removeFrom((Rectangle)r, (Insets)i);
            int amountFull = this.getAmountFull(i, r.width, r.height);
            int orientation = this.progressBar.getOrientation();
            if (orientation == 0) {
                int pHeight = this.progressBar.getPreferredSize().height;
                int yOffset = r.y + (r.height - pHeight) / 2;
                fullShape = this.getShapedRect(r.x, yOffset, r.width, pHeight, pHeight);
                coloredShape = this.getShapedRect(r.x, yOffset, amountFull, pHeight, pHeight);
            } else {
                int pWidth = this.progressBar.getPreferredSize().width;
                int xOffset = r.x + (r.width - pWidth) / 2;
                fullShape = this.getShapedRect(xOffset, r.y, pWidth, r.height, pWidth);
                coloredShape = this.getShapedRect(xOffset, r.y, pWidth, amountFull, pWidth);
            }
            g2.setColor(this.getRemainderColor());
            g2.fill(fullShape);
            Color foreground = this.progressBar.getForeground();
            if (foreground == ColorProgressBar.RED) {
                g2.setColor(RED);
            } else if (foreground == ColorProgressBar.GREEN) {
                g2.setColor(GREEN);
            } else {
                g2.setColor(this.getFinishedColor());
            }
            g2.fill(coloredShape);
            if (this.progressBar.isStringPainted()) {
                this.paintString(g, i.left, i.top, r.width, r.height, amountFull, i);
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected Color getRemainderColor() {
        return REMAINDER_COLOR;
    }

    protected Color getFinishedColor() {
        return FINISHED_COLOR;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        if (!(c instanceof JProgressBar)) {
            return size;
        }
        if (((JProgressBar)c).getOrientation() == 0) {
            size.height = this.getStripeWidth();
        } else {
            size.width = this.getStripeWidth();
        }
        return size;
    }

    private int getStripeWidth() {
        Object ho = this.progressBar.getClientProperty("ProgressBar.stripeWidth");
        if (ho != null) {
            try {
                return JBUI.scale((int)Integer.parseInt(ho.toString()));
            }
            catch (NumberFormatException nfe) {
                return JBUI.scale((int)4);
            }
        }
        return JBUI.scale((int)4);
    }

    @Override
    protected int getBoxLength(int availableLength, int otherDimension) {
        return availableLength;
    }

    private Shape getShapedRect(float x, float y, float w, float h, float ar) {
        boolean flatEnds = UIUtil.isUnderWin10LookAndFeel() || this.progressBar.getClientProperty("ProgressBar.flatEnds") == Boolean.TRUE;
        return flatEnds ? new Rectangle2D.Float(x, y, w, h) : new RoundRectangle2D.Float(x, y, w, h, ar, ar);
    }

    private static boolean isSimplified() {
        return false;
    }
}

