/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.ui.ColorPanel;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class DarculaTextBorder
implements Border,
UIResource,
ErrorBorderCapable {
    @Override
    public Insets getBorderInsets(Component c) {
        if (c instanceof JTextField && c.getParent() instanceof ColorPanel) {
            return JBUI.insets((int)3, (int)3, (int)2, (int)2).asUIResource();
        }
        JBInsets.JBInsetsUIResource insets = JBUI.insets((int)5, (int)9).asUIResource();
        TextFieldWithPopupHandlerUI.updateBorderInsets(c, (Insets)insets);
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (((JComponent)c).getClientProperty("JTextField.Search.noBorderRing") == Boolean.TRUE) {
            return;
        }
        Rectangle r = new Rectangle(x, y, width, height);
        if (TextFieldWithPopupHandlerUI.isSearchField(c)) {
            this.paintSearchArea((Graphics2D)g, r, (JTextComponent)c, false);
        } else {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
                g2.translate(r.x, r.y);
                Path2D.Float border = new Path2D.Float(0);
                float lw = this.lw(g2);
                float bw = this.bw();
                border.append(new Rectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f), false);
                border.append(new Rectangle2D.Float(bw + lw, bw + lw, (float)r.width - (bw + lw) * 2.0f, (float)r.height - (bw + lw) * 2.0f), false);
                boolean editable = !(c instanceof JTextComponent) || ((JTextComponent)c).isEditable();
                g2.setColor(this.getOutlineColor(c.isEnabled() && editable));
                g2.fill(border);
                if (c.getParent() instanceof JComboBox) {
                    return;
                }
                this.paint(c, g2, r.width, r.height, 0.0f);
            }
            finally {
                g2.dispose();
            }
        }
    }

    protected void paint(Component c, Graphics2D g2, int width, int height, float arc) {
        this.clipForBorder(c, g2, width, height);
        Object op = ((JComponent)c).getClientProperty("JComponent.outline");
        if (op != null) {
            DarculaUIUtil.paintOutlineBorder(g2, width, height, arc, this.isSymmetric(), this.isFocused(c), DarculaUIUtil.Outline.valueOf(op.toString()));
        } else if (this.isFocused(c)) {
            DarculaUIUtil.paintFocusBorder(g2, width, height, arc, this.isSymmetric());
        }
    }

    protected void paintSearchArea(Graphics2D g, Rectangle r, JTextComponent c, boolean fillBackground) {
        DarculaTextBorder.paintDarculaSearchArea(g, r, c, fillBackground);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintDarculaSearchArea(Graphics2D g, Rectangle r, JTextComponent c, boolean fillBackground) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
            g2.translate(r.x, r.y);
            float arc = JBUI.scale((float)6.0f);
            float lw = DarculaUIUtil.lw(g);
            float bw = DarculaUIUtil.bw();
            RoundRectangle2D.Float outerShape = new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc);
            if (fillBackground) {
                g2.setColor(c.getBackground());
                g2.fill(outerShape);
            }
            Path2D.Float path = new Path2D.Float(0);
            path.append(outerShape, false);
            path.append(new RoundRectangle2D.Float(bw + lw, bw + lw, (float)r.width - (bw + lw) * 2.0f, (float)r.height - (bw + lw) * 2.0f, arc - lw, arc - lw), false);
            g2.setColor(DarculaUIUtil.getOutlineColor(c.isEnabled() && c.isEditable()));
            g2.fill(path);
            if (c.hasFocus() && c.getClientProperty("JTextField.Search.noBorderRing") != Boolean.TRUE) {
                DarculaUIUtil.paintFocusBorder(g2, r.width, r.height, arc, true);
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected boolean isFocused(Component c) {
        return c instanceof JScrollPane ? ((JScrollPane)c).getViewport().getView().hasFocus() : c.hasFocus();
    }

    protected void clipForBorder(Component c, Graphics2D g2, int width, int height) {
        Area area = new Area(new Rectangle2D.Float(0.0f, 0.0f, width, height));
        float lw = this.lw(g2);
        float bw = this.bw();
        area.subtract(new Area(new Rectangle2D.Float(bw + lw, bw + lw, (float)width - (bw + lw) * 2.0f, (float)height - (bw + lw) * 2.0f)));
        area.intersect(new Area(g2.getClip()));
        g2.setClip(area);
    }

    protected boolean isSymmetric() {
        return true;
    }

    protected float lw(Graphics2D g2) {
        return DarculaUIUtil.lw(g2);
    }

    protected float bw() {
        return DarculaUIUtil.bw();
    }

    protected Color getOutlineColor(boolean enabled) {
        return DarculaUIUtil.getOutlineColor(enabled);
    }
}

