/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaCheckBoxUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WinIntelliJCheckBoxUI
extends DarculaCheckBoxUI {
    private static final Icon DEFAULT_ICON = ((EmptyIcon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)13))).asUIResource();

    public static ComponentUI createUI(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        b.setRolloverEnabled(true);
        return new WinIntelliJCheckBoxUI();
    }

    @Override
    protected void drawCheckIcon(JComponent c, Graphics2D g, AbstractButton b, Rectangle iconRect, boolean selected, boolean enabled) {
        ButtonModel bm = b.getModel();
        boolean focused = c.hasFocus() || bm.isRollover() || WinIntelliJCheckBoxUI.isCellRollover(b);
        boolean pressed = bm.isPressed() || WinIntelliJCheckBoxUI.isCellPressed(b);
        String iconName = this.isIndeterminate(b) ? "checkBoxIndeterminate" : "checkBox";
        Icon icon = MacIntelliJIconCache.getIcon(iconName, false, selected || this.isIndeterminate(b), focused, enabled, pressed);
        if (icon != null) {
            icon.paintIcon(c, g, iconRect.x, iconRect.y + JBUI.scale((int)1));
        }
    }

    private static boolean isCellRollover(AbstractButton checkBox) {
        Rectangle cellPosition = (Rectangle)checkBox.getClientProperty("JCheckBox.rollOver.rectangle");
        return cellPosition != null && cellPosition.getBounds().equals(checkBox.getBounds());
    }

    private static boolean isCellPressed(AbstractButton checkBox) {
        Rectangle cellPosition = (Rectangle)checkBox.getClientProperty("JCheckBox.pressed.rectangle");
        return cellPosition != null && cellPosition.getBounds().equals(checkBox.getBounds());
    }

    @Override
    public Icon getDefaultIcon() {
        return DEFAULT_ICON;
    }
}

