/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.WeakList;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class UndoRedoStacksHolder {
    private final Key<LinkedList<UndoableGroup>> STACK_IN_DOCUMENT_KEY = Key.create((String)"STACK_IN_DOCUMENT_KEY");
    private final boolean myUndo;
    private final LinkedList<UndoableGroup> myGlobalStack = new LinkedList();
    private final THashMap<DocumentReference, LinkedList<UndoableGroup>> myDocumentStacks = new THashMap();
    private final Collection<Document> myDocumentsWithStacks = new WeakList();
    private final Collection<VirtualFile> myNonlocalVirtualFilesWithStacks = new WeakList();

    public UndoRedoStacksHolder(boolean isUndo) {
        this.myUndo = isUndo;
    }

    @NotNull
    LinkedList<UndoableGroup> getStack(@NotNull DocumentReference r) {
        if (r == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(0);
        }
        LinkedList<UndoableGroup> linkedList = r.getFile() != null ? this.doGetStackForFile(r) : this.doGetStackForDocument(r);
        if (linkedList == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(1);
        }
        return linkedList;
    }

    @NotNull
    private LinkedList<UndoableGroup> doGetStackForFile(@NotNull DocumentReference r) {
        LinkedList result2;
        VirtualFile file2;
        if (r == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(2);
        }
        if (!(file2 = r.getFile()).isInLocalFileSystem()) {
            result2 = this.addWeaklyTrackedEmptyStack(file2, this.myNonlocalVirtualFilesWithStacks);
        } else {
            result2 = (LinkedList)this.myDocumentStacks.get((Object)r);
            if (result2 == null) {
                result2 = new LinkedList();
                this.myDocumentStacks.put((Object)r, result2);
            }
        }
        LinkedList linkedList = result2;
        if (linkedList == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(3);
        }
        return linkedList;
    }

    @NotNull
    private LinkedList<UndoableGroup> doGetStackForDocument(@NotNull DocumentReference r) {
        if (r == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(4);
        }
        LinkedList<UndoableGroup> linkedList = this.addWeaklyTrackedEmptyStack(r.getDocument(), this.myDocumentsWithStacks);
        if (linkedList == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(5);
        }
        return linkedList;
    }

    @NotNull
    private <T extends UserDataHolder> LinkedList<UndoableGroup> addWeaklyTrackedEmptyStack(@NotNull T holder, @NotNull Collection<T> allHolders) {
        LinkedList result2;
        if (holder == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(6);
        }
        if (allHolders == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(7);
        }
        if ((result2 = (LinkedList)holder.getUserData(this.STACK_IN_DOCUMENT_KEY)) == null) {
            result2 = new LinkedList();
            holder.putUserData(this.STACK_IN_DOCUMENT_KEY, result2);
            allHolders.add(holder);
        }
        LinkedList linkedList = result2;
        if (linkedList == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(8);
        }
        return linkedList;
    }

    boolean canBeUndoneOrRedone(@NotNull Collection<DocumentReference> refs) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(9);
        }
        if (refs.isEmpty()) {
            return !this.myGlobalStack.isEmpty() && this.myGlobalStack.getLast().isValid();
        }
        for (DocumentReference each : refs) {
            if (this.getStack(each).isEmpty() || !this.getStack(each).getLast().isValid()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    UndoableGroup getLastAction(@NotNull Collection<DocumentReference> refs) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(10);
        }
        if (refs.isEmpty()) {
            UndoableGroup undoableGroup = this.myGlobalStack.getLast();
            if (undoableGroup == null) {
                UndoRedoStacksHolder.$$$reportNull$$$0(11);
            }
            return undoableGroup;
        }
        UndoableGroup mostRecentAction = null;
        int mostRecentDocTimestamp = 0;
        for (DocumentReference each : refs) {
            LinkedList<UndoableGroup> stack = this.getStack(each);
            if (stack.isEmpty()) continue;
            UndoableGroup lastAction = stack.getLast();
            int timestamp = lastAction.getCommandTimestamp();
            if (mostRecentAction != null && (!lastAction.isTemporary() || mostRecentAction.isTemporary()) && (lastAction.isTemporary() != mostRecentAction.isTemporary() || !(this.myUndo ? timestamp > mostRecentDocTimestamp : timestamp < mostRecentDocTimestamp))) continue;
            mostRecentAction = lastAction;
            mostRecentDocTimestamp = timestamp;
        }
        UndoableGroup undoableGroup = mostRecentAction;
        if (undoableGroup == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(12);
        }
        return undoableGroup;
    }

    @NotNull
    Set<DocumentReference> collectClashingActions(@NotNull UndoableGroup group) {
        UndoableGroup last;
        if (group == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(13);
        }
        THashSet result2 = new THashSet();
        for (DocumentReference each : group.getAffectedDocuments()) {
            UndoableGroup last2 = this.getStack(each).peekLast();
            if (last2 == null || last2 == group) continue;
            result2.addAll(last2.getAffectedDocuments());
        }
        if (group.isGlobal() && (last = this.myGlobalStack.peekLast()) != null && last != group) {
            result2.addAll(last.getAffectedDocuments());
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(14);
        }
        return tHashSet;
    }

    void addToStacks(@NotNull UndoableGroup group) {
        if (group == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(15);
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(group)) {
            this.doAddToStack(each, group, each == this.myGlobalStack ? UndoManagerImpl.getGlobalUndoLimit() : UndoManagerImpl.getDocumentUndoLimit());
        }
    }

    private void doAddToStack(@NotNull LinkedList<UndoableGroup> stack, @NotNull UndoableGroup group, int limit) {
        if (stack == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(16);
        }
        if (group == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(17);
        }
        if (!group.isUndoable() && stack.isEmpty()) {
            return;
        }
        stack.add(group);
        while (stack.size() > limit) {
            this.clearStacksFrom(stack.getFirst());
        }
    }

    void removeFromStacks(@NotNull UndoableGroup group) {
        if (group == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(18);
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(group)) {
            assert (each.getLast() == group);
            each.removeLast();
        }
    }

    void clearStacks(boolean clearGlobal, @NotNull Set<DocumentReference> refs) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(19);
        }
        for (LinkedList<UndoableGroup> each2 : this.getAffectedStacks(clearGlobal, refs)) {
            while (!each2.isEmpty()) {
                this.clearStacksFrom(each2.getLast());
            }
        }
        this.myDocumentStacks.entrySet().removeIf(each -> ((LinkedList)each.getValue()).isEmpty());
        this.myDocumentStacks.compact();
        this.cleanWeaklyTrackedEmptyStacks(this.myDocumentsWithStacks);
        this.cleanWeaklyTrackedEmptyStacks(this.myNonlocalVirtualFilesWithStacks);
    }

    void convertTemporaryActionsToPermanent(boolean global, @NotNull Set<DocumentReference> affectedRefs) {
        if (affectedRefs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(20);
        }
        for (LinkedList<UndoableGroup> stack : this.getAffectedStacks(global, affectedRefs)) {
            UndoableGroup group;
            for (int i = stack.size() - 1; i >= 0 && (group = stack.get(i)).isTemporary(); --i) {
                group.makePermanent();
            }
        }
    }

    private <T extends UserDataHolder> void cleanWeaklyTrackedEmptyStacks(@NotNull Collection<T> stackHolders) {
        if (stackHolders == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(21);
        }
        THashSet holdersToDrop = new THashSet();
        for (UserDataHolder holder : stackHolders) {
            List stack = (List)holder.getUserData(this.STACK_IN_DOCUMENT_KEY);
            if (stack == null || !stack.isEmpty()) continue;
            holder.putUserData(this.STACK_IN_DOCUMENT_KEY, null);
            holdersToDrop.add(holder);
        }
        stackHolders.removeAll((Collection<?>)holdersToDrop);
    }

    private void clearStacksFrom(@NotNull UndoableGroup from) {
        if (from == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(22);
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(from)) {
            int pos = each.indexOf(from);
            if (pos == -1) continue;
            if (pos > 0) {
                int top = each.size() - pos;
                this.clearStacksFrom(each.get(pos - 1));
                assert (each.size() == top && each.indexOf(from) == 0);
            }
            each.removeFirst();
        }
    }

    @NotNull
    private List<LinkedList<UndoableGroup>> getAffectedStacks(@NotNull UndoableGroup group) {
        if (group == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(23);
        }
        List<LinkedList<UndoableGroup>> list2 = this.getAffectedStacks(group.isGlobal(), group.getAffectedDocuments());
        if (list2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(24);
        }
        return list2;
    }

    @NotNull
    private List<LinkedList<UndoableGroup>> getAffectedStacks(boolean global, @NotNull Collection<DocumentReference> refs) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(25);
        }
        ArrayList<LinkedList<UndoableGroup>> result2 = new ArrayList<LinkedList<UndoableGroup>>(refs.size() + 1);
        if (global) {
            result2.add(this.myGlobalStack);
        }
        for (DocumentReference each : refs) {
            result2.add(this.getStack(each));
        }
        ArrayList<LinkedList<UndoableGroup>> arrayList = result2;
        if (arrayList == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    void clearAllStacksInTests() {
        this.clearStacks(true, this.getAffectedDocuments());
        this.myGlobalStack.clear();
        this.myDocumentStacks.clear();
        this.myDocumentsWithStacks.clear();
        this.myNonlocalVirtualFilesWithStacks.clear();
    }

    void collectAllAffectedDocuments(@NotNull Collection<DocumentReference> result2) {
        if (result2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(27);
        }
        for (UndoableGroup each : this.myGlobalStack) {
            result2.addAll(each.getAffectedDocuments());
        }
        this.collectLocalAffectedDocuments(result2);
    }

    private void collectLocalAffectedDocuments(@NotNull Collection<DocumentReference> result2) {
        if (result2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(28);
        }
        result2.addAll(this.myDocumentStacks.keySet());
        DocumentReferenceManager documentReferenceManager = DocumentReferenceManager.getInstance();
        for (Document document : this.myDocumentsWithStacks) {
            result2.add(documentReferenceManager.create(document));
        }
        for (VirtualFile virtualFile : this.myNonlocalVirtualFilesWithStacks) {
            result2.add(documentReferenceManager.create(virtualFile));
        }
    }

    @NotNull
    private Set<DocumentReference> getAffectedDocuments() {
        THashSet result2 = new THashSet();
        this.collectAllAffectedDocuments((Collection<DocumentReference>)result2);
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(29);
        }
        return tHashSet;
    }

    int getLastCommandTimestamp(@NotNull DocumentReference r) {
        LinkedList<UndoableGroup> stack;
        if (r == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(30);
        }
        if ((stack = this.getStack(r)).isEmpty()) {
            return 0;
        }
        return Math.max(stack.getFirst().getCommandTimestamp(), stack.getLast().getCommandTimestamp());
    }

    void invalidateActionsFor(@NotNull DocumentReference ref) {
        if (ref == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(31);
        }
        for (List list2 : this.getAffectedStacks(true, Collections.singleton(ref))) {
            for (UndoableGroup eachGroup : list2) {
                eachGroup.invalidateActionsFor(ref);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 24: 
            case 26: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 24: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 24: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoRedoStacksHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allHolders";
                break;
            }
            case 9: 
            case 10: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedRefs";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackHolders";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoRedoStacksHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStack";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetStackForFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetStackForDocument";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addWeaklyTrackedEmptyStack";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClashingActions";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedStacks";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedDocuments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStack";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 24: 
            case 26: 
            case 29: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doGetStackForFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doGetStackForDocument";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addWeaklyTrackedEmptyStack";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canBeUndoneOrRedone";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLastAction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectClashingActions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addToStacks";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doAddToStack";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeFromStacks";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "clearStacks";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "convertTemporaryActionsToPermanent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "cleanWeaklyTrackedEmptyStacks";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "clearStacksFrom";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedStacks";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectAllAffectedDocuments";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectLocalAffectedDocuments";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommandTimestamp";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "invalidateActionsFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 24: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

