/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.TrackingPathMacroSubstitutorImpl;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class BasePathMacroManager
extends PathMacroManager {
    private PathMacrosImpl myPathMacros;

    public BasePathMacroManager(@Nullable PathMacros pathMacros) {
        this.myPathMacros = (PathMacrosImpl)pathMacros;
    }

    protected static void addFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result2, @NotNull String macroName, @Nullable @SystemIndependent String path) {
        if (result2 == null) {
            BasePathMacroManager.$$$reportNull$$$0(0);
        }
        if (macroName == null) {
            BasePathMacroManager.$$$reportNull$$$0(1);
        }
        if (path != null) {
            BasePathMacroManager.doAddFileHierarchyReplacements(result2, StringUtil.trimEnd((String)path, (String)"/"), '$' + macroName + '$');
        }
    }

    private static void doAddFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result2, @NotNull String path, @NotNull String macro) {
        String parentPath;
        if (result2 == null) {
            BasePathMacroManager.$$$reportNull$$$0(2);
        }
        if (path == null) {
            BasePathMacroManager.$$$reportNull$$$0(3);
        }
        if (macro == null) {
            BasePathMacroManager.$$$reportNull$$$0(4);
        }
        if (!(parentPath = PathUtilRt.getParentPath((String)path)).isEmpty()) {
            BasePathMacroManager.doAddFileHierarchyReplacements(result2, parentPath, macro + "/..");
        }
        result2.put(macro, path);
    }

    protected static void addFileHierarchyReplacements(ReplacePathToMacroMap result2, String macroName, @Nullable String path, @Nullable String stopAt) {
        if (path == null) {
            return;
        }
        String macro = '$' + macroName + '$';
        path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)path), (String)"/");
        boolean overwrite = true;
        while (StringUtil.isNotEmpty((String)path) && path.contains("/")) {
            result2.addReplacement(path, macro, overwrite);
            if (path.equals(stopAt)) break;
            macro = macro + "/..";
            overwrite = false;
            path = StringUtil.getPackageName((String)path, (char)'/');
        }
    }

    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result2 = new ExpandMacroToPathMap();
        this.getPathMacros().addMacroExpands(result2);
        for (Map.Entry entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result2.addMacroExpand((String)entry.getKey(), (String)entry.getValue());
        }
        ExpandMacroToPathMap expandMacroToPathMap = result2;
        if (expandMacroToPathMap == null) {
            BasePathMacroManager.$$$reportNull$$$0(5);
        }
        return expandMacroToPathMap;
    }

    @NotNull
    protected ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result2 = new ReplacePathToMacroMap();
        this.getPathMacros().addMacroReplacements(result2);
        for (Map.Entry entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result2.addMacroReplacement((String)entry.getValue(), (String)entry.getKey());
        }
        ReplacePathToMacroMap replacePathToMacroMap = result2;
        if (replacePathToMacroMap == null) {
            BasePathMacroManager.$$$reportNull$$$0(6);
        }
        return replacePathToMacroMap;
    }

    @Override
    @NotNull
    public TrackingPathMacroSubstitutor createTrackingSubstitutor() {
        TrackingPathMacroSubstitutorImpl trackingPathMacroSubstitutorImpl = new TrackingPathMacroSubstitutorImpl(this);
        if (trackingPathMacroSubstitutorImpl == null) {
            BasePathMacroManager.$$$reportNull$$$0(7);
        }
        return trackingPathMacroSubstitutorImpl;
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    public String expandPath(@Nullable String text) {
        if (StringUtil.isEmpty((String)text)) {
            return text;
        }
        return this.getExpandMacroMap().substitute(text, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public String collapsePath(@Nullable String text, boolean recursively) {
        if (StringUtil.isEmpty((String)text)) {
            return text;
        }
        return this.getReplacePathMap().substitute(text, SystemInfo.isFileSystemCaseSensitive, recursively);
    }

    @Override
    public void expandPaths(@NotNull Element element) {
        if (element == null) {
            BasePathMacroManager.$$$reportNull$$$0(8);
        }
        this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePaths(@NotNull Element element, boolean recursively) {
        if (element == null) {
            BasePathMacroManager.$$$reportNull$$$0(9);
        }
        BasePathMacroManager.collapsePaths(element, recursively, this.getReplacePathMap());
    }

    public static void collapsePaths(@NotNull Element element, boolean recursively, @NotNull ReplacePathToMacroMap map) {
        if (element == null) {
            BasePathMacroManager.$$$reportNull$$$0(10);
        }
        if (map == null) {
            BasePathMacroManager.$$$reportNull$$$0(11);
        }
        map.substitute(element, SystemInfo.isFileSystemCaseSensitive, recursively, Holder.FILTER);
    }

    @NotNull
    private PathMacrosImpl getPathMacros() {
        if (this.myPathMacros == null) {
            this.myPathMacros = PathMacrosImpl.getInstanceEx();
        }
        PathMacrosImpl pathMacrosImpl = this.myPathMacros;
        if (pathMacrosImpl == null) {
            BasePathMacroManager.$$$reportNull$$$0(12);
        }
        return pathMacrosImpl;
    }

    protected static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        return path1 != null && path2 != null && FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)path1), (String)FileUtil.toSystemIndependentName((String)path2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macro";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/BasePathMacroManager";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/BasePathMacroManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandMacroMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacePathMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrackingSubstitutor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMacros";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFileHierarchyReplacements";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doAddFileHierarchyReplacements";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expandPaths";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collapsePaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static final CompositePathMacroFilter FILTER = new CompositePathMacroFilter((PathMacroFilter[])Extensions.getExtensions(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME));

        private Holder() {
        }
    }
}

