/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.NonHideableIconGutterMark;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.GutterMarkPreprocessor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DisplayedFoldingAnchor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingAnchorsOverlayStrategy;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntFunction;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorGutterComponentImpl
extends EditorGutterComponentEx
implements MouseListener,
MouseMotionListener,
DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorGutterComponentImpl");
    private static final int START_ICON_AREA_WIDTH = JBUI.scale((int)17);
    private static final int FREE_PAINTERS_LEFT_AREA_WIDTH = JBUI.scale((int)8);
    private static final int FREE_PAINTERS_RIGHT_AREA_WIDTH = JBUI.scale((int)5);
    private static final int GAP_BETWEEN_ICONS = JBUI.scale((int)3);
    private static final int GAP_BETWEEN_AREAS = JBUI.scale((int)5);
    private static final int GAP_BETWEEN_ANNOTATIONS = JBUI.scale((int)5);
    private static final TooltipGroup GUTTER_TOOLTIP_GROUP = new TooltipGroup("GUTTER_TOOLTIP_GROUP", 0);
    private final EditorImpl myEditor;
    private final FoldingAnchorsOverlayStrategy myAnchorsDisplayStrategy;
    @Nullable
    private TIntObjectHashMap<List<GutterMark>> myLineToGutterRenderers;
    private int myStartIconAreaWidth;
    private int myIconsAreaWidth;
    private int myLineNumberAreaWidth;
    private int myAdditionalLineNumberAreaWidth;
    private FoldRegion myActiveFoldRegion;
    private int myTextAnnotationGuttersSize;
    private int myTextAnnotationExtraSize;
    private TIntArrayList myTextAnnotationGutterSizes;
    private ArrayList<TextAnnotationGutterProvider> myTextAnnotationGutters;
    private final Map<TextAnnotationGutterProvider, EditorGutterAction> myProviderToListener;
    private String myLastGutterToolTip;
    @NotNull
    private TIntFunction myLineNumberConvertor;
    @Nullable
    private TIntFunction myAdditionalLineNumberConvertor;
    private boolean myShowDefaultGutterPopup;
    @Nullable
    private ActionGroup myCustomGutterPopupGroup;
    private final TIntObjectHashMap<Color> myTextFgColors;
    private boolean myPaintBackground;
    private boolean myLeftFreePaintersAreaShown;
    private boolean myRightFreePaintersAreaShown;
    private boolean myForceLeftFreePaintersAreaShown;
    private boolean myForceRightFreePaintersAreaShown;
    private int myLastNonDumbModeIconAreaWidth;
    boolean myDnDInProgress;

    EditorGutterComponentImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(0);
        }
        this.myStartIconAreaWidth = START_ICON_AREA_WIDTH;
        this.myTextAnnotationGutterSizes = new TIntArrayList();
        this.myTextAnnotationGutters = new ArrayList();
        this.myProviderToListener = new HashMap<TextAnnotationGutterProvider, EditorGutterAction>();
        this.myLineNumberConvertor = value -> value;
        this.myShowDefaultGutterPopup = true;
        this.myTextFgColors = new TIntObjectHashMap();
        this.myPaintBackground = true;
        this.myEditor = editor;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.installDnD();
        }
        this.setOpaque(true);
        this.myAnchorsDisplayStrategy = new FoldingAnchorsOverlayStrategy(editor);
        Project project = this.myEditor.getProject();
        if (project != null) {
            project.getMessageBus().connect(this.myEditor.getDisposable()).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void exitDumbMode() {
                    EditorGutterComponentImpl.this.updateSize();
                }
            });
        }
    }

    private void installDnD() {
        DnDSupport.createBuilder((JComponent)this).setBeanProvider(info -> {
            GutterMark renderer = this.getGutterRenderer(info.getPoint());
            if (renderer instanceof GutterIconRenderer && ((GutterIconRenderer)renderer).getDraggableObject() != null && (info.isCopy() || info.isMove())) {
                this.myDnDInProgress = true;
                return new DnDDragStartBean((Object)renderer);
            }
            return null;
        }).setDropHandler(e -> {
            Transferable transferable;
            Object attachedObject = e.getAttachedObject();
            if (attachedObject instanceof GutterIconRenderer && this.checkDumbAware(attachedObject)) {
                int line;
                GutterDraggableObject draggableObject = ((GutterIconRenderer)attachedObject).getDraggableObject();
                if (draggableObject != null && (line = this.convertPointToLineNumber(e.getPoint())) != -1) {
                    draggableObject.copy(line, this.myEditor.getVirtualFile(), e.getAction().getActionId());
                }
            } else if (attachedObject instanceof DnDNativeTarget.EventInfo && this.myEditor.getSettings().isDndEnabled() && (transferable = ((DnDNativeTarget.EventInfo)attachedObject).getTransferable()) != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                EditorImpl.handleDrop(this.myEditor, transferable, e.getAction().getActionId());
            }
            this.myDnDInProgress = false;
        }).setTargetChecker(e -> {
            int line;
            Transferable transferable;
            Object attachedObject = e.getAttachedObject();
            if (attachedObject instanceof GutterIconRenderer && this.checkDumbAware(attachedObject)) {
                int line2;
                GutterDraggableObject draggableObject = ((GutterIconRenderer)attachedObject).getDraggableObject();
                if (draggableObject != null && (line2 = this.convertPointToLineNumber(e.getPoint())) != -1) {
                    e.setDropPossible(true);
                    e.setCursor(draggableObject.getCursor(line2, e.getAction().getActionId()));
                }
            } else if (attachedObject instanceof DnDNativeTarget.EventInfo && this.myEditor.getSettings().isDndEnabled() && (transferable = ((DnDNativeTarget.EventInfo)attachedObject).getTransferable()) != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && (line = this.convertPointToLineNumber(e.getPoint())) != -1) {
                e.setDropPossible(true);
                this.myEditor.getCaretModel().moveToOffset(this.myEditor.getDocument().getLineStartOffset(line));
            }
            return true;
        }).setImageProvider((Function)((NullableFunction)info -> {
            boolean inUserScale = SystemInfo.isWindows ? !UIUtil.isJreHiDPI((Component)this.myEditor.getComponent()) : true;
            BufferedImage image = ImageUtil.toBufferedImage((Image)this.getDragImage(this.getGutterRenderer(info.getPoint())), (boolean)inUserScale);
            return new DnDImage((Image)image, new Point(((Image)image).getWidth(null) / 2, ((Image)image).getHeight(null) / 2));
        })).enableAsNativeTarget().install();
    }

    Image getDragImage(GutterMark renderer) {
        return IconUtil.toImage((Icon)this.scaleIcon(renderer.getIcon()));
    }

    private void fireResized() {
        this.processComponentEvent(new ComponentEvent(this, 101));
    }

    @Override
    public Dimension getPreferredSize() {
        int w = this.getFoldingAreaOffset() + this.getFoldingAreaWidth();
        Dimension size = new Dimension(w, this.myEditor.getPreferredHeight());
        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
        return size;
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.reinitSettings();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.reinitSettings();
    }

    public void reinitSettings() {
        this.updateSize(false, true);
        this.repaint();
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g_) {
        ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintStart();
        try {
            Rectangle clip = g_.getClipBounds();
            if (clip.height < 0) {
                return;
            }
            Graphics2D g = (Graphics2D)this.getComponentGraphics(g_);
            AffineTransform old = this.setMirrorTransformIfNeeded(g, 0, this.getWidth());
            EditorUIUtil.setupAntialiasing(g);
            Color backgroundColor = this.getBackground();
            if (this.myEditor.isDisposed()) {
                g.setColor(this.myEditor.getDisposedBackground());
                g.fillRect(clip.x, clip.y, clip.width, clip.height);
                return;
            }
            int startVisualLine = this.myEditor.yToVisibleLine(clip.y);
            int endVisualLine = this.myEditor.yToVisibleLine(clip.y + clip.height);
            int gutterSeparatorX = this.getWhitespaceSeparatorOffset();
            this.paintBackground(g, clip, 0, gutterSeparatorX, backgroundColor);
            this.paintBackground(g, clip, gutterSeparatorX, this.getFoldingAreaWidth(), this.myEditor.getBackgroundColor());
            int firstVisibleOffset = this.myEditor.visualLineStartOffset(startVisualLine);
            int lastVisibleOffset = this.myEditor.visualLineStartOffset(endVisualLine + 1);
            this.paintEditorBackgrounds(g, firstVisibleOffset, lastVisibleOffset);
            Object hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (!UIUtil.isJreHiDPI((Graphics2D)g)) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            try {
                this.paintAnnotations(g, startVisualLine, endVisualLine);
                this.paintLineMarkers(g, firstVisibleOffset, lastVisibleOffset);
                this.paintFoldingLines(g, clip);
                this.paintFoldingTree(g, clip, firstVisibleOffset, lastVisibleOffset);
                this.paintLineNumbers(g, startVisualLine, endVisualLine);
            }
            finally {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
            }
            if (old != null) {
                g.setTransform(old);
            }
        }
        finally {
            ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintFinish();
        }
    }

    private void paintEditorBackgrounds(Graphics g, int firstVisibleOffset, int lastVisibleOffset) {
        this.myTextFgColors.clear();
        Color defaultBackgroundColor = this.myEditor.getBackgroundColor();
        Color defaultForegroundColor = this.myEditor.getColorsScheme().getDefaultForeground();
        int startX = this.myEditor.isInDistractionFreeMode() ? 0 : this.getWhitespaceSeparatorOffset();
        IterationState state = new IterationState(this.myEditor, firstVisibleOffset, lastVisibleOffset, null, true, false, true, false);
        while (!state.atEnd()) {
            this.drawEditorBackgroundForRange(g, state.getStartOffset(), state.getEndOffset(), state.getMergedAttributes(), defaultBackgroundColor, defaultForegroundColor, startX);
            state.advance();
        }
    }

    private void drawEditorBackgroundForRange(Graphics g, int startOffset, int endOffset, TextAttributes attributes, Color defaultBackgroundColor, Color defaultForegroundColor, int startX) {
        VisualPosition visualStart = this.myEditor.offsetToVisualPosition(startOffset, true, false);
        VisualPosition visualEnd = this.myEditor.offsetToVisualPosition(endOffset, false, false);
        for (int line = visualStart.getLine(); line <= visualEnd.getLine(); ++line) {
            if (line == visualStart.getLine()) {
                if (visualStart.getColumn() != 0) continue;
                this.drawEditorLineBackgroundRect(g, attributes, line, defaultBackgroundColor, defaultForegroundColor, startX, this.myEditor.visibleLineToY(line));
                continue;
            }
            if (line == visualEnd.getLine() && visualEnd.getColumn() == 0) continue;
            this.drawEditorLineBackgroundRect(g, attributes, line, defaultBackgroundColor, defaultForegroundColor, startX, this.myEditor.visibleLineToY(line));
        }
    }

    private void drawEditorLineBackgroundRect(Graphics g, TextAttributes attributes, int visualLine, Color defaultBackgroundColor, Color defaultForegroundColor, int startX, int startY) {
        Color color = this.myEditor.getBackgroundColor(attributes);
        if (!Comparing.equal((Object)color, (Object)defaultBackgroundColor)) {
            Color fgColor = attributes.getForegroundColor();
            if (!Comparing.equal((Object)fgColor, (Object)defaultForegroundColor)) {
                this.myTextFgColors.put(visualLine, (Object)fgColor);
            }
            g.setColor(color);
            g.fillRect(startX, startY, this.getWidth() - startX, this.myEditor.getLineHeight());
        }
    }

    private void processClose(MouseEvent e) {
        IdeEventQueue queue2 = IdeEventQueue.getInstance();
        if (this.getGutterRenderer(e) != null) {
            return;
        }
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            queue2.blockNextEvents(e);
            this.closeAllAnnotations();
            e.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintAnnotations(Graphics2D g, int startVisualLine, int endVisualLine) {
        int x = this.getAnnotationsAreaOffset();
        int w = this.getAnnotationsAreaWidthEx();
        if (w == 0) {
            return;
        }
        AffineTransform old = this.setMirrorTransformIfNeeded(g, x, w);
        try {
            Color color = this.myEditor.getColorsScheme().getColor(EditorColors.ANNOTATIONS_COLOR);
            g.setColor(color != null ? color : JBColor.blue);
            g.setFont(this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
            for (int i = 0; i < this.myTextAnnotationGutters.size(); ++i) {
                TextAnnotationGutterProvider gutterProvider = this.myTextAnnotationGutters.get(i);
                int lineHeight = this.myEditor.getLineHeight();
                int lastLine = this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)this.endLineNumber(), (int)0)).line;
                if (startVisualLine > (endVisualLine = Math.min(endVisualLine, lastLine))) {
                    break;
                }
                int annotationSize = this.myTextAnnotationGutterSizes.get(i);
                if (startVisualLine == 0 && endVisualLine == 0) {
                    this.paintAnnotationLine(g, gutterProvider, 0, x, 0, annotationSize, lineHeight);
                } else {
                    VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, startVisualLine);
                    while (!visLinesIterator.atEnd() && visLinesIterator.getVisualLine() <= endVisualLine) {
                        int logLine = visLinesIterator.getStartLogicalLine();
                        int y = visLinesIterator.getY();
                        this.paintAnnotationLine(g, gutterProvider, logLine, x, y, annotationSize, lineHeight);
                        visLinesIterator.advance();
                    }
                }
                x += annotationSize;
            }
        }
        finally {
            if (old != null) {
                g.setTransform(old);
            }
        }
    }

    private void paintAnnotationLine(Graphics g, TextAnnotationGutterProvider gutterProvider, int line, int x, int y, int width, int height) {
        String s = gutterProvider.getLineText(line, (Editor)this.myEditor);
        Color bg = gutterProvider.getBgColor(line, (Editor)this.myEditor);
        if (bg != null) {
            g.setColor(bg);
            g.fillRect(x, y, width, height);
        }
        if (!StringUtil.isEmpty((String)s)) {
            g.setColor(this.myEditor.getColorsScheme().getColor(gutterProvider.getColor(line, (Editor)this.myEditor)));
            EditorFontType style = gutterProvider.getStyle(line, (Editor)this.myEditor);
            Font font = this.getFontForText(s, style);
            g.setFont(font);
            g.drawString(s, GAP_BETWEEN_ANNOTATIONS / 2 + x, y + this.myEditor.getAscent());
        }
    }

    private Font getFontForText(String text, EditorFontType style) {
        Font font = this.myEditor.getColorsScheme().getFont(style);
        if (font.canDisplayUpTo(text) != -1) {
            font = UIUtil.getFontWithFallback((Font)font);
        }
        return font;
    }

    private void paintFoldingTree(Graphics g, Rectangle clip, int firstVisibleOffset, int lastVisibleOffset) {
        if (this.isFoldingOutlineShown()) {
            this.doPaintFoldingTree((Graphics2D)g, clip, firstVisibleOffset, lastVisibleOffset);
        }
    }

    private void paintLineMarkers(Graphics2D g, int firstVisibleOffset, int lastVisibleOffset) {
        if (this.isLineMarkersShown()) {
            this.paintGutterRenderers(g, firstVisibleOffset, lastVisibleOffset);
        }
    }

    private void paintBackground(Graphics g, Rectangle clip, int x, int width, Color background) {
        g.setColor(background);
        g.fillRect(x, clip.y, width, clip.height);
        this.paintCaretRowBackground(g, x, width);
    }

    private void paintCaretRowBackground(Graphics g, int x, int width) {
        if (!this.myEditor.getSettings().isCaretRowShown()) {
            return;
        }
        VisualPosition visCaret = this.myEditor.getCaretModel().getVisualPosition();
        Color caretRowColor = this.myEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR);
        if (caretRowColor != null) {
            g.setColor(caretRowColor);
            Point caretPoint = this.myEditor.visualPositionToXY(visCaret);
            g.fillRect(x, caretPoint.y, width, this.myEditor.getLineHeight());
        }
    }

    private void paintLineNumbers(Graphics2D g, int startVisualLine, int endVisualLine) {
        if (this.isLineNumbersShown()) {
            int offset = this.getLineNumberAreaOffset() + this.myLineNumberAreaWidth;
            this.doPaintLineNumbers(g, startVisualLine, endVisualLine, offset, this.myLineNumberConvertor);
            if (this.myAdditionalLineNumberConvertor != null) {
                this.doPaintLineNumbers(g, startVisualLine, endVisualLine, offset + EditorGutterComponentImpl.getAreaWidthWithGap(this.myAdditionalLineNumberAreaWidth), this.myAdditionalLineNumberConvertor);
            }
        }
    }

    @Override
    public Color getBackground() {
        if (this.myEditor.isInDistractionFreeMode() || !this.myPaintBackground) {
            return this.myEditor.getBackgroundColor();
        }
        Color color = this.myEditor.getColorsScheme().getColor(EditorColors.GUTTER_BACKGROUND);
        return color != null ? color : EditorColors.GUTTER_BACKGROUND.getDefaultColor();
    }

    private Font getFontForLineNumbers() {
        Font editorFont = this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN);
        float editorFontSize = editorFont.getSize2D();
        return editorFont.deriveFont(Math.max(1.0f, editorFontSize - 1.0f));
    }

    private int calcLineNumbersAreaWidth(int maxLineNumber) {
        return this.getFontMetrics(this.getFontForLineNumbers()).stringWidth(Integer.toString(maxLineNumber + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPaintLineNumbers(Graphics2D g, int startVisualLine, int endVisualLine, int offset, @NotNull TIntFunction convertor) {
        int lastLine;
        if (convertor == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(1);
        }
        if (startVisualLine > (endVisualLine = Math.min(endVisualLine, lastLine = this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)this.endLineNumber(), (int)0)).line))) {
            return;
        }
        Color color = this.myEditor.getColorsScheme().getColor(EditorColors.LINE_NUMBERS_COLOR);
        g.setColor(color != null ? color : JBColor.blue);
        Font font = this.getFontForLineNumbers();
        g.setFont(font);
        AffineTransform old = this.setMirrorTransformIfNeeded(g, this.getLineNumberAreaOffset(), this.getLineNumberAreaWidth());
        try {
            VisualLinesIterator visLinesIterator = new VisualLinesIterator(this.myEditor, startVisualLine);
            while (!visLinesIterator.atEnd() && visLinesIterator.getVisualLine() <= endVisualLine) {
                int logLine;
                LogicalPosition logicalPosition = this.myEditor.visualToLogicalPosition(new VisualPosition(visLinesIterator.getVisualLine(), 0));
                if (EditorUtil.getSoftWrapCountAfterLineStart(this.myEditor, logicalPosition) <= 0 && (logLine = convertor.execute(visLinesIterator.getStartLogicalLine())) >= 0) {
                    int startY = visLinesIterator.getY();
                    if (this.myEditor.isInDistractionFreeMode()) {
                        Color fgColor = (Color)this.myTextFgColors.get(visLinesIterator.getVisualLine());
                        g.setColor(fgColor != null ? fgColor : (color != null ? color : JBColor.blue));
                    }
                    String s = String.valueOf(logLine + 1);
                    int textOffset = this.isMirrored() ? offset - this.getLineNumberAreaWidth() - 1 : offset - g.getFontMetrics().stringWidth(s);
                    g.drawString(s, textOffset, startY + this.myEditor.getAscent());
                }
                visLinesIterator.advance();
            }
        }
        finally {
            if (old != null) {
                g.setTransform(old);
            }
        }
    }

    private int endLineNumber() {
        return Math.max(0, this.myEditor.getDocument().getLineCount() - 1);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (this.myEditor.isDisposed()) {
            return null;
        }
        if (EditorGutter.KEY.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return this.myEditor;
        }
        return null;
    }

    private void processRangeHighlighters(int startOffset, int endOffset, @NotNull RangeHighlighterProcessor processor2) {
        if (processor2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(2);
        }
        DocumentEx document = this.myEditor.getDocument();
        MarkupIterator<RangeHighlighterEx> docHighlighters = this.myEditor.getFilteredDocumentMarkupModel().overlappingIterator(startOffset, endOffset);
        MarkupIterator<RangeHighlighterEx> editorHighlighters = this.myEditor.getMarkupModel().overlappingIterator(startOffset, endOffset);
        try {
            RangeHighlighterEx lastDocHighlighter = null;
            RangeHighlighterEx lastEditorHighlighter = null;
            while (true) {
                int endLineIndex;
                int startLineIndex;
                RangeHighlighterEx lowerHighlighter;
                if (lastDocHighlighter == null && docHighlighters.hasNext()) {
                    lastDocHighlighter = (RangeHighlighterEx)docHighlighters.next();
                    if (!lastDocHighlighter.isValid() || lastDocHighlighter.getAffectedAreaStartOffset() > endOffset) {
                        lastDocHighlighter = null;
                        continue;
                    }
                    if (lastDocHighlighter.getAffectedAreaEndOffset() < startOffset) {
                        lastDocHighlighter = null;
                        continue;
                    }
                }
                if (lastEditorHighlighter == null && editorHighlighters.hasNext()) {
                    lastEditorHighlighter = (RangeHighlighterEx)editorHighlighters.next();
                    if (!lastEditorHighlighter.isValid() || lastEditorHighlighter.getAffectedAreaStartOffset() > endOffset) {
                        lastEditorHighlighter = null;
                        continue;
                    }
                    if (lastEditorHighlighter.getAffectedAreaEndOffset() < startOffset) {
                        lastEditorHighlighter = null;
                        continue;
                    }
                }
                if (lastDocHighlighter == null && lastEditorHighlighter == null) {
                    return;
                }
                if (EditorGutterComponentImpl.less(lastDocHighlighter, lastEditorHighlighter)) {
                    lowerHighlighter = lastDocHighlighter;
                    lastDocHighlighter = null;
                } else {
                    lowerHighlighter = lastEditorHighlighter;
                    lastEditorHighlighter = null;
                }
                if (!lowerHighlighter.isValid() || !EditorGutterComponentImpl.isValidLine(document, startLineIndex = lowerHighlighter.getDocument().getLineNumber(startOffset)) || !EditorGutterComponentImpl.isValidLine(document, endLineIndex = lowerHighlighter.getDocument().getLineNumber(endOffset))) continue;
                processor2.process(lowerHighlighter);
            }
        }
        finally {
            docHighlighters.dispose();
            editorHighlighters.dispose();
        }
    }

    private static boolean isValidLine(@NotNull Document document, int line) {
        if (document == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(3);
        }
        if (line < 0) {
            return false;
        }
        int lineCount = document.getLineCount();
        return lineCount == 0 ? line == 0 : line < lineCount;
    }

    private static boolean less(RangeHighlighter h1, RangeHighlighter h2) {
        return h1 != null && (h2 == null || h1.getStartOffset() < h2.getStartOffset());
    }

    @Override
    public void revalidateMarkup() {
        this.updateSize();
    }

    void updateSizeOnShowNotify() {
        this.updateSize(false, true);
    }

    public void updateSize() {
        this.updateSize(false, false);
    }

    void updateSize(boolean onLayout, boolean canShrink) {
        int prevHash = this.sizeHash();
        if (!onLayout) {
            this.clearLineToGutterRenderersCache();
            this.calcLineNumberAreaWidth();
            this.calcLineMarkerAreaWidth(canShrink);
            this.calcAnnotationsSize();
        }
        this.calcAnnotationExtraSize();
        if (prevHash != this.sizeHash()) {
            this.fireResized();
        }
        this.repaint();
    }

    private int sizeHash() {
        int result2 = this.getLineMarkerAreaWidth();
        result2 = 31 * result2 + this.myTextAnnotationGuttersSize;
        result2 = 31 * result2 + this.myTextAnnotationExtraSize;
        result2 = 31 * result2 + this.getLineNumberAreaWidth();
        return result2;
    }

    private void calcAnnotationsSize() {
        this.myTextAnnotationGuttersSize = 0;
        int lineCount = Math.max(this.myEditor.getDocument().getLineCount(), 1);
        for (int j = 0; j < this.myTextAnnotationGutters.size(); ++j) {
            TextAnnotationGutterProvider gutterProvider = this.myTextAnnotationGutters.get(j);
            int gutterSize = 0;
            for (int i = 0; i < lineCount; ++i) {
                String lineText = gutterProvider.getLineText(i, (Editor)this.myEditor);
                if (StringUtil.isEmpty((String)lineText)) continue;
                EditorFontType style = gutterProvider.getStyle(i, (Editor)this.myEditor);
                Font font = this.getFontForText(lineText, style);
                FontMetrics fontMetrics = this.getFontMetrics(font);
                gutterSize = Math.max(gutterSize, fontMetrics.stringWidth(lineText));
            }
            if (gutterSize > 0) {
                gutterSize += GAP_BETWEEN_ANNOTATIONS;
            }
            this.myTextAnnotationGutterSizes.set(j, gutterSize);
            this.myTextAnnotationGuttersSize += gutterSize;
        }
    }

    private void calcAnnotationExtraSize() {
        int width;
        this.myTextAnnotationExtraSize = 0;
        if (!this.myEditor.isInDistractionFreeMode() || this.isMirrored()) {
            return;
        }
        Window frame = SwingUtilities.getWindowAncestor(this.myEditor.getComponent());
        if (frame == null) {
            return;
        }
        EditorSettings settings = this.myEditor.getSettings();
        int rightMargin = settings.getRightMargin(this.myEditor.getProject());
        if (rightMargin <= 0) {
            return;
        }
        JComponent editorComponent = this.myEditor.getComponent();
        RelativePoint point = new RelativePoint((Component)editorComponent, new Point(0, 0));
        Point editorLocationInWindow = point.getPoint((Component)frame);
        int editorLocationX = (int)editorLocationInWindow.getX();
        int rightMarginX = rightMargin * EditorUtil.getSpaceWidth(0, this.myEditor) + editorLocationX;
        if (rightMarginX < (width = editorLocationX + editorComponent.getWidth()) && editorLocationX < width - rightMarginX) {
            int centeredSize = (width - rightMarginX - editorLocationX) / 2 - (this.getLineMarkerAreaWidth() + this.getLineNumberAreaWidth() + this.getFoldingAreaWidth() + 2 * GAP_BETWEEN_AREAS);
            this.myTextAnnotationExtraSize = Math.max(0, centeredSize - this.myTextAnnotationGuttersSize);
        }
    }

    void clearLineToGutterRenderersCache() {
        this.myLineToGutterRenderers = null;
    }

    private void buildGutterRenderersCache() {
        this.myLineToGutterRenderers = new TIntObjectHashMap();
        this.processRangeHighlighters(0, this.myEditor.getDocument().getTextLength(), highlighter -> {
            GutterIconRenderer renderer = highlighter.getGutterIconRenderer();
            if (renderer == null) {
                return;
            }
            if (!this.areIconsShown() && !(renderer instanceof NonHideableIconGutterMark)) {
                return;
            }
            if (!this.isHighlighterVisible(highlighter)) {
                return;
            }
            int lineStartOffset = EditorUtil.getNotFoldedLineStartOffset(this.myEditor, highlighter.getStartOffset());
            int line = this.myEditor.getDocument().getLineNumber(lineStartOffset);
            List renderers = (List)this.myLineToGutterRenderers.get(line);
            if (renderers == null) {
                renderers = new SmartList();
                this.myLineToGutterRenderers.put(line, (Object)renderers);
            }
            renderers.add(renderer);
        });
        this.myLineToGutterRenderers.transformValues(value -> {
            List newValue = value;
            for (GutterMarkPreprocessor preprocessor : (GutterMarkPreprocessor[])GutterMarkPreprocessor.EP_NAME.getExtensions()) {
                newValue = preprocessor.processMarkers((List)value);
            }
            if (newValue.size() >= 5) {
                newValue = newValue.subList(0, 4);
            }
            return newValue;
        });
    }

    private void calcLineMarkerAreaWidth(boolean canShrink) {
        this.myLeftFreePaintersAreaShown = this.myForceLeftFreePaintersAreaShown;
        this.myRightFreePaintersAreaShown = this.myForceRightFreePaintersAreaShown;
        this.processRangeHighlighters(0, this.myEditor.getDocument().getTextLength(), highlighter -> {
            LineMarkerRenderer lineMarkerRenderer = highlighter.getLineMarkerRenderer();
            if (lineMarkerRenderer != null) {
                LineMarkerRendererEx.Position position = EditorGutterComponentImpl.getLineMarkerPosition(lineMarkerRenderer);
                if (position == LineMarkerRendererEx.Position.LEFT && this.isLineMarkerVisible(highlighter)) {
                    this.myLeftFreePaintersAreaShown = true;
                }
                if (position == LineMarkerRendererEx.Position.RIGHT && this.isLineMarkerVisible(highlighter)) {
                    this.myRightFreePaintersAreaShown = true;
                }
            }
        });
        int minWidth = this.areIconsShown() ? this.scaleWidth(this.myStartIconAreaWidth) : 0;
        this.myIconsAreaWidth = canShrink ? minWidth : Math.max(this.myIconsAreaWidth, minWidth);
        this.processGutterRenderers((TIntObjectProcedure<List<GutterMark>>)((TIntObjectProcedure)(line, renderers) -> {
            int width = 1;
            for (int i = 0; i < renderers.size(); ++i) {
                GutterMark renderer = (GutterMark)renderers.get(i);
                if (!this.checkDumbAware(renderer)) continue;
                width += this.scaleIcon(renderer.getIcon()).getIconWidth();
                if (i <= 0) continue;
                width += GAP_BETWEEN_ICONS;
            }
            if (this.myIconsAreaWidth < width) {
                this.myIconsAreaWidth = width + 1;
            }
            return true;
        }));
        if (this.isDumbMode()) {
            this.myIconsAreaWidth = Math.max(this.myIconsAreaWidth, this.myLastNonDumbModeIconAreaWidth);
        } else {
            this.myLastNonDumbModeIconAreaWidth = this.myIconsAreaWidth;
        }
    }

    @Nullable
    private List<GutterMark> getGutterRenderers(int line) {
        if (this.myLineToGutterRenderers == null) {
            this.buildGutterRenderersCache();
        }
        return (List)this.myLineToGutterRenderers.get(line);
    }

    private void processGutterRenderers(@NotNull TIntObjectProcedure<List<GutterMark>> processor2) {
        if (processor2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(4);
        }
        if (this.myLineToGutterRenderers == null) {
            this.buildGutterRenderersCache();
        }
        this.myLineToGutterRenderers.forEachEntry(processor2);
    }

    private boolean isHighlighterVisible(RangeHighlighter highlighter) {
        return !FoldingUtil.isHighlighterFolded(this.myEditor, highlighter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintGutterRenderers(Graphics2D g, int firstVisibleOffset, int lastVisibleOffset) {
        Object hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            ArrayList highlighters = new ArrayList();
            this.processRangeHighlighters(firstVisibleOffset, lastVisibleOffset, highlighter -> {
                LineMarkerRenderer renderer = highlighter.getLineMarkerRenderer();
                if (renderer != null) {
                    highlighters.add(highlighter);
                }
            });
            ContainerUtil.sort(highlighters, Comparator.comparingInt(RangeHighlighter::getLayer));
            for (RangeHighlighter highlighter2 : highlighters) {
                this.paintLineMarkerRenderer(highlighter2, g);
            }
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
        }
        int firstVisibleLine = this.myEditor.getDocument().getLineNumber(firstVisibleOffset);
        int lastVisibleLine = this.myEditor.getDocument().getLineNumber(lastVisibleOffset);
        this.paintIcons(firstVisibleLine, lastVisibleLine, g);
    }

    private void paintIcons(int firstVisibleLine, int lastVisibleLine, Graphics2D g) {
        for (int line = firstVisibleLine; line <= lastVisibleLine; ++line) {
            List<GutterMark> renderers = this.getGutterRenderers(line);
            if (renderers == null) continue;
            this.paintIconRow(line, renderers, g);
        }
    }

    private void paintIconRow(int line, List<GutterMark> row, Graphics2D g) {
        this.processIconsRow(line, row, (x, y, renderer) -> {
            Icon icon = this.scaleIcon(renderer.getIcon());
            AffineTransform old = this.setMirrorTransformIfNeeded(g, x, icon.getIconWidth());
            try {
                icon.paintIcon(this, g, x, y);
            }
            finally {
                if (old != null) {
                    g.setTransform(old);
                }
            }
        });
    }

    private void paintLineMarkerRenderer(RangeHighlighter highlighter, Graphics g) {
        Rectangle rectangle;
        LineMarkerRenderer lineMarkerRenderer = highlighter.getLineMarkerRenderer();
        if (lineMarkerRenderer != null && (rectangle = this.getLineRendererRectangle(highlighter)) != null) {
            lineMarkerRenderer.paint((Editor)this.myEditor, g, rectangle);
        }
    }

    private boolean isLineMarkerVisible(RangeHighlighter highlighter) {
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        FoldRegion startFoldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        FoldRegion endFoldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(endOffset);
        return startFoldRegion == null || endFoldRegion == null || !startFoldRegion.equals(endFoldRegion);
    }

    @Nullable
    private Rectangle getLineRendererRectangle(RangeHighlighter highlighter) {
        int x;
        int w;
        if (!this.isLineMarkerVisible(highlighter)) {
            return null;
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        int startY = this.myEditor.visibleLineToY(this.myEditor.offsetToVisualLine(startOffset));
        int endY = this.myEditor.visibleLineToY(this.myEditor.offsetToVisualLine(endOffset));
        DocumentEx document = this.myEditor.getDocument();
        if (document.getLineStartOffset(document.getLineNumber(endOffset)) != endOffset) {
            endY += this.myEditor.getLineHeight();
        }
        LineMarkerRenderer renderer = (LineMarkerRenderer)ObjectUtils.assertNotNull((Object)highlighter.getLineMarkerRenderer());
        LineMarkerRendererEx.Position position = EditorGutterComponentImpl.getLineMarkerPosition(renderer);
        switch (position) {
            case LEFT: {
                w = this.getLeftFreePaintersAreaWidth();
                x = this.getLeftFreePaintersAreaOffset();
                break;
            }
            case RIGHT: {
                w = this.getRightFreePaintersAreaWidth();
                x = this.getLineMarkerFreePaintersAreaOffset();
                break;
            }
            case CUSTOM: {
                w = this.getWidth();
                x = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException(position.name());
            }
        }
        int height = endY - startY;
        return new Rectangle(x, startY, w, height);
    }

    private float getEditorScaleFactor() {
        float scale;
        if (Registry.is((String)"editor.scale.gutter.icons") && Math.abs(1.0f - (scale = this.myEditor.getScale())) > 0.1f) {
            return scale;
        }
        return 1.0f;
    }

    private Icon scaleIcon(Icon icon) {
        float scale = this.getEditorScaleFactor();
        return scale == 1.0f ? icon : IconUtil.scale((Icon)icon, (Component)this, (float)scale);
    }

    private int scaleWidth(int width) {
        return (int)(this.getEditorScaleFactor() * (float)width);
    }

    private void processIconsRow(int line, @NotNull List<GutterMark> row, @NotNull LineGutterIconRendererProcessor processor2) {
        Icon icon;
        if (row == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(5);
        }
        if (processor2 == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(6);
        }
        int middleCount = 0;
        int middleSize = 0;
        int x = this.getIconAreaOffset() + 2;
        int y = this.myEditor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
        for (GutterMark gutterMark : row) {
            if (!this.checkDumbAware(gutterMark)) continue;
            GutterIconRenderer.Alignment alignment = ((GutterIconRenderer)gutterMark).getAlignment();
            icon = this.scaleIcon(gutterMark.getIcon());
            if (alignment == GutterIconRenderer.Alignment.LEFT) {
                processor2.process(x, y + this.getTextAlignmentShift(icon), gutterMark);
                x += icon.getIconWidth() + GAP_BETWEEN_ICONS;
                continue;
            }
            if (alignment != GutterIconRenderer.Alignment.CENTER) continue;
            ++middleCount;
            middleSize += icon.getIconWidth() + GAP_BETWEEN_ICONS;
        }
        int leftSize = x - this.getIconAreaOffset();
        x = this.getIconAreaOffset() + this.myIconsAreaWidth;
        for (GutterMark r : row) {
            if (!this.checkDumbAware(r) || ((GutterIconRenderer)r).getAlignment() != GutterIconRenderer.Alignment.RIGHT) continue;
            icon = this.scaleIcon(r.getIcon());
            processor2.process(x -= icon.getIconWidth(), y + this.getTextAlignmentShift(icon), r);
            x -= GAP_BETWEEN_ICONS;
        }
        int n = this.myIconsAreaWidth + this.getIconAreaOffset() - x + 1;
        if (middleCount > 0) {
            x = this.getIconAreaOffset() + leftSize + (this.myIconsAreaWidth - leftSize - n - (middleSize -= GAP_BETWEEN_ICONS)) / 2;
            for (GutterMark r : row) {
                if (!this.checkDumbAware(r) || ((GutterIconRenderer)r).getAlignment() != GutterIconRenderer.Alignment.CENTER) continue;
                Icon icon2 = this.scaleIcon(r.getIcon());
                processor2.process(x, y + this.getTextAlignmentShift(icon2), r);
                x += icon2.getIconWidth() + GAP_BETWEEN_ICONS;
            }
        }
    }

    private int getTextAlignmentShift(Icon icon) {
        int centerRelative = (this.myEditor.getLineHeight() - icon.getIconHeight()) / 2;
        int baselineRelative = this.myEditor.getAscent() - icon.getIconHeight();
        return Math.max(centerRelative, baselineRelative);
    }

    private Color getOutlineColor(boolean isActive) {
        ColorKey key = isActive ? EditorColors.SELECTED_TEARLINE_COLOR : EditorColors.TEARLINE_COLOR;
        Color color = this.myEditor.getColorsScheme().getColor(key);
        return color != null ? color : JBColor.black;
    }

    public void registerTextAnnotation(@NotNull TextAnnotationGutterProvider provider) {
        if (provider == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(7);
        }
        this.myTextAnnotationGutters.add(provider);
        this.myTextAnnotationGutterSizes.add(0);
        this.updateSize();
    }

    public void registerTextAnnotation(@NotNull TextAnnotationGutterProvider provider, @NotNull EditorGutterAction action) {
        if (provider == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(8);
        }
        if (action == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(9);
        }
        this.myTextAnnotationGutters.add(provider);
        this.myProviderToListener.put(provider, action);
        this.myTextAnnotationGutterSizes.add(0);
        this.updateSize();
    }

    private void doPaintFoldingTree(Graphics2D g, Rectangle clip, int firstVisibleOffset, int lastVisibleOffset) {
        double width = this.getFoldingAnchorWidth2D();
        Collection<DisplayedFoldingAnchor> anchorsToDisplay = this.myAnchorsDisplayStrategy.getAnchorsToDisplay(firstVisibleOffset, lastVisibleOffset, this.myActiveFoldRegion);
        for (DisplayedFoldingAnchor anchor2 : anchorsToDisplay) {
            this.drawFoldingAnchor(width, clip, g, anchor2.visualLine, anchor2.type, anchor2.foldRegion == this.myActiveFoldRegion);
        }
    }

    private void paintFoldingLines(Graphics2D g, Rectangle clip) {
        boolean shown = this.isFoldingOutlineShown();
        if ((shown || this.myEditor.isInDistractionFreeMode() && Registry.is((String)"editor.distraction.gutter.separator")) && this.myPaintBackground) {
            g.setColor(this.getOutlineColor(false));
            double x = this.getWhitespaceSeparatorOffset2D();
            LinePainter2D.paint((Graphics2D)g, (double)x, (double)clip.y, (double)x, (double)(clip.y + clip.height), (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)this.getStrokeWidth());
        }
        if (!shown) {
            return;
        }
        int anchorX = this.getFoldingAreaOffset();
        int width = this.getFoldingAnchorWidth();
        if (this.myActiveFoldRegion != null && this.myActiveFoldRegion.isExpanded() && this.myActiveFoldRegion.isValid()) {
            int foldStart = this.myEditor.offsetToVisualLine(this.myActiveFoldRegion.getStartOffset());
            int foldEnd = this.myEditor.offsetToVisualLine(this.getEndOffset(this.myActiveFoldRegion));
            int startY = this.getLineCenterY(foldStart);
            int endY = this.getLineCenterY(foldEnd);
            if (startY <= clip.y + clip.height && endY + 1 + this.myEditor.getDescent() >= clip.y) {
                g.setColor(this.getOutlineColor(true));
                int lineX = anchorX + width / 2;
                LinePainter2D.paint((Graphics2D)g, (double)lineX, (double)startY, (double)lineX, (double)endY, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)this.getStrokeWidth());
            }
        }
    }

    @Override
    public int getWhitespaceSeparatorOffset() {
        return (int)Math.round(this.getWhitespaceSeparatorOffset2D());
    }

    private double getWhitespaceSeparatorOffset2D() {
        return PaintUtil.alignToInt((double)(this.getFoldingAreaOffset() + this.getFoldingAnchorWidth() / 2), (JBUI.ScaleContext)JBUI.ScaleContext.create((Component)this.myEditor.getComponent()), (PaintUtil.RoundingMode)PaintUtil.RoundingMode.ROUND, null);
    }

    void setActiveFoldRegion(FoldRegion activeFoldRegion) {
        if (this.myActiveFoldRegion != activeFoldRegion) {
            this.myActiveFoldRegion = activeFoldRegion;
            this.repaint();
        }
    }

    private int getLineCenterY(int line) {
        return this.myEditor.visibleLineToY(line) + this.myEditor.getLineHeight() / 2;
    }

    private double getFoldAnchorY(int line, double width) {
        return (double)(this.myEditor.visibleLineToY(line) + this.myEditor.getAscent()) - width;
    }

    int getHeadCenterY(FoldRegion foldRange) {
        return this.getLineCenterY(this.myEditor.offsetToVisualLine(foldRange.getStartOffset()));
    }

    private void drawFoldingAnchor(double width, Rectangle clip, Graphics2D g, int visualLine, DisplayedFoldingAnchor.Type type, boolean active) {
        double off = width / 4.0;
        double height = width + off;
        double baseHeight = height - width / 2.0;
        double y = this.getFoldAnchorY(visualLine, width);
        double centerX = LinePainter2D.getStrokeCenter((Graphics2D)g, (double)this.getWhitespaceSeparatorOffset2D(), (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)this.getStrokeWidth());
        double strokeOff = centerX - this.getWhitespaceSeparatorOffset2D();
        double centerY = PaintUtil.alignToInt((double)(y + width / 2.0), (Graphics2D)g) + strokeOff;
        switch (type) {
            case COLLAPSED: {
                if (!(y <= (double)(clip.y + clip.height)) || !(y + height >= (double)clip.y)) break;
                this.drawSquareWithPlus(g, centerX, centerY, width, active);
                break;
            }
            case EXPANDED_TOP: {
                if (!(y <= (double)(clip.y + clip.height)) || !(y + height >= (double)clip.y)) break;
                this.drawDirectedBox(g, centerX, centerY, width, height, baseHeight, active);
                break;
            }
            case EXPANDED_BOTTOM: {
                y += width;
                if (!(y - height <= (double)(clip.y + clip.height)) || !(y >= (double)clip.y)) break;
                this.drawDirectedBox(g, centerX, centerY, width, -height, -baseHeight, active);
            }
        }
    }

    private int getEndOffset(FoldRegion foldRange) {
        LOG.assertTrue(foldRange.isValid(), (Object)foldRange);
        FoldingGroup group = foldRange.getGroup();
        return group == null ? foldRange.getEndOffset() : this.myEditor.getFoldingModel().getEndOffset(group);
    }

    private void drawDirectedBox(Graphics2D g, double centerX, double centerY, double width, double height, double baseHeight, boolean active) {
        double sw = this.getStrokeWidth();
        Rectangle2D rect = RectanglePainter2D.align((Graphics2D)g, EnumSet.of(LinePainter2D.Align.CENTER_X, LinePainter2D.Align.CENTER_Y), (double)centerX, (double)centerY, (double)width, (double)width, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)sw);
        double x1 = rect.getX();
        double x2 = x1 + rect.getWidth() - 1.0;
        double y = height > 0.0 ? rect.getY() : rect.getY() + rect.getHeight() - 1.0;
        double[] dxPoints = new double[]{x1, x1, x2, x2, centerX};
        double[] dyPoints = new double[]{y + baseHeight, y, y, y + baseHeight, y + height + (double)(height < 0.0 ? 1 : 0)};
        g.setColor(this.myEditor.getBackgroundColor());
        LinePainter2D.fillPolygon((Graphics2D)g, (double[])dxPoints, (double[])dyPoints, (int)5, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED_CAPS_SQUARE, (double)sw, (Object)RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getOutlineColor(active));
        LinePainter2D.paintPolygon((Graphics2D)g, (double[])dxPoints, (double[])dyPoints, (int)5, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED_CAPS_SQUARE, (double)sw, (Object)RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawPlusOrMinus(g, false, centerX, centerY, width, sw);
    }

    private void drawPlusOrMinus(Graphics2D g, boolean plus, double centerX, double centerY, double width, double strokeWidth) {
        double length = width - this.getSquareInnerOffset(width) * 2.0;
        Line2D line = LinePainter2D.align((Graphics2D)g, EnumSet.of(LinePainter2D.Align.CENTER_X, LinePainter2D.Align.CENTER_Y), (double)centerX, (double)centerY, (double)length, (boolean)plus, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)strokeWidth);
        LinePainter2D.paint((Graphics2D)g, (Line2D)line, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)strokeWidth, (Object)RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void drawSquareWithPlus(Graphics2D g, double centerX, double centerY, double width, boolean active) {
        double sw = this.getStrokeWidth();
        Rectangle2D rect = RectanglePainter2D.align((Graphics2D)g, EnumSet.of(LinePainter2D.Align.CENTER_X, LinePainter2D.Align.CENTER_Y), (double)centerX, (double)centerY, (double)width, (double)width, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)sw);
        g.setColor(this.myEditor.getBackgroundColor());
        RectanglePainter2D.FILL.paint(g, rect, null, LinePainter2D.StrokeType.CENTERED, sw, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(this.getOutlineColor(active));
        RectanglePainter2D.DRAW.paint(g, rect, null, LinePainter2D.StrokeType.CENTERED, sw, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.drawPlusOrMinus(g, false, centerX, centerY, width, sw);
        this.drawPlusOrMinus(g, true, centerX, centerY, width, sw);
    }

    private double getSquareInnerOffset(double width) {
        return Math.max(width / 5.0, this.scale(2.0));
    }

    private double scale(double v) {
        return JBUI.scale((float)((float)v)) * this.myEditor.getScale();
    }

    private int getFoldingAnchorWidth() {
        return (int)Math.round(this.getFoldingAnchorWidth2D());
    }

    private double getFoldingAnchorWidth2D() {
        return Math.min(this.scale(4.0), (double)((float)this.myEditor.getLineHeight() / 2.0f - JBUI.scale((float)2.0f))) * 2.0;
    }

    private double getStrokeWidth() {
        double sw = UIUtil.isJreHiDPIEnabled() || this.scale(1.0) < 2.0 ? 1.0 : 2.0;
        JBUI.ScaleContext ctx = JBUI.ScaleContext.create((Component)this.myEditor.getComponent());
        return PaintUtil.alignToInt((double)sw, (JBUI.ScaleContext)ctx, (PaintUtil.RoundingMode)(PaintUtil.devValue((double)1.0, (JBUI.ScaleContext)ctx) > 2.0 ? PaintUtil.RoundingMode.FLOOR : PaintUtil.RoundingMode.ROUND), null);
    }

    private int getFoldingAreaOffset() {
        return this.getLineMarkerAreaOffset() + this.getLineMarkerAreaWidth();
    }

    private int getFoldingAreaWidth() {
        return this.isFoldingOutlineShown() ? this.getFoldingAnchorWidth() + JBUI.scale((int)2) : (this.isRealEditor() ? this.getFoldingAnchorWidth() : 0);
    }

    private boolean isRealEditor() {
        return EditorUtil.isRealFileEditor(this.myEditor);
    }

    private boolean isLineMarkersShown() {
        return this.myEditor.getSettings().isLineMarkerAreaShown();
    }

    private boolean areIconsShown() {
        return this.myEditor.getSettings().areGutterIconsShown();
    }

    private boolean isLineNumbersShown() {
        return this.myEditor.getSettings().isLineNumbersShown();
    }

    public boolean isAnnotationsShown() {
        return !this.myTextAnnotationGutters.isEmpty();
    }

    private boolean isFoldingOutlineShown() {
        return this.myEditor.getSettings().isFoldingOutlineShown() && this.myEditor.getFoldingModel().isFoldingEnabled() && !this.myEditor.isInPresentationMode();
    }

    private static int getAreaWidthWithGap(int width) {
        if (width > 0) {
            return width + GAP_BETWEEN_AREAS;
        }
        return 0;
    }

    private int getLineNumberAreaWidth() {
        return this.isLineNumbersShown() ? this.myLineNumberAreaWidth + EditorGutterComponentImpl.getAreaWidthWithGap(this.myAdditionalLineNumberAreaWidth) : 0;
    }

    private int getLineMarkerAreaWidth() {
        return this.isLineMarkersShown() ? this.getLeftFreePaintersAreaWidth() + this.myIconsAreaWidth + this.getGapAfterIconsArea() + this.getRightFreePaintersAreaWidth() : 0;
    }

    private void calcLineNumberAreaWidth() {
        if (!this.isLineNumbersShown()) {
            return;
        }
        int maxLineNumber = this.getMaxLineNumber(this.myLineNumberConvertor);
        this.myLineNumberAreaWidth = this.calcLineNumbersAreaWidth(maxLineNumber);
        this.myAdditionalLineNumberAreaWidth = 0;
        if (this.myAdditionalLineNumberConvertor != null) {
            int maxAdditionalLineNumber = this.getMaxLineNumber(this.myAdditionalLineNumberConvertor);
            this.myAdditionalLineNumberAreaWidth = this.calcLineNumbersAreaWidth(maxAdditionalLineNumber);
        }
    }

    private int getMaxLineNumber(@NotNull TIntFunction convertor) {
        if (convertor == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(10);
        }
        for (int i = this.endLineNumber(); i >= 0; --i) {
            int number = convertor.execute(i);
            if (number < 0) continue;
            return number;
        }
        return 0;
    }

    @Nullable
    EditorMouseEventArea getEditorMouseAreaByOffset(int offset) {
        if (this.isLineNumbersShown() && offset < this.getLineNumberAreaOffset() + this.getLineNumberAreaWidth()) {
            return EditorMouseEventArea.LINE_NUMBERS_AREA;
        }
        if (this.isAnnotationsShown() && offset < this.getAnnotationsAreaOffset() + this.getAnnotationsAreaWidth()) {
            return EditorMouseEventArea.ANNOTATIONS_AREA;
        }
        if (this.isLineMarkersShown() && offset < this.getFoldingAreaOffset()) {
            return EditorMouseEventArea.LINE_MARKERS_AREA;
        }
        if (this.isFoldingOutlineShown() && offset < this.getFoldingAreaOffset() + this.getFoldingAreaWidth()) {
            return EditorMouseEventArea.FOLDING_OUTLINE_AREA;
        }
        return null;
    }

    private int getLineNumberAreaOffset() {
        if (this.getLineNumberAreaWidth() == 0 && this.getAnnotationsAreaWidthEx() == 0 && this.getLineMarkerAreaWidth() == 0) {
            return this.getFoldingAreaWidth() == 0 ? 0 : 1;
        }
        if (this.getLineNumberAreaWidth() == 0 && this.getAnnotationsAreaWidthEx() > 0) {
            return 0;
        }
        return GAP_BETWEEN_AREAS;
    }

    @Override
    public int getAnnotationsAreaOffset() {
        return this.getLineNumberAreaOffset() + EditorGutterComponentImpl.getAreaWidthWithGap(this.getLineNumberAreaWidth());
    }

    @Override
    public int getAnnotationsAreaWidth() {
        return this.myTextAnnotationGuttersSize;
    }

    private int getAnnotationsAreaWidthEx() {
        return this.myTextAnnotationGuttersSize + this.myTextAnnotationExtraSize;
    }

    @Override
    public int getLineMarkerAreaOffset() {
        return this.getAnnotationsAreaOffset() + EditorGutterComponentImpl.getAreaWidthWithGap(this.getAnnotationsAreaWidthEx());
    }

    @Override
    public int getIconAreaOffset() {
        return this.getLineMarkerAreaOffset() + this.getLeftFreePaintersAreaWidth();
    }

    private int getLeftFreePaintersAreaOffset() {
        return this.getLineMarkerAreaOffset();
    }

    @Override
    public int getLineMarkerFreePaintersAreaOffset() {
        return this.getIconAreaOffset() + this.myIconsAreaWidth + this.getGapAfterIconsArea();
    }

    private int getLeftFreePaintersAreaWidth() {
        return this.myLeftFreePaintersAreaShown ? FREE_PAINTERS_LEFT_AREA_WIDTH : 0;
    }

    private int getRightFreePaintersAreaWidth() {
        return this.myRightFreePaintersAreaShown ? FREE_PAINTERS_RIGHT_AREA_WIDTH : 0;
    }

    @Override
    public int getIconsAreaWidth() {
        return this.myIconsAreaWidth;
    }

    private int getGapAfterIconsArea() {
        return this.isRealEditor() && this.areIconsShown() ? GAP_BETWEEN_AREAS : 0;
    }

    private boolean isMirrored() {
        return this.myEditor.getVerticalScrollbarOrientation() != 1;
    }

    @Nullable
    private AffineTransform setMirrorTransformIfNeeded(Graphics2D g, int offset, int width) {
        if (this.isMirrored()) {
            AffineTransform old = g.getTransform();
            AffineTransform transform = new AffineTransform(old);
            transform.scale(-1.0, 1.0);
            transform.translate(-offset * 2 - width, 0.0);
            g.setTransform(transform);
            return old;
        }
        return null;
    }

    @Override
    @Nullable
    public FoldRegion findFoldingAnchorAt(int x, int y) {
        if (!this.myEditor.getSettings().isFoldingOutlineShown()) {
            return null;
        }
        int anchorX = this.getFoldingAreaOffset();
        int anchorWidth = this.getFoldingAnchorWidth();
        int visualLine = this.myEditor.yToVisibleLine(y);
        int neighbourhoodStartOffset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(visualLine, 0)));
        int neighbourhoodEndOffset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(visualLine, Integer.MAX_VALUE)));
        Collection<DisplayedFoldingAnchor> displayedAnchors = this.myAnchorsDisplayStrategy.getAnchorsToDisplay(neighbourhoodStartOffset, neighbourhoodEndOffset, null);
        for (DisplayedFoldingAnchor anchor2 : displayedAnchors) {
            if (!this.rectangleByFoldOffset(anchor2.visualLine, anchorWidth, anchorX).contains(this.convertX(x), y)) continue;
            return anchor2.foldRegion;
        }
        return null;
    }

    private Rectangle rectangleByFoldOffset(int foldStart, int anchorWidth, int anchorX) {
        return new Rectangle(anchorX, (int)this.getFoldAnchorY(foldStart, anchorWidth), anchorWidth, anchorWidth);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        TooltipController.getInstance().cancelTooltips();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int line;
        String toolTip = null;
        GutterIconRenderer renderer = this.getGutterRenderer(e);
        TooltipController controller = TooltipController.getInstance();
        if (renderer != null) {
            toolTip = renderer.getTooltipText();
        } else {
            TextAnnotationGutterProvider provider = this.getProviderAtPoint(e.getPoint());
            if (provider != null) {
                line = this.getLineNumAtPoint(e.getPoint());
                toolTip = provider.getToolTip(line, (Editor)this.myEditor);
                if (!Comparing.equal((String)toolTip, (String)this.myLastGutterToolTip)) {
                    controller.cancelTooltip(GUTTER_TOOLTIP_GROUP, e, true);
                    this.myLastGutterToolTip = toolTip;
                }
            } else {
                ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
                if (lineRenderer != null) {
                    toolTip = lineRenderer.getTooltipText();
                }
            }
        }
        if (toolTip != null && !toolTip.isEmpty()) {
            Ref t = new Ref((Object)e.getPoint());
            line = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, e);
            List<GutterMark> row = this.getGutterRenderers(line);
            Balloon.Position ballPosition = Balloon.Position.atRight;
            if (row != null) {
                TreeMap xPos = new TreeMap();
                int[] currentPos = new int[]{0};
                this.processIconsRow(line, row, (x, y, r) -> {
                    xPos.put(x, r);
                    if (renderer == r) {
                        currentPos[0] = x;
                        Icon icon = this.scaleIcon(r.getIcon());
                        t.set((Object)new Point(x + icon.getIconWidth() / 2, y + icon.getIconHeight() / 2));
                    }
                });
                ArrayList xx = new ArrayList(xPos.keySet());
                int posIndex = xx.indexOf(currentPos[0]);
                if (xPos.size() > 1 && posIndex == 0) {
                    ballPosition = Balloon.Position.below;
                }
            }
            RelativePoint showPoint = new RelativePoint((Component)this, (Point)t.get());
            controller.showTooltipByMouseMove(this.myEditor, showPoint, ((EditorMarkupModel)((Object)this.myEditor.getMarkupModel())).getErrorStripTooltipRendererProvider().calcTooltipRenderer(toolTip), false, GUTTER_TOOLTIP_GROUP, new HintHint(this, (Point)t.get()).setAwtTooltip(true).setPreferredPosition(ballPosition));
        } else {
            controller.cancelTooltip(GUTTER_TOOLTIP_GROUP, e, false);
        }
    }

    void validateMousePointer(@NotNull MouseEvent e) {
        GutterIconRenderer renderer;
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(11);
        }
        if (IdeGlassPaneImpl.hasPreProcessedCursor(this)) {
            return;
        }
        FoldRegion foldingAtCursor = this.findFoldingAnchorAt(e.getX(), e.getY());
        this.setActiveFoldRegion(foldingAtCursor);
        Cursor cursor = Cursor.getPredefinedCursor(0);
        if (foldingAtCursor != null) {
            cursor = Cursor.getPredefinedCursor(12);
        }
        if ((renderer = this.getGutterRenderer(e)) != null) {
            if (renderer.isNavigateAction()) {
                cursor = Cursor.getPredefinedCursor(12);
            }
        } else {
            ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
            if (lineRenderer != null) {
                cursor = Cursor.getPredefinedCursor(12);
            } else {
                EditorGutterAction action;
                TextAnnotationGutterProvider provider = this.getProviderAtPoint(e.getPoint());
                if (provider != null && this.myProviderToListener.containsKey(provider) && (action = this.myProviderToListener.get(provider)) != null) {
                    int line = this.getLineNumAtPoint(e.getPoint());
                    cursor = action.getCursor(line);
                }
            }
        }
        UIUtil.setCursor((Component)this, (Cursor)cursor);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e);
        }
    }

    private void fireEventToTextAnnotationListeners(MouseEvent e) {
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            int line;
            Point clickPoint = e.getPoint();
            TextAnnotationGutterProvider provider = this.getProviderAtPoint(clickPoint);
            if (provider == null) {
                return;
            }
            if (this.myProviderToListener.containsKey(provider) && (line = this.getLineNumAtPoint(clickPoint)) >= 0 && line < this.myEditor.getDocument().getLineCount() && UIUtil.isActionClick((MouseEvent)e, (int)502)) {
                this.myProviderToListener.get(provider).doAction(line);
            }
        }
    }

    private int getLineNumAtPoint(Point clickPoint) {
        return EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, clickPoint);
    }

    @Nullable
    private TextAnnotationGutterProvider getProviderAtPoint(Point clickPoint) {
        int current = this.getAnnotationsAreaOffset();
        if (clickPoint.x < current) {
            return null;
        }
        for (int i = 0; i < this.myTextAnnotationGutterSizes.size(); ++i) {
            if (clickPoint.x > (current += this.myTextAnnotationGutterSizes.get(i))) continue;
            return this.myTextAnnotationGutters.get(i);
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || this.isPopupAction(e)) {
            this.invokePopup(e);
        } else if (UIUtil.isCloseClick((MouseEvent)e)) {
            this.processClose(e);
        }
    }

    private boolean isPopupAction(MouseEvent e) {
        GutterIconRenderer renderer = this.getGutterRenderer(e);
        return renderer != null && renderer.getClickAction() == null && renderer.getPopupMenuActions() != null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e);
            return;
        }
        GutterIconRenderer renderer = this.getGutterRenderer(e);
        AnAction clickAction = null;
        if (renderer != null && e.getButton() < 4) {
            AnAction anAction = clickAction = BitUtil.isSet((int)e.getModifiers(), (int)8) ? renderer.getMiddleButtonClickAction() : renderer.getClickAction();
        }
        if (clickAction != null) {
            this.performAction(clickAction, e, "ICON_NAVIGATION", this.myEditor.getDataContext());
            this.repaint();
            e.consume();
        } else {
            ActiveGutterRenderer lineRenderer = this.getActiveRendererByMouseEvent(e);
            if (lineRenderer != null) {
                lineRenderer.doAction((Editor)this.myEditor, e);
            } else {
                this.fireEventToTextAnnotationListeners(e);
            }
        }
    }

    private boolean isDumbMode() {
        Project project = this.myEditor.getProject();
        return project != null && DumbService.isDumb((Project)project);
    }

    private boolean checkDumbAware(@NotNull Object possiblyDumbAware) {
        if (possiblyDumbAware == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(12);
        }
        return !this.isDumbMode() || DumbService.isDumbAware((Object)possiblyDumbAware);
    }

    private void notifyNotDumbAware() {
        Project project = this.myEditor.getProject();
        if (project != null) {
            DumbService.getInstance((Project)project).showDumbModeNotification("This functionality is not available during indexing");
        }
    }

    private void performAction(@NotNull AnAction action, @NotNull InputEvent e, @NotNull String place, @NotNull DataContext context) {
        if (action == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(13);
        }
        if (e == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(14);
        }
        if (place == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(15);
        }
        if (context == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(16);
        }
        if (!this.checkDumbAware(action)) {
            this.notifyNotDumbAware();
            return;
        }
        AnActionEvent actionEvent = AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)e, (String)place, (DataContext)context);
        action.update(actionEvent);
        if (actionEvent.getPresentation().isEnabledAndVisible()) {
            ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)actionEvent);
        }
    }

    @Nullable
    private ActiveGutterRenderer getActiveRendererByMouseEvent(MouseEvent e) {
        if (this.findFoldingAnchorAt(e.getX(), e.getY()) != null) {
            return null;
        }
        if (e.isConsumed() || e.getX() > this.getWhitespaceSeparatorOffset()) {
            return null;
        }
        ActiveGutterRenderer[] gutterRenderer = new ActiveGutterRenderer[]{null};
        int[] layer = new int[]{-1};
        Rectangle clip = this.myEditor.getScrollingModel().getVisibleArea();
        int firstVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y - this.myEditor.getLineHeight())));
        int lastVisibleOffset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(new Point(0, clip.y + clip.height + this.myEditor.getLineHeight())));
        this.processRangeHighlighters(firstVisibleOffset, lastVisibleOffset, highlighter -> {
            LineMarkerRenderer renderer = highlighter.getLineMarkerRenderer();
            if (renderer == null) {
                return;
            }
            if (gutterRenderer[0] != null && layer[0] >= highlighter.getLayer()) {
                return;
            }
            Rectangle rectangle = this.getLineRendererRectangle(highlighter);
            if (rectangle == null) {
                return;
            }
            int startY = rectangle.y;
            int endY = startY + rectangle.height;
            if (startY == endY) {
                endY += this.myEditor.getLineHeight();
            }
            if (startY < e.getY() && e.getY() <= endY && renderer instanceof ActiveGutterRenderer && ((ActiveGutterRenderer)renderer).canDoAction(e)) {
                gutterRenderer[0] = (ActiveGutterRenderer)renderer;
                layer[0] = highlighter.getLayer();
            }
        });
        return gutterRenderer[0];
    }

    public void closeAllAnnotations() {
        for (TextAnnotationGutterProvider provider : this.myTextAnnotationGutters) {
            provider.gutterClosed();
        }
        this.revalidateSizes();
    }

    private void revalidateSizes() {
        this.myTextAnnotationGutters = new ArrayList();
        this.myTextAnnotationGutterSizes = new TIntArrayList();
        this.updateSize();
    }

    @Override
    @Nullable
    public Point getCenterPoint(GutterIconRenderer renderer) {
        Ref result2 = Ref.create();
        if (!this.areIconsShown()) {
            this.processGutterRenderers((TIntObjectProcedure<List<GutterMark>>)((TIntObjectProcedure)(line, renderers) -> {
                if (ContainerUtil.find((Iterable)renderers, (Object)renderer) != null) {
                    result2.set((Object)new Point(this.getIconAreaOffset(), this.getLineCenterY(line)));
                    return false;
                }
                return true;
            }));
        } else {
            this.processGutterRenderers((TIntObjectProcedure<List<GutterMark>>)((TIntObjectProcedure)(line, renderers) -> {
                this.processIconsRow(line, (List<GutterMark>)renderers, (x, y, r) -> {
                    if (result2.isNull() && r.equals(renderer)) {
                        Icon icon = this.scaleIcon(r.getIcon());
                        result2.set((Object)new Point(x + icon.getIconWidth() / 2, y + icon.getIconHeight() / 2));
                    }
                });
                return result2.isNull();
            }));
        }
        return (Point)result2.get();
    }

    @Override
    public void setLineNumberConvertor(@Nullable TIntFunction lineNumberConvertor) {
        this.setLineNumberConvertor(lineNumberConvertor, null);
    }

    @Override
    public void setLineNumberConvertor(@Nullable TIntFunction lineNumberConvertor1, @Nullable TIntFunction lineNumberConvertor2) {
        this.myLineNumberConvertor = lineNumberConvertor1 != null ? lineNumberConvertor1 : value -> value;
        this.myAdditionalLineNumberConvertor = lineNumberConvertor2;
    }

    @Override
    public void setShowDefaultGutterPopup(boolean show) {
        this.myShowDefaultGutterPopup = show;
    }

    @Override
    public void setGutterPopupGroup(@Nullable ActionGroup group) {
        this.myCustomGutterPopupGroup = group;
    }

    @Override
    public void setPaintBackground(boolean value) {
        this.myPaintBackground = value;
    }

    @Override
    public void setForceShowLeftFreePaintersArea(boolean value) {
        this.myForceLeftFreePaintersAreaShown = value;
    }

    @Override
    public void setForceShowRightFreePaintersArea(boolean value) {
        this.myForceRightFreePaintersAreaShown = value;
    }

    @Override
    public void setInitialIconAreaWidth(int width) {
        this.myStartIconAreaWidth = width;
    }

    private void invokePopup(MouseEvent e) {
        ActionManager actionManager = ActionManager.getInstance();
        if (this.myEditor.getMouseEventArea(e) == EditorMouseEventArea.ANNOTATIONS_AREA) {
            DefaultActionGroup actionGroup = new DefaultActionGroup(EditorBundle.message((String)"editor.annotations.action.group.name", (Object[])new Object[0]), true);
            actionGroup.add((AnAction)new CloseAnnotationsAction());
            ArrayList<AnAction> addActions = new ArrayList<AnAction>();
            Point p = e.getPoint();
            int line = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, p);
            for (TextAnnotationGutterProvider gutterProvider : this.myTextAnnotationGutters) {
                List list2 = gutterProvider.getPopupActions(line, (Editor)this.myEditor);
                if (list2 == null) continue;
                for (AnAction action : list2) {
                    if (addActions.contains(action)) continue;
                    addActions.add(action);
                }
            }
            for (AnAction addAction : addActions) {
                actionGroup.add(addAction);
            }
            JPopupMenu menu = actionManager.createActionPopupMenu("", (ActionGroup)actionGroup).getComponent();
            menu.show(this, e.getX(), e.getY());
            e.consume();
        } else {
            GutterIconRenderer renderer = this.getGutterRenderer(e);
            if (renderer != null) {
                ActionGroup actionGroup = renderer.getPopupMenuActions();
                if (actionGroup != null) {
                    if (this.checkDumbAware(actionGroup)) {
                        ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("unknown", actionGroup);
                        popupMenu.getComponent().show(this, e.getX(), e.getY());
                    } else {
                        this.notifyNotDumbAware();
                    }
                    e.consume();
                } else {
                    AnAction rightButtonAction = renderer.getRightButtonClickAction();
                    if (rightButtonAction != null) {
                        this.performAction(rightButtonAction, e, "ICON_NAVIGATION_SECONDARY_BUTTON", this.myEditor.getDataContext());
                        e.consume();
                    }
                }
            } else {
                ActionGroup group = this.myCustomGutterPopupGroup;
                if (group == null && this.myShowDefaultGutterPopup) {
                    group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("EditorGutterPopupMenu");
                }
                if (group != null) {
                    ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("unknown", group);
                    popupMenu.getComponent().show(this, e.getX(), e.getY());
                }
                e.consume();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        TooltipController.getInstance().cancelTooltip(GUTTER_TOOLTIP_GROUP, e, false);
    }

    private int convertPointToLineNumber(Point p) {
        int line;
        DocumentEx document = this.myEditor.getDocument();
        if (!EditorGutterComponentImpl.isValidLine(document, line = EditorUtil.yPositionToLogicalLine((Editor)this.myEditor, p))) {
            return -1;
        }
        int startOffset = document.getLineStartOffset(line);
        FoldRegion region = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        if (region != null) {
            return document.getLineNumber(region.getEndOffset());
        }
        return line;
    }

    @Nullable
    private GutterMark getGutterRenderer(Point p) {
        int line = this.convertPointToLineNumber(p);
        if (line == -1) {
            return null;
        }
        List<GutterMark> renderers = this.getGutterRenderers(line);
        if (renderers == null) {
            return null;
        }
        GutterMark[] result2 = new GutterMark[]{null};
        this.processIconsRow(line, renderers, (x, y, renderer) -> {
            int ex = this.convertX((int)p.getX());
            Icon icon = this.scaleIcon(renderer.getIcon());
            if (x <= ex && ex <= x + icon.getIconWidth()) {
                result2[0] = renderer;
            }
        });
        return result2[0];
    }

    @Nullable
    private GutterIconRenderer getGutterRenderer(MouseEvent e) {
        return (GutterIconRenderer)this.getGutterRenderer(e.getPoint());
    }

    @NotNull
    private static LineMarkerRendererEx.Position getLineMarkerPosition(@NotNull LineMarkerRenderer renderer) {
        if (renderer == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(17);
        }
        if (renderer instanceof LineMarkerRendererEx) {
            LineMarkerRendererEx.Position position = ((LineMarkerRendererEx)renderer).getPosition();
            if (position == null) {
                EditorGutterComponentImpl.$$$reportNull$$$0(18);
            }
            return position;
        }
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.RIGHT;
        if (position == null) {
            EditorGutterComponentImpl.$$$reportNull$$$0(19);
        }
        return position;
    }

    int convertX(int x) {
        if (!this.isMirrored()) {
            return x;
        }
        return this.getWidth() - x;
    }

    public void dispose() {
        for (TextAnnotationGutterProvider gutterProvider : this.myTextAnnotationGutters) {
            gutterProvider.gutterClosed();
        }
        this.myProviderToListener.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possiblyDumbAware";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorGutterComponentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorGutterComponentImpl";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineMarkerPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doPaintLineNumbers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processRangeHighlighters";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processGutterRenderers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processIconsRow";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerTextAnnotation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMaxLineNumber";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateMousePointer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkDumbAware";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerPosition";
                break;
            }
            case 18: 
            case 19: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CloseAnnotationsAction
    extends DumbAwareAction {
        CloseAnnotationsAction() {
            super(EditorBundle.message((String)"close.editor.annotations.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAnnotationsAction.$$$reportNull$$$0(0);
            }
            EditorGutterComponentImpl.this.closeAllAnnotations();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorGutterComponentImpl$CloseAnnotationsAction", "actionPerformed"));
        }
    }

    @FunctionalInterface
    private static interface LineGutterIconRendererProcessor {
        public void process(int var1, int var2, @NotNull GutterMark var3);
    }

    @FunctionalInterface
    private static interface RangeHighlighterProcessor {
        public void process(@NotNull RangeHighlighter var1);
    }
}

