/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.roots.impl.DirectoryInfoWithExcludePatterns;
import com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.PackageDirectoryCache;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SLRUMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class RootIndex {
    public static final Comparator<OrderEntry> BY_OWNER_MODULE = (o1, o2) -> {
        String name1 = o1.getOwnerModule().getName();
        String name2 = o2.getOwnerModule().getName();
        return name1.compareTo(name2);
    };
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.RootIndex");
    private static final FileTypeRegistry ourFileTypes = FileTypeRegistry.getInstance();
    private final Map<VirtualFile, String> myPackagePrefixByRoot;
    private final InfoCache myInfoCache;
    private final List<JpsModuleSourceRootType<?>> myRootTypes;
    private final TObjectIntHashMap<JpsModuleSourceRootType<?>> myRootTypeId;
    @NotNull
    private final Project myProject;
    private final PackageDirectoryCache myPackageDirectoryCache;
    private OrderEntryGraph myOrderEntryGraph;

    public RootIndex(@NotNull Project project, @NotNull InfoCache cache) {
        if (project == null) {
            RootIndex.$$$reportNull$$$0(0);
        }
        if (cache == null) {
            RootIndex.$$$reportNull$$$0(1);
        }
        this.myPackagePrefixByRoot = ContainerUtil.newHashMap();
        this.myRootTypes = ContainerUtil.newArrayList();
        this.myRootTypeId = new TObjectIntHashMap();
        this.myProject = project;
        this.myInfoCache = cache;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootInfo info = this.buildRootInfo(project);
        MultiMap rootsByPackagePrefix = MultiMap.create();
        Set<VirtualFile> allRoots = info.getAllRoots();
        for (VirtualFile root : allRoots) {
            Pair<DirectoryInfo, String> pair;
            List<VirtualFile> hierarchy = RootIndex.getHierarchy(root, allRoots, info);
            if (hierarchy != null) {
                pair = RootIndex.calcDirectoryInfo(root, hierarchy, info);
            } else {
                Pair<DirectoryInfo, String> pair2;
                pair = pair2;
                super((Object)NonProjectDirectoryInfo.IGNORED, null);
            }
            Pair<DirectoryInfo, String> pair3 = pair;
            this.cacheInfos(root, root, (DirectoryInfo)pair3.first);
            rootsByPackagePrefix.putValue(pair3.second, (Object)root);
            this.myPackagePrefixByRoot.put(root, (String)pair3.second);
        }
        this.myPackageDirectoryCache = new PackageDirectoryCache(rootsByPackagePrefix){

            @Override
            protected boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName) {
                if (dir == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (packageName == null) {
                    1.$$$reportNull$$$0(1);
                }
                return RootIndex.this.getInfoForFile(dir).isInProject(dir) && packageName.equals(RootIndex.this.getPackageName(dir));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dir";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "packageName";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/impl/RootIndex$1";
                objectArray[2] = "isPackageDirectory";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void onLowMemory() {
        this.myPackageDirectoryCache.onLowMemory();
    }

    @NotNull
    private RootInfo buildRootInfo(@NotNull Project project) {
        if (project == null) {
            RootIndex.$$$reportNull$$$0(2);
        }
        RootInfo info = new RootInfo();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (VirtualFile contentRoot : moduleRootManager.getContentRoots()) {
                if (info.contentRootOf.containsKey(contentRoot) || !RootIndex.ensureValid(contentRoot, module)) continue;
                info.contentRootOf.put(contentRoot, module);
            }
            for (ContentEntry contentEntry : moduleRootManager.getContentEntries()) {
                Object patterns;
                int n;
                if (!(contentEntry instanceof ContentEntryImpl) || !((ContentEntryImpl)contentEntry).isDisposed()) {
                    VirtualFile[] virtualFileArray = contentEntry.getExcludeFolderFiles();
                    int n2 = virtualFileArray.length;
                    for (n = 0; n < n2; ++n) {
                        VirtualFile excludeRoot = virtualFileArray[n];
                        if (!RootIndex.ensureValid(excludeRoot, contentEntry)) continue;
                        info.excludedFromModule.put(excludeRoot, module);
                    }
                    patterns = contentEntry.getExcludePatterns();
                    if (!patterns.isEmpty()) {
                        FileTypeAssocTable table = new FileTypeAssocTable();
                        Iterator iterator = patterns.iterator();
                        while (iterator.hasNext()) {
                            String pattern = (String)iterator.next();
                            table.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(pattern), (Object)Boolean.TRUE);
                        }
                        info.excludeFromContentRootTables.put(contentEntry.getFile(), (FileTypeAssocTable<Boolean>)table);
                    }
                }
                patterns = contentEntry.getSourceFolders();
                int table = ((SourceFolder[])patterns).length;
                for (n = 0; n < table; ++n) {
                    VirtualFile[] sourceFolder = patterns[n];
                    VirtualFile sourceFolderRoot = sourceFolder.getFile();
                    if (sourceFolderRoot == null || !RootIndex.ensureValid(sourceFolderRoot, sourceFolder)) continue;
                    info.rootTypeId.put((Object)sourceFolderRoot, this.getRootTypeId(sourceFolder.getRootType()));
                    info.classAndSourceRoots.add(sourceFolderRoot);
                    info.sourceRootOf.putValue((Object)sourceFolderRoot, (Object)module);
                    info.packagePrefix.put(sourceFolderRoot, sourceFolder.getPackagePrefix());
                }
            }
            for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                Library library;
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                VirtualFile[] sourceRoots = entry.getRootFiles(OrderRootType.SOURCES);
                VirtualFile[] classRoots = entry.getRootFiles(OrderRootType.CLASSES);
                for (VirtualFile sourceRoot : sourceRoots) {
                    if (!RootIndex.ensureValid(sourceRoot, entry)) continue;
                    info.classAndSourceRoots.add(sourceRoot);
                    info.libraryOrSdkSources.add(sourceRoot);
                    info.packagePrefix.put(sourceRoot, "");
                }
                for (VirtualFile classRoot : classRoots) {
                    if (!RootIndex.ensureValid(classRoot, entry)) continue;
                    info.classAndSourceRoots.add(classRoot);
                    info.libraryOrSdkClasses.add(classRoot);
                    info.packagePrefix.put(classRoot, "");
                }
                if (!(orderEntry instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)orderEntry).getLibrary()) == null) continue;
                for (VirtualFile root : ((LibraryEx)library).getExcludedRoots()) {
                    if (!RootIndex.ensureValid(root, library)) continue;
                    info.excludedFromLibraries.putValue((Object)root, (Object)library);
                }
                for (VirtualFile root : sourceRoots) {
                    if (!RootIndex.ensureValid(root, library)) continue;
                    info.sourceOfLibraries.putValue((Object)root, (Object)library);
                }
                for (VirtualFile root : classRoots) {
                    if (!RootIndex.ensureValid(root, library)) continue;
                    info.classOfLibraries.putValue((Object)root, (Object)library);
                }
            }
        }
        for (Module module : (AdditionalLibraryRootsProvider[])Extensions.getExtensions(AdditionalLibraryRootsProvider.EP_NAME)) {
            Collection<SyntheticLibrary> libraries = module.getAdditionalProjectLibraries(project);
            for (SyntheticLibrary descriptor : libraries) {
                for (VirtualFile root : descriptor.getSourceRoots()) {
                    if (!RootIndex.ensureValid(root, descriptor)) continue;
                    info.libraryOrSdkSources.add(root);
                    info.classAndSourceRoots.add(root);
                    info.sourceOfLibraries.putValue((Object)root, (Object)descriptor);
                }
                for (VirtualFile file2 : descriptor.getExcludedRoots()) {
                    if (!RootIndex.ensureValid(file2, project)) continue;
                    info.excludedFromLibraries.putValue((Object)file2, (Object)descriptor);
                }
            }
        }
        for (Module module : (DirectoryIndexExcludePolicy[])Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)project)) {
            info.excludedFromProject.addAll(ContainerUtil.filter((Object[])module.getExcludeRootsForProject(), arg_0 -> RootIndex.lambda$buildRootInfo$1((DirectoryIndexExcludePolicy)module, arg_0)));
            Function<Sdk, List<VirtualFile>> fun = module.getExcludeSdkRootsStrategy();
            if (fun == null) continue;
            HashSet<Sdk> sdks = new HashSet<Sdk>();
            for (Module m : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                Sdk sdk = ModuleRootManager.getInstance((Module)m).getSdk();
                if (sdk == null) continue;
                sdks.add(sdk);
            }
            HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
            for (Sdk sdk : sdks) {
                roots.addAll(Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES)));
            }
            for (Sdk sdk : sdks) {
                info.excludedFromSdkRoots.addAll(ContainerUtil.filter((Collection)((Collection)fun.fun((Object)sdk)), arg_0 -> RootIndex.lambda$buildRootInfo$2((DirectoryIndexExcludePolicy)module, roots, arg_0)));
            }
        }
        for (UnloadedModuleDescription description : moduleManager.getUnloadedModuleDescriptions()) {
            for (VirtualFilePointer virtualFilePointer : description.getContentRoots()) {
                VirtualFile contentRoot = virtualFilePointer.getFile();
                if (contentRoot == null || !RootIndex.ensureValid(contentRoot, description)) continue;
                info.contentRootOfUnloaded.put(contentRoot, description.getName());
            }
        }
        RootInfo rootInfo = info;
        if (rootInfo == null) {
            RootIndex.$$$reportNull$$$0(3);
        }
        return rootInfo;
    }

    private static boolean ensureValid(@NotNull VirtualFile file2, @NotNull Object container) {
        if (file2 == null) {
            RootIndex.$$$reportNull$$$0(4);
        }
        if (container == null) {
            RootIndex.$$$reportNull$$$0(5);
        }
        if (!(file2 instanceof VirtualFileWithId)) {
            return false;
        }
        if (!file2.isValid()) {
            LOG.error("Invalid root " + file2 + " in " + container);
            return false;
        }
        return true;
    }

    @NotNull
    private synchronized OrderEntryGraph getOrderEntryGraph() {
        if (this.myOrderEntryGraph == null) {
            RootInfo rootInfo = this.buildRootInfo(this.myProject);
            this.myOrderEntryGraph = new OrderEntryGraph(this.myProject, rootInfo);
        }
        OrderEntryGraph orderEntryGraph = this.myOrderEntryGraph;
        if (orderEntryGraph == null) {
            RootIndex.$$$reportNull$$$0(6);
        }
        return orderEntryGraph;
    }

    private int getRootTypeId(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            RootIndex.$$$reportNull$$$0(7);
        }
        if (this.myRootTypeId.containsKey(rootType)) {
            return this.myRootTypeId.get(rootType);
        }
        int id = this.myRootTypes.size();
        if (id > 127) {
            LOG.error("Too many different types of module source roots (" + id + ") registered: " + this.myRootTypes);
        }
        this.myRootTypes.add(rootType);
        this.myRootTypeId.put(rootType, id);
        return id;
    }

    @NotNull
    public DirectoryInfo getInfoForFile(@NotNull VirtualFile file2) {
        VirtualFile dir;
        if (file2 == null) {
            RootIndex.$$$reportNull$$$0(8);
        }
        if (!file2.isValid()) {
            NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.INVALID;
            if (nonProjectDirectoryInfo == null) {
                RootIndex.$$$reportNull$$$0(9);
            }
            return nonProjectDirectoryInfo;
        }
        if (!file2.isDirectory()) {
            DirectoryInfo info = this.myInfoCache.getCachedInfo(file2);
            if (info != null) {
                DirectoryInfo directoryInfo = info;
                if (directoryInfo == null) {
                    RootIndex.$$$reportNull$$$0(10);
                }
                return directoryInfo;
            }
            if (ourFileTypes.isFileIgnored(file2)) {
                NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.IGNORED;
                if (nonProjectDirectoryInfo == null) {
                    RootIndex.$$$reportNull$$$0(11);
                }
                return nonProjectDirectoryInfo;
            }
            dir = file2.getParent();
        } else {
            dir = file2;
        }
        int count = 0;
        for (VirtualFile root = dir; root != null; root = root.getParent()) {
            if (++count > 1000) {
                throw new IllegalStateException("Possible loop in tree, started at " + dir.getName());
            }
            DirectoryInfo info = this.myInfoCache.getCachedInfo(root);
            if (info != null) {
                if (!dir.equals(root)) {
                    this.cacheInfos(dir, root, info);
                }
                DirectoryInfo directoryInfo = info;
                if (directoryInfo == null) {
                    RootIndex.$$$reportNull$$$0(12);
                }
                return directoryInfo;
            }
            if (!ourFileTypes.isFileIgnored(root)) continue;
            DirectoryInfo directoryInfo = this.cacheInfos(dir, root, NonProjectDirectoryInfo.IGNORED);
            if (directoryInfo == null) {
                RootIndex.$$$reportNull$$$0(13);
            }
            return directoryInfo;
        }
        DirectoryInfo directoryInfo = this.cacheInfos(dir, null, NonProjectDirectoryInfo.NOT_UNDER_PROJECT_ROOTS);
        if (directoryInfo == null) {
            RootIndex.$$$reportNull$$$0(14);
        }
        return directoryInfo;
    }

    @NotNull
    private DirectoryInfo cacheInfos(VirtualFile dir, @Nullable VirtualFile stopAt, @NotNull DirectoryInfo info) {
        if (info == null) {
            RootIndex.$$$reportNull$$$0(15);
        }
        while (dir != null) {
            this.myInfoCache.cacheInfo(dir, info);
            if (dir.equals(stopAt)) break;
            dir = dir.getParent();
        }
        DirectoryInfo directoryInfo = info;
        if (directoryInfo == null) {
            RootIndex.$$$reportNull$$$0(16);
        }
        return directoryInfo;
    }

    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            RootIndex.$$$reportNull$$$0(17);
        }
        List result2 = this.myPackageDirectoryCache.getDirectoriesByPackageName(packageName);
        if (!includeLibrarySources) {
            result2 = ContainerUtil.filter(result2, file2 -> {
                DirectoryInfo info = this.getInfoForFile((VirtualFile)file2);
                return info.isInProject((VirtualFile)file2) && (!info.isInLibrarySource((VirtualFile)file2) || info.isInModuleSource((VirtualFile)file2) || info.hasLibraryClassRoot());
            });
        }
        CollectionQuery collectionQuery = new CollectionQuery(result2);
        if (collectionQuery == null) {
            RootIndex.$$$reportNull$$$0(18);
        }
        return collectionQuery;
    }

    @Nullable
    public String getPackageName(@NotNull VirtualFile dir) {
        if (dir == null) {
            RootIndex.$$$reportNull$$$0(19);
        }
        if (dir.isDirectory()) {
            if (ourFileTypes.isFileIgnored(dir)) {
                return null;
            }
            if (this.myPackagePrefixByRoot.containsKey(dir)) {
                return this.myPackagePrefixByRoot.get(dir);
            }
            VirtualFile parent = dir.getParent();
            if (parent != null) {
                return RootIndex.getPackageNameForSubdir(this.getPackageName(parent), dir.getName());
            }
        }
        return null;
    }

    @Nullable
    protected static String getPackageNameForSubdir(@Nullable String parentPackageName, @NotNull String subdirName) {
        if (subdirName == null) {
            RootIndex.$$$reportNull$$$0(20);
        }
        if (parentPackageName == null) {
            return null;
        }
        return parentPackageName.isEmpty() ? subdirName : parentPackageName + "." + subdirName;
    }

    @Nullable
    public JpsModuleSourceRootType<?> getSourceRootType(@NotNull DirectoryInfo directoryInfo) {
        if (directoryInfo == null) {
            RootIndex.$$$reportNull$$$0(21);
        }
        return this.myRootTypes.get(directoryInfo.getSourceRootTypeId());
    }

    boolean resetOnEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            RootIndex.$$$reportNull$$$0(22);
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2 = vFileEvent.getFile();
            if (file2 != null && !file2.isDirectory()) continue;
            return true;
        }
        return false;
    }

    @Nullable(value="returns null only if dir is under ignored folder")
    private static List<VirtualFile> getHierarchy(VirtualFile dir, @NotNull Set<VirtualFile> allRoots, @NotNull RootInfo info) {
        if (allRoots == null) {
            RootIndex.$$$reportNull$$$0(23);
        }
        if (info == null) {
            RootIndex.$$$reportNull$$$0(24);
        }
        ArrayList hierarchy = ContainerUtil.newArrayList();
        boolean hasContentRoots = false;
        while (dir != null) {
            if (!(hasContentRoots |= info.contentRootOf.get(dir) != null) && ourFileTypes.isFileIgnored(dir)) {
                return null;
            }
            if (allRoots.contains(dir)) {
                hierarchy.add(dir);
            }
            dir = dir.getParent();
        }
        return hierarchy;
    }

    @NotNull
    private static Pair<DirectoryInfo, String> calcDirectoryInfo(@NotNull VirtualFile root, @NotNull List<VirtualFile> hierarchy, @NotNull RootInfo info) {
        VirtualFile nearestContentRoot;
        boolean inProject;
        if (root == null) {
            RootIndex.$$$reportNull$$$0(25);
        }
        if (hierarchy == null) {
            RootIndex.$$$reportNull$$$0(26);
        }
        if (info == null) {
            RootIndex.$$$reportNull$$$0(27);
        }
        VirtualFile moduleContentRoot = info.findNearestContentRoot(hierarchy);
        Pair librarySourceRootInfo = info.findLibraryRootInfo(hierarchy, true);
        VirtualFile librarySourceRoot = librarySourceRootInfo != null ? (VirtualFile)librarySourceRootInfo.first : null;
        Pair libraryClassRootInfo = info.findLibraryRootInfo(hierarchy, false);
        VirtualFile libraryClassRoot = libraryClassRootInfo != null ? (VirtualFile)libraryClassRootInfo.first : null;
        boolean bl = inProject = moduleContentRoot != null || (libraryClassRoot != null || librarySourceRoot != null) && !info.excludedFromSdkRoots.contains(root);
        if (inProject) {
            nearestContentRoot = moduleContentRoot;
        } else {
            nearestContentRoot = info.findNearestContentRootForExcluded(hierarchy);
            if (nearestContentRoot == null) {
                Pair pair = new Pair((Object)NonProjectDirectoryInfo.EXCLUDED, null);
                if (pair == null) {
                    RootIndex.$$$reportNull$$$0(28);
                }
                return pair;
            }
        }
        VirtualFile sourceRoot = info.findPackageRootInfo(hierarchy, moduleContentRoot, null, librarySourceRoot);
        VirtualFile moduleSourceRoot = info.findPackageRootInfo(hierarchy, moduleContentRoot, null, null);
        boolean inModuleSources = moduleSourceRoot != null;
        boolean inLibrarySource = librarySourceRoot != null;
        int typeId = moduleSourceRoot != null ? info.rootTypeId.get((Object)moduleSourceRoot) : 0;
        Module module = info.contentRootOf.get(nearestContentRoot);
        String unloadedModuleName = info.contentRootOfUnloaded.get(nearestContentRoot);
        FileTypeAssocTable<Boolean> contentExcludePatterns = moduleContentRoot != null ? info.excludeFromContentRootTables.get(moduleContentRoot) : null;
        Condition<VirtualFile> libraryExclusionPredicate = RootIndex.getLibraryExclusionPredicate((Pair<VirtualFile, Collection<Object>>)librarySourceRootInfo);
        DirectoryInfoImpl directoryInfo = contentExcludePatterns != null || libraryExclusionPredicate != null ? new DirectoryInfoWithExcludePatterns(root, module, nearestContentRoot, sourceRoot, libraryClassRoot, inModuleSources, inLibrarySource, !inProject, typeId, contentExcludePatterns, libraryExclusionPredicate, unloadedModuleName) : new DirectoryInfoImpl(root, module, nearestContentRoot, sourceRoot, libraryClassRoot, inModuleSources, inLibrarySource, !inProject, typeId, unloadedModuleName);
        String packagePrefix = info.calcPackagePrefix(root, hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot);
        Pair pair = Pair.create((Object)directoryInfo, (Object)packagePrefix);
        if (pair == null) {
            RootIndex.$$$reportNull$$$0(29);
        }
        return pair;
    }

    @Nullable
    private static Condition<VirtualFile> getLibraryExclusionPredicate(@Nullable Pair<VirtualFile, Collection<Object>> libraryRootInfo) {
        Condition result2 = Conditions.alwaysFalse();
        if (libraryRootInfo != null) {
            for (Object library : (Collection)libraryRootInfo.second) {
                Condition<VirtualFile> exclusionPredicate;
                Condition<VirtualFile> condition = exclusionPredicate = library instanceof SyntheticLibrary ? ((SyntheticLibrary)library).getExcludeFileCondition() : null;
                if (exclusionPredicate == null) continue;
                result2 = Conditions.or((Condition)result2, exclusionPredicate);
            }
        }
        return result2 != Condition.FALSE ? result2 : null;
    }

    @NotNull
    public List<OrderEntry> getOrderEntries(@NotNull DirectoryInfo info) {
        if (info == null) {
            RootIndex.$$$reportNull$$$0(30);
        }
        if (!(info instanceof DirectoryInfoImpl)) {
            List<OrderEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                RootIndex.$$$reportNull$$$0(31);
            }
            return list2;
        }
        List list3 = this.getOrderEntryGraph().getOrderEntries(((DirectoryInfoImpl)info).getRoot());
        if (list3 == null) {
            RootIndex.$$$reportNull$$$0(32);
        }
        return list3;
    }

    @NotNull
    public Set<String> getDependentUnloadedModules(@NotNull Module module) {
        if (module == null) {
            RootIndex.$$$reportNull$$$0(33);
        }
        Set<String> set2 = this.getOrderEntryGraph().getDependentUnloadedModules(module);
        if (set2 == null) {
            RootIndex.$$$reportNull$$$0(34);
        }
        return set2;
    }

    private static /* synthetic */ boolean lambda$buildRootInfo$2(DirectoryIndexExcludePolicy policy, Set roots, VirtualFile file2) {
        return RootIndex.ensureValid(file2, policy) && !roots.contains(file2);
    }

    private static /* synthetic */ boolean lambda$buildRootInfo$1(DirectoryIndexExcludePolicy policy, VirtualFile file2) {
        return RootIndex.ensureValid(file2, policy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 15: 
            case 24: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdirName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryInfo";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRoots";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchy";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRootInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntryGraph";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheInfos";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDirectoryInfo";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentUnloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildRootInfo";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRootTypeId";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cacheInfos";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameForSubdir";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resetOnEvents";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchy";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "calcDirectoryInfo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDependentUnloadedModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class SynchronizedSLRUCache<K, V>
    extends SLRUMap<K, V> {
        protected final Object myLock = new Object();

        protected SynchronizedSLRUCache(int protectedQueueSize, int probationalQueueSize) {
            super(protectedQueueSize, probationalQueueSize);
        }

        @NotNull
        public abstract V createValue(K var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public V get(K key) {
            Object value;
            Object object = this.myLock;
            synchronized (object) {
                value = super.get(key);
                if (value != null) {
                    Object object2 = value;
                    // MONITOREXIT @DISABLED, blocks:[3, 7] lbl6 : MonitorExitStatement: MONITOREXIT : var3_2
                    if (object2 == null) {
                        SynchronizedSLRUCache.$$$reportNull$$$0(0);
                    }
                    return (V)object2;
                }
            }
            value = this.createValue(key);
            object = this.myLock;
            synchronized (object) {
                this.put(key, value);
            }
            Object object3 = value;
            if (object3 == null) {
                SynchronizedSLRUCache.$$$reportNull$$$0(1);
            }
            return (V)object3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$SynchronizedSLRUCache", "get"));
        }
    }

    public static interface InfoCache {
        @Nullable
        public DirectoryInfo getCachedInfo(@NotNull VirtualFile var1);

        public void cacheInfo(@NotNull VirtualFile var1, @NotNull DirectoryInfo var2);
    }

    private static class RootInfo {
        @NotNull
        final LinkedHashSet<VirtualFile> classAndSourceRoots = ContainerUtil.newLinkedHashSet();
        @NotNull
        final Set<VirtualFile> libraryOrSdkSources = ContainerUtil.newHashSet();
        @NotNull
        final Set<VirtualFile> libraryOrSdkClasses = ContainerUtil.newHashSet();
        @NotNull
        final Map<VirtualFile, Module> contentRootOf = ContainerUtil.newHashMap();
        @NotNull
        final Map<VirtualFile, String> contentRootOfUnloaded = ContainerUtil.newHashMap();
        @NotNull
        final MultiMap<VirtualFile, Module> sourceRootOf = MultiMap.createSet();
        @NotNull
        final TObjectIntHashMap<VirtualFile> rootTypeId = new TObjectIntHashMap();
        @NotNull
        final MultiMap<VirtualFile, Object> excludedFromLibraries = MultiMap.createSmart();
        @NotNull
        final MultiMap<VirtualFile, Library> classOfLibraries = MultiMap.createSmart();
        @NotNull
        final MultiMap<VirtualFile, Object> sourceOfLibraries = MultiMap.createSmart();
        @NotNull
        final Set<VirtualFile> excludedFromProject = ContainerUtil.newHashSet();
        @NotNull
        final Set<VirtualFile> excludedFromSdkRoots = ContainerUtil.newHashSet();
        @NotNull
        final Map<VirtualFile, Module> excludedFromModule = ContainerUtil.newHashMap();
        @NotNull
        final Map<VirtualFile, FileTypeAssocTable<Boolean>> excludeFromContentRootTables = ContainerUtil.newHashMap();
        @NotNull
        final Map<VirtualFile, String> packagePrefix = ContainerUtil.newHashMap();

        private RootInfo() {
        }

        @NotNull
        Set<VirtualFile> getAllRoots() {
            LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
            result2.addAll(this.classAndSourceRoots);
            result2.addAll(this.contentRootOf.keySet());
            result2.addAll(this.contentRootOfUnloaded.keySet());
            result2.addAll(this.excludedFromLibraries.keySet());
            result2.addAll(this.excludedFromModule.keySet());
            result2.addAll(this.excludedFromProject);
            result2.addAll(this.excludedFromSdkRoots);
            LinkedHashSet linkedHashSet = result2;
            if (linkedHashSet == null) {
                RootInfo.$$$reportNull$$$0(0);
            }
            return linkedHashSet;
        }

        @Nullable
        private VirtualFile findNearestContentRoot(@NotNull List<VirtualFile> hierarchy) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(1);
            }
            Collection sourceRootOwners = null;
            boolean underExcludedSourceRoot = false;
            for (VirtualFile root : hierarchy) {
                Collection modulesForSourceRoot;
                FileTypeAssocTable<Boolean> table;
                Module module = this.contentRootOf.get(root);
                Module excludedFrom = this.excludedFromModule.get(root);
                if (module != null && (table = this.excludeFromContentRootTables.get(root)) != null && RootInfo.isExcludedByPattern(root, hierarchy, table)) {
                    excludedFrom = module;
                }
                if (module != null && (excludedFrom != module || underExcludedSourceRoot && sourceRootOwners.contains(module))) {
                    return root;
                }
                if (excludedFrom != null || this.excludedFromProject.contains(root) || this.contentRootOfUnloaded.containsKey(root)) {
                    if (sourceRootOwners != null) {
                        underExcludedSourceRoot = true;
                    } else {
                        return null;
                    }
                }
                if (underExcludedSourceRoot || !this.sourceRootOf.containsKey((Object)root) || (modulesForSourceRoot = this.sourceRootOf.get((Object)root)).isEmpty()) continue;
                if (sourceRootOwners == null) {
                    sourceRootOwners = modulesForSourceRoot;
                    continue;
                }
                sourceRootOwners = ContainerUtil.union((Collection)sourceRootOwners, (Collection)modulesForSourceRoot);
            }
            return null;
        }

        private static boolean isExcludedByPattern(VirtualFile contentRoot, List<VirtualFile> hierarchy, FileTypeAssocTable<Boolean> table) {
            for (VirtualFile file2 : hierarchy) {
                if (table.findAssociatedFileType(file2.getNameSequence()) != null) {
                    return true;
                }
                if (!file2.equals(contentRoot)) continue;
                break;
            }
            return false;
        }

        @Nullable
        private VirtualFile findNearestContentRootForExcluded(@NotNull List<VirtualFile> hierarchy) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(2);
            }
            for (VirtualFile root : hierarchy) {
                if (!this.contentRootOf.containsKey(root) && !this.contentRootOfUnloaded.containsKey(root)) continue;
                return root;
            }
            return null;
        }

        @Nullable
        private Pair<VirtualFile, Collection<Object>> findLibraryRootInfo(@NotNull List<VirtualFile> hierarchy, boolean source) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(3);
            }
            HashSet librariesToIgnore = ContainerUtil.newHashSet();
            for (VirtualFile root : hierarchy) {
                Collection<Object> rootProducers;
                librariesToIgnore.addAll(this.excludedFromLibraries.get((Object)root));
                if (source && this.libraryOrSdkSources.contains(root)) {
                    if (!this.sourceOfLibraries.containsKey((Object)root)) {
                        return Pair.create((Object)root, Collections.emptySet());
                    }
                    rootProducers = this.findLibrarySourceRootProducers(librariesToIgnore, root);
                    if (rootProducers.isEmpty()) continue;
                    return Pair.create((Object)root, rootProducers);
                }
                if (source || !this.libraryOrSdkClasses.contains(root)) continue;
                if (!this.classOfLibraries.containsKey((Object)root)) {
                    return Pair.create((Object)root, Collections.emptySet());
                }
                rootProducers = this.findLibraryClassRootProducers(librariesToIgnore, root);
                if (rootProducers.isEmpty()) continue;
                return Pair.create((Object)root, rootProducers);
            }
            return null;
        }

        @NotNull
        private Collection<Object> findLibraryClassRootProducers(Set<Object> librariesToIgnore, VirtualFile root) {
            HashSet libraries = ContainerUtil.newHashSet((Iterable)this.classOfLibraries.get((Object)root));
            libraries.removeAll(librariesToIgnore);
            HashSet hashSet = libraries;
            if (hashSet == null) {
                RootInfo.$$$reportNull$$$0(4);
            }
            return hashSet;
        }

        @NotNull
        private Collection<Object> findLibrarySourceRootProducers(Set<Object> librariesToIgnore, VirtualFile root) {
            HashSet libraries = ContainerUtil.newHashSet();
            for (Object library : this.sourceOfLibraries.get((Object)root)) {
                Condition<VirtualFile> exclusion;
                if (librariesToIgnore.contains(library) || library instanceof SyntheticLibrary && (exclusion = ((SyntheticLibrary)library).getExcludeFileCondition()) != null && exclusion.value((Object)root)) continue;
                libraries.add(library);
            }
            HashSet hashSet = libraries;
            if (hashSet == null) {
                RootInfo.$$$reportNull$$$0(5);
            }
            return hashSet;
        }

        private String calcPackagePrefix(@NotNull VirtualFile root, @NotNull List<VirtualFile> hierarchy, VirtualFile moduleContentRoot, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot) {
            VirtualFile packageRoot;
            String prefix;
            if (root == null) {
                RootInfo.$$$reportNull$$$0(6);
            }
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(7);
            }
            if ((prefix = this.packagePrefix.get(packageRoot = this.findPackageRootInfo(hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot))) != null && !root.equals(packageRoot)) {
                assert (packageRoot != null);
                String relative = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)packageRoot, (char)'.');
                prefix = StringUtil.isEmpty((String)prefix) ? relative : prefix + '.' + relative;
            }
            return prefix;
        }

        @Nullable
        private VirtualFile findPackageRootInfo(@NotNull List<VirtualFile> hierarchy, VirtualFile moduleContentRoot, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(8);
            }
            for (VirtualFile root : hierarchy) {
                if (moduleContentRoot != null && this.sourceRootOf.get((Object)root).contains(this.contentRootOf.get(moduleContentRoot)) && librarySourceRoot == null) {
                    return root;
                }
                if (root.equals(libraryClassRoot) || root.equals(librarySourceRoot)) {
                    return root;
                }
                if (!root.equals(moduleContentRoot) || this.sourceRootOf.containsKey((Object)root) || librarySourceRoot != null || libraryClassRoot != null) continue;
                return null;
            }
            return null;
        }

        @NotNull
        private LinkedHashSet<OrderEntry> getLibraryOrderEntries(@NotNull List<VirtualFile> hierarchy, @Nullable VirtualFile libraryClassRoot, @Nullable VirtualFile librarySourceRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libSourceRootEntries) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(9);
            }
            if (libClassRootEntries == null) {
                RootInfo.$$$reportNull$$$0(10);
            }
            if (libSourceRootEntries == null) {
                RootInfo.$$$reportNull$$$0(11);
            }
            LinkedHashSet orderEntries = ContainerUtil.newLinkedHashSet();
            for (VirtualFile root : hierarchy) {
                if (root.equals(libraryClassRoot) && !this.sourceRootOf.containsKey((Object)root)) {
                    orderEntries.addAll(libClassRootEntries.get((Object)root));
                }
                if (root.equals(librarySourceRoot) && libraryClassRoot == null) {
                    orderEntries.addAll(libSourceRootEntries.get((Object)root));
                }
                if (!libClassRootEntries.containsKey((Object)root) && (!this.sourceRootOf.containsKey((Object)root) || librarySourceRoot != null)) continue;
                break;
            }
            LinkedHashSet linkedHashSet = orderEntries;
            if (linkedHashSet == null) {
                RootInfo.$$$reportNull$$$0(12);
            }
            return linkedHashSet;
        }

        @Nullable
        private ModuleSourceOrderEntry getModuleSourceEntry(@NotNull List<VirtualFile> hierarchy, @NotNull VirtualFile moduleContentRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries) {
            if (hierarchy == null) {
                RootInfo.$$$reportNull$$$0(13);
            }
            if (moduleContentRoot == null) {
                RootInfo.$$$reportNull$$$0(14);
            }
            if (libClassRootEntries == null) {
                RootInfo.$$$reportNull$$$0(15);
            }
            Module module = this.contentRootOf.get(moduleContentRoot);
            for (VirtualFile root : hierarchy) {
                if (this.sourceRootOf.get((Object)root).contains(module)) {
                    return (ModuleSourceOrderEntry)ContainerUtil.findInstance((Object[])ModuleRootManager.getInstance((Module)module).getOrderEntries(), ModuleSourceOrderEntry.class);
                }
                if (!libClassRootEntries.containsKey((Object)root)) continue;
                return null;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/RootIndex$RootInfo";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hierarchy";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 10: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libClassRootEntries";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libSourceRootEntries";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleContentRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllRoots";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$RootInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findLibraryClassRootProducers";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findLibrarySourceRootProducers";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryOrderEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestContentRoot";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findNearestContentRootForExcluded";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findLibraryRootInfo";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "calcPackagePrefix";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findPackageRootInfo";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryOrderEntries";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleSourceEntry";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OrderEntryGraph {
        final Project myProject;
        final RootInfo myRootInfo;
        final Set<VirtualFile> myAllRoots;
        Graph myGraph;
        MultiMap<VirtualFile, Node> myRoots;
        final SynchronizedSLRUCache<VirtualFile, List<OrderEntry>> myCache;
        final SynchronizedSLRUCache<Module, Set<String>> myDependentUnloadedModulesCache;
        private MultiMap<VirtualFile, OrderEntry> myLibClassRootEntries;
        private MultiMap<VirtualFile, OrderEntry> myLibSourceRootEntries;

        public OrderEntryGraph(Project project, RootInfo rootInfo) {
            this.myProject = project;
            this.myRootInfo = rootInfo;
            this.myAllRoots = this.myRootInfo.getAllRoots();
            int cacheSize = Math.max(25, this.myAllRoots.size() / 100 * 2);
            this.myCache = new SynchronizedSLRUCache<VirtualFile, List<OrderEntry>>(cacheSize, cacheSize){

                @Override
                @NotNull
                public List<OrderEntry> createValue(VirtualFile key) {
                    List list2 = this.collectOrderEntries(key);
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$1", "createValue"));
                }
            };
            int dependentUnloadedModulesCacheSize = ModuleManager.getInstance((Project)project).getModules().length / 2;
            this.myDependentUnloadedModulesCache = new SynchronizedSLRUCache<Module, Set<String>>(dependentUnloadedModulesCacheSize, dependentUnloadedModulesCacheSize){

                @Override
                @NotNull
                public Set<String> createValue(Module key) {
                    Set set2 = this.collectDependentUnloadedModules(key);
                    if (set2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return set2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$2", "createValue"));
                }
            };
            this.initGraph();
            this.initLibraryRoots();
        }

        private void initGraph() {
            Graph graph = new Graph();
            MultiMap roots = MultiMap.createSmart();
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            for (Module module : moduleManager.getModules()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                List<OrderEnumerationHandler> handlers = OrderEnumeratorBase.getCustomHandlers(module);
                for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                    ModuleOrderEntry moduleOrderEntry;
                    Module depModule;
                    if (!(orderEntry instanceof ModuleOrderEntry) || (depModule = (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                    Node node = graph.myNodes.get(depModule);
                    OrderEnumerator en = OrderEnumerator.orderEntries((Module)depModule).exportedOnly();
                    if (node == null) {
                        VirtualFile[] importedSourceRoots;
                        VirtualFile[] importedClassRoots;
                        node = new Node();
                        node.myKey = depModule;
                        graph.myNodes.put(depModule, node);
                        for (VirtualFile importedClassRoot : importedClassRoots = en.classes().usingCache().getRoots()) {
                            roots.putValue((Object)importedClassRoot, (Object)node);
                        }
                        for (VirtualFile sourceRoot : importedSourceRoots = en.sources().usingCache().getRoots()) {
                            roots.putValue((Object)sourceRoot, (Object)node);
                        }
                    }
                    boolean shouldRecurse = en.recursively().shouldRecurse(moduleOrderEntry, handlers);
                    node.myEdges.add(new Edge(module, moduleOrderEntry, shouldRecurse));
                }
            }
            for (UnloadedModuleDescription description : moduleManager.getUnloadedModuleDescriptions()) {
                for (String depName : description.getDependencyModuleNames()) {
                    Module depModule = moduleManager.findModuleByName(depName);
                    if (depModule == null) continue;
                    Node node = graph.myNodes.get(depModule);
                    if (node == null) {
                        node = new Node();
                        node.myKey = depModule;
                        graph.myNodes.put(depModule, node);
                    }
                    if (node.myUnloadedDependentModules == null) {
                        node.myUnloadedDependentModules = new LinkedHashSet<String>();
                    }
                    node.myUnloadedDependentModules.add(description.getName());
                }
            }
            this.myGraph = graph;
            this.myRoots = roots;
        }

        private void initLibraryRoots() {
            MultiMap libClassRootEntries = MultiMap.createSmart();
            MultiMap libSourceRootEntries = MultiMap.createSmart();
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                    if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                    LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                    for (VirtualFile sourceRoot : entry.getRootFiles(OrderRootType.SOURCES)) {
                        libSourceRootEntries.putValue((Object)sourceRoot, (Object)orderEntry);
                    }
                    for (VirtualFile classRoot : entry.getRootFiles(OrderRootType.CLASSES)) {
                        libClassRootEntries.putValue((Object)classRoot, (Object)orderEntry);
                    }
                }
            }
            this.myLibClassRootEntries = libClassRootEntries;
            this.myLibSourceRootEntries = libSourceRootEntries;
        }

        private List<OrderEntry> getOrderEntries(@NotNull VirtualFile file2) {
            if (file2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(0);
            }
            return this.myCache.get(file2);
        }

        private List<OrderEntry> collectOrderEntries(@NotNull VirtualFile file2) {
            List roots;
            if (file2 == null) {
                OrderEntryGraph.$$$reportNull$$$0(1);
            }
            if ((roots = RootIndex.getHierarchy(file2, this.myAllRoots, this.myRootInfo)) == null) {
                return Collections.emptyList();
            }
            ArrayList<OrderEntry> result2 = new ArrayList<OrderEntry>();
            Stack<Node> stack = new Stack<Node>();
            for (VirtualFile root : roots) {
                Collection nodes = this.myRoots.get((Object)root);
                Iterator iterator = nodes.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    stack.push(node);
                }
            }
            HashSet<Node> seen = new HashSet<Node>();
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                if (seen.contains(node)) continue;
                seen.add(node);
                for (Edge edge : node.myEdges) {
                    Node targetNode;
                    result2.add((OrderEntry)edge.myOrderEntry);
                    if (!edge.myRecursive || (targetNode = this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push(targetNode);
                }
            }
            Pair libraryClassRootInfo = this.myRootInfo.findLibraryRootInfo(roots, false);
            Pair librarySourceRootInfo = this.myRootInfo.findLibraryRootInfo(roots, true);
            result2.addAll(this.myRootInfo.getLibraryOrderEntries(roots, libraryClassRootInfo != null ? (VirtualFile)libraryClassRootInfo.first : null, librarySourceRootInfo != null ? (VirtualFile)librarySourceRootInfo.first : null, (MultiMap<VirtualFile, OrderEntry>)this.myLibClassRootEntries, (MultiMap<VirtualFile, OrderEntry>)this.myLibSourceRootEntries));
            VirtualFile moduleContentRoot = this.myRootInfo.findNearestContentRoot(roots);
            if (moduleContentRoot != null) {
                ContainerUtil.addIfNotNull(result2, (Object)this.myRootInfo.getModuleSourceEntry(roots, moduleContentRoot, (MultiMap<VirtualFile, OrderEntry>)this.myLibClassRootEntries));
            }
            Collections.sort(result2, BY_OWNER_MODULE);
            return result2;
        }

        public Set<String> getDependentUnloadedModules(@NotNull Module module) {
            if (module == null) {
                OrderEntryGraph.$$$reportNull$$$0(2);
            }
            return this.myDependentUnloadedModulesCache.get(module);
        }

        private Set<String> collectDependentUnloadedModules(@NotNull Module module) {
            if (module == null) {
                OrderEntryGraph.$$$reportNull$$$0(3);
            }
            ArrayDeque<Node> stack = new ArrayDeque<Node>();
            Node start = this.myGraph.myNodes.get(module);
            if (start == null) {
                return Collections.emptySet();
            }
            stack.push(start);
            HashSet<Node> seen = new HashSet<Node>();
            Set<String> result2 = null;
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                if (!seen.add(node)) continue;
                if (node.myUnloadedDependentModules != null) {
                    if (result2 == null) {
                        result2 = new LinkedHashSet<String>(node.myUnloadedDependentModules);
                    } else {
                        result2.addAll(node.myUnloadedDependentModules);
                    }
                }
                for (Edge edge : node.myEdges) {
                    Node targetNode;
                    if (!edge.myRecursive || (targetNode = this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push(targetNode);
                }
            }
            return result2 != null ? result2 : Collections.emptySet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOrderEntries";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectOrderEntries";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDependentUnloadedModules";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectDependentUnloadedModules";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class Graph {
            Map<Module, Node> myNodes = new HashMap<Module, Node>();

            private Graph() {
            }
        }

        private static class Node {
            Module myKey;
            List<Edge> myEdges = new ArrayList<Edge>();
            Set<String> myUnloadedDependentModules;

            private Node() {
            }

            public String toString() {
                return this.myKey.toString();
            }
        }

        private static class Edge {
            Module myKey;
            ModuleOrderEntry myOrderEntry;
            boolean myRecursive;

            public Edge(Module key, ModuleOrderEntry orderEntry, boolean recursive) {
                this.myKey = key;
                this.myOrderEntry = orderEntry;
                this.myRecursive = recursive;
            }

            public String toString() {
                return this.myOrderEntry.toString();
            }
        }
    }
}

