/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.diff.DiffContext;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffRequest;
import com.intellij.openapi.vcs.ex.MoveChangesLineStatusAction;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleLocalChangeListDiffViewer
extends SimpleDiffViewer {
    @NotNull
    private final String myChangelistId;
    @NotNull
    private final PartialLocalLineStatusTracker myTracker;

    public SimpleLocalChangeListDiffViewer(@NotNull DiffContext context, @NotNull LocalChangeListDiffRequest localRequest) {
        if (context == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(0);
        }
        if (localRequest == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (DiffRequest)localRequest.getRequest());
        this.myChangelistId = localRequest.getChangelistId();
        this.myTracker = (PartialLocalLineStatusTracker)ObjectUtils.notNull((Object)localRequest.getLineStatusTracker());
        this.myTracker.addListener(new MyTrackerListener(), (Disposable)this);
        DiffUtil.registerAction((AnAction)new MoveSelectedChangesToAnotherChangelistAction(true), this.myPanel);
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(super.createEditorPopupActions());
        group.add((AnAction)new MoveSelectedChangesToAnotherChangelistAction(false));
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable2;
        TrackerData data;
        block26: {
            block25: {
                block24: {
                    block23: {
                        if (indicator == null) {
                            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(3);
                        }
                        if (this.getContent2().getDocument() != this.myTracker.getDocument()) {
                            Runnable runnable3 = this.applyNotification(DiffNotifications.createError());
                            if (runnable3 == null) {
                                SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(4);
                            }
                            return runnable3;
                        }
                        indicator.checkCanceled();
                        data = (TrackerData)ReadAction.compute(() -> {
                            boolean isReleased = this.myTracker.isReleased();
                            boolean isOperational = this.myTracker.isOperational();
                            List<String> affectedChangelistIds = this.myTracker.getAffectedChangeListsIds();
                            List<PartialLocalLineStatusTracker.LocalRange> ranges = null;
                            CharSequence localText = null;
                            CharSequence vcsText = null;
                            CharSequence trackerVcsText = null;
                            if (isOperational) {
                                ranges = this.myTracker.getRanges();
                                localText = this.getContent2().getDocument().getImmutableCharSequence();
                                vcsText = this.getContent1().getDocument().getImmutableCharSequence();
                                trackerVcsText = this.myTracker.getVcsDocument().getImmutableCharSequence();
                            }
                            return new TrackerData(isReleased, isOperational, affectedChangelistIds, ranges, localText, vcsText, trackerVcsText);
                        });
                        if (!data.isReleased) break block23;
                        Runnable runnable4 = this.applyNotification(DiffNotifications.createError());
                        if (runnable4 == null) {
                            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(5);
                        }
                        return runnable4;
                    }
                    if (data.isOperational || data.affectedChangelist.size() != 1 || !data.affectedChangelist.contains(this.myChangelistId)) break block24;
                    Runnable runnable5 = super.performRediff(indicator);
                    if (runnable5 == null) {
                        SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(6);
                    }
                    return runnable5;
                }
                if (data.ranges == null) {
                    this.scheduleRediff();
                    throw new ProcessCanceledException();
                }
                assert (data.localText != null);
                assert (data.vcsText != null);
                assert (data.trackerVcsText != null);
                if (StringUtil.equals((CharSequence)data.trackerVcsText, (CharSequence)data.vcsText)) break block25;
                Runnable runnable6 = this.applyNotification(DiffNotifications.createError());
                if (runnable6 == null) {
                    SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(7);
                }
                return runnable6;
            }
            if (!this.myTextDiffProvider.isHighlightingDisabled()) break block26;
            Runnable runnable7 = this.apply(new SimpleDiffViewer.CompareData(null, null, data.ranges.isEmpty()));
            if (runnable7 == null) {
                SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(8);
            }
            return runnable7;
        }
        try {
            List linesRanges = ContainerUtil.map(data.ranges, range2 -> new Range(range2.getVcsLine1(), range2.getVcsLine2(), range2.getLine1(), range2.getLine2()));
            List newFragments = (List)ObjectUtils.notNull(this.myTextDiffProvider.compare(data.vcsText, data.localText, linesRanges, indicator));
            boolean isContentsEqual = data.ranges.isEmpty();
            BitSet areSkipped = new BitSet();
            ArrayList<LineFragment> fragments = new ArrayList<LineFragment>();
            for (int i = 0; i < data.ranges.size(); ++i) {
                PartialLocalLineStatusTracker.LocalRange localRange = data.ranges.get(i);
                List rangeFragments = (List)newFragments.get(i);
                boolean isSkipped = !localRange.getChangelistId().equals(this.myChangelistId);
                areSkipped.set(fragments.size(), fragments.size() + newFragments.size(), isSkipped);
                fragments.addAll(rangeFragments);
            }
            runnable2 = this.apply(new SimpleDiffViewer.CompareData(fragments, areSkipped, isContentsEqual));
        }
        catch (DiffTooBigException e) {
            Runnable runnable8 = this.applyNotification(DiffNotifications.createDiffTooBig());
            if (runnable8 == null) {
                SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(10);
            }
            return runnable8;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable9 = this.applyNotification(DiffNotifications.createError());
            if (runnable9 == null) {
                SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(11);
            }
            return runnable9;
        }
        if (runnable2 == null) {
            SimpleLocalChangeListDiffViewer.$$$reportNull$$$0(9);
        }
        return runnable2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRequest";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TrackerData {
        private final boolean isReleased;
        public final boolean isOperational;
        @NotNull
        public final List<String> affectedChangelist;
        @Nullable
        public final List<PartialLocalLineStatusTracker.LocalRange> ranges;
        @Nullable
        public final CharSequence localText;
        @Nullable
        public final CharSequence vcsText;
        @Nullable
        public final CharSequence trackerVcsText;

        public TrackerData(boolean isReleased, boolean isOperational, @NotNull List<String> affectedChangelist, @Nullable List<PartialLocalLineStatusTracker.LocalRange> ranges, @Nullable CharSequence localText, @Nullable CharSequence vcsText, @Nullable CharSequence trackerVcsText) {
            if (affectedChangelist == null) {
                TrackerData.$$$reportNull$$$0(0);
            }
            this.isReleased = isReleased;
            this.isOperational = isOperational;
            this.affectedChangelist = affectedChangelist;
            this.ranges = ranges;
            this.localText = localText;
            this.vcsText = vcsText;
            this.trackerVcsText = trackerVcsText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedChangelist", "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$TrackerData", "<init>"));
        }
    }

    private class MoveSelectedChangesToAnotherChangelistAction
    extends SimpleDiffViewer.SelectedChangesActionBase {
        public MoveSelectedChangesToAnotherChangelistAction(boolean shortcut) {
            super(shortcut);
        }

        @Override
        protected boolean isVisible(@NotNull Side side) {
            if (side == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        @NotNull
        protected String getText(@NotNull Side side) {
            if (side == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(1);
            }
            String string = ActionsBundle.actionText((String)"ChangesView.Move");
            if (string == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        protected Icon getIcon(@NotNull Side side) {
            if (side == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(3);
            }
            return AllIcons.Actions.MoveToAnotherChangelist;
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull Side side, @NotNull List<SimpleDiffChange> changes) {
            if (e == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(4);
            }
            if (side == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(5);
            }
            if (changes == null) {
                MoveSelectedChangesToAnotherChangelistAction.$$$reportNull$$$0(6);
            }
            BitSet selectedLines = new BitSet();
            for (SimpleDiffChange change : changes) {
                selectedLines.set(change.getStartLine(side), change.getEndLine(side));
            }
            MoveChangesLineStatusAction.moveToAnotherChangelist(SimpleLocalChangeListDiffViewer.this.myTracker, selectedLines);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MoveSelectedChangesToAnotherChangelistAction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/SimpleLocalChangeListDiffViewer$MoveSelectedChangesToAnotherChangelistAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isVisible";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "doPerform";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyTrackerListener
    implements PartialLocalLineStatusTracker.Listener {
        private MyTrackerListener() {
        }

        @Override
        public void onBecomingValid() {
            SimpleLocalChangeListDiffViewer.this.scheduleRediff();
        }

        @Override
        public void onChangelistsChange() {
            SimpleLocalChangeListDiffViewer.this.scheduleRediff();
        }
    }
}

