/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserGenericNode
extends ChangesBrowserNode<Object>
implements Comparable<ChangesBrowserGenericNode> {
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final FileStatus myFileStatus;

    protected ChangesBrowserGenericNode(@NotNull FilePath filePath, @NotNull FileStatus fileStatus, @NotNull Object userObject) {
        if (filePath == null) {
            ChangesBrowserGenericNode.$$$reportNull$$$0(0);
        }
        if (fileStatus == null) {
            ChangesBrowserGenericNode.$$$reportNull$$$0(1);
        }
        if (userObject == null) {
            ChangesBrowserGenericNode.$$$reportNull$$$0(2);
        }
        super(userObject);
        this.myFilePath = filePath;
        this.myFileStatus = fileStatus;
    }

    @Override
    protected boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        return this.myFilePath.isDirectory();
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        FilePath parentPath;
        if (renderer == null) {
            ChangesBrowserGenericNode.$$$reportNull$$$0(3);
        }
        renderer.appendFileName(this.myFilePath.getVirtualFile(), this.myFilePath.getName(), this.myFileStatus.getColor());
        if (renderer.isShowFlatten() && (parentPath = this.myFilePath.getParentPath()) != null) {
            this.appendParentPath(renderer, parentPath);
        }
        if (!renderer.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount(renderer);
        }
        renderer.setIcon(this.myFilePath.getFileType(), this.myFilePath.isDirectory() || !this.isLeaf());
    }

    public String getTooltip() {
        return null;
    }

    @Override
    public String getTextPresentation() {
        return this.myFilePath.getName();
    }

    @Override
    public String toString() {
        return FileUtil.toSystemDependentName((String)this.myFilePath.getPath());
    }

    @Override
    public int getSortWeight() {
        return 6;
    }

    @Override
    public int compareTo(@NotNull ChangesBrowserGenericNode o) {
        if (o == null) {
            ChangesBrowserGenericNode.$$$reportNull$$$0(4);
        }
        return this.myFilePath.getPath().compareToIgnoreCase(o.myFilePath.getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserGenericNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

