/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserIgnoredFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLogicallyLockedFile;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserModuleNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeModelBuilder {
    private static final int UNVERSIONED_MAX_SIZE = 50;
    @NotNull
    protected final Project myProject;
    protected final boolean myShowFlatten;
    @NotNull
    protected final DefaultTreeModel myModel;
    @NotNull
    protected final ChangesBrowserNode myRoot;
    @NotNull
    private final Map<ChangesBrowserNode, ChangesGroupingPolicy> myGroupingPoliciesCache;
    @NotNull
    private final Map<ChangesBrowserNode, Map<String, ChangesBrowserNode>> myFoldersCache;
    private static final Comparator<ChangesBrowserNode> BROWSER_NODE_COMPARATOR = (node1, node2) -> {
        int sortWeightDiff = Comparing.compare((int)node1.getSortWeight(), (int)node2.getSortWeight());
        if (sortWeightDiff != 0) {
            return sortWeightDiff;
        }
        if (node1 instanceof Comparable && node1.getClass().equals(node2.getClass())) {
            return ((Comparable)((Object)node1)).compareTo(node2);
        }
        return node1.compareUserObjects(node2.getUserObject());
    };
    protected static final Comparator<Change> PATH_LENGTH_COMPARATOR = (o1, o2) -> {
        FilePath fp1 = ChangesUtil.getFilePath((Change)o1);
        FilePath fp2 = ChangesUtil.getFilePath((Change)o2);
        return Comparing.compare((int)fp1.getPath().length(), (int)fp2.getPath().length());
    };

    public TreeModelBuilder(@NotNull Project project, boolean showFlatten) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myShowFlatten = showFlatten;
        this.myRoot = ChangesBrowserNode.createRoot(this.myProject);
        this.myModel = new DefaultTreeModel(this.myRoot);
        this.myGroupingPoliciesCache = FactoryMap.create(key -> {
            ChangesGroupingPolicyFactory factory = ChangesGroupingPolicyFactory.getInstance(this.myProject);
            return factory != null ? factory.createGroupingPolicy(this.myModel) : null;
        });
        this.myFoldersCache = new HashMap<ChangesBrowserNode, Map<String, ChangesBrowserNode>>();
    }

    @NotNull
    public static DefaultTreeModel buildEmpty(@NotNull Project project) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(1);
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(ChangesBrowserNode.createRoot(project));
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(2);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromChanges(@NotNull Project project, boolean showFlatten, @NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(3);
        }
        if (changes == null) {
            TreeModelBuilder.$$$reportNull$$$0(4);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, showFlatten).setChanges(changes, changeNodeDecorator).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(5);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromFilePaths(@NotNull Project project, boolean showFlatten, @NotNull Collection<FilePath> filePaths) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(6);
        }
        if (filePaths == null) {
            TreeModelBuilder.$$$reportNull$$$0(7);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, showFlatten).setFilePaths(filePaths).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(8);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromChangeLists(@NotNull Project project, boolean showFlatten, @NotNull Collection<? extends ChangeList> changeLists) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(9);
        }
        if (changeLists == null) {
            TreeModelBuilder.$$$reportNull$$$0(10);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, showFlatten).setChangeLists(changeLists).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(11);
        }
        return defaultTreeModel;
    }

    @NotNull
    public static DefaultTreeModel buildFromVirtualFiles(@NotNull Project project, boolean showFlatten, @NotNull Collection<VirtualFile> virtualFiles) {
        if (project == null) {
            TreeModelBuilder.$$$reportNull$$$0(12);
        }
        if (virtualFiles == null) {
            TreeModelBuilder.$$$reportNull$$$0(13);
        }
        DefaultTreeModel defaultTreeModel = new TreeModelBuilder(project, showFlatten).setVirtualFiles(virtualFiles, null).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(14);
        }
        return defaultTreeModel;
    }

    @NotNull
    public TreeModelBuilder setChanges(@NotNull Collection<? extends Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes == null) {
            TreeModelBuilder.$$$reportNull$$$0(15);
        }
        List sortedChanges = ContainerUtil.sorted(changes, PATH_LENGTH_COMPARATOR);
        for (Change change : sortedChanges) {
            this.insertChangeNode(change, this.myRoot, this.createChangeNode(change, changeNodeDecorator));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(16);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setUnversioned(@Nullable List<VirtualFile> unversionedFiles) {
        if (ContainerUtil.isEmpty(unversionedFiles)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(17);
            }
            return treeModelBuilder;
        }
        int dirsCount = ContainerUtil.count(unversionedFiles, it -> it.isDirectory());
        int filesCount = unversionedFiles.size() - dirsCount;
        boolean manyFiles = unversionedFiles.size() > 50;
        ChangesBrowserUnversionedFilesNode node = new ChangesBrowserUnversionedFilesNode(this.myProject, filesCount, dirsCount, manyFiles);
        TreeModelBuilder treeModelBuilder = this.insertSpecificNodeToModel(unversionedFiles, node);
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(18);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setIgnored(@Nullable List<VirtualFile> ignoredFiles, boolean updatingMode) {
        if (ContainerUtil.isEmpty(ignoredFiles)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(19);
            }
            return treeModelBuilder;
        }
        int dirsCount = ContainerUtil.count(ignoredFiles, it -> it.isDirectory());
        int filesCount = ignoredFiles.size() - dirsCount;
        boolean manyFiles = ignoredFiles.size() > 50;
        ChangesBrowserIgnoredFilesNode node = new ChangesBrowserIgnoredFilesNode(this.myProject, filesCount, dirsCount, manyFiles, updatingMode);
        TreeModelBuilder treeModelBuilder = this.insertSpecificNodeToModel(ignoredFiles, node);
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(20);
        }
        return treeModelBuilder;
    }

    @NotNull
    private TreeModelBuilder insertSpecificNodeToModel(@NotNull List<VirtualFile> specificFiles, @NotNull ChangesBrowserSpecificFilesNode node) {
        if (specificFiles == null) {
            TreeModelBuilder.$$$reportNull$$$0(21);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(22);
        }
        this.myModel.insertNodeInto(node, this.myRoot, this.myRoot.getChildCount());
        if (!node.isManyFiles()) {
            node.markAsHelperNode();
            this.insertFilesIntoNode(specificFiles, node);
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(23);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setChangeLists(@NotNull Collection<? extends ChangeList> changeLists) {
        if (changeLists == null) {
            TreeModelBuilder.$$$reportNull$$$0(24);
        }
        RemoteRevisionsCache revisionsCache = RemoteRevisionsCache.getInstance(this.myProject);
        for (ChangeList changeList : changeLists) {
            List changes = ContainerUtil.sorted((Collection)changeList.getChanges(), PATH_LENGTH_COMPARATOR);
            ChangeListRemoteState listRemoteState = new ChangeListRemoteState(changes.size());
            ChangesBrowserChangeListNode listNode = new ChangesBrowserChangeListNode(this.myProject, changeList, listRemoteState);
            listNode.markAsHelperNode();
            this.myModel.insertNodeInto(listNode, this.myRoot, 0);
            for (int i = 0; i < changes.size(); ++i) {
                Change change = (Change)changes.get(i);
                RemoteStatusChangeNodeDecorator decorator = new RemoteStatusChangeNodeDecorator(revisionsCache, listRemoteState, i);
                this.insertChangeNode(change, listNode, this.createChangeNode(change, decorator));
            }
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(25);
        }
        return treeModelBuilder;
    }

    protected ChangesBrowserNode createChangeNode(Change change, ChangeNodeDecorator decorator) {
        return new ChangesBrowserChangeNode(this.myProject, change, decorator);
    }

    @NotNull
    public TreeModelBuilder setLockedFolders(@Nullable List<VirtualFile> lockedFolders) {
        TreeModelBuilder treeModelBuilder = this.setVirtualFiles(lockedFolders, ChangesBrowserNode.LOCKED_FOLDERS_TAG);
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(26);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setModifiedWithoutEditing(@NotNull List<VirtualFile> modifiedWithoutEditing) {
        if (modifiedWithoutEditing == null) {
            TreeModelBuilder.$$$reportNull$$$0(27);
        }
        TreeModelBuilder treeModelBuilder = this.setVirtualFiles(modifiedWithoutEditing, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(28);
        }
        return treeModelBuilder;
    }

    @NotNull
    private TreeModelBuilder setVirtualFiles(@Nullable Collection<VirtualFile> files, @Nullable Object tag) {
        if (ContainerUtil.isEmpty(files)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(29);
            }
            return treeModelBuilder;
        }
        this.insertFilesIntoNode(files, this.createTagNode(tag));
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(30);
        }
        return treeModelBuilder;
    }

    @NotNull
    protected ChangesBrowserNode createTagNode(@Nullable Object tag) {
        if (tag == null) {
            ChangesBrowserNode changesBrowserNode = this.myRoot;
            if (changesBrowserNode == null) {
                TreeModelBuilder.$$$reportNull$$$0(31);
            }
            return changesBrowserNode;
        }
        ChangesBrowserNode subtreeRoot = ChangesBrowserNode.create(this.myProject, tag);
        subtreeRoot.markAsHelperNode();
        this.myModel.insertNodeInto(subtreeRoot, this.myRoot, this.myRoot.getChildCount());
        ChangesBrowserNode changesBrowserNode = subtreeRoot;
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(32);
        }
        return changesBrowserNode;
    }

    private void insertFilesIntoNode(@NotNull Collection<VirtualFile> files, @NotNull ChangesBrowserNode subtreeRoot) {
        if (files == null) {
            TreeModelBuilder.$$$reportNull$$$0(33);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(34);
        }
        List sortedFiles = ContainerUtil.sorted(files, (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file2 : sortedFiles) {
            this.insertChangeNode(file2, subtreeRoot, ChangesBrowserNode.create(this.myProject, file2));
        }
    }

    @NotNull
    public TreeModelBuilder setLocallyDeletedPaths(@Nullable Collection<LocallyDeletedChange> locallyDeletedChanges) {
        if (ContainerUtil.isEmpty(locallyDeletedChanges)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(35);
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG);
        for (LocallyDeletedChange change : locallyDeletedChanges) {
            StaticFilePath key = new StaticFilePath(false, change.getPresentableUrl(), change.getPath().getVirtualFile());
            ChangesBrowserNode oldNode = this.getFolderCache(subtreeRoot).get(key.getKey());
            if (oldNode != null) continue;
            ChangesBrowserNode node = ChangesBrowserNode.create(change);
            ChangesBrowserNode parent = this.getParentNodeFor(key, subtreeRoot);
            this.myModel.insertNodeInto(node, parent, parent.getChildCount());
            this.getFolderCache(subtreeRoot).put(key.getKey(), node);
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(36);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setFilePaths(@NotNull Collection<FilePath> filePaths) {
        if (filePaths == null) {
            TreeModelBuilder.$$$reportNull$$$0(37);
        }
        TreeModelBuilder treeModelBuilder = this.setFilePaths(filePaths, this.myRoot);
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(38);
        }
        return treeModelBuilder;
    }

    @NotNull
    private TreeModelBuilder setFilePaths(@NotNull Collection<FilePath> filePaths, @NotNull ChangesBrowserNode subtreeRoot) {
        if (filePaths == null) {
            TreeModelBuilder.$$$reportNull$$$0(39);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(40);
        }
        for (FilePath file2 : filePaths) {
            StaticFilePath pathKey;
            assert (file2 != null);
            String path = file2.getPath();
            StaticFilePath staticFilePath = pathKey = !FileUtil.isAbsolute((String)path) || VcsUtil.isPathRemote((String)path) ? new StaticFilePath(false, path, null) : new StaticFilePath(false, new File(file2.getIOFile().getPath().replace('\\', '/')).getAbsolutePath(), file2.getVirtualFile());
            ChangesBrowserNode oldNode = this.getFolderCache(subtreeRoot).get(pathKey.getKey());
            if (oldNode != null) continue;
            ChangesBrowserNode node = ChangesBrowserNode.create(this.myProject, file2);
            ChangesBrowserNode parentNode = this.getParentNodeFor(pathKey, subtreeRoot);
            this.myModel.insertNodeInto(node, parentNode, 0);
            this.getFolderCache(subtreeRoot).put(pathKey.getKey(), node);
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(41);
        }
        return treeModelBuilder;
    }

    public void setGenericNodes(@NotNull Collection<GenericNodeData> nodesData, @Nullable Object tag) {
        if (nodesData == null) {
            TreeModelBuilder.$$$reportNull$$$0(42);
        }
        ChangesBrowserNode parentNode = this.createTagNode(tag);
        for (GenericNodeData data : nodesData) {
            ChangesBrowserNode node = ChangesBrowserNode.createGeneric(data.myFilePath, data.myStatus, data.myUserData);
            this.insertChangeNode(data.myFilePath, parentNode, node);
        }
    }

    @NotNull
    public TreeModelBuilder setSwitchedRoots(@Nullable Map<VirtualFile, String> switchedRoots) {
        if (ContainerUtil.isEmpty(switchedRoots)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(43);
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode rootsHeadNode = this.createTagNode(ChangesBrowserNode.SWITCHED_ROOTS_TAG);
        rootsHeadNode.setAttributes(SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        List files = ContainerUtil.sorted(switchedRoots.keySet(), (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile vf : files) {
            CurrentContentRevision cr = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)vf));
            Change change = new Change((ContentRevision)cr, (ContentRevision)cr, FileStatus.NOT_CHANGED);
            final String branchName = switchedRoots.get(vf);
            this.insertChangeNode(vf, rootsHeadNode, this.createChangeNode(change, new ChangeNodeDecorator(){

                @Override
                public void decorate(Change change1, SimpleColoredComponent component, boolean isShowFlatten) {
                }

                @Override
                public void preDecorate(Change change1, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
                    renderer.append("[" + branchName + "] ", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                }
            }));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(44);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setSwitchedFiles(@NotNull MultiMap<String, VirtualFile> switchedFiles) {
        if (switchedFiles == null) {
            TreeModelBuilder.$$$reportNull$$$0(45);
        }
        if (switchedFiles.isEmpty()) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(46);
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.SWITCHED_FILES_TAG);
        for (String branchName : switchedFiles.keySet()) {
            List switchedFileList = ContainerUtil.sorted((Collection)switchedFiles.get((Object)branchName), (Comparator)VirtualFileHierarchicalComparator.getInstance());
            if (switchedFileList.size() <= 0) continue;
            ChangesBrowserNode branchNode = ChangesBrowserNode.create(this.myProject, branchName);
            branchNode.markAsHelperNode();
            this.myModel.insertNodeInto(branchNode, subtreeRoot, subtreeRoot.getChildCount());
            for (VirtualFile file2 : switchedFileList) {
                this.insertChangeNode(file2, branchNode, ChangesBrowserNode.create(this.myProject, file2));
            }
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(47);
        }
        return treeModelBuilder;
    }

    @NotNull
    public TreeModelBuilder setLogicallyLockedFiles(@Nullable Map<VirtualFile, LogicalLock> logicallyLockedFiles) {
        if (ContainerUtil.isEmpty(logicallyLockedFiles)) {
            TreeModelBuilder treeModelBuilder = this;
            if (treeModelBuilder == null) {
                TreeModelBuilder.$$$reportNull$$$0(48);
            }
            return treeModelBuilder;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.LOGICALLY_LOCKED_TAG);
        List keys = ContainerUtil.sorted(logicallyLockedFiles.keySet(), (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file2 : keys) {
            LogicalLock lock = logicallyLockedFiles.get(file2);
            ChangesBrowserLogicallyLockedFile obj = new ChangesBrowserLogicallyLockedFile(this.myProject, file2, lock);
            this.insertChangeNode(obj, subtreeRoot, ChangesBrowserNode.create(this.myProject, obj));
        }
        TreeModelBuilder treeModelBuilder = this;
        if (treeModelBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(49);
        }
        return treeModelBuilder;
    }

    protected void insertChangeNode(@NotNull Object change, @NotNull ChangesBrowserNode subtreeRoot, @NotNull ChangesBrowserNode node) {
        if (change == null) {
            TreeModelBuilder.$$$reportNull$$$0(50);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(51);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(52);
        }
        this.insertChangeNode(change, subtreeRoot, node, (Convertor<StaticFilePath, ChangesBrowserNode>)((Convertor)this::createPathNode));
    }

    protected void insertChangeNode(@NotNull Object change, @NotNull ChangesBrowserNode subtreeRoot, @NotNull ChangesBrowserNode node, @NotNull Convertor<StaticFilePath, ChangesBrowserNode> nodeBuilder) {
        if (change == null) {
            TreeModelBuilder.$$$reportNull$$$0(53);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(54);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(55);
        }
        if (nodeBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(56);
        }
        StaticFilePath pathKey = TreeModelBuilder.getKey(change);
        ChangesBrowserNode parentNode = this.getParentNodeFor(pathKey, subtreeRoot, nodeBuilder);
        this.myModel.insertNodeInto(node, parentNode, this.myModel.getChildCount(parentNode));
        if (pathKey.isDirectory()) {
            this.getFolderCache(subtreeRoot).put(pathKey.getKey(), node);
        }
    }

    @NotNull
    public DefaultTreeModel build() {
        TreeModelBuilder.collapseDirectories(this.myModel, this.myRoot);
        this.sortNodes();
        DefaultTreeModel defaultTreeModel = this.myModel;
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(57);
        }
        return defaultTreeModel;
    }

    private void sortNodes() {
        TreeUtil.sort((DefaultTreeModel)this.myModel, BROWSER_NODE_COMPARATOR);
        this.myModel.nodeStructureChanged((TreeNode)this.myModel.getRoot());
    }

    private static void collapseDirectories(@NotNull DefaultTreeModel model, @NotNull ChangesBrowserNode node) {
        ChangesBrowserNode child;
        ChangesBrowserNode collapsed;
        if (model == null) {
            TreeModelBuilder.$$$reportNull$$$0(58);
        }
        if (node == null) {
            TreeModelBuilder.$$$reportNull$$$0(59);
        }
        ChangesBrowserNode collapsedNode = node;
        while (collapsedNode.getChildCount() == 1 && (collapsed = TreeModelBuilder.collapseParentWithOnlyChild(collapsedNode, child = (ChangesBrowserNode)collapsedNode.getChildAt(0))) != null) {
            collapsedNode = collapsed;
        }
        if (collapsedNode != node) {
            ChangesBrowserNode parent = (ChangesBrowserNode)node.getParent();
            int idx = parent.getIndex(node);
            model.removeNodeFromParent(node);
            model.insertNodeInto(collapsedNode, parent, idx);
            node = collapsedNode;
        }
        Enumeration<TreeNode> children2 = node.children();
        while (children2.hasMoreElements()) {
            ChangesBrowserNode child2 = (ChangesBrowserNode)children2.nextElement();
            TreeModelBuilder.collapseDirectories(model, child2);
        }
    }

    @Nullable
    private static ChangesBrowserNode collapseParentWithOnlyChild(@NotNull ChangesBrowserNode parent, @NotNull ChangesBrowserNode child) {
        if (parent == null) {
            TreeModelBuilder.$$$reportNull$$$0(60);
        }
        if (child == null) {
            TreeModelBuilder.$$$reportNull$$$0(61);
        }
        if (child.isLeaf()) {
            return null;
        }
        Object parentUserObject = parent.getUserObject();
        Object childUserObject = child.getUserObject();
        if (parentUserObject instanceof FilePath && childUserObject instanceof FilePath) {
            return child;
        }
        if (parent instanceof ChangesBrowserModuleNode && childUserObject instanceof FilePath) {
            FilePath childPath;
            FilePath parentPath = ((ChangesBrowserModuleNode)parent).getModuleRoot();
            if (!parentPath.equals(childPath = (FilePath)childUserObject)) {
                return null;
            }
            parent.remove(0);
            Enumeration<TreeNode> children2 = child.children();
            for (ChangesBrowserNode childNode : ContainerUtil.toList(children2)) {
                parent.add(childNode);
            }
            return parent;
        }
        return null;
    }

    @NotNull
    private static StaticFilePath getKey(@NotNull Object o) {
        if (o == null) {
            TreeModelBuilder.$$$reportNull$$$0(62);
        }
        if (o instanceof Change) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom(ChangesUtil.getFilePath((Change)((Change)o)));
            if (staticFilePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(63);
            }
            return staticFilePath;
        }
        if (o instanceof VirtualFile) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom((VirtualFile)o);
            if (staticFilePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(64);
            }
            return staticFilePath;
        }
        if (o instanceof FilePath) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom((FilePath)o);
            if (staticFilePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(65);
            }
            return staticFilePath;
        }
        if (o instanceof ChangesBrowserLogicallyLockedFile) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom((VirtualFile)((ChangesBrowserLogicallyLockedFile)o).getUserObject());
            if (staticFilePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(66);
            }
            return staticFilePath;
        }
        if (o instanceof LocallyDeletedChange) {
            StaticFilePath staticFilePath = TreeModelBuilder.staticFrom(((LocallyDeletedChange)o).getPath());
            if (staticFilePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(67);
            }
            return staticFilePath;
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    private static StaticFilePath staticFrom(@NotNull FilePath fp) {
        if (fp == null) {
            TreeModelBuilder.$$$reportNull$$$0(68);
        }
        String path = fp.getPath();
        if (fp.isNonLocal() && (!FileUtil.isAbsolute((String)path) || VcsUtil.isPathRemote((String)path))) {
            StaticFilePath staticFilePath = new StaticFilePath(fp.isDirectory(), fp.getIOFile().getPath().replace('\\', '/'), fp.getVirtualFile());
            if (staticFilePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(69);
            }
            return staticFilePath;
        }
        StaticFilePath staticFilePath = new StaticFilePath(fp.isDirectory(), new File(fp.getIOFile().getPath().replace('\\', '/')).getAbsolutePath(), fp.getVirtualFile());
        if (staticFilePath == null) {
            TreeModelBuilder.$$$reportNull$$$0(70);
        }
        return staticFilePath;
    }

    @NotNull
    private static StaticFilePath staticFrom(@NotNull VirtualFile vf) {
        if (vf == null) {
            TreeModelBuilder.$$$reportNull$$$0(71);
        }
        StaticFilePath staticFilePath = new StaticFilePath(vf.isDirectory(), vf.getPath(), vf);
        if (staticFilePath == null) {
            TreeModelBuilder.$$$reportNull$$$0(72);
        }
        return staticFilePath;
    }

    @NotNull
    public static FilePath getPathForObject(@NotNull Object o) {
        if (o == null) {
            TreeModelBuilder.$$$reportNull$$$0(73);
        }
        if (o instanceof Change) {
            FilePath filePath = ChangesUtil.getFilePath((Change)((Change)o));
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(74);
            }
            return filePath;
        }
        if (o instanceof VirtualFile) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)((VirtualFile)o));
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(75);
            }
            return filePath;
        }
        if (o instanceof FilePath) {
            FilePath filePath = (FilePath)o;
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(76);
            }
            return filePath;
        }
        if (o instanceof ChangesBrowserLogicallyLockedFile) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)((VirtualFile)((ChangesBrowserLogicallyLockedFile)o).getUserObject()));
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(77);
            }
            return filePath;
        }
        if (o instanceof LocallyDeletedChange) {
            FilePath filePath = ((LocallyDeletedChange)o).getPath();
            if (filePath == null) {
                TreeModelBuilder.$$$reportNull$$$0(78);
            }
            return filePath;
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    protected ChangesBrowserNode getParentNodeFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode subtreeRoot) {
        if (nodePath == null) {
            TreeModelBuilder.$$$reportNull$$$0(79);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(80);
        }
        ChangesBrowserNode changesBrowserNode = this.getParentNodeFor(nodePath, subtreeRoot, (Convertor<StaticFilePath, ChangesBrowserNode>)((Convertor)this::createPathNode));
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(81);
        }
        return changesBrowserNode;
    }

    @NotNull
    protected ChangesBrowserNode getParentNodeFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode subtreeRoot, @NotNull Convertor<StaticFilePath, ChangesBrowserNode> nodeBuilder) {
        ChangesBrowserNode nodeFromPolicy;
        if (nodePath == null) {
            TreeModelBuilder.$$$reportNull$$$0(82);
        }
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(83);
        }
        if (nodeBuilder == null) {
            TreeModelBuilder.$$$reportNull$$$0(84);
        }
        if (this.myShowFlatten) {
            ChangesBrowserNode changesBrowserNode = subtreeRoot;
            if (changesBrowserNode == null) {
                TreeModelBuilder.$$$reportNull$$$0(85);
            }
            return changesBrowserNode;
        }
        ChangesGroupingPolicy policy = this.myGroupingPoliciesCache.get(subtreeRoot);
        if (policy != null && (nodeFromPolicy = policy.getParentNodeFor(nodePath, subtreeRoot)) != null) {
            nodeFromPolicy.markAsHelperNode();
            ChangesBrowserNode changesBrowserNode = nodeFromPolicy;
            if (changesBrowserNode == null) {
                TreeModelBuilder.$$$reportNull$$$0(86);
            }
            return changesBrowserNode;
        }
        for (StaticFilePath parentPath = nodePath.getParent(); parentPath != null; parentPath = parentPath.getParent()) {
            ChangesBrowserNode oldParentNode = this.getFolderCache(subtreeRoot).get(parentPath.getKey());
            if (oldParentNode != null) {
                ChangesBrowserNode changesBrowserNode = oldParentNode;
                if (changesBrowserNode == null) {
                    TreeModelBuilder.$$$reportNull$$$0(87);
                }
                return changesBrowserNode;
            }
            ChangesBrowserNode parentNode = (ChangesBrowserNode)nodeBuilder.convert((Object)parentPath);
            if (parentNode == null) continue;
            parentNode.markAsHelperNode();
            ChangesBrowserNode grandPa = this.getParentNodeFor(parentPath, subtreeRoot, nodeBuilder);
            this.myModel.insertNodeInto(parentNode, grandPa, grandPa.getChildCount());
            this.getFolderCache(subtreeRoot).put(parentPath.getKey(), parentNode);
            ChangesBrowserNode changesBrowserNode = parentNode;
            if (changesBrowserNode == null) {
                TreeModelBuilder.$$$reportNull$$$0(88);
            }
            return changesBrowserNode;
        }
        ChangesBrowserNode changesBrowserNode = subtreeRoot;
        if (changesBrowserNode == null) {
            TreeModelBuilder.$$$reportNull$$$0(89);
        }
        return changesBrowserNode;
    }

    @Nullable
    private ChangesBrowserNode createPathNode(@NotNull StaticFilePath path) {
        if (path == null) {
            TreeModelBuilder.$$$reportNull$$$0(90);
        }
        FilePath filePath = path.getVf() == null ? VcsUtil.getFilePath((String)path.getPath(), (boolean)true) : VcsUtil.getFilePath((VirtualFile)path.getVf());
        return ChangesBrowserNode.create(this.myProject, filePath);
    }

    @NotNull
    private Map<String, ChangesBrowserNode> getFolderCache(@NotNull ChangesBrowserNode subtreeRoot) {
        if (subtreeRoot == null) {
            TreeModelBuilder.$$$reportNull$$$0(91);
        }
        Map map = this.myFoldersCache.computeIfAbsent(subtreeRoot, key -> new HashMap());
        if (map == null) {
            TreeModelBuilder.$$$reportNull$$$0(92);
        }
        return map;
    }

    public boolean isEmpty() {
        return this.myModel.getChildCount(this.myRoot) == 0;
    }

    @Deprecated
    @NotNull
    public DefaultTreeModel buildModel(@NotNull List<Change> changes, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        if (changes == null) {
            TreeModelBuilder.$$$reportNull$$$0(93);
        }
        DefaultTreeModel defaultTreeModel = this.setChanges(changes, changeNodeDecorator).build();
        if (defaultTreeModel == null) {
            TreeModelBuilder.$$$reportNull$$$0(94);
        }
        return defaultTreeModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 81: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 92: 
            case 94: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 81: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 92: 
            case 94: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 81: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 92: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder";
                break;
            }
            case 4: 
            case 15: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 7: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeLists";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specificFiles";
                break;
            }
            case 22: 
            case 52: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedWithoutEditing";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 34: 
            case 40: 
            case 51: 
            case 54: 
            case 80: 
            case 83: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtreeRoot";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesData";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchedFiles";
                break;
            }
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 56: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeBuilder";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 62: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fp";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePath";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEmpty";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromChanges";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromFilePaths";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromChangeLists";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromVirtualFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setChanges";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "setUnversioned";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "setIgnored";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "insertSpecificNodeToModel";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "setChangeLists";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "setLockedFolders";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "setModifiedWithoutEditing";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "setVirtualFiles";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagNode";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocallyDeletedPaths";
                break;
            }
            case 38: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "setFilePaths";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "setSwitchedRoots";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "setSwitchedFiles";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "setLogicallyLockedFiles";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 69: 
            case 70: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "staticFrom";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathForObject";
                break;
            }
            case 81: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentNodeFor";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolderCache";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildEmpty";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 81: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 92: 
            case 94: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildFromChanges";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildFromFilePaths";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildFromChangeLists";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildFromVirtualFiles";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setChanges";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "insertSpecificNodeToModel";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setChangeLists";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setModifiedWithoutEditing";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "insertFilesIntoNode";
                break;
            }
            case 37: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setFilePaths";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setGenericNodes";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setSwitchedFiles";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "insertChangeNode";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "collapseDirectories";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "collapseParentWithOnlyChild";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 68: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "staticFrom";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getPathForObject";
                break;
            }
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getParentNodeFor";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "createPathNode";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getFolderCache";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "buildModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 81: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 92: 
            case 94: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GenericNodeData {
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final FileStatus myStatus;
        @NotNull
        private final Object myUserData;

        public GenericNodeData(@NotNull FilePath filePath, @NotNull FileStatus status, @NotNull Object userData) {
            if (filePath == null) {
                GenericNodeData.$$$reportNull$$$0(0);
            }
            if (status == null) {
                GenericNodeData.$$$reportNull$$$0(1);
            }
            if (userData == null) {
                GenericNodeData.$$$reportNull$$$0(2);
            }
            this.myFilePath = filePath;
            this.myStatus = status;
            this.myUserData = userData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "status";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "userData";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/ui/TreeModelBuilder$GenericNodeData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

