/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.Range;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002JR\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2<\u0010\r\u001a8\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/ex/MergingBlockProcessor;", "", "handler", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;)V", "mergeBlocks", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "block1", "block2", "processMergedBlocks", "", "group", "", "processBlock", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "original", "merged", "intellij.platform.diff.impl"})
final class MergingBlockProcessor {
    private final DocumentTracker.Handler handler;

    public final void processMergedBlocks(@NotNull List<DocumentTracker.Block> group, @NotNull Function2<? super List<DocumentTracker.Block>, ? super DocumentTracker.Block, Unit> processBlock) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(group, (String)"group");
        Intrinsics.checkParameterIsNotNull(processBlock, (String)"processBlock");
        boolean bl2 = bl = !group.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List originalGroup = new ArrayList();
        DocumentTracker.Block merged = null;
        for (DocumentTracker.Block block : group) {
            if (merged == null) {
                originalGroup.add(block);
                merged = block;
                continue;
            }
            DocumentTracker.Block newMerged = this.mergeBlocks(merged, block);
            if (newMerged != null) {
                originalGroup.add(block);
                merged = newMerged;
                continue;
            }
            processBlock.invoke((Object)originalGroup, (Object)merged);
            originalGroup.clear();
            originalGroup.add(block);
            merged = block;
        }
        DocumentTracker.Block block = merged;
        if (block == null) {
            Intrinsics.throwNpe();
        }
        processBlock.invoke((Object)originalGroup, (Object)block);
    }

    private final DocumentTracker.Block mergeBlocks(DocumentTracker.Block block1, DocumentTracker.Block block2) {
        boolean isTooBig;
        Range range2 = new Range(block1.getRange().start1, block2.getRange().end1, block1.getRange().start2, block2.getRange().end2);
        boolean isDirty = block1.isDirty$intellij_platform_diff_impl() || block2.isDirty$intellij_platform_diff_impl();
        DocumentTracker.Block merged = new DocumentTracker.Block(range2, isDirty, isTooBig = block1.isTooBig$intellij_platform_diff_impl() || block2.isTooBig$intellij_platform_diff_impl());
        if (!this.handler.onRangesMerged(block1, block2, merged)) {
            return null;
        }
        return merged;
    }

    public MergingBlockProcessor(@NotNull DocumentTracker.Handler handler2) {
        Intrinsics.checkParameterIsNotNull((Object)handler2, (String)"handler");
        this.handler = handler2;
    }
}

