/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileResolveScopeProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ResolveScopeManagerImpl
extends ResolveScopeManager {
    private final Project myProject;
    private final ProjectRootManager myProjectRootManager;
    private final PsiManager myManager;
    private final Map<VirtualFile, GlobalSearchScope> myDefaultResolveScopesCache;
    private final AdditionalIndexableFileSet myAdditionalIndexableFileSet;

    public ResolveScopeManagerImpl(Project project, ProjectRootManager projectRootManager, PsiManager psiManager) {
        this.myProject = project;
        this.myProjectRootManager = projectRootManager;
        this.myManager = psiManager;
        this.myAdditionalIndexableFileSet = new AdditionalIndexableFileSet(project);
        this.myDefaultResolveScopesCache = ConcurrentFactoryMap.createMap(key -> {
            ResolveScopeProvider resolveScopeProvider;
            GlobalSearchScope scope = null;
            Object[] objectArray = (ResolveScopeProvider[])ResolveScopeProvider.EP_NAME.getExtensions();
            int n = objectArray.length;
            for (int i = 0; i < n && (scope = (resolveScopeProvider = objectArray[i]).getResolveScope((VirtualFile)key, this.myProject)) == null; ++i) {
            }
            if (scope == null) {
                scope = this.getInherentResolveScope((VirtualFile)key);
            }
            for (ResolveScopeEnlarger enlarger : (ResolveScopeEnlarger[])ResolveScopeEnlarger.EP_NAME.getExtensions()) {
                SearchScope extra = enlarger.getAdditionalResolveScope((VirtualFile)key, this.myProject);
                if (extra == null) continue;
                scope = scope.union(extra);
            }
            return scope;
        }, ContainerUtil::createConcurrentWeakKeySoftValueMap);
        ((PsiManagerImpl)psiManager).registerRunnableToRunOnChange(this.myDefaultResolveScopesCache::clear);
    }

    private GlobalSearchScope getResolveScopeFromProviders(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(0);
        }
        return this.myDefaultResolveScopesCache.get(vFile);
    }

    private GlobalSearchScope getInherentResolveScope(VirtualFile vFile) {
        ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
        Module module = projectFileIndex.getModuleForFile(vFile);
        if (module != null) {
            boolean includeTests = TestSourcesFilter.isTestSources((VirtualFile)vFile, (Project)this.myProject);
            return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)includeTests);
        }
        if (!projectFileIndex.isInLibrarySource(vFile) && !projectFileIndex.isInLibraryClasses(vFile)) {
            GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (!allScope.contains(vFile)) {
                return GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)vFile).uniteWith(allScope);
            }
            return allScope;
        }
        return LibraryScopeCache.getInstance(this.myProject).getLibraryScope(projectFileIndex.getOrderEntriesForFile(vFile));
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        PsiFile contextFile;
        VirtualFile vFile;
        if (element == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(1);
        }
        ProgressIndicatorProvider.checkCanceled();
        if (element instanceof PsiDirectory) {
            vFile = ((PsiDirectory)element).getVirtualFile();
            contextFile = null;
        } else {
            PsiElement context;
            GlobalSearchScope forcedScope;
            PsiFile containingFile = element.getContainingFile();
            if (containingFile instanceof PsiCodeFragment && (forcedScope = ((PsiCodeFragment)containingFile).getForcedResolveScope()) != null) {
                GlobalSearchScope globalSearchScope = forcedScope;
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(2);
                }
                return globalSearchScope;
            }
            if (containingFile != null && (context = containingFile.getContext()) != null) {
                GlobalSearchScope globalSearchScope = this.getResolveScope(context);
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(3);
                }
                return globalSearchScope;
            }
            contextFile = containingFile;
            if (containingFile == null) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(4);
                }
                return globalSearchScope;
            }
            if (contextFile instanceof FileResolveScopeProvider) {
                GlobalSearchScope globalSearchScope = ((FileResolveScopeProvider)contextFile).getFileResolveScope();
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(5);
                }
                return globalSearchScope;
            }
            vFile = contextFile.getOriginalFile().getVirtualFile();
        }
        if (vFile == null || contextFile == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.getResolveScopeFromProviders(vFile);
        if (globalSearchScope == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    @Override
    public GlobalSearchScope getDefaultResolveScope(VirtualFile vFile) {
        PsiFile psiFile = this.myManager.findFile(vFile);
        assert (psiFile != null) : "directory=" + vFile.isDirectory() + "; " + this.myProject;
        return this.getResolveScopeFromProviders(vFile);
    }

    @Override
    @NotNull
    public GlobalSearchScope getUseScope(@NotNull PsiElement element) {
        RefResolveService resolveService;
        GlobalSearchScope scope;
        PsiFile containingFile;
        VirtualFile virtualFile;
        VirtualFile vDirectory;
        if (element == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(8);
        }
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.myManager.getProject());
        if (element instanceof PsiDirectory) {
            vDirectory = ((PsiDirectory)element).getVirtualFile();
            virtualFile = null;
            containingFile = null;
        } else {
            containingFile = element.getContainingFile();
            if (containingFile == null) {
                GlobalSearchScope globalSearchScope = allScope;
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(9);
                }
                return globalSearchScope;
            }
            virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                GlobalSearchScope globalSearchScope = allScope;
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(10);
                }
                return globalSearchScope;
            }
            if (virtualFile instanceof VirtualFileWindow) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)((VirtualFileWindow)virtualFile).getDelegate());
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(11);
                }
                return globalSearchScope;
            }
            if ("Scratch".equals(virtualFile.getFileType().getName())) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)virtualFile);
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(12);
                }
                return globalSearchScope;
            }
            vDirectory = virtualFile.getParent();
        }
        if (vDirectory == null) {
            GlobalSearchScope globalSearchScope = allScope;
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(13);
            }
            return globalSearchScope;
        }
        ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
        Module module = projectFileIndex.getModuleForFile(vDirectory);
        if (module == null) {
            VirtualFile notNullVFile = virtualFile != null ? virtualFile : vDirectory;
            List entries = projectFileIndex.getOrderEntriesForFile(notNullVFile);
            if (entries.isEmpty() && (this.myAdditionalIndexableFileSet.isInSet(notNullVFile) || this.isFromAdditionalLibraries(notNullVFile))) {
                GlobalSearchScope globalSearchScope = allScope;
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(14);
                }
                return globalSearchScope;
            }
            GlobalSearchScope result2 = LibraryScopeCache.getInstance(this.myProject).getLibraryUseScope(entries);
            GlobalSearchScope globalSearchScope = containingFile == null || virtualFile.isDirectory() || result2.contains(virtualFile) ? result2 : GlobalSearchScope.fileScope((PsiFile)containingFile).uniteWith(result2);
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(15);
            }
            return globalSearchScope;
        }
        boolean isTest = TestSourcesFilter.isTestSources((VirtualFile)vDirectory, (Project)this.myProject);
        GlobalSearchScope globalSearchScope = scope = isTest ? GlobalSearchScope.moduleTestsWithDependentsScope((Module)module) : GlobalSearchScope.moduleWithDependentsScope((Module)module);
        if (virtualFile instanceof VirtualFileWithId && RefResolveService.ENABLED && (resolveService = RefResolveService.getInstance((Project)this.myProject)).isUpToDate()) {
            GlobalSearchScope globalSearchScope2 = resolveService.restrictByBackwardIds(virtualFile, scope);
            if (globalSearchScope2 == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(16);
            }
            return globalSearchScope2;
        }
        GlobalSearchScope globalSearchScope3 = scope;
        if (globalSearchScope3 == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(17);
        }
        return globalSearchScope3;
    }

    private boolean isFromAdditionalLibraries(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(18);
        }
        for (AdditionalLibraryRootsProvider provider : (AdditionalLibraryRootsProvider[])Extensions.getExtensions(AdditionalLibraryRootsProvider.EP_NAME)) {
            for (SyntheticLibrary library : provider.getAdditionalProjectLibraries(this.myProject)) {
                if (!VfsUtilCore.isUnder((VirtualFile)file2, ResolveScopeManagerImpl.asSet(library.getSourceRoots())) || VfsUtilCore.isUnder((VirtualFile)file2, library.getExcludedRoots())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static Set<VirtualFile> asSet(Collection<VirtualFile> collection) {
        Set set2 = collection instanceof Set ? (Set)collection : ContainerUtil.newTroveSet(collection);
        if (set2 == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(19);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "asSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScopeFromProviders";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUseScope";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isFromAdditionalLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

