/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.ITemplateDataElementType;
import com.intellij.psi.templateLanguages.OuterLanguageElementImpl;
import com.intellij.psi.templateLanguages.SimpleTreePatcher;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TreePatcher;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.LocalTimeCounter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataElementType
extends IFileElementType
implements ITemplateDataElementType {
    public static final LanguageExtension<TreePatcher> TREE_PATCHER = new LanguageExtension("com.intellij.lang.treePatcher", (Object)new SimpleTreePatcher());
    @NotNull
    private final IElementType myTemplateElementType;
    @NotNull
    private final IElementType myOuterElementType;

    public TemplateDataElementType(@NonNls String debugName, Language language, @NotNull IElementType templateElementType, @NotNull IElementType outerElementType) {
        if (templateElementType == null) {
            TemplateDataElementType.$$$reportNull$$$0(0);
        }
        if (outerElementType == null) {
            TemplateDataElementType.$$$reportNull$$$0(1);
        }
        super(debugName, language);
        this.myTemplateElementType = templateElementType;
        this.myOuterElementType = outerElementType;
    }

    protected Lexer createBaseLexer(TemplateLanguageFileViewProvider viewProvider) {
        return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(viewProvider.getBaseLanguage())).createLexer(viewProvider.getManager().getProject());
    }

    protected LanguageFileType createTemplateFakeFileType(Language language) {
        return new TemplateFileType(language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASTNode parseContents(@NotNull ASTNode chameleon) {
        if (chameleon == null) {
            TemplateDataElementType.$$$reportNull$$$0(2);
        }
        CharTable charTable = SharedImplUtil.findCharTableByTree(chameleon);
        FileElement fileElement = TreeUtil.getFileElement((TreeElement)chameleon);
        PsiFile psiFile = (PsiFile)fileElement.getPsi();
        PsiFile originalPsiFile = psiFile.getOriginalFile();
        TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)originalPsiFile.getViewProvider();
        Language templateLanguage = this.getTemplateFileLanguage(viewProvider);
        CharSequence sourceCode = chameleon.getChars();
        RangesCollector collector = new RangesCollector();
        PsiFile templatePsiFile = this.createTemplateFile(psiFile, templateLanguage, sourceCode, viewProvider, collector);
        FileElement templateFileElement = ((PsiFileImpl)templatePsiFile).calcTreeElement();
        DebugUtil.startPsiModification("template language parsing");
        try {
            this.prepareParsedTemplateFile(templateFileElement);
            this.insertOuters(templateFileElement, sourceCode, collector.myRanges, charTable);
            TreeElement childNode = templateFileElement.getFirstChildNode();
            DebugUtil.checkTreeStructure(templateFileElement);
            DebugUtil.checkTreeStructure(chameleon);
            if (fileElement != chameleon) {
                DebugUtil.checkTreeStructure((ASTNode)psiFile.getNode());
                DebugUtil.checkTreeStructure((ASTNode)originalPsiFile.getNode());
            }
            TreeElement treeElement = childNode;
            return treeElement;
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    protected void prepareParsedTemplateFile(@NotNull FileElement root) {
        if (root == null) {
            TemplateDataElementType.$$$reportNull$$$0(3);
        }
    }

    protected Language getTemplateFileLanguage(TemplateLanguageFileViewProvider viewProvider) {
        return viewProvider.getTemplateDataLanguage();
    }

    protected PsiFile createTemplateFile(PsiFile psiFile, Language templateLanguage, CharSequence sourceCode, TemplateLanguageFileViewProvider viewProvider, @NotNull RangesCollector outerRangesCollector) {
        if (outerRangesCollector == null) {
            TemplateDataElementType.$$$reportNull$$$0(4);
        }
        CharSequence templateSourceCode = this.createTemplateText(sourceCode, this.createBaseLexer(viewProvider), outerRangesCollector);
        return this.createPsiFileFromSource(templateLanguage, templateSourceCode, psiFile.getManager());
    }

    protected CharSequence createTemplateText(@NotNull CharSequence sourceCode, @NotNull Lexer baseLexer, @NotNull RangesCollector outerRangesCollector) {
        if (sourceCode == null) {
            TemplateDataElementType.$$$reportNull$$$0(5);
        }
        if (baseLexer == null) {
            TemplateDataElementType.$$$reportNull$$$0(6);
        }
        if (outerRangesCollector == null) {
            TemplateDataElementType.$$$reportNull$$$0(7);
        }
        StringBuilder result2 = new StringBuilder(sourceCode.length());
        baseLexer.start(sourceCode);
        TextRange currentRange = TextRange.EMPTY_RANGE;
        while (baseLexer.getTokenType() != null) {
            TextRange newRange = TextRange.create((int)baseLexer.getTokenStart(), (int)baseLexer.getTokenEnd());
            assert (currentRange.getEndOffset() == newRange.getStartOffset()) : "Inconsistent tokens stream from " + baseLexer + ": " + TemplateDataElementType.getRangeDump(currentRange, sourceCode) + " followed by " + TemplateDataElementType.getRangeDump(newRange, sourceCode);
            currentRange = newRange;
            if (baseLexer.getTokenType() == this.myTemplateElementType) {
                this.appendCurrentTemplateToken(result2, sourceCode, baseLexer);
            } else {
                outerRangesCollector.addRange(currentRange);
            }
            baseLexer.advance();
        }
        return result2;
    }

    @NotNull
    private static String getRangeDump(@NotNull TextRange range2, @NotNull CharSequence sequence) {
        if (range2 == null) {
            TemplateDataElementType.$$$reportNull$$$0(8);
        }
        if (sequence == null) {
            TemplateDataElementType.$$$reportNull$$$0(9);
        }
        String string = "'" + StringUtil.escapeLineBreak((String)range2.subSequence(sequence).toString()) + "' " + range2;
        if (string == null) {
            TemplateDataElementType.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected void appendCurrentTemplateToken(StringBuilder result2, CharSequence buf, Lexer lexer) {
        result2.append(buf, lexer.getTokenStart(), lexer.getTokenEnd());
    }

    private void insertOuters(TreeElement templateFileElement, @NotNull CharSequence sourceCode, @NotNull List<TextRange> outerElementsRanges, CharTable charTable) {
        if (sourceCode == null) {
            TemplateDataElementType.$$$reportNull$$$0(11);
        }
        if (outerElementsRanges == null) {
            TemplateDataElementType.$$$reportNull$$$0(12);
        }
        TreePatcher templateTreePatcher = (TreePatcher)TREE_PATCHER.forLanguage(templateFileElement.getPsi().getLanguage());
        int treeOffset = 0;
        LeafElement currentLeaf = TreeUtil.findFirstLeaf(templateFileElement);
        for (TextRange outerElementRange : outerElementsRanges) {
            while (currentLeaf != null && treeOffset < outerElementRange.getStartOffset()) {
                int currentTokenStart;
                if ((treeOffset += currentLeaf.getTextLength()) > (currentTokenStart = outerElementRange.getStartOffset())) {
                    currentLeaf = templateTreePatcher.split(currentLeaf, currentLeaf.getTextLength() - (treeOffset - currentTokenStart), charTable);
                    treeOffset = currentTokenStart;
                }
                currentLeaf = (LeafElement)TreeUtil.nextLeaf(currentLeaf);
            }
            if (currentLeaf == null) {
                assert (outerElementsRanges.get(outerElementsRanges.size() - 1) == outerElementRange) : "This should only happen for the last inserted range. Got " + outerElementsRanges.lastIndexOf(outerElementRange) + " of " + (outerElementsRanges.size() - 1);
                ((CompositeElement)templateFileElement).rawAddChildren(this.createOuterLanguageElement(charTable.intern(outerElementRange.subSequence(sourceCode)), this.myOuterElementType));
                ((CompositeElement)templateFileElement).subtreeChanged();
                break;
            }
            OuterLanguageElementImpl newLeaf = this.createOuterLanguageElement(charTable.intern(outerElementRange.subSequence(sourceCode)), this.myOuterElementType);
            templateTreePatcher.insert(currentLeaf.getTreeParent(), currentLeaf, newLeaf);
            currentLeaf.getTreeParent().subtreeChanged();
            currentLeaf = newLeaf;
        }
    }

    protected OuterLanguageElementImpl createOuterLanguageElement(@NotNull CharSequence internedTokenText, @NotNull IElementType outerElementType) {
        if (internedTokenText == null) {
            TemplateDataElementType.$$$reportNull$$$0(13);
        }
        if (outerElementType == null) {
            TemplateDataElementType.$$$reportNull$$$0(14);
        }
        return new OuterLanguageElementImpl(outerElementType, internedTokenText);
    }

    protected PsiFile createPsiFileFromSource(final Language language, CharSequence sourceCode, PsiManager manager) {
        LightVirtualFile virtualFile = new LightVirtualFile("foo", (FileType)this.createTemplateFakeFileType(language), sourceCode, LocalTimeCounter.currentTime());
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(manager, (VirtualFile)virtualFile, false){

            @Override
            @NotNull
            public Language getBaseLanguage() {
                Language language2 = language;
                if (language2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return language2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataElementType$1", "getBaseLanguage"));
            }
        };
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)virtualFile);
        return viewProvider.getPsi(language);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateElementType";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerRangesCollector";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceCode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/templateLanguages/TemplateDataElementType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElementsRanges";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internedTokenText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/templateLanguages/TemplateDataElementType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeDump";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseContents";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareParsedTemplateFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRangeDump";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "insertOuters";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createOuterLanguageElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class RangesCollector {
        private final List<TextRange> myRanges = new ArrayList<TextRange>();

        protected RangesCollector() {
        }

        public void addRange(@NotNull TextRange newRange) {
            int lastItemIndex;
            TextRange lastRange;
            if (newRange == null) {
                RangesCollector.$$$reportNull$$$0(0);
            }
            if (newRange.isEmpty()) {
                return;
            }
            if (!this.myRanges.isEmpty() && (lastRange = this.myRanges.get(lastItemIndex = this.myRanges.size() - 1)).getEndOffset() == newRange.getStartOffset()) {
                this.myRanges.set(lastItemIndex, TextRange.create((int)lastRange.getStartOffset(), (int)newRange.getEndOffset()));
                return;
            }
            this.myRanges.add(newRange);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRange", "com/intellij/psi/templateLanguages/TemplateDataElementType$RangesCollector", "addRange"));
        }
    }

    protected static class TemplateFileType
    extends LanguageFileType {
        private final Language myLanguage;

        public TemplateFileType(Language language) {
            super(language);
            this.myLanguage = language;
        }

        @NotNull
        public String getDefaultExtension() {
            if ("" == null) {
                TemplateFileType.$$$reportNull$$$0(0);
            }
            return "";
        }

        @NotNull
        @NonNls
        public String getDescription() {
            String string = "fake for language" + this.myLanguage.getID();
            if (string == null) {
                TemplateFileType.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return null;
        }

        @NotNull
        @NonNls
        public String getName() {
            String string = this.myLanguage.getID();
            if (string == null) {
                TemplateFileType.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/psi/templateLanguages/TemplateDataElementType$TemplateFileType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultExtension";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

