/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.util.Computable;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.CancellationException;
import org.jetbrains.annotations.NotNull;

public class AgentTaskExecutor
implements CloudAgentErrorHandler {
    private String myErrorMessage;

    public void onError(String message) {
        this.myErrorMessage = message;
    }

    private void clear() {
        this.myErrorMessage = null;
    }

    public <T> T execute(Computable<T> task) throws ServerRuntimeException {
        Object result2;
        this.clear();
        try {
            result2 = task.compute();
        }
        catch (CancellationException e) {
            throw new ServerRuntimeException(AgentTaskExecutor.safeMessage(e));
        }
        if (this.myErrorMessage == null) {
            return (T)result2;
        }
        throw new ServerRuntimeException(this.myErrorMessage);
    }

    public <T> void execute(Computable<T> task, CallbackWrapper<T> callback) {
        Object result2;
        this.clear();
        try {
            result2 = task.compute();
        }
        catch (CancellationException e) {
            this.onError(AgentTaskExecutor.safeMessage(e));
            result2 = null;
        }
        if (this.myErrorMessage == null) {
            callback.onSuccess(result2);
        } else {
            callback.onError(this.myErrorMessage);
        }
    }

    private static String safeMessage(@NotNull CancellationException ex) {
        if (ex == null) {
            AgentTaskExecutor.$$$reportNull$$$0(0);
        }
        return (String)ObjectUtils.notNull((Object)ex.getMessage(), (Object)"Operation cancelled");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex", "com/intellij/remoteServer/util/AgentTaskExecutor", "safeMessage"));
    }
}

