/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.treeWithCheckedNodes;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.changes.ui.PlusMinus;
import com.intellij.openapi.vcs.impl.CollectionsDelta;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.Convertor;
import com.intellij.util.treeWithCheckedNodes.SelectedState;
import com.intellij.util.treeWithCheckedNodes.TreeNodeState;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nullable;

public class SelectionManager {
    private final SelectedState<VirtualFile> myState;
    private final Convertor<DefaultMutableTreeNode, VirtualFile> myNodeConvertor;
    private PlusMinus<VirtualFile> mySelectionChangeListener;

    public SelectionManager(int selectedSize, int queueSize, Convertor<DefaultMutableTreeNode, VirtualFile> nodeConvertor) {
        this.myNodeConvertor = nodeConvertor;
        this.myState = new SelectedState(selectedSize, queueSize);
    }

    public void toggleSelection(DefaultMutableTreeNode node) {
        StateWorker stateWorker = new StateWorker(node, this.myNodeConvertor);
        VirtualFile vf = stateWorker.getVf();
        if (vf == null) {
            return;
        }
        TreeNodeState state = this.getStateImpl(stateWorker);
        if (TreeNodeState.HAVE_SELECTED_ABOVE.equals((Object)state)) {
            return;
        }
        if (TreeNodeState.CLEAR.equals((Object)state) && !this.myState.canAddSelection()) {
            return;
        }
        HashSet<VirtualFile> old = new HashSet<VirtualFile>(this.myState.getSelected());
        TreeNodeState futureState = this.myState.putAndPass(vf, TreeNodeState.SELECTED.equals((Object)state) ? TreeNodeState.CLEAR : TreeNodeState.SELECTED);
        if (!TreeNodeState.SELECTED.equals((Object)futureState)) {
            this.myState.clearAllCachedMatching((Processor<VirtualFile>)((Processor)virtualFile -> VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)vf, (boolean)false)));
        }
        stateWorker.iterateParents(this.myState, (PairProcessor<VirtualFile, TreeNodeState>)((PairProcessor)(virtualFile, state1) -> {
            if (TreeNodeState.SELECTED.equals((Object)futureState)) {
                this.myState.putAndPass((VirtualFile)virtualFile, TreeNodeState.HAVE_SELECTED_BELOW);
            } else {
                this.myState.remove((VirtualFile)virtualFile);
            }
            return true;
        }));
        this.myState.clearAllCachedMatching((Processor<VirtualFile>)((Processor)vf1 -> VfsUtilCore.isAncestor((VirtualFile)stateWorker.getVf(), (VirtualFile)vf1, (boolean)false)));
        for (VirtualFile selected : this.myState.getSelected()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)stateWorker.getVf(), (VirtualFile)selected, (boolean)true)) continue;
            this.myState.remove(selected);
        }
        Set<VirtualFile> selectedAfter = this.myState.getSelected();
        if (this.mySelectionChangeListener != null && !old.equals(selectedAfter)) {
            Set<VirtualFile> removed = CollectionsDelta.notInSecond(old, selectedAfter);
            Set<VirtualFile> newlyAdded = CollectionsDelta.notInSecond(selectedAfter, old);
            if (newlyAdded != null) {
                for (VirtualFile file2 : newlyAdded) {
                    if (this.mySelectionChangeListener == null) continue;
                    this.mySelectionChangeListener.plus(file2);
                }
            }
            if (removed != null) {
                for (VirtualFile file2 : removed) {
                    if (this.mySelectionChangeListener == null) continue;
                    this.mySelectionChangeListener.minus(file2);
                }
            }
        }
    }

    public boolean canAddSelection() {
        return this.myState.canAddSelection();
    }

    public void setSelection(Collection<VirtualFile> files) {
        this.myState.setSelection(files);
        for (VirtualFile file2 : files) {
            if (this.mySelectionChangeListener == null) continue;
            this.mySelectionChangeListener.plus(file2);
        }
    }

    public TreeNodeState getState(DefaultMutableTreeNode node) {
        return this.getStateImpl(new StateWorker(node, this.myNodeConvertor));
    }

    private TreeNodeState getStateImpl(StateWorker stateWorker) {
        if (stateWorker.getVf() == null) {
            return TreeNodeState.CLEAR;
        }
        TreeNodeState stateSelf = this.myState.get(stateWorker.getVf());
        if (stateSelf != null) {
            return stateSelf;
        }
        Ref result2 = new Ref();
        stateWorker.iterateParents(this.myState, (PairProcessor<VirtualFile, TreeNodeState>)((PairProcessor)(virtualFile, state) -> {
            if (state != null) {
                if (TreeNodeState.SELECTED.equals(state) || TreeNodeState.HAVE_SELECTED_ABOVE.equals(state)) {
                    result2.set((Object)this.myState.putAndPass(stateWorker.getVf(), TreeNodeState.HAVE_SELECTED_ABOVE));
                }
                return false;
            }
            return true;
        }));
        if (!result2.isNull()) {
            return (TreeNodeState)((Object)result2.get());
        }
        for (VirtualFile selected : this.myState.getSelected()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)stateWorker.getVf(), (VirtualFile)selected, (boolean)true)) continue;
            return this.myState.putAndPass(stateWorker.getVf(), TreeNodeState.HAVE_SELECTED_BELOW);
        }
        return TreeNodeState.CLEAR;
    }

    public void removeSelection(VirtualFile elementAt) {
        this.myState.remove(elementAt);
        this.myState.clearAllCachedMatching((Processor<VirtualFile>)((Processor)f -> VfsUtilCore.isAncestor((VirtualFile)f, (VirtualFile)elementAt, (boolean)false) || VfsUtilCore.isAncestor((VirtualFile)elementAt, (VirtualFile)f, (boolean)false)));
        if (this.mySelectionChangeListener != null) {
            this.mySelectionChangeListener.minus(elementAt);
        }
    }

    public void setSelectionChangeListener(@Nullable PlusMinus<VirtualFile> selectionChangeListener) {
        this.mySelectionChangeListener = selectionChangeListener;
    }

    private static class StateWorker {
        private final DefaultMutableTreeNode myNode;
        private final Convertor<DefaultMutableTreeNode, VirtualFile> myConvertor;
        private VirtualFile myVf;

        private StateWorker(DefaultMutableTreeNode node, Convertor<DefaultMutableTreeNode, VirtualFile> convertor) {
            this.myNode = node;
            this.myConvertor = convertor;
            this.myVf = (VirtualFile)this.myConvertor.convert((Object)node);
        }

        public VirtualFile getVf() {
            return this.myVf;
        }

        public void iterateParents(SelectedState<VirtualFile> states, PairProcessor<VirtualFile, TreeNodeState> parentsProcessor) {
            for (DefaultMutableTreeNode current = (DefaultMutableTreeNode)this.myNode.getParent(); current != null; current = (DefaultMutableTreeNode)current.getParent()) {
                VirtualFile file2 = (VirtualFile)this.myConvertor.convert((Object)current);
                if (file2 == null) {
                    return;
                }
                TreeNodeState state = states.get(file2);
                if (parentsProcessor.process((Object)file2, (Object)state)) continue;
                return;
            }
        }
    }
}

