/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.ui.StatusText;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.attach.XLocalAttachDebugger;
import com.intellij.xdebugger.attach.XLocalAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XLocalAttachGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttachToLocalProcessAction
extends AnAction {
    private static final Key<LinkedHashMap<String, HistoryItem>> HISTORY_KEY = Key.create((String)"AttachToLocalProcessAction.HISTORY_KEY");

    public AttachToLocalProcessAction() {
        super(XDebuggerBundle.message((String)"xdebugger.attach.toLocal.action", (Object[])new Object[0]), XDebuggerBundle.message((String)"xdebugger.attach.toLocal.action.description", (Object[])new Object[0]), AllIcons.Debugger.AttachToProcess);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Project project = AttachToLocalProcessAction.getEventProject((AnActionEvent)e);
        boolean enabled = project != null && ((XLocalAttachDebuggerProvider[])Extensions.getExtensions(XLocalAttachDebuggerProvider.EP)).length > 0;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = AttachToLocalProcessAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        final XLocalAttachDebuggerProvider[] providers = (XLocalAttachDebuggerProvider[])Extensions.getExtensions(XLocalAttachDebuggerProvider.EP);
        new Task.Backgroundable(project, XDebuggerBundle.message((String)"xdebugger.attach.toLocal.action.collectingProcesses", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProcessInfo[] processList = OSProcessUtil.getProcessList();
                List<AttachItem> items = AttachToLocalProcessAction.collectAttachItems(project, processList, indicator, providers);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    ProcessListStep step = new ProcessListStep(items, project);
                    ListPopupImpl popup2 = (ListPopupImpl)JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
                    JList mainList = popup2.getList();
                    ListSelectionListener listener2 = event -> {
                        if (event.getValueIsAdjusting()) {
                            return;
                        }
                        Object item = ((JList)event.getSource()).getSelectedValue();
                        if (item == null) {
                            item = mainList.getSelectedValue();
                        }
                        if (item instanceof AttachItem) {
                            AttachItem attachItem = (AttachItem)item;
                            String debuggerName = attachItem.getSelectedDebugger().getDebuggerDisplayName();
                            debuggerName = StringUtil.shortenTextWithEllipsis((String)debuggerName, (int)50, (int)0);
                            popup2.setCaption(XDebuggerBundle.message((String)"xdebugger.attach.toLocal.popup.title", (Object[])new Object[]{debuggerName}));
                            String description = attachItem.getTooltipText(project);
                            popup2.setAdText(description != null ? description : " ");
                        }
                    };
                    popup2.addListSelectionListener(listener2);
                    listener2.valueChanged(new ListSelectionEvent(mainList, mainList.getMinSelectionIndex(), mainList.getMaxSelectionIndex(), false));
                    popup2.showCenteredInCurrentWindow(project);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/xdebugger/impl/actions/AttachToLocalProcessAction$1", "run"));
            }
        }.queue();
    }

    @NotNull
    public static List<AttachItem> collectAttachItems(@NotNull Project project, @NotNull ProcessInfo[] processList, @NotNull ProgressIndicator indicator, XLocalAttachDebuggerProvider ... providers) {
        if (project == null) {
            AttachToLocalProcessAction.$$$reportNull$$$0(0);
        }
        if (processList == null) {
            AttachToLocalProcessAction.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            AttachToLocalProcessAction.$$$reportNull$$$0(2);
        }
        if (providers == null) {
            AttachToLocalProcessAction.$$$reportNull$$$0(3);
        }
        MultiMap groupWithItems = new MultiMap();
        UserDataHolderBase dataHolder = new UserDataHolderBase();
        for (ProcessInfo eachInfo : processList) {
            MultiMap groupsWithDebuggers = new MultiMap();
            for (XLocalAttachDebuggerProvider eachProvider : providers) {
                indicator.checkCanceled();
                groupsWithDebuggers.putValues((Object)eachProvider.getAttachGroup(), eachProvider.getAvailableDebuggers(project, eachInfo, (UserDataHolder)dataHolder));
            }
            for (XLocalAttachGroup eachGroup : groupsWithDebuggers.keySet()) {
                Collection debuggers = groupsWithDebuggers.get((Object)eachGroup);
                if (debuggers.isEmpty()) continue;
                groupWithItems.putValue((Object)eachGroup, (Object)Pair.create((Object)eachInfo, new ArrayList(debuggers)));
            }
        }
        ArrayList<XLocalAttachGroup> sortedGroups = new ArrayList<XLocalAttachGroup>(groupWithItems.keySet());
        sortedGroups.sort(Comparator.comparingInt(XLocalAttachGroup::getOrder));
        ArrayList<AttachItem> currentItems = new ArrayList<AttachItem>();
        for (XLocalAttachGroup eachGroup : sortedGroups) {
            ArrayList sortedItems = new ArrayList(groupWithItems.get((Object)eachGroup));
            sortedItems.sort((a, b) -> {
                if (project == null) {
                    AttachToLocalProcessAction.$$$reportNull$$$0(9);
                }
                return eachGroup.compare(project, (ProcessInfo)a.first, (ProcessInfo)b.first, (UserDataHolder)dataHolder);
            });
            boolean first = true;
            for (Pair eachItem : sortedItems) {
                currentItems.add(new AttachItem(eachGroup, first, (ProcessInfo)eachItem.first, (List)eachItem.second, (UserDataHolder)dataHolder));
                first = false;
            }
        }
        ArrayList<AttachItem> currentHistoryItems = new ArrayList<AttachItem>();
        List<HistoryItem> history = AttachToLocalProcessAction.getHistory(project);
        for (int i = history.size() - 1; i >= 0; --i) {
            HistoryItem eachHistoryItem = history.get(i);
            for (AttachItem eachCurrentItem : currentItems) {
                boolean isSuitableItem;
                boolean bl = isSuitableItem = eachHistoryItem.getGroup().equals(eachCurrentItem.getGroup()) && eachHistoryItem.getProcessInfo().getCommandLine().equals(eachCurrentItem.getProcessInfo().getCommandLine());
                if (!isSuitableItem) continue;
                List<XLocalAttachDebugger> debuggers = eachCurrentItem.getDebuggers();
                int selectedDebugger = -1;
                for (int j = 0; j < debuggers.size(); ++j) {
                    XLocalAttachDebugger eachDebugger = debuggers.get(j);
                    if (!eachDebugger.getDebuggerDisplayName().equals(eachHistoryItem.getDebuggerName())) continue;
                    selectedDebugger = j;
                    break;
                }
                if (selectedDebugger == -1) continue;
                currentHistoryItems.add(new AttachItem(eachCurrentItem.getGroup(), currentHistoryItems.isEmpty(), XDebuggerBundle.message((String)"xdebugger.attach.toLocal.popup.recent", (Object[])new Object[0]), eachCurrentItem.getProcessInfo(), debuggers, selectedDebugger, (UserDataHolder)dataHolder));
            }
        }
        currentHistoryItems.addAll(currentItems);
        ArrayList<AttachItem> arrayList = currentHistoryItems;
        if (arrayList == null) {
            AttachToLocalProcessAction.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static void addToHistory(@NotNull Project project, @NotNull AttachItem item) {
        LinkedHashMap history;
        if (project == null) {
            AttachToLocalProcessAction.$$$reportNull$$$0(5);
        }
        if (item == null) {
            AttachToLocalProcessAction.$$$reportNull$$$0(6);
        }
        if ((history = (LinkedHashMap)project.getUserData(HISTORY_KEY)) == null) {
            history = new LinkedHashMap();
            project.putUserData(HISTORY_KEY, (Object)history);
        }
        ProcessInfo processInfo = item.getProcessInfo();
        history.remove((Object)processInfo.getCommandLine());
        history.put((Object)processInfo.getCommandLine(), (Object)new HistoryItem(processInfo, item.getGroup(), item.getSelectedDebugger().getDebuggerDisplayName()));
        while (history.size() > 4) {
            history.remove(history.keySet().iterator().next());
        }
    }

    @NotNull
    public static List<HistoryItem> getHistory(@NotNull Project project) {
        LinkedHashMap history;
        if (project == null) {
            AttachToLocalProcessAction.$$$reportNull$$$0(7);
        }
        List<HistoryItem> list2 = (history = (LinkedHashMap)project.getUserData(HISTORY_KEY)) == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(history.values()));
        if (list2 == null) {
            AttachToLocalProcessAction.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/actions/AttachToLocalProcessAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/actions/AttachToLocalProcessAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAttachItems";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectAttachItems";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHistory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectAttachItems$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProcessListStep
    extends MyBasePopupStep
    implements ListPopupStepEx<AttachItem> {
        public ProcessListStep(@NotNull List<AttachItem> items, @NotNull Project project) {
            if (items == null) {
                ProcessListStep.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ProcessListStep.$$$reportNull$$$0(1);
            }
            super(project, XDebuggerBundle.message((String)"xdebugger.attach.toLocal.popup.title.default", (Object[])new Object[0]), items);
        }

        @Nullable
        public ListSeparator getSeparatorAbove(AttachItem value) {
            String separatorTitle = value.getSeparatorTitle();
            return separatorTitle == null ? null : new ListSeparator(separatorTitle);
        }

        public Icon getIconFor(AttachItem value) {
            return value.getIcon(this.myProject);
        }

        @NotNull
        public String getTextFor(AttachItem value) {
            String string = value.getText(this.myProject);
            if (string == null) {
                ProcessListStep.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public String getTooltipTextFor(AttachItem value) {
            String tooltipText = value.getTooltipText(this.myProject);
            if (tooltipText != null) {
                return tooltipText;
            }
            return value.getText(this.myProject);
        }

        public void setEmptyText(@NotNull StatusText emptyText) {
            if (emptyText == null) {
                ProcessListStep.$$$reportNull$$$0(3);
            }
            emptyText.setText(XDebuggerBundle.message((String)"xdebugger.attach.toLocal.popup.emptyText", (Object[])new Object[0]));
        }

        @Override
        public PopupStep onChosen(AttachItem selectedValue, boolean finalChoice) {
            if (finalChoice) {
                return super.onChosen(selectedValue, true);
            }
            return new DebuggerListStep(selectedValue.getSubItems(), selectedValue.mySelectedDebugger);
        }

        public PopupStep onChosen(AttachItem selectedValue, boolean finalChoice, int eventModifiers) {
            return this.onChosen(selectedValue, finalChoice);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/actions/AttachToLocalProcessAction$ProcessListStep";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "emptyText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/actions/AttachToLocalProcessAction$ProcessListStep";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setEmptyText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class DebuggerListStep
        extends MyBasePopupStep {
            public DebuggerListStep(List<AttachItem> items, int selectedItem) {
                super(ProcessListStep.this.myProject, XDebuggerBundle.message((String)"xdebugger.attach.toLocal.popup.selectDebugger.title", (Object[])new Object[0]), items);
                this.setDefaultOptionIndex(selectedItem);
            }

            @NotNull
            public String getTextFor(AttachItem value) {
                String string = value.getSelectedDebugger().getDebuggerDisplayName();
                if (string == null) {
                    DebuggerListStep.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/AttachToLocalProcessAction$ProcessListStep$DebuggerListStep", "getTextFor"));
            }
        }
    }

    private static class MyBasePopupStep
    extends BaseListPopupStep<AttachItem> {
        @NotNull
        final Project myProject;

        public MyBasePopupStep(@NotNull Project project, @Nullable String title, List<? extends AttachItem> values) {
            if (project == null) {
                MyBasePopupStep.$$$reportNull$$$0(0);
            }
            super(title, values);
            this.myProject = project;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        public boolean hasSubstep(AttachItem selectedValue) {
            return !selectedValue.getSubItems().isEmpty();
        }

        public PopupStep onChosen(AttachItem selectedValue, boolean finalChoice) {
            AttachToLocalProcessAction.addToHistory(this.myProject, selectedValue);
            return this.doFinalStep(() -> selectedValue.startDebugSession(this.myProject));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/AttachToLocalProcessAction$MyBasePopupStep", "<init>"));
        }
    }

    public static class AttachItem {
        @NotNull
        private final XLocalAttachGroup myGroup;
        private final boolean myIsFirstInGroup;
        @NotNull
        private final String myGroupName;
        @NotNull
        private UserDataHolder myDataHolder;
        @NotNull
        private final ProcessInfo myProcessInfo;
        @NotNull
        private final List<XLocalAttachDebugger> myDebuggers;
        private final int mySelectedDebugger;
        @NotNull
        private final List<AttachItem> mySubItems;

        public AttachItem(@NotNull XLocalAttachGroup group, boolean isFirstInGroup, @NotNull ProcessInfo info, @NotNull List<XLocalAttachDebugger> debuggers, @NotNull UserDataHolder dataHolder) {
            if (group == null) {
                AttachItem.$$$reportNull$$$0(0);
            }
            if (info == null) {
                AttachItem.$$$reportNull$$$0(1);
            }
            if (debuggers == null) {
                AttachItem.$$$reportNull$$$0(2);
            }
            if (dataHolder == null) {
                AttachItem.$$$reportNull$$$0(3);
            }
            this(group, isFirstInGroup, group.getGroupName(), info, debuggers, 0, dataHolder);
        }

        public AttachItem(@NotNull XLocalAttachGroup group, boolean isFirstInGroup, @NotNull String groupName, @NotNull ProcessInfo info, @NotNull List<XLocalAttachDebugger> debuggers, int selectedDebugger, @NotNull UserDataHolder dataHolder) {
            if (group == null) {
                AttachItem.$$$reportNull$$$0(4);
            }
            if (groupName == null) {
                AttachItem.$$$reportNull$$$0(5);
            }
            if (info == null) {
                AttachItem.$$$reportNull$$$0(6);
            }
            if (debuggers == null) {
                AttachItem.$$$reportNull$$$0(7);
            }
            if (dataHolder == null) {
                AttachItem.$$$reportNull$$$0(8);
            }
            this.myGroupName = groupName;
            this.myDataHolder = dataHolder;
            assert (!debuggers.isEmpty()) : "debugger list should not be empty";
            assert (selectedDebugger >= 0 && selectedDebugger < debuggers.size()) : "wrong selected debugger index";
            this.myGroup = group;
            this.myIsFirstInGroup = isFirstInGroup;
            this.myProcessInfo = info;
            this.myDebuggers = debuggers;
            this.mySelectedDebugger = selectedDebugger;
            this.mySubItems = debuggers.size() > 1 ? ContainerUtil.map(debuggers, debugger -> {
                if (dataHolder == null) {
                    AttachItem.$$$reportNull$$$0(19);
                }
                return new AttachItem(this.myGroup, false, this.myProcessInfo, Collections.singletonList(debugger), dataHolder);
            }) : Collections.emptyList();
        }

        @NotNull
        public ProcessInfo getProcessInfo() {
            ProcessInfo processInfo = this.myProcessInfo;
            if (processInfo == null) {
                AttachItem.$$$reportNull$$$0(9);
            }
            return processInfo;
        }

        @NotNull
        public XLocalAttachGroup getGroup() {
            XLocalAttachGroup xLocalAttachGroup = this.myGroup;
            if (xLocalAttachGroup == null) {
                AttachItem.$$$reportNull$$$0(10);
            }
            return xLocalAttachGroup;
        }

        @Nullable
        public String getSeparatorTitle() {
            return this.myIsFirstInGroup ? this.myGroupName : null;
        }

        @Nullable
        public Icon getIcon(@NotNull Project project) {
            if (project == null) {
                AttachItem.$$$reportNull$$$0(11);
            }
            return this.myGroup.getProcessIcon(project, this.myProcessInfo, this.myDataHolder);
        }

        @NotNull
        public String getText(@NotNull Project project) {
            if (project == null) {
                AttachItem.$$$reportNull$$$0(12);
            }
            String shortenedText = StringUtil.shortenTextWithEllipsis((String)this.myGroup.getProcessDisplayText(project, this.myProcessInfo, this.myDataHolder), (int)200, (int)0);
            String string = this.myProcessInfo.getPid() + " " + shortenedText;
            if (string == null) {
                AttachItem.$$$reportNull$$$0(13);
            }
            return string;
        }

        @Nullable
        public String getTooltipText(@NotNull Project project) {
            if (project == null) {
                AttachItem.$$$reportNull$$$0(14);
            }
            return this.myGroup.getProcessDescription(project, this.myProcessInfo, this.myDataHolder);
        }

        @NotNull
        public List<XLocalAttachDebugger> getDebuggers() {
            List<XLocalAttachDebugger> list2 = this.myDebuggers;
            if (list2 == null) {
                AttachItem.$$$reportNull$$$0(15);
            }
            return list2;
        }

        @NotNull
        public XLocalAttachDebugger getSelectedDebugger() {
            XLocalAttachDebugger xLocalAttachDebugger = this.myDebuggers.get(this.mySelectedDebugger);
            if (xLocalAttachDebugger == null) {
                AttachItem.$$$reportNull$$$0(16);
            }
            return xLocalAttachDebugger;
        }

        @NotNull
        public List<AttachItem> getSubItems() {
            List<AttachItem> list2 = this.mySubItems;
            if (list2 == null) {
                AttachItem.$$$reportNull$$$0(17);
            }
            return list2;
        }

        public void startDebugSession(@NotNull Project project) {
            if (project == null) {
                AttachItem.$$$reportNull$$$0(18);
            }
            XLocalAttachDebugger debugger = this.getSelectedDebugger();
            UsageTrigger.trigger(ConvertUsagesUtil.ensureProperKey("debugger.attach.local"));
            UsageTrigger.trigger(ConvertUsagesUtil.ensureProperKey("debugger.attach.local." + debugger.getDebuggerDisplayName()));
            try {
                debugger.attachDebugSession(project, this.myProcessInfo);
            }
            catch (ExecutionException e) {
                ExecutionUtil.handleExecutionError((Project)project, (String)ToolWindowId.DEBUG, (String)this.myProcessInfo.getExecutableName(), (Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debuggers";
                    break;
                }
                case 3: 
                case 8: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataHolder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupName";
                    break;
                }
                case 9: 
                case 10: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/actions/AttachToLocalProcessAction$AttachItem";
                    break;
                }
                case 11: 
                case 12: 
                case 14: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/actions/AttachToLocalProcessAction$AttachItem";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcessInfo";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroup";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebuggers";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedDebugger";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 9: 
                case 10: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getTooltipText";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "startDebugSession";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$new$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: 
                case 13: 
                case 15: 
                case 16: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class HistoryItem {
        @NotNull
        private final ProcessInfo myProcessInfo;
        @NotNull
        private final XLocalAttachGroup myGroup;
        @NotNull
        private final String myDebuggerName;

        public HistoryItem(@NotNull ProcessInfo processInfo, @NotNull XLocalAttachGroup group, @NotNull String debuggerName) {
            if (processInfo == null) {
                HistoryItem.$$$reportNull$$$0(0);
            }
            if (group == null) {
                HistoryItem.$$$reportNull$$$0(1);
            }
            if (debuggerName == null) {
                HistoryItem.$$$reportNull$$$0(2);
            }
            this.myProcessInfo = processInfo;
            this.myGroup = group;
            this.myDebuggerName = debuggerName;
        }

        @NotNull
        public ProcessInfo getProcessInfo() {
            ProcessInfo processInfo = this.myProcessInfo;
            if (processInfo == null) {
                HistoryItem.$$$reportNull$$$0(3);
            }
            return processInfo;
        }

        @NotNull
        public XLocalAttachGroup getGroup() {
            XLocalAttachGroup xLocalAttachGroup = this.myGroup;
            if (xLocalAttachGroup == null) {
                HistoryItem.$$$reportNull$$$0(4);
            }
            return xLocalAttachGroup;
        }

        @NotNull
        public String getDebuggerName() {
            String string = this.myDebuggerName;
            if (string == null) {
                HistoryItem.$$$reportNull$$$0(5);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HistoryItem item = (HistoryItem)o;
            if (!this.myProcessInfo.equals(item.myProcessInfo)) {
                return false;
            }
            if (!this.myGroup.equals(item.myGroup)) {
                return false;
            }
            return this.myDebuggerName.equals(item.myDebuggerName);
        }

        public int hashCode() {
            return Objects.hash(this.myProcessInfo, this.myGroup, this.myDebuggerName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debuggerName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/actions/AttachToLocalProcessAction$HistoryItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/actions/AttachToLocalProcessAction$HistoryItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcessInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroup";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebuggerName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

