/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonNullLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaReader {
    private static final int MAX_SCHEMA_LENGTH = 0x100000;
    public static final Logger LOG = Logger.getInstance(JsonSchemaReader.class);
    public static final NotificationGroup ERRORS_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"JSON Schema");
    private final Map<String, JsonSchemaObject> myIds = new HashMap<String, JsonSchemaObject>();
    private final ArrayDeque<JsonSchemaObject> myQueue = new ArrayDeque();
    private static final Map<String, MyReader> READERS_MAP = new HashMap<String, MyReader>();

    public static JsonSchemaObject readFromFile(@NotNull Project project, @NotNull VirtualFile key) throws Exception {
        PsiFile psiFile;
        if (project == null) {
            JsonSchemaReader.$$$reportNull$$$0(0);
        }
        if (key == null) {
            JsonSchemaReader.$$$reportNull$$$0(1);
        }
        if (!((psiFile = PsiManager.getInstance((Project)project).findFile(key)) instanceof JsonFile)) {
            throw new Exception(String.format("Can not load PSI for JSON Schema file '%s'", key.getName()));
        }
        JsonObject value = (JsonObject)ObjectUtils.tryCast((Object)((JsonFile)psiFile).getTopLevelValue(), JsonObject.class);
        if (value == null) {
            throw new Exception(String.format("JSON Schema file '%s' must contain only one top-level object", key.getName()));
        }
        return new JsonSchemaReader().read(value);
    }

    @Nullable
    public static String checkIfValidJsonSchema(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            JsonSchemaReader.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(3);
        }
        long length = file2.getLength();
        String fileName = file2.getName();
        if (length > 0x100000L) {
            return String.format("JSON schema was not loaded from '%s' because it's too large (file size is %d bytes).", fileName, length);
        }
        if (length == 0L) {
            return String.format("JSON schema was not loaded from '%s'. File is empty.", fileName);
        }
        try {
            JsonSchemaReader.readFromFile(project, file2);
        }
        catch (Exception e) {
            String message = String.format("JSON Schema not found or contain error in '%s': %s", fileName, e.getMessage());
            LOG.info(message);
            return message;
        }
        return null;
    }

    @Nullable
    public static String readSchemaId(@NotNull Project project, @NotNull VirtualFile schemaFile) {
        PsiFile psiFile;
        if (project == null) {
            JsonSchemaReader.$$$reportNull$$$0(4);
        }
        if (schemaFile == null) {
            JsonSchemaReader.$$$reportNull$$$0(5);
        }
        if (!((psiFile = PsiManager.getInstance((Project)project).findFile(schemaFile)) instanceof JsonFile)) {
            return null;
        }
        CachedValueProvider provider = () -> {
            JsonObject topLevelValue = (JsonObject)ObjectUtils.tryCast((Object)((JsonFile)psiFile).getTopLevelValue(), JsonObject.class);
            if (topLevelValue == null) {
                return null;
            }
            return CachedValueProvider.Result.create((Object)JsonSchemaReader.readId(topLevelValue), (Object[])new Object[]{psiFile});
        };
        return (String)ReadAction.compute(() -> (String)CachedValuesManager.getCachedValue((PsiElement)psiFile, (CachedValueProvider)provider));
    }

    public JsonSchemaObject read(@NotNull JsonObject object) {
        if (object == null) {
            JsonSchemaReader.$$$reportNull$$$0(6);
        }
        JsonSchemaObject root = new JsonSchemaObject(object);
        this.myQueue.add(root);
        while (!this.myQueue.isEmpty()) {
            JsonSchemaObject currentSchema = this.myQueue.removeFirst();
            JsonObject jsonObject = currentSchema.getJsonObject();
            List<JsonProperty> list2 = jsonObject.getPropertyList();
            for (JsonProperty property : list2) {
                if (StringUtil.isEmptyOrSpaces((String)property.getName()) || property.getValue() == null) continue;
                MyReader reader = READERS_MAP.get(property.getName());
                if (reader != null) {
                    reader.read(property.getValue(), currentSchema, this.myQueue);
                    continue;
                }
                this.readSingleDefinition(property.getName(), property.getValue(), currentSchema);
            }
            if (currentSchema.getId() == null) continue;
            this.myIds.put(currentSchema.getId(), currentSchema);
        }
        return root;
    }

    public Map<String, JsonSchemaObject> getIds() {
        return this.myIds;
    }

    @Nullable
    private static String readId(@NotNull JsonObject object) {
        JsonProperty property;
        if (object == null) {
            JsonSchemaReader.$$$reportNull$$$0(7);
        }
        if ((property = object.findProperty("id")) != null && property.getValue() instanceof JsonStringLiteral) {
            return JsonSchemaService.normalizeId(StringUtil.unquoteString((String)property.getValue().getText()));
        }
        return null;
    }

    private void readSingleDefinition(@NotNull String name, @NotNull JsonValue value, @NotNull JsonSchemaObject schema) {
        if (name == null) {
            JsonSchemaReader.$$$reportNull$$$0(8);
        }
        if (value == null) {
            JsonSchemaReader.$$$reportNull$$$0(9);
        }
        if (schema == null) {
            JsonSchemaReader.$$$reportNull$$$0(10);
        }
        if (value instanceof JsonObject) {
            JsonSchemaObject defined = new JsonSchemaObject((JsonObject)value);
            this.myQueue.add(defined);
            Map<String, JsonSchemaObject> definitions = schema.getDefinitionsMap();
            if (definitions == null) {
                definitions = new HashMap<String, JsonSchemaObject>();
                schema.setDefinitionsMap(definitions);
            }
            definitions.put(name, defined);
        }
    }

    private static void fillMap() {
        READERS_MAP.put("id", (element, object, queue2) -> {
            if (element instanceof JsonStringLiteral) {
                object.setId(StringUtil.unquoteString((String)element.getText()));
            }
        });
        READERS_MAP.put("$schema", (element, object, queue2) -> {
            if (element instanceof JsonStringLiteral) {
                object.setSchema(StringUtil.unquoteString((String)element.getText()));
            }
        });
        READERS_MAP.put("description", (element, object, queue2) -> {
            if (element instanceof JsonStringLiteral) {
                object.setDescription(StringUtil.unquoteString((String)element.getText()));
            }
        });
        READERS_MAP.put("title", (element, object, queue2) -> {
            if (element instanceof JsonStringLiteral) {
                object.setTitle(StringUtil.unquoteString((String)element.getText()));
            }
        });
        READERS_MAP.put("$ref", (element, object, queue2) -> {
            if (element instanceof JsonStringLiteral) {
                object.setRef(StringUtil.unquoteString((String)element.getText()));
            }
        });
        READERS_MAP.put("default", JsonSchemaReader.createDefault());
        READERS_MAP.put("format", (element, object, queue2) -> {
            if (element instanceof JsonStringLiteral) {
                object.setFormat(StringUtil.unquoteString((String)element.getText()));
            }
        });
        READERS_MAP.put("definitions", JsonSchemaReader.createDefinitionsConsumer());
        READERS_MAP.put("properties", JsonSchemaReader.createPropertiesConsumer());
        READERS_MAP.put("multipleOf", (element, object, queue2) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMultipleOf(((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("maximum", (element, object, queue2) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMaximum(((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("minimum", (element, object, queue2) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMinimum(((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("exclusiveMaximum", (element, object, queue2) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setExclusiveMaximum(((JsonBooleanLiteral)element).getValue());
            }
        });
        READERS_MAP.put("exclusiveMinimum", (element, object, queue2) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setExclusiveMinimum(((JsonBooleanLiteral)element).getValue());
            }
        });
        READERS_MAP.put("maxLength", (element, object, queue2) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMaxLength((int)((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("minLength", (element, object, queue2) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMinLength((int)((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("pattern", (element, object, queue2) -> {
            if (element instanceof JsonStringLiteral) {
                object.setPattern(StringUtil.unquoteString((String)element.getText()));
            }
        });
        READERS_MAP.put("additionalItems", JsonSchemaReader.createAdditionalItems());
        READERS_MAP.put("items", JsonSchemaReader.createItems());
        READERS_MAP.put("maxItems", (element, object, queue2) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMaxItems((int)((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("minItems", (element, object, queue2) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMinItems((int)((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("uniqueItems", (element, object, queue2) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setUniqueItems(((JsonBooleanLiteral)element).getValue());
            }
        });
        READERS_MAP.put("maxProperties", (element, object, queue2) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMaxProperties((int)((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("minProperties", (element, object, queue2) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMinProperties((int)((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("required", JsonSchemaReader.createRequired());
        READERS_MAP.put("additionalProperties", JsonSchemaReader.createAdditionalProperties());
        READERS_MAP.put("patternProperties", JsonSchemaReader.createPatternProperties());
        READERS_MAP.put("dependencies", JsonSchemaReader.createDependencies());
        READERS_MAP.put("enum", JsonSchemaReader.createEnum());
        READERS_MAP.put("type", JsonSchemaReader.createType());
        READERS_MAP.put("allOf", JsonSchemaReader.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setAllOf((List<JsonSchemaObject>)members))));
        READERS_MAP.put("anyOf", JsonSchemaReader.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setAnyOf((List<JsonSchemaObject>)members))));
        READERS_MAP.put("oneOf", JsonSchemaReader.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setOneOf((List<JsonSchemaObject>)members))));
        READERS_MAP.put("not", JsonSchemaReader.createNot());
        READERS_MAP.put("instanceof", (element, object, queue2) -> object.shouldValidateAgainstJSType());
        READERS_MAP.put("typeof", (element, object, queue2) -> object.shouldValidateAgainstJSType());
    }

    private static MyReader createNot() {
        return (element, object, queue2) -> {
            if (element instanceof JsonObject) {
                JsonSchemaObject not = new JsonSchemaObject((JsonObject)element);
                queue2.add(not);
                object.setNot(not);
            }
        };
    }

    private static MyReader createContainer(@NotNull PairConsumer<JsonSchemaObject, List<JsonSchemaObject>> delegate) {
        if (delegate == null) {
            JsonSchemaReader.$$$reportNull$$$0(11);
        }
        return (element, object, queue2) -> {
            if (delegate == null) {
                JsonSchemaReader.$$$reportNull$$$0(19);
            }
            if (element instanceof JsonArray) {
                List<JsonValue> list2 = ((JsonArray)element).getValueList();
                List members = list2.stream().filter(el -> el instanceof JsonObject).map(el -> {
                    JsonSchemaObject child = new JsonSchemaObject((JsonObject)el);
                    queue2.add(child);
                    return child;
                }).collect(Collectors.toList());
                delegate.consume((Object)object, members);
            }
        };
    }

    private static MyReader createType() {
        return (element, object, queue2) -> {
            List<JsonSchemaType> typeList;
            if (element instanceof JsonStringLiteral) {
                JsonSchemaType type = JsonSchemaReader.parseType(StringUtil.unquoteString((String)element.getText()));
                if (type != null) {
                    object.setType(type);
                }
            } else if (element instanceof JsonArray && !(typeList = ((JsonArray)element).getValueList().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> JsonSchemaReader.parseType(StringUtil.unquoteString((String)el.getText()))).filter(el -> el != null).collect(Collectors.toList())).isEmpty()) {
                object.setTypeVariants(typeList);
            }
        };
    }

    @Nullable
    private static JsonSchemaType parseType(@NotNull String typeString) {
        if (typeString == null) {
            JsonSchemaReader.$$$reportNull$$$0(12);
        }
        try {
            return JsonSchemaType.valueOf("_" + typeString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static MyReader createEnum() {
        return (element, object, queue2) -> {
            if (element instanceof JsonArray) {
                ArrayList<Object> objects = new ArrayList<Object>();
                List<JsonValue> list2 = ((JsonArray)element).getValueList();
                for (JsonValue value : list2) {
                    if (value instanceof JsonStringLiteral) {
                        objects.add("\"" + StringUtil.unquoteString((String)((JsonStringLiteral)value).getValue()) + "\"");
                        continue;
                    }
                    if (value instanceof JsonNumberLiteral) {
                        objects.add(JsonSchemaReader.getNumber((JsonNumberLiteral)value));
                        continue;
                    }
                    if (value instanceof JsonBooleanLiteral) {
                        objects.add(((JsonBooleanLiteral)value).getValue());
                        continue;
                    }
                    if (!(value instanceof JsonNullLiteral)) continue;
                    objects.add("null");
                }
                object.setEnum(objects);
            }
        };
    }

    @NotNull
    private static Number getNumber(@NotNull JsonNumberLiteral value) {
        Number numberValue;
        if (value == null) {
            JsonSchemaReader.$$$reportNull$$$0(13);
        }
        try {
            numberValue = Integer.parseInt(value.getText());
        }
        catch (NumberFormatException e) {
            numberValue = value.getValue();
        }
        Number number = numberValue;
        if (number == null) {
            JsonSchemaReader.$$$reportNull$$$0(14);
        }
        return number;
    }

    private static MyReader createDependencies() {
        return (element, object, queue2) -> {
            if (element instanceof JsonObject) {
                HashMap<String, List<String>> propertyDependencies = new HashMap<String, List<String>>();
                HashMap<String, JsonSchemaObject> schemaDependencies = new HashMap<String, JsonSchemaObject>();
                List<JsonProperty> list2 = ((JsonObject)element).getPropertyList();
                for (JsonProperty property : list2) {
                    if (StringUtil.isEmptyOrSpaces((String)property.getName()) || property.getValue() == null) continue;
                    if (property.getValue() instanceof JsonArray) {
                        List dependencies = ((JsonArray)property.getValue()).getValueList().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> StringUtil.unquoteString((String)el.getText())).collect(Collectors.toList());
                        if (dependencies.isEmpty()) continue;
                        propertyDependencies.put(property.getName(), dependencies);
                        continue;
                    }
                    if (!(property.getValue() instanceof JsonObject)) continue;
                    JsonSchemaObject child = new JsonSchemaObject((JsonObject)property.getValue());
                    queue2.add(child);
                    schemaDependencies.put(property.getName(), child);
                }
                object.setPropertyDependencies(propertyDependencies);
                object.setSchemaDependencies(schemaDependencies);
            }
        };
    }

    @NotNull
    private static Predicate<JsonValue> notEmptyString() {
        Predicate<JsonValue> predicate = el -> el instanceof JsonStringLiteral && !StringUtil.isEmptyOrSpaces((String)el.getText());
        if (predicate == null) {
            JsonSchemaReader.$$$reportNull$$$0(15);
        }
        return predicate;
    }

    private static MyReader createPatternProperties() {
        return (element, object, queue2) -> {
            if (element instanceof JsonObject) {
                object.setPatternProperties(JsonSchemaReader.readInnerObject((JsonObject)element, queue2));
            }
        };
    }

    private static MyReader createAdditionalProperties() {
        return (element, object, queue2) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setAdditionalPropertiesAllowed(((JsonBooleanLiteral)element).getValue());
            } else if (element instanceof JsonObject) {
                JsonSchemaObject schema = new JsonSchemaObject((JsonObject)element);
                queue2.add(schema);
                object.setAdditionalPropertiesSchema(schema);
            }
        };
    }

    private static MyReader createRequired() {
        return (element, object, queue2) -> {
            if (element instanceof JsonArray) {
                object.setRequired(((JsonArray)element).getValueList().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> StringUtil.unquoteString((String)el.getText())).collect(Collectors.toList()));
            }
        };
    }

    private static MyReader createItems() {
        return (element, object, queue2) -> {
            if (element instanceof JsonObject) {
                JsonSchemaObject schema = new JsonSchemaObject((JsonObject)element);
                queue2.add(schema);
                object.setItemsSchema(schema);
            } else if (element instanceof JsonArray) {
                ArrayList<JsonSchemaObject> list2 = new ArrayList<JsonSchemaObject>();
                List<JsonValue> values = ((JsonArray)element).getValueList();
                for (JsonValue value : values) {
                    if (!(value instanceof JsonObject)) continue;
                    JsonSchemaObject child = new JsonSchemaObject((JsonObject)value);
                    queue2.add(child);
                    list2.add(child);
                }
                object.setItemsSchemaList(list2);
            }
        };
    }

    private static MyReader createAdditionalItems() {
        return (element, object, queue2) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setAdditionalItemsAllowed(((JsonBooleanLiteral)element).getValue());
            } else if (element instanceof JsonObject) {
                JsonSchemaObject additionalItemsSchema = new JsonSchemaObject((JsonObject)element);
                queue2.add(additionalItemsSchema);
                object.setAdditionalItemsSchema(additionalItemsSchema);
            }
        };
    }

    private static MyReader createPropertiesConsumer() {
        return (element, object, queue2) -> {
            if (element instanceof JsonObject) {
                object.setProperties(JsonSchemaReader.readInnerObject((JsonObject)element, queue2));
            }
        };
    }

    private static MyReader createDefinitionsConsumer() {
        return (element, object, queue2) -> {
            if (element instanceof JsonObject) {
                JsonObject definitions = (JsonObject)element;
                object.setDefinitionsMap(JsonSchemaReader.readInnerObject(definitions, queue2));
            }
        };
    }

    @NotNull
    private static Map<String, JsonSchemaObject> readInnerObject(@NotNull JsonObject element, @NotNull Collection<JsonSchemaObject> queue2) {
        if (element == null) {
            JsonSchemaReader.$$$reportNull$$$0(16);
        }
        if (queue2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(17);
        }
        List<JsonProperty> properties = element.getPropertyList();
        HashMap<String, JsonSchemaObject> map = new HashMap<String, JsonSchemaObject>();
        for (JsonProperty property : properties) {
            if (StringUtil.isEmptyOrSpaces((String)property.getName()) || !(property.getValue() instanceof JsonObject)) continue;
            JsonSchemaObject child = new JsonSchemaObject((JsonObject)property.getValue());
            queue2.add(child);
            map.put(property.getName(), child);
        }
        HashMap<String, JsonSchemaObject> hashMap = map;
        if (hashMap == null) {
            JsonSchemaReader.$$$reportNull$$$0(18);
        }
        return hashMap;
    }

    private static MyReader createDefault() {
        return (element, object, queue2) -> {
            if (element instanceof JsonObject) {
                JsonSchemaObject schemaObject = new JsonSchemaObject((JsonObject)element);
                queue2.add(schemaObject);
                object.setDefault(schemaObject);
            } else if (element instanceof JsonStringLiteral) {
                object.setDefault(StringUtil.unquoteString((String)((JsonStringLiteral)element).getValue()));
            } else if (element instanceof JsonNumberLiteral) {
                object.setDefault(JsonSchemaReader.getNumber((JsonNumberLiteral)element));
            } else if (element instanceof JsonBooleanLiteral) {
                object.setDefault(((JsonBooleanLiteral)element).getValue());
            }
        };
    }

    static {
        JsonSchemaReader.fillMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaReader";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaReader";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumber";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "notEmptyString";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "readInnerObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFromFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkIfValidJsonSchema";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readSchemaId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readId";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readSingleDefinition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createContainer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNumber";
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readInnerObject";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createContainer$29";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface MyReader {
        public void read(@NotNull JsonElement var1, @NotNull JsonSchemaObject var2, @NotNull Collection<JsonSchemaObject> var3);
    }
}

