/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp._RegExLexer;
import org.jetbrains.annotations.NotNull;

public class RegExpLexer
extends LookAheadLexer {
    public RegExpLexer(EnumSet<RegExpCapability> capabilities) {
        super((Lexer)new FlexRegExpLexer(capabilities));
    }

    protected void lookAhead(@NotNull Lexer baseLexer) {
        IElementType tokenType;
        if (baseLexer == null) {
            RegExpLexer.$$$reportNull$$$0(0);
        }
        if (!RegExpTT.CHARACTERS.contains(tokenType = baseLexer.getTokenType()) && tokenType != RegExpTT.RBRACE) {
            this.advanceLexer(baseLexer);
            if (baseLexer.getTokenType() == RegExpTT.MINUS) {
                this.advanceAs(baseLexer, RegExpTT.CHARACTER);
            }
        } else {
            super.lookAhead(baseLexer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "org/intellij/lang/regexp/RegExpLexer", "lookAhead"));
    }

    static class FlexRegExpLexer
    extends FlexAdapter {
        private static final int COMMENT_MODE = 16384;
        private static final int NESTED_STATES = 32768;
        private static final int CAPTURING_GROUPS = 65536;
        private final EnumSet<RegExpCapability> myCapabilities;

        public FlexRegExpLexer(EnumSet<RegExpCapability> capabilities) {
            super((FlexLexer)new _RegExLexer(capabilities));
            this.myCapabilities = capabilities;
        }

        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            if (buffer == null) {
                FlexRegExpLexer.$$$reportNull$$$0(0);
            }
            this.getFlex().commentMode = (initialState & 0x4000) != 0 || this.myCapabilities.contains((Object)RegExpCapability.COMMENT_MODE);
            super.start(buffer, startOffset, endOffset, initialState & 0xFFFFBFFF);
        }

        public _RegExLexer getFlex() {
            return (_RegExLexer)super.getFlex();
        }

        public int getState() {
            _RegExLexer flex = this.getFlex();
            int state = super.getState();
            if (flex.commentMode) {
                state |= 0x4000;
            }
            if (!flex.states.isEmpty()) {
                state |= 0x8000;
            }
            if (flex.capturingGroupCount != 0) {
                state |= 0x10000;
            }
            return state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/intellij/lang/regexp/RegExpLexer$FlexRegExpLexer", "start"));
        }
    }
}

