/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerMonitorView;
import com.android.tools.profilers.ProfilerScrollbar;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.ViewBinder;
import com.android.tools.profilers.cpu.CpuMonitor;
import com.android.tools.profilers.cpu.CpuMonitorTooltipView;
import com.android.tools.profilers.cpu.CpuMonitorView;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.event.EventMonitorTooltipView;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.memory.MemoryMonitor;
import com.android.tools.profilers.memory.MemoryMonitorTooltipView;
import com.android.tools.profilers.memory.MemoryMonitorView;
import com.android.tools.profilers.network.NetworkMonitor;
import com.android.tools.profilers.network.NetworkMonitorTooltipView;
import com.android.tools.profilers.network.NetworkMonitorView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioMonitorStageView
extends StageView<StudioMonitorStage> {
    @Nullable
    private ProfilerTooltipView myMonitorTooltipView;
    @NotNull
    private final ViewBinder<StudioMonitorStageView, ProfilerMonitor, ProfilerTooltipView> myTooltipBinder;
    @NotNull
    private final JPanel myTooltip;
    @NotNull
    private final List<ProfilerMonitorView> myViews;

    public StudioMonitorStageView(@NotNull StudioProfilersView profilersView, final @NotNull StudioMonitorStage stage) {
        if (profilersView == null) {
            StudioMonitorStageView.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            StudioMonitorStageView.$$$reportNull$$$0(1);
        }
        super(profilersView, stage);
        ViewBinder binder = new ViewBinder();
        binder.bind(NetworkMonitor.class, NetworkMonitorView::new);
        binder.bind(CpuMonitor.class, CpuMonitorView::new);
        binder.bind(MemoryMonitor.class, MemoryMonitorView::new);
        binder.bind(EventMonitor.class, EventMonitorView::new);
        ProfilerScrollbar sb = new ProfilerScrollbar(this.getTimeline(), this.getComponent());
        this.getComponent().add((Component)((Object)sb), "South");
        JPanel topPanel = new JPanel((LayoutManager)new TabularLayout("*", "*,Fit"));
        topPanel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        TabularLayout layout = new TabularLayout("*");
        JPanel monitors = new JPanel((LayoutManager)layout);
        ProfilerTimeline timeline = stage.getStudioProfilers().getTimeline();
        this.myTooltip = new JPanel(new BorderLayout());
        this.myTooltip.setMinimumSize(new Dimension(200, 10));
        RangeTooltipComponent tooltip = new RangeTooltipComponent(timeline.getTooltipRange(), timeline.getViewRange(), timeline.getDataRange(), (Component)this.myTooltip);
        timeline.getDataRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> timeline.getTooltipRange().changed((Enum)Range.Aspect.RANGE));
        this.myTooltipBinder = new ViewBinder();
        this.myTooltipBinder.bind(NetworkMonitor.class, NetworkMonitorTooltipView::new);
        this.myTooltipBinder.bind(CpuMonitor.class, CpuMonitorTooltipView::new);
        this.myTooltipBinder.bind(MemoryMonitor.class, MemoryMonitorTooltipView::new);
        this.myTooltipBinder.bind(EventMonitor.class, EventMonitorTooltipView::new);
        stage.getAspect().addDependency((AspectObserver)this).onChange((Enum)StudioMonitorStage.Aspect.TOOLTIP, this::tooltipChanged);
        this.myViews = new ArrayList<ProfilerMonitorView>(stage.getMonitors().size());
        int rowIndex = 0;
        for (final ProfilerMonitor monitor : stage.getMonitors()) {
            ProfilerMonitorView view = (ProfilerMonitorView)((Object)binder.build(profilersView, monitor));
            JComponent component = view.getComponent();
            tooltip.registerListenersOn((Component)component);
            component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (monitor.isEnabled()) {
                        stage.setTooltip(monitor);
                    } else {
                        stage.setTooltip(null);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    stage.setTooltip(null);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    StudioMonitorStageView.this.expandMonitor(monitor);
                }
            });
            component.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    int keyCode = KeyEvent.getExtendedKeyCodeForChar(e.getKeyChar());
                    if ((keyCode == 10 || keyCode == 32) && monitor.isFocused()) {
                        StudioMonitorStageView.this.expandMonitor(monitor);
                    }
                }
            });
            int weight = (int)(view.getVerticalWeight() * 100.0f);
            layout.setRowSizing(rowIndex, weight > 0 ? weight + "*" : "Fit");
            monitors.add((Component)component, new TabularLayout.Constraint(rowIndex, 0));
            ++rowIndex;
            this.myViews.add(view);
        }
        StudioProfilers profilers = stage.getStudioProfilers();
        JComponent timeAxis = this.buildTimeAxis(profilers);
        topPanel.add((Component)tooltip, new TabularLayout.Constraint(0, 0));
        topPanel.add((Component)monitors, new TabularLayout.Constraint(0, 0));
        topPanel.add((Component)timeAxis, new TabularLayout.Constraint(1, 0));
        this.getComponent().add((Component)topPanel, "Center");
    }

    private void tooltipChanged() {
        if (this.myMonitorTooltipView != null) {
            this.myMonitorTooltipView.dispose();
            this.myMonitorTooltipView = null;
        }
        this.myTooltip.removeAll();
        ProfilerMonitor tooltip = ((StudioMonitorStage)((Object)this.getStage())).getTooltip();
        if (tooltip != null) {
            this.myMonitorTooltipView = this.myTooltipBinder.build(this, tooltip);
            Component component = this.myMonitorTooltipView.createComponent();
            this.myTooltip.add(component, "Center");
        }
        this.myTooltip.repaint();
    }

    private void expandMonitor(ProfilerMonitor monitor) {
        ((StudioMonitorStage)((Object)this.getStage())).getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectMonitor();
        monitor.expand();
    }

    @Override
    public JComponent getToolbar() {
        return new JPanel();
    }

    @Override
    public boolean needsProcessSelection() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "stage";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/StudioMonitorStageView";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

