/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuUsage;
import org.jetbrains.annotations.NotNull;

public class CpuMonitor
extends ProfilerMonitor {
    private static final SingleUnitAxisFormatter CPU_USAGE_FORMATTER = new SingleUnitAxisFormatter(1, 2, 10, "%");
    @NotNull
    private final CpuUsage myThisProcessCpuUsage;
    @NotNull
    private final AxisComponentModel myCpuUsageAxis;
    @NotNull
    private final Legends myLegends;
    @NotNull
    private final Legends myTooltipLegends;

    public CpuMonitor(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            CpuMonitor.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myThisProcessCpuUsage = new CpuUsage(profilers);
        this.myCpuUsageAxis = new AxisComponentModel(this.myThisProcessCpuUsage.getCpuRange(), (BaseAxisFormatter)CPU_USAGE_FORMATTER);
        this.myCpuUsageAxis.setClampToMajorTicks(true);
        this.myLegends = new Legends(this.myThisProcessCpuUsage, profilers.getTimeline().getDataRange(), 100);
        this.myTooltipLegends = new Legends(this.myThisProcessCpuUsage, profilers.getTimeline().getTooltipRange(), 0);
    }

    @Override
    public String getName() {
        return "CPU";
    }

    @Override
    public void exit() {
        this.myProfilers.getUpdater().unregister((Updatable)this.myThisProcessCpuUsage);
        this.myProfilers.getUpdater().unregister((Updatable)this.myCpuUsageAxis);
        this.myProfilers.getUpdater().unregister((Updatable)this.myLegends);
        this.myProfilers.getUpdater().unregister((Updatable)this.myTooltipLegends);
    }

    @Override
    public void enter() {
        this.myProfilers.getUpdater().register((Updatable)this.myThisProcessCpuUsage);
        this.myProfilers.getUpdater().register((Updatable)this.myCpuUsageAxis);
        this.myProfilers.getUpdater().register((Updatable)this.myLegends);
        this.myProfilers.getUpdater().register((Updatable)this.myTooltipLegends);
    }

    @Override
    public void expand() {
        this.myProfilers.setStage(new CpuProfilerStage(this.myProfilers));
    }

    @NotNull
    public AxisComponentModel getCpuUsageAxis() {
        AxisComponentModel axisComponentModel = this.myCpuUsageAxis;
        if (axisComponentModel == null) {
            CpuMonitor.$$$reportNull$$$0(1);
        }
        return axisComponentModel;
    }

    @NotNull
    public Legends getLegends() {
        Legends legends = this.myLegends;
        if (legends == null) {
            CpuMonitor.$$$reportNull$$$0(2);
        }
        return legends;
    }

    @NotNull
    public CpuUsage getThisProcessCpuUsage() {
        CpuUsage cpuUsage = this.myThisProcessCpuUsage;
        if (cpuUsage == null) {
            CpuMonitor.$$$reportNull$$$0(3);
        }
        return cpuUsage;
    }

    public Legends getTooltipLegends() {
        return this.myTooltipLegends;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuMonitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuMonitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuUsageAxis";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegends";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThisProcessCpuUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Legends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;

        public Legends(@NotNull CpuUsage usage, @NotNull Range range, int updateFrequencyMs) {
            if (usage == null) {
                Legends.$$$reportNull$$$0(0);
            }
            if (range == null) {
                Legends.$$$reportNull$$$0(1);
            }
            super(updateFrequencyMs);
            this.myCpuLegend = new SeriesLegend(usage.getCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, range);
            this.add((Legend)this.myCpuLegend);
        }

        @NotNull
        public SeriesLegend getCpuLegend() {
            SeriesLegend seriesLegend = this.myCpuLegend;
            if (seriesLegend == null) {
                Legends.$$$reportNull$$$0(2);
            }
            return seriesLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuMonitor$Legends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuMonitor$Legends";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCpuLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

