/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SelectionModel;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.MemoryAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.memory.AllocationInfosDataSeries;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureObjectLoader;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.GcDurationData;
import com.android.tools.profilers.memory.GcStatsDataSeries;
import com.android.tools.profilers.memory.HeapDumpSampleDataSeries;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerConfiguration;
import com.android.tools.profilers.memory.MemoryProfilerSelection;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.android.tools.profilers.stacktrace.StackTraceModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryProfilerStage
extends Stage
implements CodeNavigator.Listener {
    private static final BaseAxisFormatter MEMORY_AXIS_FORMATTER = new MemoryAxisFormatter(1, 5, 5);
    private static final BaseAxisFormatter OBJECT_COUNT_AXIS_FORMATTER = new SingleUnitAxisFormatter(1, 5, 5, "");
    private static final long INVALID_START_TIME = -1L;
    private final DetailedMemoryUsage myDetailedMemoryUsage;
    private final AxisComponentModel myMemoryAxis;
    private final AxisComponentModel myObjectsAxis;
    private final MemoryStageLegends myLegends;
    private final MemoryStageLegends myTooltipLegends;
    private final int myProcessId;
    @Nullable
    private final Common.Session mySessionData;
    private DurationDataModel<GcDurationData> myGcStats;
    @NotNull
    private AspectModel<MemoryProfilerAspect> myAspect;
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    private final DurationDataModel<CaptureDurationData<CaptureObject>> myHeapDumpDurations;
    private final DurationDataModel<CaptureDurationData<CaptureObject>> myAllocationDurations;
    private final CaptureObjectLoader myLoader;
    private final MemoryProfilerSelection mySelection;
    private final MemoryProfilerConfiguration myConfiguration;
    private final EventMonitor myEventMonitor;
    private final SelectionModel mySelectionModel;
    private final StackTraceModel myStackTraceModel;
    private boolean myTrackingAllocations;
    private boolean myUpdateCaptureOnSelection;
    private final CaptureElapsedTimeUpdatable myCaptureElapsedTimeUpdatable;
    private long myPendingCaptureStartTime;
    private long myPendingLegacyAllocationStartTimeNs;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryProfilerStage.class);
    }

    public MemoryProfilerStage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            MemoryProfilerStage.$$$reportNull$$$0(0);
        }
        this(profilers, new CaptureObjectLoader());
    }

    @VisibleForTesting
    public MemoryProfilerStage(final @NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader) {
        if (profilers == null) {
            MemoryProfilerStage.$$$reportNull$$$0(1);
        }
        if (loader == null) {
            MemoryProfilerStage.$$$reportNull$$$0(2);
        }
        super(profilers);
        this.myAspect = new AspectModel();
        this.myUpdateCaptureOnSelection = true;
        this.myCaptureElapsedTimeUpdatable = new CaptureElapsedTimeUpdatable();
        this.myPendingCaptureStartTime = -1L;
        this.myPendingLegacyAllocationStartTimeNs = -1L;
        this.myProcessId = profilers.getProcessId();
        this.mySessionData = profilers.getSession();
        this.myClient = profilers.getClient().getMemoryClient();
        HeapDumpSampleDataSeries heapDumpSeries = new HeapDumpSampleDataSeries(profilers.getClient().getMemoryClient(), this.mySessionData, this.myProcessId, profilers.getRelativeTimeConverter(), this.getStudioProfilers().getIdeServices().getFeatureTracker());
        AllocationInfosDataSeries allocationSeries = new AllocationInfosDataSeries(profilers.getClient().getMemoryClient(), this.mySessionData, this.myProcessId, profilers.getRelativeTimeConverter(), this.getStudioProfilers().getIdeServices().getFeatureTracker(), this);
        this.myLoader = loader;
        Range viewRange = profilers.getTimeline().getViewRange();
        this.myHeapDumpDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)heapDumpSeries));
        this.myAllocationDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)allocationSeries));
        this.mySelection = new MemoryProfilerSelection(this);
        this.myConfiguration = new MemoryProfilerConfiguration(this);
        this.myDetailedMemoryUsage = new DetailedMemoryUsage(profilers);
        this.myMemoryAxis = new AxisComponentModel(this.myDetailedMemoryUsage.getMemoryRange(), MEMORY_AXIS_FORMATTER);
        this.myMemoryAxis.setClampToMajorTicks(true);
        this.myObjectsAxis = new AxisComponentModel(this.myDetailedMemoryUsage.getObjectsRange(), OBJECT_COUNT_AXIS_FORMATTER);
        this.myObjectsAxis.setClampToMajorTicks(true);
        this.myLegends = new MemoryStageLegends(profilers, this.myDetailedMemoryUsage, profilers.getTimeline().getDataRange(), false);
        this.myTooltipLegends = new MemoryStageLegends(profilers, this.myDetailedMemoryUsage, profilers.getTimeline().getTooltipRange(), true);
        this.myGcStats = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)new GcStatsDataSeries(this.myClient, this.myProcessId, this.mySessionData)));
        this.myGcStats.setAttachedSeries(this.myDetailedMemoryUsage.getObjectsSeries(), Interpolatable.SegmentInterpolator);
        this.myEventMonitor = new EventMonitor(profilers);
        this.mySelectionModel = new SelectionModel(profilers.getTimeline().getSelectionRange(), profilers.getTimeline().getViewRange());
        this.mySelectionModel.addConstraint(this.myAllocationDurations);
        this.mySelectionModel.addConstraint(this.myHeapDumpDurations);
        this.mySelectionModel.addListener(new SelectionListener(){

            public void selectionCreated() {
                MemoryProfilerStage.this.selectCaptureFromSelectionRange();
                profilers.getIdeServices().getFeatureTracker().trackSelectRange();
            }

            public void selectionCleared() {
                MemoryProfilerStage.this.selectCaptureFromSelectionRange();
            }
        });
        this.myStackTraceModel = new StackTraceModel(profilers.getIdeServices().getCodeNavigator());
    }

    public DetailedMemoryUsage getDetailedMemoryUsage() {
        return this.myDetailedMemoryUsage;
    }

    @Override
    public void enter() {
        this.myLoader.start();
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myDetailedMemoryUsage);
        this.getStudioProfilers().getUpdater().register(this.myHeapDumpDurations);
        this.getStudioProfilers().getUpdater().register(this.myAllocationDurations);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myMemoryAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myObjectsAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myLegends);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myTooltipLegends);
        this.getStudioProfilers().getUpdater().register(this.myGcStats);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCaptureElapsedTimeUpdatable);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
        this.myTrackingAllocations = false;
    }

    @Override
    public void exit() {
        this.enableSelectLatestCapture(false, null);
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myDetailedMemoryUsage);
        this.getStudioProfilers().getUpdater().unregister(this.myHeapDumpDurations);
        this.getStudioProfilers().getUpdater().unregister(this.myAllocationDurations);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myMemoryAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myObjectsAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myLegends);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myTooltipLegends);
        this.getStudioProfilers().getUpdater().unregister(this.myGcStats);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCaptureElapsedTimeUpdatable);
        this.selectCaptureDuration(null, null);
        this.myLoader.stop();
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
        this.mySelectionModel.clearListeners();
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.mySelectionModel;
        if (selectionModel == null) {
            MemoryProfilerStage.$$$reportNull$$$0(3);
        }
        return selectionModel;
    }

    @NotNull
    public StackTraceModel getStackTraceModel() {
        StackTraceModel stackTraceModel = this.myStackTraceModel;
        if (stackTraceModel == null) {
            MemoryProfilerStage.$$$reportNull$$$0(4);
        }
        return stackTraceModel;
    }

    private void selectCaptureFromSelectionRange() {
        if (!this.myUpdateCaptureOnSelection) {
            return;
        }
        this.myUpdateCaptureOnSelection = false;
        Range selectionRange = this.getStudioProfilers().getTimeline().getSelectionRange();
        CaptureDurationData durationData = null;
        double overlap = 0.0;
        ArrayList series = new ArrayList(this.getAllocationInfosDurations().getSeries().getDataSeries().getDataForXRange(selectionRange));
        series.addAll(this.getHeapDumpSampleDurations().getSeries().getDataSeries().getDataForXRange(selectionRange));
        for (SeriesData data : series) {
            long dataMax;
            Range c;
            Range intersection;
            long duration = ((CaptureDurationData)((Object)data.value)).getDuration();
            if (duration == Long.MAX_VALUE && !((CaptureDurationData)((Object)data.value)).getSelectableWhenMaxDuration() || (intersection = (c = new Range((double)data.x, (double)(dataMax = duration == Long.MAX_VALUE ? duration : data.x + duration))).getIntersection(selectionRange)).isEmpty() || !(intersection.getLength() >= overlap)) continue;
            durationData = (CaptureDurationData)((Object)data.value);
            overlap = intersection.getLength();
        }
        this.selectCaptureDuration(durationData, SwingUtilities::invokeLater);
        this.myUpdateCaptureOnSelection = true;
    }

    public void enableSelectLatestCapture(boolean enable, @Nullable Executor loadJoiner) {
        ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
        if (enable) {
            timeline.getDataRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> this.queryAndSelectCaptureObject(loadJoiner == null ? MoreExecutors.directExecutor() : loadJoiner));
        } else {
            timeline.getDataRange().removeDependencies((AspectObserver)this);
        }
    }

    private void queryAndSelectCaptureObject(@NotNull Executor loadJoiner) {
        if (loadJoiner == null) {
            MemoryProfilerStage.$$$reportNull$$$0(5);
        }
        Range dataRange = this.getStudioProfilers().getTimeline().getDataRange();
        if (this.mySelection.getCaptureObject() == null && this.myPendingCaptureStartTime != -1L) {
            ArrayList series = new ArrayList(this.getAllocationInfosDurations().getSeries().getDataSeries().getDataForXRange(dataRange));
            series.addAll(this.getHeapDumpSampleDurations().getSeries().getDataSeries().getDataForXRange(dataRange));
            long pendingCaptureStartTimeUs = TimeUnit.NANOSECONDS.toMicros(this.myPendingCaptureStartTime);
            SeriesData captureToSelect = null;
            for (int i = series.size() - 1; i >= 0; --i) {
                if (((SeriesData)series.get((int)i)).x != pendingCaptureStartTimeUs) continue;
                captureToSelect = (SeriesData)series.get(i);
                break;
            }
            if (captureToSelect != null && (((CaptureDurationData)((Object)captureToSelect.value)).getDuration() != Long.MAX_VALUE || ((CaptureDurationData)((Object)captureToSelect.value)).getSelectableWhenMaxDuration())) {
                this.selectCaptureDuration((CaptureDurationData)((Object)captureToSelect.value), loadJoiner);
            }
        }
    }

    @NotNull
    public AspectModel<MemoryProfilerAspect> getAspect() {
        AspectModel<MemoryProfilerAspect> aspectModel = this.myAspect;
        if (aspectModel == null) {
            MemoryProfilerStage.$$$reportNull$$$0(6);
        }
        return aspectModel;
    }

    public void requestHeapDump() {
        MemoryProfiler.TriggerHeapDumpResponse response = this.myClient.triggerHeapDump(MemoryProfiler.TriggerHeapDumpRequest.newBuilder().setSession(this.mySessionData).setProcessId(this.myProcessId).build());
        switch (response.getStatus()) {
            case SUCCESS: {
                this.myPendingCaptureStartTime = response.getInfo().getStartTime();
                break;
            }
            case IN_PROGRESS: {
                MemoryProfilerStage.getLogger().debug(String.format("A heap dump for %d is already in progress.", this.myProcessId));
                break;
            }
        }
        this.getStudioProfilers().getTimeline().setStreaming(true);
    }

    public void forceGarbageCollection() {
        this.myClient.forceGarbageCollection(MemoryProfiler.ForceGarbageCollectionRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySessionData).build());
    }

    public DurationDataModel<CaptureDurationData<CaptureObject>> getHeapDumpSampleDurations() {
        return this.myHeapDumpDurations;
    }

    public void trackAllocations(boolean enabled) {
        Profiler.TimeResponse timeResponse = this.getStudioProfilers().getClient().getProfilerClient().getCurrentTime(Profiler.TimeRequest.newBuilder().setSession(this.mySessionData).build());
        long timeNs = timeResponse.getTimestampNs();
        try {
            MemoryProfiler.TrackAllocationsResponse response = this.myClient.trackAllocations(MemoryProfiler.TrackAllocationsRequest.newBuilder().setRequestTime(timeNs).setSession(this.mySessionData).setProcessId(this.myProcessId).setEnabled(enabled).build());
            MemoryProfiler.AllocationsInfo info = response.getInfo();
            switch (response.getStatus()) {
                case SUCCESS: {
                    this.myTrackingAllocations = enabled;
                    this.myPendingCaptureStartTime = info.getStartTime();
                    this.myPendingLegacyAllocationStartTimeNs = enabled ? info.getStartTime() : -1L;
                    break;
                }
                case IN_PROGRESS: {
                    this.myTrackingAllocations = true;
                    break;
                }
                case NOT_ENABLED: {
                    this.myTrackingAllocations = false;
                    break;
                }
            }
            this.myAspect.changed((Enum)MemoryProfilerAspect.TRACKING_ENABLED);
        }
        catch (StatusRuntimeException e) {
            MemoryProfilerStage.getLogger().debug((Throwable)e);
        }
        if (this.myTrackingAllocations) {
            this.getStudioProfilers().getTimeline().setStreaming(true);
        }
    }

    public boolean isTrackingAllocations() {
        return this.myTrackingAllocations;
    }

    public long getAllocationTrackingElapsedTimeNs() {
        if (this.myTrackingAllocations) {
            Profiler.TimeResponse timeResponse = this.getStudioProfilers().getClient().getProfilerClient().getCurrentTime(Profiler.TimeRequest.newBuilder().setSession(this.mySessionData).build());
            return timeResponse.getTimestampNs() - this.myPendingLegacyAllocationStartTimeNs;
        }
        return -1L;
    }

    public boolean useLiveAllocationTracking() {
        return this.getStudioProfilers().getIdeServices().getFeatureConfig().isLiveAllocationsEnabled() && this.getStudioProfilers().getDevice().getFeatureLevel() >= 26;
    }

    @NotNull
    public DurationDataModel<CaptureDurationData<CaptureObject>> getAllocationInfosDurations() {
        DurationDataModel<CaptureDurationData<CaptureObject>> durationDataModel = this.myAllocationDurations;
        if (durationDataModel == null) {
            MemoryProfilerStage.$$$reportNull$$$0(7);
        }
        return durationDataModel;
    }

    public void selectFieldObjectPath(@NotNull List<FieldObject> fieldObjectPath) {
        if (fieldObjectPath == null) {
            MemoryProfilerStage.$$$reportNull$$$0(8);
        }
        this.mySelection.selectFieldObjectPath(fieldObjectPath);
    }

    @NotNull
    public List<FieldObject> getSelectedFieldObjectPath() {
        List<FieldObject> list = this.mySelection.getFieldObjectPath();
        if (list == null) {
            MemoryProfilerStage.$$$reportNull$$$0(9);
        }
        return list;
    }

    public void selectInstanceObject(@Nullable InstanceObject instanceObject) {
        this.mySelection.selectInstanceObject(instanceObject);
    }

    @Nullable
    public InstanceObject getSelectedInstanceObject() {
        return this.mySelection.getInstanceObject();
    }

    public void selectClassSet(@Nullable ClassSet classSet) {
        this.mySelection.selectClassSet(classSet);
    }

    @Nullable
    public ClassSet getSelectedClassSet() {
        return this.mySelection.getClassSet();
    }

    public void refreshSelectedHeap() {
        this.myAspect.changed((Enum)MemoryProfilerAspect.CURRENT_HEAP_CONTENTS);
    }

    public void selectHeapSet(@Nullable HeapSet heapSet) {
        this.mySelection.selectHeapSet(heapSet);
    }

    @Nullable
    public HeapSet getSelectedHeapSet() {
        return this.mySelection.getHeapSet();
    }

    @VisibleForTesting
    void selectCaptureDuration(@Nullable CaptureDurationData<? extends CaptureObject> durationData, @Nullable Executor joiner) {
        this.myPendingCaptureStartTime = -1L;
        if (!this.mySelection.selectCaptureEntry(durationData == null ? null : durationData.getCaptureEntry())) {
            return;
        }
        this.myUpdateCaptureOnSelection = false;
        ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
        CaptureObject captureObject = this.mySelection.getCaptureObject();
        if (captureObject == null) {
            this.mySelection.selectCaptureEntry(null);
            timeline.getSelectionRange().clear();
            this.myAspect.changed((Enum)MemoryProfilerAspect.CURRENT_LOADED_CAPTURE);
            this.setProfilerMode(ProfilerMode.NORMAL);
            return;
        }
        if (durationData.getDuration() != Long.MAX_VALUE) {
            timeline.getSelectionRange().clear();
            long startTimeUs = TimeUnit.NANOSECONDS.toMicros(captureObject.getStartTimeNs());
            long endTimeUs = TimeUnit.NANOSECONDS.toMicros(captureObject.getEndTimeNs());
            timeline.getSelectionRange().set((double)startTimeUs, (double)endTimeUs);
        }
        this.myUpdateCaptureOnSelection = true;
        ListenableFuture<CaptureObject> future = this.myLoader.loadCapture(captureObject, timeline.getSelectionRange(), joiner);
        future.addListener(() -> {
            try {
                CaptureObject loadedCaptureObject = (CaptureObject)future.get();
                if (this.mySelection.finishSelectingCaptureObject(loadedCaptureObject)) {
                    Collection<HeapSet> heaps = loadedCaptureObject.getHeapSets();
                    if (heaps.isEmpty()) {
                        return;
                    }
                    for (HeapSet heap : heaps) {
                        if (!heap.getName().equals("app")) continue;
                        this.selectHeapSet(heap);
                        return;
                    }
                    for (HeapSet heap : heaps) {
                        if (!heap.getName().equals("default")) continue;
                        this.selectHeapSet(heap);
                        return;
                    }
                    HeapSet heap = new ArrayList<HeapSet>(heaps).get(0);
                    this.selectHeapSet(heap);
                } else {
                    this.selectCaptureDuration(null, null);
                }
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                this.selectCaptureDuration(null, null);
            }
            catch (ExecutionException exception) {
                this.selectCaptureDuration(null, null);
                MemoryProfilerStage.getLogger().error((Throwable)exception);
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }, joiner == null ? MoreExecutors.directExecutor() : joiner);
        this.setProfilerMode(ProfilerMode.EXPANDED);
    }

    @Nullable
    public CaptureObject getSelectedCapture() {
        return this.mySelection.getCaptureObject();
    }

    @NotNull
    public MemoryProfilerConfiguration getConfiguration() {
        MemoryProfilerConfiguration memoryProfilerConfiguration = this.myConfiguration;
        if (memoryProfilerConfiguration == null) {
            MemoryProfilerStage.$$$reportNull$$$0(10);
        }
        return memoryProfilerConfiguration;
    }

    public AxisComponentModel getMemoryAxis() {
        return this.myMemoryAxis;
    }

    public AxisComponentModel getObjectsAxis() {
        return this.myObjectsAxis;
    }

    public MemoryStageLegends getLegends() {
        return this.myLegends;
    }

    public MemoryStageLegends getTooltipLegends() {
        return this.myTooltipLegends;
    }

    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    public DurationDataModel<GcDurationData> getGcStats() {
        return this.myGcStats;
    }

    public String getName() {
        return "MEMORY";
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        if (location == null) {
            MemoryProfilerStage.$$$reportNull$$$0(11);
        }
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryProfilerStage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadJoiner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldObjectPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryProfilerStage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackTraceModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationInfosDurations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFieldObjectPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "queryAndSelectCaptureObject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectFieldObjectPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onNavigated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CaptureElapsedTimeUpdatable
    implements Updatable {
        private CaptureElapsedTimeUpdatable() {
        }

        public void update(long elapsedNs) {
            if (MemoryProfilerStage.this.myTrackingAllocations) {
                MemoryProfilerStage.this.myAspect.changed((Enum)MemoryProfilerAspect.CURRENT_CAPTURE_ELAPSED_TIME);
            }
        }
    }

    public static class MemoryStageLegends
    extends LegendComponentModel {
        @NotNull
        private final StudioProfilers myProfilers;
        @NotNull
        private final SeriesLegend myJavaLegend;
        @NotNull
        private final SeriesLegend myNativeLegend;
        @NotNull
        private final SeriesLegend myGraphicsLegend;
        @NotNull
        private final SeriesLegend myStackLegend;
        @NotNull
        private final SeriesLegend myCodeLegend;
        @NotNull
        private final SeriesLegend myOtherLegend;
        @NotNull
        private final SeriesLegend myTotalLegend;
        @NotNull
        private final SeriesLegend myObjectsLegend;

        public MemoryStageLegends(@NotNull StudioProfilers profilers, @NotNull DetailedMemoryUsage usage, @NotNull Range range, boolean isTooltip) {
            if (profilers == null) {
                MemoryStageLegends.$$$reportNull$$$0(0);
            }
            if (usage == null) {
                MemoryStageLegends.$$$reportNull$$$0(1);
            }
            if (range == null) {
                MemoryStageLegends.$$$reportNull$$$0(2);
            }
            super(100);
            this.myJavaLegend = new SeriesLegend(usage.getJavaSeries(), MEMORY_AXIS_FORMATTER, range);
            this.myNativeLegend = new SeriesLegend(usage.getNativeSeries(), MEMORY_AXIS_FORMATTER, range);
            this.myGraphicsLegend = new SeriesLegend(usage.getGraphicsSeries(), MEMORY_AXIS_FORMATTER, range);
            this.myStackLegend = new SeriesLegend(usage.getStackSeries(), MEMORY_AXIS_FORMATTER, range);
            this.myCodeLegend = new SeriesLegend(usage.getCodeSeries(), MEMORY_AXIS_FORMATTER, range);
            this.myOtherLegend = new SeriesLegend(usage.getOtherSeries(), MEMORY_AXIS_FORMATTER, range);
            this.myTotalLegend = new SeriesLegend(usage.getTotalMemorySeries(), MEMORY_AXIS_FORMATTER, range);
            this.myObjectsLegend = new SeriesLegend(usage.getObjectsSeries(), OBJECT_COUNT_AXIS_FORMATTER, range, Interpolatable.RoundedSegmentInterpolator);
            List<SeriesLegend> legends = isTooltip ? Arrays.asList(this.myTotalLegend, this.myOtherLegend, this.myCodeLegend, this.myStackLegend, this.myGraphicsLegend, this.myNativeLegend, this.myJavaLegend) : Arrays.asList(this.myTotalLegend, this.myJavaLegend, this.myNativeLegend, this.myGraphicsLegend, this.myStackLegend, this.myCodeLegend, this.myOtherLegend);
            legends.forEach(arg_0 -> ((MemoryStageLegends)this).add(arg_0));
            this.myProfilers = profilers;
            this.myProfilers.addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.AGENT, this::agentStatusChanged);
            this.agentStatusChanged();
        }

        @NotNull
        public SeriesLegend getJavaLegend() {
            SeriesLegend seriesLegend = this.myJavaLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(3);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getNativeLegend() {
            SeriesLegend seriesLegend = this.myNativeLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(4);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getGraphicsLegend() {
            SeriesLegend seriesLegend = this.myGraphicsLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(5);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getStackLegend() {
            SeriesLegend seriesLegend = this.myStackLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(6);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getCodeLegend() {
            SeriesLegend seriesLegend = this.myCodeLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(7);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getOtherLegend() {
            SeriesLegend seriesLegend = this.myOtherLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(8);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getTotalLegend() {
            SeriesLegend seriesLegend = this.myTotalLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(9);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getObjectsLegend() {
            SeriesLegend seriesLegend = this.myObjectsLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(10);
            }
            return seriesLegend;
        }

        private void agentStatusChanged() {
            if (this.myProfilers.isAgentAttached()) {
                this.add((Legend)this.myObjectsLegend);
            } else {
                this.remove((Legend)this.myObjectsLegend);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/memory/MemoryProfilerStage$MemoryStageLegends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/memory/MemoryProfilerStage$MemoryStageLegends";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJavaLegend";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNativeLegend";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGraphicsLegend";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStackLegend";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCodeLegend";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOtherLegend";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTotalLegend";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjectsLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

