/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.preloading.ClassPreloadingUtils;
import org.jetbrains.kotlin.utils.KotlinPaths;

public class CompilerRunnerUtil {
    private static SoftReference<ClassLoader> ourClassLoaderRef = new SoftReference<Object>(null);

    @NotNull
    private static synchronized ClassLoader getOrCreateClassLoader(@NotNull JpsCompilerEnvironment environment, @NotNull List<File> paths) throws IOException {
        ClassLoader classLoader = ourClassLoaderRef.get();
        if (classLoader == null) {
            classLoader = ClassPreloadingUtils.preloadClasses(paths, 4096, CompilerRunnerUtil.class.getClassLoader(), environment.getClassesToLoadByParent());
            ourClassLoaderRef = new SoftReference<ClassLoader>(classLoader);
        }
        return classLoader;
    }

    @Nullable
    public static File getLibPath(@NotNull KotlinPaths paths, @NotNull MessageCollector messageCollector) {
        File libs = paths.getLibPath();
        if (libs.exists() && !libs.isFile()) {
            return libs;
        }
        messageCollector.report(CompilerMessageSeverity.ERROR, "Broken compiler at '" + libs.getAbsolutePath() + "'. Make sure plugin is properly installed", null);
        return null;
    }

    @Nullable
    public static Object invokeExecMethod(@NotNull String compilerClassName, @NotNull String[] arguments, @NotNull JpsCompilerEnvironment environment, @NotNull PrintStream out) throws Exception {
        File toolsJar;
        File libPath = CompilerRunnerUtil.getLibPath(environment.getKotlinPaths(), environment.getMessageCollector());
        if (libPath == null) {
            return null;
        }
        ArrayList<File> paths = new ArrayList<File>();
        paths.add(new File(libPath, "kotlin-compiler.jar"));
        if (Arrays.asList(arguments).contains("-Xuse-javac") && (toolsJar = CompilerRunnerUtil.getJdkToolsJar()) != null) {
            paths.add(toolsJar);
        }
        ClassLoader classLoader = CompilerRunnerUtil.getOrCreateClassLoader(environment, paths);
        Class<?> kompiler = Class.forName(compilerClassName, true, classLoader);
        Method exec = kompiler.getMethod("execAndOutputXml", PrintStream.class, Class.forName("org.jetbrains.kotlin.config.Services", true, classLoader), String[].class);
        return exec.invoke(kompiler.newInstance(), out, environment.getServices(), arguments);
    }

    @Nullable
    static File getJdkToolsJar() throws IOException {
        String javaHomePath = System.getProperty("java.home");
        if (javaHomePath == null || javaHomePath.isEmpty()) {
            return null;
        }
        File javaHome = new File(javaHomePath);
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (toolsJar.exists()) {
            return toolsJar.getCanonicalFile();
        }
        if (javaHome.getName().equals("jre") && (toolsJar = new File(javaHome.getParent(), "lib/tools.jar")).exists()) {
            return toolsJar.getCanonicalFile();
        }
        return null;
    }
}

