/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.google.common.collect.HashMultiset;
import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.URLUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchesCollection;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgit4idea/GitStatisticsCollector;", "Lcom/intellij/internal/statistic/AbstractProjectsUsagesCollector;", "()V", "ID", "Lcom/intellij/internal/statistic/beans/GroupDescriptor;", "kotlin.jvm.PlatformType", "getGroupId", "getProjectUsages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getRemoteServerType", "", "remote", "Lgit4idea/repo/GitRemote;", "versionUsage", "version", "Lgit4idea/config/GitVersion;", "intellij.vcs.git"})
public final class GitStatisticsCollector
extends AbstractProjectsUsagesCollector {
    private final GroupDescriptor ID = GroupDescriptor.create((String)"Git");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        List<GitRepository> repositories = repositoryManager.getRepositories();
        HashSet<UsageDescriptor> usages = new HashSet<UsageDescriptor>();
        usages.add(new UsageDescriptor("config.repo.sync." + settings.getSyncSetting().name(), 1));
        usages.add(new UsageDescriptor("config.update.type." + settings.getUpdateType().name(), 1));
        usages.add(new UsageDescriptor("config.save.policy." + settings.updateChangesPolicy().name(), 1));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.ssh", (boolean)settings.isIdeaSsh()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.push.autoupdate", (boolean)settings.autoUpdateIfPushRejected()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.push.update.all.roots", (boolean)settings.shouldUpdateAllRootsIfPushRejected()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.cherry-pick.autocommit", (boolean)settings.isAutoCommitOnCherryPick()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.warn.about.crlf", (boolean)settings.warnAboutCrlf()));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"config.warn.about.detached", (boolean)settings.warnAboutDetachedHead()));
        GitVersion gitVersion = GitVcs.getInstance(project).getVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)gitVersion, (String)"GitVcs.getInstance(project).version");
        usages.add(this.versionUsage(gitVersion));
        for (GitRepository repository : repositories) {
            void $receiver$iv$iv;
            void $receiver$iv;
            GitBranchesCollection branches = repository.getBranches();
            usages.add(StatisticsUtilKt.getCountingUsage((String)"data.local.branches.count", (int)branches.getLocalBranches().size(), (List)CollectionsKt.listOf((Object[])new Integer[]{0, 1, 2, 5, 8, 15, 30, 50})));
            usages.add(StatisticsUtilKt.getCountingUsage((String)"data.remote.branches.count", (int)branches.getRemoteBranches().size(), (List)CollectionsKt.listOf((Object[])new Integer[]{0, 1, 2, 5, 8, 15, 30, 100})));
            usages.add(StatisticsUtilKt.getCountingUsage((String)"data.remotes.in.project", (int)repository.getRemotes().size(), (List)CollectionsKt.listOf((Object[])new Integer[]{0, 1, 2, 5})));
            Iterable iterable = repository.getRemotes();
            GitStatisticsCollector gitStatisticsCollector = this;
            void var12_12 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                String string;
                Object element$iv$iv = element$iv$iv$iv;
                GitRemote p1 = (GitRemote)element$iv$iv;
                if (gitStatisticsCollector.getRemoteServerType(p1) == null) continue;
                String it$iv$iv = string;
                destination$iv$iv.add(it$iv$iv);
            }
            HashMultiset servers = (HashMultiset)CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)((Collection)HashMultiset.create()));
            for (String serverName : servers) {
                usages.add(StatisticsUtilKt.getCountingUsage((String)("data.remote.servers." + serverName), (int)servers.count((Object)serverName), (List)CollectionsKt.listOf((Object[])new Integer[]{0, 1, 2, 3, 5})));
            }
        }
        return usages;
    }

    private final UsageDescriptor versionUsage(GitVersion version) {
        return new UsageDescriptor("version." + version.getSemanticPresentation());
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = this.ID;
        Intrinsics.checkExpressionValueIsNotNull((Object)groupDescriptor, (String)"ID");
        return groupDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private final String getRemoteServerType(GitRemote remote) {
        boolean bl;
        block18: {
            boolean bl2;
            String it;
            Iterable $receiver$iv;
            block17: {
                boolean bl3;
                block16: {
                    void $receiver$iv$iv;
                    $receiver$iv = remote.getUrls();
                    Iterator iterator = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void p1;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        String string2 = URLUtil.parseHostFromSshUrl((String)p1);
                        collection.add(string2);
                    }
                    List hosts = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                    if (hosts.contains("github.com")) {
                        return "github.com";
                    }
                    if (hosts.contains("gitlab.com")) {
                        return "gitlab.com";
                    }
                    if (hosts.contains("bitbucket.org")) {
                        return "bitbucket.org";
                    }
                    $receiver$iv = remote.getUrls();
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            it = (String)element$iv;
                            if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"github", (boolean)false, (int)2, null)) continue;
                            bl3 = true;
                            break block16;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    return "github.custom";
                }
                $receiver$iv = remote.getUrls();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        it = (String)element$iv;
                        if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"gitlab", (boolean)false, (int)2, null)) continue;
                        bl2 = true;
                        break block17;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return "gitlab.custom";
            }
            $receiver$iv = remote.getUrls();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    it = (String)element$iv;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"bitbucket", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block18;
                }
                bl = false;
            }
        }
        if (bl) {
            return "bitbucket.custom";
        }
        return null;
    }
}

