/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitSvnRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import git4idea.validators.GitNewBranchNameValidator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchUtil {
    private static final Logger LOG = Logger.getInstance(GitBranchUtil.class);
    private static final Function<GitBranch, String> BRANCH_TO_NAME = input -> {
        assert (input != null);
        return input.getName();
    };
    private static final String NO_BRANCH_NAME = "(no branch)";

    private GitBranchUtil() {
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfoForBranch(@NotNull GitRepository repository, @NotNull GitLocalBranch branch) {
        if (repository == null) {
            GitBranchUtil.$$$reportNull$$$0(0);
        }
        if (branch == null) {
            GitBranchUtil.$$$reportNull$$$0(1);
        }
        for (GitBranchTrackInfo trackInfo : repository.getBranchTrackInfos()) {
            if (!trackInfo.getLocalBranch().equals(branch)) continue;
            return trackInfo;
        }
        return null;
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfo(@NotNull GitRepository repository, @NotNull String localBranchName) {
        if (repository == null) {
            GitBranchUtil.$$$reportNull$$$0(2);
        }
        if (localBranchName == null) {
            GitBranchUtil.$$$reportNull$$$0(3);
        }
        return (GitBranchTrackInfo)ContainerUtil.find(repository.getBranchTrackInfos(), it -> {
            if (localBranchName == null) {
                GitBranchUtil.$$$reportNull$$$0(45);
            }
            return it.getLocalBranch().getName().equals(localBranchName);
        });
    }

    @NotNull
    static String getCurrentBranchOrRev(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(4);
        }
        if (repositories.size() > 1) {
            GitMultiRootBranchConfig multiRootBranchConfig = new GitMultiRootBranchConfig(repositories);
            String currentBranch = multiRootBranchConfig.getCurrentBranch();
            LOG.assertTrue(currentBranch != null, (Object)("Repositories have unexpectedly diverged. " + (Object)((Object)multiRootBranchConfig)));
            String string = currentBranch;
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        assert (!repositories.isEmpty()) : "No repositories passed to GitBranchOperationsProcessor.";
        GitRepository repository = repositories.iterator().next();
        String string = GitBranchUtil.getBranchNameOrRev(repository);
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static Collection<String> convertBranchesToNames(@NotNull Collection<? extends GitBranch> branches) {
        if (branches == null) {
            GitBranchUtil.$$$reportNull$$$0(7);
        }
        Collection collection = Collections2.transform(branches, BRANCH_TO_NAME);
        if (collection == null) {
            GitBranchUtil.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Deprecated
    @Nullable
    public static GitLocalBranch getCurrentBranch(@NotNull Project project, @NotNull VirtualFile root) {
        GitRepository repository;
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(9);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(10);
        }
        if ((repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root)) != null) {
            return repository.getCurrentBranch();
        }
        LOG.info("getCurrentBranch: Repository is null for root " + root);
        return GitBranchUtil.getCurrentBranchFromGit(project, root);
    }

    @Nullable
    private static GitLocalBranch getCurrentBranchFromGit(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(11);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(12);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REV_PARSE);
        handler.addParameters("--abbrev-ref", "HEAD");
        handler.setSilent(true);
        try {
            String name = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
            if (!name.equals("HEAD")) {
                return new GitLocalBranch(name);
            }
            return null;
        }
        catch (VcsException e) {
            LOG.info("git rev-parse --abbrev-ref HEAD", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static String getTrackedRemoteName(Project project, VirtualFile root, String branchName) throws VcsException {
        return GitConfigUtil.getValue(project, root, GitBranchUtil.trackedRemoteKey(branchName));
    }

    @Nullable
    public static String getTrackedBranchName(Project project, VirtualFile root, String branchName) throws VcsException {
        return GitConfigUtil.getValue(project, root, GitBranchUtil.trackedBranchKey(branchName));
    }

    @NotNull
    private static String trackedBranchKey(String branchName) {
        String string = "branch." + branchName + ".merge";
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String trackedRemoteKey(String branchName) {
        String string = "branch." + branchName + ".remote";
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Deprecated
    @Nullable
    public static GitRemoteBranch tracked(@NotNull Project project, @NotNull VirtualFile root, @NotNull String branchName) throws VcsException {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(15);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(16);
        }
        if (branchName == null) {
            GitBranchUtil.$$$reportNull$$$0(17);
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        GitConfigUtil.getValues(project, root, null, result2);
        String remoteName = result2.get(GitBranchUtil.trackedRemoteKey(branchName));
        if (remoteName == null) {
            return null;
        }
        String branch = result2.get(GitBranchUtil.trackedBranchKey(branchName));
        if (branch == null) {
            return null;
        }
        if (".".equals(remoteName)) {
            return new GitSvnRemoteBranch(branch);
        }
        GitRemote remote = GitBranchUtil.findRemoteByNameOrLogError(project, root, remoteName);
        if (remote == null) {
            return null;
        }
        return new GitStandardRemoteBranch(remote, branch);
    }

    @Deprecated
    @Nullable
    public static GitRemote findRemoteByNameOrLogError(@NotNull Project project, @NotNull VirtualFile root, @NotNull String remoteName) {
        GitRepository repository;
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(18);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(19);
        }
        if (remoteName == null) {
            GitBranchUtil.$$$reportNull$$$0(20);
        }
        if ((repository = GitUtil.getRepositoryForRootOrLogError(project, root)) == null) {
            return null;
        }
        GitRemote remote = GitUtil.findRemoteByName(repository, remoteName);
        if (remote == null) {
            LOG.warn("Couldn't find remote with name " + remoteName);
            return null;
        }
        return remote;
    }

    @NotNull
    public static Collection<String> getBranchNamesWithoutRemoteHead(@NotNull Collection<GitRemoteBranch> remoteBranches) {
        if (remoteBranches == null) {
            GitBranchUtil.$$$reportNull$$$0(21);
        }
        Collection collection = Collections2.filter(GitBranchUtil.convertBranchesToNames(remoteBranches), input -> {
            assert (input != null);
            return !input.equals("HEAD");
        });
        if (collection == null) {
            GitBranchUtil.$$$reportNull$$$0(22);
        }
        return collection;
    }

    @NotNull
    public static String stripRefsPrefix(@NotNull String branchName) {
        if (branchName == null) {
            GitBranchUtil.$$$reportNull$$$0(23);
        }
        if (branchName.startsWith("refs/heads/")) {
            String string = branchName.substring("refs/heads/".length());
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(24);
            }
            return string;
        }
        if (branchName.startsWith("refs/remotes/")) {
            String string = branchName.substring("refs/remotes/".length());
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(25);
            }
            return string;
        }
        if (branchName.startsWith("refs/tags/")) {
            String string = branchName.substring("refs/tags/".length());
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(26);
            }
            return string;
        }
        String string = branchName;
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static String getBranchNameOrRev(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchUtil.$$$reportNull$$$0(28);
        }
        if (repository.isOnBranch()) {
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            assert (currentBranch != null);
            String string = currentBranch.getName();
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(29);
            }
            return string;
        }
        String currentRevision = repository.getCurrentRevision();
        String string = currentRevision != null ? currentRevision.substring(0, 7) : "";
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Nullable
    public static GitNewBranchOptions getNewBranchNameFromUser(@NotNull Project project, @NotNull Collection<GitRepository> repositories, @NotNull String dialogTitle, @Nullable String initialName) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(31);
        }
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(32);
        }
        if (dialogTitle == null) {
            GitBranchUtil.$$$reportNull$$$0(33);
        }
        return new GitNewBranchDialog(project, dialogTitle, initialName, GitNewBranchNameValidator.newInstance(repositories)).showAndGetOptions();
    }

    @NotNull
    public static String getDisplayableBranchText(@NotNull GitRepository repository) {
        GitLocalBranch branch;
        Repository.State state;
        if (repository == null) {
            GitBranchUtil.$$$reportNull$$$0(34);
        }
        if ((state = repository.getState()) == Repository.State.DETACHED) {
            String currentRevision = repository.getCurrentRevision();
            assert (currentRevision != null) : "Current revision can't be null in DETACHED state, only on the fresh repository.";
            String string = DvcsUtil.getShortHash((String)currentRevision);
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(35);
            }
            return string;
        }
        String prefix = "";
        if (state == Repository.State.MERGING || state == Repository.State.REBASING) {
            prefix = state.toString() + " ";
        }
        String branchName = (branch = repository.getCurrentBranch()) == null ? "" : branch.getName();
        String string = prefix + branchName;
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    @Nullable
    public static GitRepository getCurrentRepository(@NotNull Project project) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(37);
        }
        return GitBranchUtil.getRepositoryOrGuess(project, DvcsUtil.getSelectedFile((Project)project));
    }

    @Nullable
    public static GitRepository getRepositoryOrGuess(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(38);
        }
        if (project.isDisposed()) {
            return null;
        }
        return (GitRepository)DvcsUtil.guessRepositoryForFile((Project)project, (RepositoryManager)GitUtil.getRepositoryManager(project), (VirtualFile)file, (String)GitVcsSettings.getInstance(project).getRecentRootPath());
    }

    @NotNull
    public static Collection<String> getCommonBranches(Collection<GitRepository> repositories, boolean local) {
        Collection<Object> commonBranches = null;
        for (GitRepository repository : repositories) {
            GitBranchesCollection branchesCollection = repository.getBranches();
            Collection<Object> names = local ? GitBranchUtil.convertBranchesToNames(branchesCollection.getLocalBranches()) : GitBranchUtil.getBranchNamesWithoutRemoteHead(branchesCollection.getRemoteBranches());
            commonBranches = commonBranches == null ? names : ContainerUtil.intersection(commonBranches, names);
        }
        List list = commonBranches != null ? ((StreamEx)StreamEx.of(commonBranches).sorted(StringUtil::naturalCompare)).toList() : Collections.emptyList();
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    public static Collection<String> getBranches(@NotNull Project project, @NotNull VirtualFile root, boolean localWanted, boolean remoteWanted, @Nullable String containingCommit) throws VcsException {
        String[] split;
        String output;
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(40);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(41);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.BRANCH);
        handler.setSilent(true);
        handler.addParameters("--no-color");
        boolean remoteOnly = false;
        if (remoteWanted && localWanted) {
            handler.addParameters("-a");
            remoteOnly = false;
        } else if (remoteWanted) {
            handler.addParameters("-r");
            remoteOnly = true;
        }
        if (containingCommit != null) {
            handler.addParameters("--contains", containingCommit);
        }
        if ((output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0])).trim().length() == 0) {
            List<String> list;
            try {
                File headFile = ((GitRepository)ObjectUtils.assertNotNull((Object)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root))).getRepositoryFiles().getHeadFile();
                String head = FileUtil.loadFile((File)headFile, (Charset)CharsetToolkit.UTF8_CHARSET).trim();
                String prefix = "ref: refs/heads/";
                list = head.startsWith("ref: refs/heads/") ? Collections.singletonList(head.substring("ref: refs/heads/".length())) : Collections.emptyList();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                List<String> list2 = Collections.emptyList();
                if (list2 == null) {
                    GitBranchUtil.$$$reportNull$$$0(43);
                }
                return list2;
            }
            if (list == null) {
                GitBranchUtil.$$$reportNull$$$0(42);
            }
            return list;
        }
        ArrayList branches = ContainerUtil.newArrayList();
        for (String b : split = output.split("\n")) {
            boolean isRemote;
            if ((b = b.substring(2).trim()).equals(NO_BRANCH_NAME)) continue;
            String remotePrefix = null;
            if (b.startsWith("remotes/")) {
                remotePrefix = "remotes/";
            } else if (b.startsWith("refs/remotes/")) {
                remotePrefix = "refs/remotes/";
            }
            boolean bl = isRemote = remotePrefix != null || remoteOnly;
            if (isRemote) {
                int idx;
                if (!remoteOnly) {
                    b = b.substring(remotePrefix.length());
                }
                if ((idx = b.indexOf("HEAD ->")) > 0) continue;
            }
            branches.add(b);
        }
        ArrayList arrayList = branches;
        if (arrayList == null) {
            GitBranchUtil.$$$reportNull$$$0(44);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 3: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranchName";
                break;
            }
            case 4: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 31: 
            case 37: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranches";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranchOrRev";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertBranchesToNames";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "trackedBranchKey";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "trackedRemoteKey";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNamesWithoutRemoteHead";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "stripRefsPrefix";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNameOrRev";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayableBranchText";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonBranches";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTrackInfoForBranch";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTrackInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchOrRev";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertBranchesToNames";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranch";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchFromGit";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tracked";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteByNameOrLogError";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBranchNamesWithoutRemoteHead";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "stripRefsPrefix";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getBranchNameOrRev";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getNewBranchNameFromUser";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayableBranchText";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRepository";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryOrGuess";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getBranches";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTrackInfo$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

